/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.config;

import com.google.common.base.Strings;
import javax.servlet.Filter;
import org.pentaho.adaptive.daemon.config.DaemonUserDetailsService;
import org.pentaho.adaptive.daemon.config.KrbAuthenticationCondition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.kerberos.authentication.KerberosAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosClient;
import org.springframework.security.kerberos.authentication.KerberosServiceAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosTicketValidator;
import org.springframework.security.kerberos.authentication.sun.SunJaasKerberosClient;
import org.springframework.security.kerberos.authentication.sun.SunJaasKerberosTicketValidator;
import org.springframework.security.kerberos.web.authentication.SpnegoAuthenticationProcessingFilter;
import org.springframework.security.kerberos.web.authentication.SpnegoEntryPoint;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableAutoConfiguration(exclude={SecurityAutoConfiguration.class})
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Value(value="${http.security.keytabLocation:#{null}}")
    private String httpSecurityKeytabLocation;
    @Value(value="${http.security.principal:#{null}}")
    private String httpSecurityPrincipal;
    @Value(value="${http.security.debug:false}")
    private boolean httpSecurityDebug;

    protected void configure(HttpSecurity http) throws Exception {
        if (!Strings.isNullOrEmpty((String)this.httpSecurityKeytabLocation) && !Strings.isNullOrEmpty((String)this.httpSecurityPrincipal)) {
            this.krbAuthConfig(http);
        } else {
            this.noAuthConfig(http);
        }
    }

    private void noAuthConfig(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/"})).permitAll();
    }

    private void krbAuthConfig(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.spnegoEntryPoint()).and()).authorizeRequests().antMatchers(new String[]{"/401"})).permitAll().anyRequest()).authenticated().and()).addFilterBefore((Filter)this.spnegoAuthenticationProcessingFilter(this.authenticationManagerBean()), BasicAuthenticationFilter.class);
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        if (this.httpSecurityKeytabLocation != null && this.httpSecurityPrincipal != null && !this.httpSecurityKeytabLocation.isEmpty() && !this.httpSecurityPrincipal.isEmpty()) {
            auth.authenticationProvider((AuthenticationProvider)this.kerberosAuthenticationProvider());
            auth.authenticationProvider((AuthenticationProvider)this.kerberosServiceAuthenticationProvider());
        }
    }

    @Bean
    @Conditional(value={KrbAuthenticationCondition.class})
    public KerberosAuthenticationProvider kerberosAuthenticationProvider() {
        KerberosAuthenticationProvider provider = new KerberosAuthenticationProvider();
        SunJaasKerberosClient client = new SunJaasKerberosClient();
        client.setDebug(true);
        provider.setKerberosClient((KerberosClient)client);
        provider.setUserDetailsService((UserDetailsService)this.daemonUserDetailsService());
        return provider;
    }

    @Bean
    @Conditional(value={KrbAuthenticationCondition.class})
    public SpnegoEntryPoint spnegoEntryPoint() {
        return new SpnegoEntryPoint("/401");
    }

    @Bean
    @Conditional(value={KrbAuthenticationCondition.class})
    public SpnegoAuthenticationProcessingFilter spnegoAuthenticationProcessingFilter(AuthenticationManager authenticationManager) {
        SpnegoAuthenticationProcessingFilter filter = new SpnegoAuthenticationProcessingFilter();
        filter.setAuthenticationManager(authenticationManager);
        return filter;
    }

    @Bean
    @Conditional(value={KrbAuthenticationCondition.class})
    public KerberosServiceAuthenticationProvider kerberosServiceAuthenticationProvider() {
        KerberosServiceAuthenticationProvider provider = new KerberosServiceAuthenticationProvider();
        provider.setTicketValidator((KerberosTicketValidator)this.sunJaasKerberosTicketValidator());
        provider.setUserDetailsService((UserDetailsService)this.daemonUserDetailsService());
        return provider;
    }

    @Bean
    @Conditional(value={KrbAuthenticationCondition.class})
    public SunJaasKerberosTicketValidator sunJaasKerberosTicketValidator() {
        SunJaasKerberosTicketValidator ticketValidator = new SunJaasKerberosTicketValidator();
        ticketValidator.setServicePrincipal(this.httpSecurityPrincipal);
        ticketValidator.setKeyTabLocation((Resource)new FileSystemResource(this.httpSecurityKeytabLocation));
        ticketValidator.setDebug(true);
        return ticketValidator;
    }

    @Bean
    @Conditional(value={KrbAuthenticationCondition.class})
    public DaemonUserDetailsService daemonUserDetailsService() {
        return new DaemonUserDetailsService();
    }
}

