/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.config.container;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.catalina.connector.Connector;
import org.pentaho.adaptive.daemon.config.container.ConnectorConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.stereotype.Component;

@Component
public class ContainerConfig
implements EmbeddedServletContainerCustomizer {
    private final List<ConnectorConfigService> connectorConfigService;

    @Autowired
    public ContainerConfig(List<ConnectorConfigService> connectorConfigService) {
        this.connectorConfigService = connectorConfigService;
    }

    public void customize(ConfigurableEmbeddedServletContainer container) {
        Preconditions.checkArgument((boolean)(container instanceof TomcatEmbeddedServletContainerFactory), (Object)"Expected only Tomcat embedded servlet container.");
        Preconditions.checkNotNull(this.connectorConfigService);
        List applicableConnectorConfigServices = this.connectorConfigService.stream().filter(ConnectorConfigService::shouldApply).collect(Collectors.toList());
        Preconditions.checkArgument((applicableConnectorConfigServices.size() > 0 ? 1 : 0) != 0, (Object)"No services daemon services have been defined, neither http or ssl");
        TomcatEmbeddedServletContainerFactory tomcatContainer = (TomcatEmbeddedServletContainerFactory)container;
        tomcatContainer.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> ((ConnectorConfigService)applicableConnectorConfigServices.get(0)).apply(container, connector)});
        int numberPortsRequired = (int)applicableConnectorConfigServices.stream().map(ConnectorConfigService::port).distinct().count();
        IntStream.range(1, numberPortsRequired).forEach(i -> {
            Connector connector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
            tomcatContainer.addAdditionalTomcatConnectors(new Connector[]{connector});
            this.connectorConfigService.get(i).apply(container, connector);
        });
    }
}

