/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.config.container;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.http11.Http11NioProtocol;
import org.pentaho.adaptive.daemon.ApplicationProperties;
import org.pentaho.adaptive.daemon.config.MessageLoader;
import org.pentaho.adaptive.daemon.config.container.ConnectorConfigService;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.DefaultPropertiesPersister;

@Service
class SslConnectorConfig
implements ConnectorConfigService {
    private final TwoWayPasswordEncoderInterface encoder;
    private String keyStorePassword;
    private String keyPassword;
    private final MessageLoader messages;
    private final ApplicationProperties props;
    private final Supplier<ApplicationContext> contextSupplier = Suppliers.memoize(this::getAppContext);
    private final DefaultPropertiesPersister defaultPropertiesPersister;
    private PrintStream OUT = System.out;
    private final BufferedReader promptInput;

    @Autowired
    public SslConnectorConfig(MessageLoader messages, ApplicationProperties props) {
        this.props = props;
        this.messages = messages;
        this.keyStorePassword = props.getKeyStorePassword();
        this.keyPassword = props.getKeyPassword();
        this.encoder = this.getPasswordEncoder();
        this.defaultPropertiesPersister = new DefaultPropertiesPersister();
        this.promptInput = null;
    }

    @VisibleForTesting
    SslConnectorConfig(MessageLoader messages, ApplicationProperties props, DefaultPropertiesPersister persister, TwoWayPasswordEncoderInterface encoder, BufferedReader promptReader) {
        this.encoder = encoder;
        this.defaultPropertiesPersister = persister;
        this.messages = messages;
        this.props = props;
        this.keyStorePassword = props.getKeyStorePassword();
        this.keyPassword = props.getKeyPassword();
        this.promptInput = promptReader;
    }

    private File getEncFile() {
        return new File(this.props.getEncFileName());
    }

    @Override
    public void apply(ConfigurableEmbeddedServletContainer container, Connector connector) {
        if (!this.shouldApply()) {
            return;
        }
        if (!this.unencodedValuesPresent()) {
            this.handleEncodedProps();
        }
        this.setupSslProvider(connector);
    }

    @Override
    public boolean shouldApply() {
        return this.props.isSslEnabled();
    }

    @Override
    public int port() {
        return this.props.getSslServerPort();
    }

    private void handleEncodedProps() {
        this.loadUnencodedValues();
        if (!this.unencodedValuesPresent()) {
            this.prompt();
            this.store();
        }
    }

    private void loadUnencodedValues() {
        File encFile = this.getEncFile();
        if (!encFile.exists()) {
            return;
        }
        try (FileInputStream in = new FileInputStream(encFile);){
            this.OUT.println(this.messages.get("SslConfig.LoadFromEncProperties", this.props.getEncFileName()));
            Properties props = new Properties();
            this.defaultPropertiesPersister.load(props, (InputStream)in);
            this.keyPassword = this.encoder.decode(props.getProperty("ael.ssl.key-password", null));
            this.keyStorePassword = this.encoder.decode(props.getProperty("ael.ssl.key-store-password", null));
        }
        catch (IOException e) {
            this.OUT.println(this.messages.get("SslConfig.FailedToLoadEncProperties", this.props.getEncFileName()));
        }
    }

    private boolean unencodedValuesPresent() {
        return this.keyPassword != null && this.keyStorePassword != null;
    }

    private void setupSslProvider(Connector connector) {
        Http11NioProtocol protocol = (Http11NioProtocol)connector.getProtocolHandler();
        connector.setSecure(true);
        connector.setScheme("wss");
        connector.setPort(this.props.getSslServerPort());
        protocol.setSSLEnabled(true);
        protocol.setKeystoreType(this.props.getKeyStoreType());
        protocol.setKeystoreFile(this.props.getSslKeyStorePath());
        protocol.setKeyPass(this.keyPassword);
        protocol.setKeystorePass(this.keyStorePassword);
    }

    private void prompt() {
        this.OUT.println(this.messages.get("SslConfig.PromptForSSLPasswords"));
        this.OUT.print(this.messages.get("SslConfig.KeyStorePassPrompt"));
        this.keyStorePassword = this.readLine();
        this.OUT.print(this.messages.get("SslConfig.KeyPassPrompt"));
        this.keyPassword = this.readLine();
    }

    private void store() {
        Properties encProps = new Properties();
        TwoWayPasswordEncoderInterface encoder = this.getPasswordEncoder();
        encProps.setProperty("ael.ssl.key-store-password", encoder.encode(this.keyStorePassword));
        encProps.setProperty("ael.ssl.key-password", encoder.encode(this.keyPassword));
        try (FileOutputStream out = new FileOutputStream(this.getEncFile());){
            this.defaultPropertiesPersister.store(encProps, (OutputStream)out, this.messages.get("SslConfig.EncFileHeader"));
        }
        catch (IOException e) {
            this.OUT.println(this.messages.get("SslConfig.FileWriteError", this.props.getEncFileName()));
        }
    }

    private String readLine() {
        if (System.console() == null) {
            try {
                return this.promptInput.readLine();
            }
            catch (IOException e) {
                this.OUT.println("System.console should only be null when running unit tests.");
            }
        } else {
            return new String(System.console().readPassword());
        }
        return null;
    }

    private TwoWayPasswordEncoderInterface getPasswordEncoder() {
        return (TwoWayPasswordEncoderInterface)((ApplicationContext)this.contextSupplier.get()).getBean("passwordEncoder", TwoWayPasswordEncoderInterface.class);
    }

    private ApplicationContext getAppContext() {
        if (new File("config/spring.xml").exists()) {
            return new FileSystemXmlApplicationContext("config/spring.xml");
        }
        return new ClassPathXmlApplicationContext("spring.xml");
    }
}

