/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.spark;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.CloseReason;
import javax.websocket.EncodeException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.spark.launcher.SparkAppHandle;
import org.pentaho.adaptive.daemon.config.SpringBootConfigurator;
import org.pentaho.adaptive.daemon.spark.RequestTracker;
import org.pentaho.adaptive.daemon.spark.SparkRunner;
import org.pentaho.di.engine.api.events.ErrorEvent;
import org.pentaho.di.engine.api.events.LogEvent;
import org.pentaho.di.engine.api.events.MetricsEvent;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.events.StatusEvent;
import org.pentaho.di.engine.api.remote.ExecutionFetchRequest;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.pentaho.di.engine.api.remote.Message;
import org.pentaho.di.engine.api.remote.MessageDecoder;
import org.pentaho.di.engine.api.remote.MessageEncoder;
import org.pentaho.di.engine.api.remote.StopMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ServerEndpoint(value="/execution", decoders={MessageDecoder.class}, encoders={MessageEncoder.class}, configurator=SpringBootConfigurator.class)
public class RequestServerEndpoint {
    private static final String CLIENT_LOST_FIRST_MSG_LOG = "CLIENT_LOST_FIRST_MSG_LOG";
    private static final String STOP_MESSAGE_RECEIVED_FROM_SERVER = "STOP_MESSAGE_RECEIVED_FROM_SERVER";
    private static final String SPARK_HANDLER = "SPARK_APP_ HANDLE";
    private static final String SPARK_SESSION_KILLED_MSG = "Spark session was killed";
    private Logger LOG = LoggerFactory.getLogger(RequestServerEndpoint.class);
    @Autowired
    private SparkRunner sparkRunner;
    @Autowired
    private RequestTracker requestTracker;

    @OnOpen
    public void onOpen(Session session) {
        this.LOG.info("Connected ... " + session.getId());
        session.setMaxTextMessageBufferSize(500000);
        session.setMaxBinaryMessageBufferSize(500000);
        RequestServerEndpoint.initParameters(session);
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        this.LOG.info(String.format("Session %s closed because of %s", session.getId(), closeReason));
        this.requestTracker.removeSession(session);
    }

    @OnMessage
    public void onMessage(Message message, Session session) {
        if (message instanceof MetricsEvent || message instanceof LogEvent || message instanceof StatusEvent || message instanceof ErrorEvent) {
            this.handlePDIEvent((PDIEvent)message, session);
        } else if (message instanceof ExecutionRequest) {
            this.handleRequestMessage((ExecutionRequest)message, session);
        } else if (message instanceof ExecutionFetchRequest) {
            this.handleSparkRequestMessage((ExecutionFetchRequest)message, session);
        } else if (message instanceof StopMessage) {
            this.handleStopMessage((StopMessage)message, session);
        }
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        if (throwable != null) {
            if (throwable.getCause() != null && throwable.getCause() instanceof IOException && "Broken pipe".equals(throwable.getCause().getMessage()) && !session.isOpen()) {
                this.LOG.info(String.format("%s error when closing the session %s", throwable.getCause().getMessage(), session.getId()));
            } else if (throwable instanceof EOFException && session.isOpen()) {
                this.LOG.info(String.format("Session %s was closed abruptly", session.getId()));
                if (session.getRequestParameterMap() != null && session.getRequestParameterMap().get("requestId") != null && !RequestServerEndpoint.getAndSet(session, STOP_MESSAGE_RECEIVED_FROM_SERVER, true)) {
                    this.handleStopMessage(new StopMessage(SPARK_SESSION_KILLED_MSG), session);
                }
            } else if (throwable instanceof IOException && "Connection reset by peer".equals(throwable.getMessage())) {
                this.LOG.error(String.format("Lost connection with client [%s]", throwable.getMessage()));
            } else {
                this.LOG.error("", throwable);
            }
        }
    }

    private void handlePDIEvent(PDIEvent message, Session session) {
        try {
            this.LOG.debug("handlePDIEvent(message: {}, session:{})", (Object)message, (Object)session);
            String requestId = (String)((List)session.getRequestParameterMap().get("requestId")).get(0);
            this.LOG.debug("  - requestId: {}", (Object)requestId);
            Session client = this.requestTracker.fetchSessionByRequestId(requestId);
            if (client != null && client.isOpen()) {
                client.getBasicRemote().sendObject((Object)message);
            } else if (RequestServerEndpoint.getAndSet(session, CLIENT_LOST_FIRST_MSG_LOG, false)) {
                this.LOG.info("Client session was lost, all the events will not be sent.");
            } else {
                this.LOG.debug("Client session was lost, the event {} wasn't sent to the client.", (Object)message);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error processing generic message", e);
        }
    }

    private void handleSparkRequestMessage(ExecutionFetchRequest message, Session session) {
        try {
            this.LOG.info("Received Spark Request Message (SessionId: {})", (Object)session.getId());
            ExecutionRequest requestMessage = this.requestTracker.fetchRequestMessageByRequestId(message.getRequestId());
            this.LOG.info("Found Transformation: {}", (Object)requestMessage.getTransformation().getId());
            session.getBasicRemote().sendObject((Object)requestMessage);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error processing spark request message.", e);
        }
    }

    private void handleStopMessage(StopMessage message, Session session) {
        Session clientSession;
        if (session.getRequestParameterMap().get("requestId") != null) {
            RequestServerEndpoint.getAndSet(session, STOP_MESSAGE_RECEIVED_FROM_SERVER, true);
            this.LOG.info("Received Stop Message from driver");
            String requestId = (String)((List)session.getRequestParameterMap().get("requestId")).get(0);
            clientSession = this.requestTracker.fetchSessionByRequestId(requestId);
        } else {
            this.LOG.info("Received Stop Message from client");
            this.stopSpark(session);
            clientSession = session;
        }
        try {
            if (clientSession != null && clientSession.isOpen()) {
                clientSession.getBasicRemote().sendObject((Object)message);
            } else {
                this.LOG.info("Client session is already close, the stop message wasn't sent to the client.");
            }
        }
        catch (IOException | EncodeException e) {
            throw new RuntimeException("Unable to forward stop message.");
        }
    }

    private void handleRequestMessage(ExecutionRequest message, Session session) {
        try {
            this.LOG.info("Received Request Message");
            this.requestTracker.addSession(session, message);
            this.runSpark(session, message);
        }
        catch (Exception e) {
            try {
                session.getBasicRemote().sendObject((Object)new StopMessage("Error running spark: " + e.getMessage()));
            }
            catch (IOException | EncodeException e1) {
                this.LOG.info("Unable to send stop message to client after error trying to run spark.");
                throw e;
            }
        }
    }

    private void runSpark(final Session session, ExecutionRequest executionRequest) {
        try {
            SparkAppHandle sparkAppHandle = this.sparkRunner.execute(executionRequest);
            RequestServerEndpoint.setSparkAppHandle(session, sparkAppHandle);
            SparkAppHandle.Listener statusListener = new SparkAppHandle.Listener(){

                public void stateChanged(SparkAppHandle sparkAppHandle) {
                    SparkAppHandle.State state = sparkAppHandle.getState();
                    if (state.equals((Object)SparkAppHandle.State.KILLED)) {
                        RequestServerEndpoint.this.LOG.info(RequestServerEndpoint.SPARK_SESSION_KILLED_MSG);
                        RequestServerEndpoint.this.stopSpark(session);
                        if (session != null && session.isOpen()) {
                            try {
                                session.getBasicRemote().sendObject((Object)new StopMessage(RequestServerEndpoint.SPARK_SESSION_KILLED_MSG));
                            }
                            catch (IOException | EncodeException e1) {
                                RequestServerEndpoint.this.LOG.info("Unable to send stop message to client after spark session being killed");
                            }
                        }
                    }
                }

                public void infoChanged(SparkAppHandle sparkAppHandle) {
                }
            };
            sparkAppHandle.addListener(statusListener);
        }
        catch (Exception e) {
            this.LOG.error("Unexpected error running Spark job.", (Throwable)e);
            throw new RuntimeException("Unexpected error running Spark job.", e);
        }
    }

    private void stopSpark(Session session) {
        SparkAppHandle sparkAppHandle = RequestServerEndpoint.getSparkAppHandle(session);
        if (sparkAppHandle != null) {
            sparkAppHandle.kill();
        }
    }

    private static void initParameters(Session session) {
        session.getUserProperties().put(CLIENT_LOST_FIRST_MSG_LOG, new AtomicBoolean(true));
        session.getUserProperties().put(STOP_MESSAGE_RECEIVED_FROM_SERVER, new AtomicBoolean(false));
    }

    private static boolean getAndSet(Session session, String parameter, boolean value) {
        AtomicBoolean property = (AtomicBoolean)session.getUserProperties().get(parameter);
        return property.getAndSet(value);
    }

    private static SparkAppHandle getSparkAppHandle(Session session) {
        return (SparkAppHandle)session.getUserProperties().get(SPARK_HANDLER);
    }

    private static SparkAppHandle setSparkAppHandle(Session session, SparkAppHandle sparkAppHandle) {
        return session.getUserProperties().put(SPARK_HANDLER, sparkAppHandle);
    }
}

