/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.spark;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.websocket.Session;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.springframework.stereotype.Component;

@Component
public class RequestTracker {
    private Map<Session, ExecutionRequest> cache = new HashMap<Session, ExecutionRequest>();

    private RequestTracker() {
    }

    public Session fetchSessionByRequestId(String requestId) {
        try {
            return this.cache.entrySet().stream().filter(entry -> Objects.equals(((ExecutionRequest)entry.getValue()).getRequestId(), requestId)).map(Map.Entry::getKey).findFirst().get();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Session fetchSessionBySessionId(String sessionId) {
        return this.cache.keySet().stream().filter(v -> v.getId().equals(sessionId)).findFirst().get();
    }

    public ExecutionRequest fetchRequestMessageByRequestId(String requestId) {
        return this.cache.values().stream().filter(v -> v.getRequestId().equals(requestId)).findFirst().get();
    }

    public void addSession(Session session, ExecutionRequest requestMessage) {
        this.cache.put(session, requestMessage);
    }

    public void addSession(Session session) {
        this.cache.put(session, null);
    }

    public void removeSession(Session session) {
        this.cache.remove(session);
    }

    public void updateMessageRequest(Session session, ExecutionRequest requestMessage) {
        this.cache.put(session, requestMessage);
    }

    public void updateSession(Session newSession, String requestId) {
        ExecutionRequest requestMessage = this.fetchRequestMessageByRequestId(requestId);
        Session oldSession = this.getSessionByRequestMessage(requestMessage);
        this.cache.remove(oldSession);
        this.cache.put(newSession, requestMessage);
    }

    private Session getSessionByRequestMessage(ExecutionRequest requestMessage) {
        return this.cache.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), requestMessage)).map(Map.Entry::getKey).findFirst().get();
    }
}

