/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.spark;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.pentaho.adaptive.daemon.ApplicationProperties;
import org.pentaho.adaptive.daemon.spark.DaemonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SparkConfigGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SparkConfigGenerator.class);
    public static final String DEBUG_TEMPLATE = " -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=%s,address=%s";
    @Autowired
    private ApplicationProperties config;

    public void createSparkDefaults(File confDir, List<String> jars) {
        try {
            boolean overwriteConfig = this.config.isOverwriteConfig();
            if (confDir.exists()) {
                if (overwriteConfig) {
                    FileUtils.deleteDirectory((File)confDir);
                } else {
                    return;
                }
            }
            confDir.mkdirs();
            File conf = new File(confDir, "spark-defaults.conf");
            conf.createNewFile();
            Properties properties = new Properties();
            File launcher = new File(this.config.getSparkApp());
            String dataIntegration = launcher.getAbsolutePath().replace("\\", "/");
            properties.put("spark.driver.memory", this.config.getSparkDriverMemory());
            properties.put("spark.driver.extraJavaOptions", this.driverExtraJavaOptions(dataIntegration));
            properties.put("spark.executor.memory", this.config.getSparkExecutorMemory());
            properties.put("spark.yarn.dist.archives", this.config.getAssemblyZip());
            properties.put("spark.executor.extraJavaOptions", this.executorExtraJavaOptions(dataIntegration));
            properties.put("spark.jars", jars.stream().collect(Collectors.joining(",")));
            FileOutputStream outputStream = new FileOutputStream(conf);
            properties.store(outputStream, "Spark Configuration");
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            throw new DaemonException("Unable to create Kettle Conf for Spark.", e);
        }
    }

    private Object executorExtraJavaOptions(String dataIntegration) {
        StringBuilder sb = new StringBuilder();
        sb.append("-DisExecutor=true").append(" ");
        sb.append("-Djava.library.path=" + dataIntegration + "/libswt/win64");
        sb.append(" ").append(this.config.getSparkExecutorExtraJavaOptions());
        if (this.config.getExecutorDebugPort() > -1) {
            sb.append(String.format(DEBUG_TEMPLATE, this.config.getSuspendDebug() ? "y" : "n", this.config.getExecutorDebugPort()));
        }
        return sb.toString();
    }

    private String driverExtraJavaOptions(String dataIntegration) {
        StringBuilder sb = new StringBuilder();
        sb.append("-Duser.dir=" + dataIntegration).append(" ");
        sb.append("-Djava.library.path=" + dataIntegration + "/libswt/win64");
        sb.append(" ").append(this.config.getSparkDriverExtraJavaOptions());
        if (this.config.getDriverDebugPort() > -1) {
            sb.append(String.format(DEBUG_TEMPLATE, this.config.getSuspendDebug() ? "y" : "n", this.config.getDriverDebugPort()));
        }
        return sb.toString();
    }
}

