/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.spark;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;
import org.pentaho.adaptive.daemon.ApplicationProperties;
import org.pentaho.adaptive.daemon.config.MessageLoader;
import org.pentaho.adaptive.daemon.spark.SparkConfigGenerator;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.pentaho.di.engine.model.ActingPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SparkRunner {
    private static final Logger LOG = LoggerFactory.getLogger(SparkRunner.class);
    private static final String ENDPOINT_SRV = "/execution";
    private ApplicationProperties config;
    private SparkConfigGenerator sparkConfigGenerator;
    private MessageLoader messages;

    @Autowired
    public SparkRunner(ApplicationProperties applicationProperties, SparkConfigGenerator sparkConfigGenerator, MessageLoader messages) {
        this.config = applicationProperties;
        this.sparkConfigGenerator = sparkConfigGenerator;
        this.messages = messages;
    }

    public SparkAppHandle execute(ExecutionRequest executionRequest) {
        try {
            String requestId = executionRequest.getRequestId();
            Principal principal = executionRequest.getActingPrincipal();
            boolean isYarn = this.config.getSparkMaster().equalsIgnoreCase("yarn");
            File confDir = new File(this.config.getSparkHome(), "kettleConf");
            File dataIntegrationHome = new File(this.config.getSparkApp());
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("SPARK_HOME", this.config.getSparkHome());
            env.put("SPARK_CONF_DIR", confDir.toString());
            env.put("HADOOP_CONF_DIR", this.config.getHadoopConfDir());
            env.put("HADOOP_USER_NAME", this.config.getHadoopUser());
            SparkLauncher sparkLauncher = isYarn ? this.yarnSparkLauncher(env) : this.localSparkLauncher(env);
            sparkLauncher.setMaster(this.config.getSparkMaster());
            sparkLauncher.directory(dataIntegrationHome);
            sparkLauncher.setVerbose(true);
            Path lib = FileSystems.getDefault().getPath(this.config.getSparkApp(), "lib");
            Path engineJarPath = Files.find(lib, 1, (path, basicFileAttributes) -> path.toString().contains("pdi-spark-driver") && path.toString().endsWith(".jar"), new FileVisitOption[0]).findFirst().orElseThrow(() -> new IllegalStateException(this.messages.get("SparkRunner.NoMainJarError")));
            List<String> jars = Files.find(lib, 1, (path, basicFileAttributes) -> path.toString().endsWith(".jar"), new FileVisitOption[0]).map(p -> p.toFile().getAbsoluteFile().toURI().toString()).collect(Collectors.toList());
            this.sparkConfigGenerator.createSparkDefaults(confDir, jars);
            sparkLauncher.setAppResource(engineJarPath.toAbsolutePath().toString());
            sparkLauncher.setMainClass(this.config.getSparkAppClass());
            Stream.of(requestId, this.config.getWebsocketURL() + ENDPOINT_SRV, "keytabLocation=" + this.config.getKeytab(), "kerberosPrincipal=" + this.config.getKerberosPrincipal(), "driver.security.keytabLocation=" + this.config.getDriverSecurityKeytabLocation(), "driver.security.principal=" + this.config.getDriverSecurityPrincipal(), "disableProxyUser=" + this.config.isDisableProxyUser()).forEach(xva$0 -> sparkLauncher.addAppArgs(new String[]{xva$0}));
            this.addSparkSecurityArgs(principal, sparkLauncher);
            sparkLauncher.setVerbose(true);
            return sparkLauncher.startApplication(new SparkAppHandle.Listener[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(this.messages.get("SparkRunner.UnexpectedError"), e);
        }
    }

    void addSparkSecurityArgs(Principal actingPrincipal, SparkLauncher sparkLauncher) {
        if (!this.hasSecurityProperties()) {
            return;
        }
        String keytab = this.config.getKeytab();
        if (new File(keytab).exists()) {
            if (this.config.isDisableProxyUser()) {
                sparkLauncher.addSparkArg("--principal", this.config.getKerberosPrincipal());
                sparkLauncher.addSparkArg("--keytab", keytab);
            } else {
                if (ActingPrincipal.ANONYMOUS.equals((Object)actingPrincipal)) {
                    throw new RuntimeException(this.messages.get("SparkRunner.ProxyUserNotSpecifiedError"));
                }
                sparkLauncher.addSparkArg("--proxy-user", actingPrincipal.getName());
            }
        }
    }

    boolean hasSecurityProperties() {
        if (this.config.isDisableProxyUser() && this.config.getKerberosPrincipal() == null) {
            LOG.warn(this.messages.get("SparkRunner.ProxyUserNoPrincipalWarning"));
            return false;
        }
        if (this.config.getKeytab() == null) {
            LOG.warn(this.messages.get("SparkRunner.NoKeyTabWarning"));
            return false;
        }
        return true;
    }

    private SparkLauncher localSparkLauncher(Map<String, String> env) {
        return new SparkLauncher(env);
    }

    private SparkLauncher yarnSparkLauncher(Map<String, String> env) {
        SparkLauncher yarnSpark = new SparkLauncher(env);
        yarnSpark.setDeployMode(this.config.getSparkDeployMode());
        return yarnSpark;
    }
}

