/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.temp;

import java.io.IOException;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.pentaho.adaptive.daemon.ApplicationProperties;
import org.pentaho.adaptive.daemon.config.SpringBootConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ServerEndpoint(value="/greeting", configurator=SpringBootConfigurator.class)
public class GreetingEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(GreetingEndpoint.class);
    @Autowired
    private ApplicationProperties applicationProperties;

    @OnMessage
    public void onMessage(Session session, String message) {
        LOG.info("onMessage(session: {}, message: {})", (Object)session, (Object)message);
        try {
            session.getBasicRemote().sendText(this.applicationProperties.getInfoBuildVersion() + ": " + message + " Pong");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

