/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.api;

import com.debortoliwines.openerp.api.Context;
import com.debortoliwines.openerp.api.ObjectAdapter;
import com.debortoliwines.openerp.api.OpenERPCommand;
import com.debortoliwines.openerp.api.OpenERPXmlRpcProxy;
import com.debortoliwines.openerp.api.OpeneERPApiException;
import com.debortoliwines.openerp.api.Version;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.xmlrpc.XmlRpcException;

public class Session {
    private String host;
    private int port;
    private String databaseName;
    private String userName;
    private String password;
    private int userID;
    private Context context = new Context();
    private static boolean connecting = false;
    private OpenERPXmlRpcProxy.RPCProtocol protocol;

    public Session(OpenERPXmlRpcProxy.RPCProtocol protocol, String host, int port, String databaseName, String userName, String password) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.databaseName = databaseName;
        this.userName = userName;
        this.password = password;
    }

    public Session(String host, int port, String databaseName, String userName, String password) {
        this(OpenERPXmlRpcProxy.RPCProtocol.RPC_HTTP, host, port, databaseName, userName, password);
    }

    public OpenERPCommand getOpenERPCommand() {
        return new OpenERPCommand(this);
    }

    public ObjectAdapter getObjectAdapter(String objectName) throws XmlRpcException, OpeneERPApiException {
        return new ObjectAdapter(this, objectName);
    }

    public void startSession() throws Exception {
        try {
            ArrayList<String> dbList = OpenERPXmlRpcProxy.getDatabaseList(this.protocol, this.host, this.port);
            if (dbList.indexOf(this.databaseName) < 0) {
                StringBuffer dbListBuff = new StringBuffer();
                for (String dbName : dbList) {
                    dbListBuff.append(String.valueOf(dbName) + System.getProperty("line.separator"));
                }
                throw new Exception("Error while connecting to OpenERP.  Database [" + this.databaseName + "] " + " was not found in the following list: " + System.getProperty("line.separator") + System.getProperty("line.separator") + dbListBuff.toString());
            }
        }
        catch (Exception dbList) {
            // empty catch block
        }
        OpenERPXmlRpcProxy commonClient = new OpenERPXmlRpcProxy(this.protocol, this.host, this.port, OpenERPXmlRpcProxy.RPCServices.RPC_COMMON);
        Session.startConnecting();
        Object id = null;
        try {
            try {
                id = commonClient.execute("login", new Object[]{this.databaseName, this.userName, this.password});
            }
            catch (ClassCastException c) {
                throw new Exception("Database " + this.databaseName + " does not exist");
            }
        }
        finally {
            connecting = false;
        }
        if (!(id instanceof Integer)) {
            throw new Exception("Incorrect username and/or password.  Login Failed.");
        }
        this.userID = (Integer)id;
        this.context.clear();
        HashMap openerpContext = (HashMap)this.executeCommand("res.users", "context_get", new Object[0]);
        this.context.putAll(openerpContext);
        this.context.setActiveTest(true);
    }

    private static synchronized void startConnecting() {
        while (connecting) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        connecting = true;
    }

    public ArrayList<String> getDatabaseList(String host, int port) throws XmlRpcException {
        return OpenERPXmlRpcProxy.getDatabaseList(this.protocol, host, port);
    }

    public Object executeCommand(String objectName, String commandName, Object[] parameters) throws XmlRpcException {
        Object[] connectionParams = new Object[]{this.databaseName, this.userID, this.password, objectName, commandName};
        Object[] params = new Object[connectionParams.length + (parameters == null ? 0 : parameters.length)];
        System.arraycopy(connectionParams, 0, params, 0, connectionParams.length);
        if (parameters != null && parameters.length > 0) {
            System.arraycopy(parameters, 0, params, connectionParams.length, parameters.length);
        }
        OpenERPXmlRpcProxy objectClient = new OpenERPXmlRpcProxy(this.protocol, this.host, this.port, OpenERPXmlRpcProxy.RPCServices.RPC_OBJECT);
        return objectClient.execute("execute", params);
    }

    public Version getServerVersion() throws XmlRpcException {
        return OpenERPXmlRpcProxy.getServerVersion(this.host, this.port);
    }

    public Context getContext() {
        return this.context;
    }
}

