/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.BasePublisher;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class GlobalListsPublisher
extends BasePublisher {
    private static final long serialVersionUID = -8247487696354924652L;
    private static final Log logger = LogFactory.getLog(GlobalListsPublisher.class);

    @Override
    public Log getLogger() {
        return logger;
    }

    public String getName() {
        return Messages.getInstance().getString("GlobalListsPublisher.USER_SYSTEM_SETTINGS");
    }

    public String getDescription() {
        return Messages.getInstance().getString("GlobalListsPublisher.USER_DESCRIPTION");
    }

    @Override
    public String publish(IPentahoSession localSession) {
        try {
            PentahoSystem.clearGlobals();
            PentahoSystem.globalStartup(localSession);
        }
        catch (Throwable t) {
            this.error(Messages.getInstance().getErrorString("GlobalListsPublisher.ERROR_0001_PUBLISH_FAILED"), t);
            return Messages.getInstance().getString("GlobalListsPublisher.USER_ERROR_PUBLISH_FAILED") + t.getLocalizedMessage();
        }
        return Messages.getInstance().getString("GlobalListsPublisher.USER_SYSTEM_SETTINGS_UPDATED");
    }
}

