/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac.spring;

import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang.ClassUtils;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.objfac.spring.Marker;
import org.pentaho.platform.engine.core.system.objfac.spring.PublishedBeanRegistry;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanPublishParser
implements BeanDefinitionDecorator {
    private static String ATTR = "as-type";
    private IPluginManager pluginManager;

    public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder beanDefinitionHolder, ParserContext parserContext) {
        String publishType = null;
        String beanClassName = beanDefinitionHolder.getBeanDefinition().getAttribute("originalClassName") != null ? beanDefinitionHolder.getBeanDefinition().getAttribute("originalClassName").toString() : beanDefinitionHolder.getBeanDefinition().getBeanClassName();
        publishType = node.getAttributes().getNamedItem(ATTR) != null ? node.getAttributes().getNamedItem(ATTR).getNodeValue() : beanClassName;
        beanDefinitionHolder.getBeanDefinition().setAttribute("id", (Object)beanDefinitionHolder.getBeanName());
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!BeanPublishParser.stripNamespace(n.getNodeName()).equals("attributes")) continue;
            NodeList attrnodes = n.getChildNodes();
            for (int y = 0; y < attrnodes.getLength(); ++y) {
                Node node2 = attrnodes.item(y);
                if (!BeanPublishParser.stripNamespace(node2.getNodeName()).equals("attr")) continue;
                beanDefinitionHolder.getBeanDefinition().setAttribute(node2.getAttributes().getNamedItem("key").getNodeValue(), (Object)node2.getAttributes().getNamedItem("value").getNodeValue());
            }
        }
        try {
            ArrayList classesToPublish = new ArrayList();
            Class<?> clazz = this.findClass(beanClassName);
            if (specialPublishTypes.INTERFACES.name().equals(publishType)) {
                if (clazz.isInterface()) {
                    classesToPublish.add(clazz);
                } else {
                    classesToPublish.addAll(ClassUtils.getAllInterfaces(clazz));
                }
            } else if (specialPublishTypes.CLASSES.name().equals(publishType)) {
                classesToPublish.addAll(ClassUtils.getAllSuperclasses(clazz));
                classesToPublish.add(clazz);
            } else if (specialPublishTypes.ALL.name().equals(publishType)) {
                classesToPublish.addAll(ClassUtils.getAllInterfaces(clazz));
                classesToPublish.addAll(ClassUtils.getAllSuperclasses(clazz));
                classesToPublish.add(clazz);
            } else {
                classesToPublish.add(this.getClass().getClassLoader().loadClass(publishType));
            }
            String beanFactoryId = null;
            if (!parserContext.getRegistry().containsBeanDefinition("PublishedBeanRegistryMarker")) {
                beanFactoryId = UUID.randomUUID().toString();
                parserContext.getRegistry().registerBeanDefinition("PublishedBeanRegistryMarker", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(Marker.class).setScope("prototype").addConstructorArgValue((Object)beanFactoryId).getBeanDefinition());
            } else {
                beanFactoryId = (String)parserContext.getRegistry().getBeanDefinition("PublishedBeanRegistryMarker").getConstructorArgumentValues().getArgumentValue(0, String.class).getValue();
            }
            for (Class clazz2 : classesToPublish) {
                PublishedBeanRegistry.registerBean(beanDefinitionHolder.getBeanName(), clazz2, beanFactoryId);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find class for publish type: " + publishType + " specified on publish of bean id: " + beanDefinitionHolder.getBeanName(), e);
        }
        return beanDefinitionHolder;
    }

    private Class<?> findClass(String beanClassName) throws ClassNotFoundException {
        Class<?> clazz = this.loadClassFromClassloader(this.getClass().getClassLoader(), beanClassName);
        if (clazz != null) {
            return clazz;
        }
        if (this.getPluginManager() != null) {
            for (String s : this.getPluginManager().getRegisteredPlugins()) {
                clazz = this.loadClassFromClassloader(this.getPluginManager().getClassLoader(s), beanClassName);
                if (clazz == null) continue;
                return clazz;
            }
        }
        throw new ClassNotFoundException(beanClassName);
    }

    private IPluginManager getPluginManager() {
        if (this.pluginManager == null) {
            this.pluginManager = PentahoSystem.get(IPluginManager.class);
        }
        return this.pluginManager;
    }

    private Class<?> loadClassFromClassloader(ClassLoader loader, String beanClassName) {
        try {
            return loader.loadClass(beanClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static String stripNamespace(String s) {
        if (s.indexOf(58) > 0) {
            return s.substring(s.indexOf(58) + 1);
        }
        return s;
    }

    private static enum specialPublishTypes {
        INTERFACES,
        CLASSES,
        ALL;

    }
}

