/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import javax.sql.DataSource;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.BaseDatasourceService;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.PooledDatasourceHelper;
import org.pentaho.platform.engine.services.messages.Messages;

public class NonPooledDatasourceService
extends BaseDatasourceService {
    @Override
    protected DataSource retrieve(String dsName) throws DBDatasourceServiceException {
        DataSource ds;
        block4: {
            ds = null;
            try {
                IDatasourceMgmtService datasourceMgmtSvc = this.getDatasourceMgmtService();
                IDatabaseConnection databaseConnection = datasourceMgmtSvc.getDatasourceByName(dsName);
                if (databaseConnection != null) {
                    ds = this.resolveDatabaseConnection(databaseConnection);
                    if (ds != null) {
                        this.cacheManager.putInRegionCache("DataSource", (Object)dsName, (Object)ds);
                    }
                    break block4;
                }
                throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("DatasourceService.ERROR_0002_UNABLE_TO_GET_DATASOURCE"));
            }
            catch (DatasourceMgmtServiceException daoe) {
                throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("DatasourceService.ERROR_0002_UNABLE_TO_GET_DATASOURCE"), (Throwable)daoe);
            }
        }
        return ds;
    }

    @Override
    public String getDSBoundName(String dsName) throws DBDatasourceServiceException {
        return dsName;
    }

    @Override
    public String getDSUnboundName(String dsName) {
        return dsName;
    }

    @Override
    protected DataSource resolveDatabaseConnection(IDatabaseConnection databaseConnection) throws DBDatasourceServiceException {
        return PooledDatasourceHelper.convert(databaseConnection);
    }
}

