/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.eapub;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventAdminHelper
implements RemoteServiceAdminListener {
    private static final Logger LOG = LoggerFactory.getLogger(EventAdminHelper.class);
    private BundleContext bctx;

    public EventAdminHelper(BundleContext bc) {
        this.bctx = bc;
    }

    private Event createEvent(Map<String, Object> props, String type) {
        String topic = "org/osgi/service/remoteserviceadmin/" + type;
        props.put("bundle", this.bctx.getBundle());
        props.put("bundle.id", this.bctx.getBundle().getBundleId());
        props.put("bundle.symbolicname", this.bctx.getBundle().getSymbolicName());
        String version = (String)this.bctx.getBundle().getHeaders().get("Bundle-Version");
        Version v = version != null ? new Version(version) : Version.emptyVersion;
        this.setIfNotNull(props, "bundle.version", v);
        return new Event(topic, props);
    }

    public void remoteAdminEvent(RemoteServiceAdminEvent rsae) {
        String topic = EventAdminHelper.remoteServiceAdminEventTypeToString(rsae.getType());
        HashMap<String, Object> props = new HashMap<String, Object>();
        this.setIfNotNull(props, "cause", rsae.getException());
        EndpointDescription endpoint = null;
        if (rsae.getImportReference() != null) {
            endpoint = rsae.getImportReference().getImportedEndpoint();
            this.setIfNotNull(props, "import.registration", endpoint);
        } else if (rsae.getExportReference() != null) {
            endpoint = rsae.getExportReference().getExportedEndpoint();
            this.setIfNotNull(props, "export.registration", endpoint);
        }
        if (endpoint != null) {
            this.setIfNotNull(props, "service.remote.id", endpoint.getServiceId());
            this.setIfNotNull(props, "service.remote.uuid", endpoint.getFrameworkUUID());
            this.setIfNotNull(props, "service.remote.uri", endpoint.getId());
            this.setIfNotNull(props, "objectClass", endpoint.getInterfaces().toArray());
            this.setIfNotNull(props, "service.imported.configs", endpoint.getConfigurationTypes());
        }
        props.put("timestamp", System.currentTimeMillis());
        props.put("event", rsae);
        Event event = this.createEvent(props, topic);
        this.notifyEventAdmins(topic, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEventAdmins(String topic, Event event) {
        ServiceReference[] refs = null;
        try {
            refs = this.bctx.getAllServiceReferences(EventAdmin.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            LOG.error("Failed to get EventAdmin: " + e.getMessage(), (Throwable)e);
        }
        if (refs != null) {
            LOG.debug("Publishing event to {} EventAdmins; Topic:[{}]", (Object)refs.length, (Object)topic);
            for (ServiceReference serviceReference : refs) {
                EventAdmin eventAdmin = (EventAdmin)this.bctx.getService(serviceReference);
                try {
                    eventAdmin.postEvent(event);
                }
                finally {
                    if (eventAdmin != null) {
                        this.bctx.ungetService(serviceReference);
                    }
                }
            }
        }
    }

    private <K, V> void setIfNotNull(Map<K, V> map, K key, V val) {
        if (val != null) {
            map.put(key, val);
        }
    }

    private static String remoteServiceAdminEventTypeToString(int type) {
        String retval;
        switch (type) {
            case 6: {
                retval = "EXPORT_ERROR";
                break;
            }
            case 2: {
                retval = "EXPORT_REGISTRATION";
                break;
            }
            case 3: {
                retval = "EXPORT_UNREGISTRATION";
                break;
            }
            case 7: {
                retval = "EXPORT_WARNING";
                break;
            }
            case 5: {
                retval = "IMPORT_ERROR";
                break;
            }
            case 1: {
                retval = "IMPORT_REGISTRATION";
                break;
            }
            case 4: {
                retval = "IMPORT_UNREGISTRATION";
                break;
            }
            case 8: {
                retval = "IMPORT_WARNING";
                break;
            }
            default: {
                retval = "UNKNOWN_EVENT";
            }
        }
        return retval;
    }
}

