/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.ui;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.api.RunConfigurationService;
import org.pentaho.di.engine.configuration.impl.pentaho.DefaultRunConfiguration;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class RunConfigurationDialog
extends Dialog
implements org.pentaho.di.engine.configuration.api.RunConfigurationDialog {
    private static Class<?> PKG = RunConfigurationDialog.class;
    private Shell shell;
    private PropsUI props;
    private Label wlName;
    private Text wName;
    private Label wlDescription;
    private Text wDescription;
    private Label wlEngine;
    private CCombo wEngine;
    private Group gOptions;
    private Button wCancel;
    private Button wOK;
    private RunConfiguration runConfiguration;
    private RunConfiguration savedRunConfiguration;
    private Map<String, RunConfiguration> runConfigurationMap = new HashMap<String, RunConfiguration>();
    private RunConfigurationService executionConfigurationManager;

    public RunConfigurationDialog(Shell parent, RunConfigurationService executionConfigurationManager, RunConfiguration runConfiguration) {
        super(parent, 0);
        this.props = PropsUI.getInstance();
        this.executionConfigurationManager = executionConfigurationManager;
        this.runConfiguration = runConfiguration;
        if (runConfiguration != null) {
            this.runConfigurationMap.put(runConfiguration.getType(), runConfiguration);
        }
    }

    public RunConfiguration open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Title", (String[])new String[0]));
        this.shell.setImage(this.getImage());
        Composite wSettings = new Composite((Composite)this.shell, 32);
        this.props.setLook((Control)wSettings);
        FormLayout specLayout = new FormLayout();
        specLayout.marginWidth = 0;
        specLayout.marginHeight = 0;
        wSettings.setLayout((Layout)specLayout);
        this.wlName = new Label(wSettings, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Label.Name", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.top = new FormAttachment(0, 0);
        this.wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(wSettings, 18436);
        this.props.setLook((Control)this.wName);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(0, 0);
        fdName.top = new FormAttachment((Control)this.wlName, 5);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        this.wName.addModifyListener(modifyEvent -> {
            this.runConfiguration.setName(this.wName.getText());
            if (Utils.isEmpty((CharSequence)this.runConfiguration.getName())) {
                this.wOK.setEnabled(false);
            } else {
                this.wOK.setEnabled(true);
            }
        });
        this.wlDescription = new Label(wSettings, 131072);
        this.wlDescription.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Label.Description", (String[])new String[0]));
        this.props.setLook((Control)this.wlDescription);
        FormData fdlDescription = new FormData();
        fdlDescription.left = new FormAttachment(0, 0);
        fdlDescription.top = new FormAttachment((Control)this.wName, 10);
        this.wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new Text(wSettings, 18434);
        this.props.setLook((Control)this.wDescription);
        FormData fdDescription = new FormData();
        fdDescription.height = 40;
        fdDescription.left = new FormAttachment(0, 0);
        fdDescription.top = new FormAttachment((Control)this.wlDescription, 5);
        fdDescription.right = new FormAttachment(100, 0);
        this.wDescription.setLayoutData((Object)fdDescription);
        this.wDescription.addModifyListener(modifyEvent -> this.runConfiguration.setDescription(this.wDescription.getText()));
        this.wlEngine = new Label(wSettings, 131072);
        this.wlEngine.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Label.Engine", (String[])new String[0]));
        this.props.setLook((Control)this.wlEngine);
        FormData fdlEngine = new FormData();
        fdlEngine.left = new FormAttachment(0, 0);
        fdlEngine.top = new FormAttachment((Control)this.wDescription, 10);
        this.wlEngine.setLayoutData((Object)fdlEngine);
        this.wEngine = new CCombo(wSettings, 2060);
        this.wEngine.setItems(this.executionConfigurationManager.getTypes());
        this.wEngine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String engine = RunConfigurationDialog.this.wEngine.getText();
                if (!engine.equals(RunConfigurationDialog.this.runConfiguration.getType())) {
                    RunConfigurationDialog.this.updateOptions(engine);
                }
            }
        });
        this.wEngine.select(0);
        this.props.setLook((Control)this.wEngine);
        FormData fdEngine = new FormData();
        fdEngine.width = 150;
        fdEngine.left = new FormAttachment(0, 0);
        fdEngine.top = new FormAttachment((Control)this.wlEngine, 5);
        this.wEngine.setLayoutData((Object)fdEngine);
        this.gOptions = new Group(wSettings, 16);
        this.gOptions.setText(BaseMessages.getString(PKG, (String)"RunConfigurationDialog.Group.Settings", (String[])new String[0]));
        this.props.setLook((Control)this.gOptions);
        FormLayout gformLayout = new FormLayout();
        gformLayout.marginWidth = 10;
        gformLayout.marginHeight = 10;
        this.gOptions.setLayout((Layout)gformLayout);
        FormData fdOptions = new FormData();
        fdOptions.top = new FormAttachment((Control)this.wEngine, 15);
        fdOptions.right = new FormAttachment(100);
        fdOptions.left = new FormAttachment(0);
        fdOptions.height = 140;
        this.gOptions.setLayoutData((Object)fdOptions);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.height = 1;
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0);
        fdSettings.top = new FormAttachment(0);
        fdSettings.right = new FormAttachment(100);
        fdSettings.bottom = new FormAttachment((Control)hSpacer, -15);
        wSettings.setLayoutData((Object)fdSettings);
        this.setValues();
        Listener lsCancel = e -> this.cancel();
        Listener lsOK = e -> this.ok();
        this.wOK.addListener(13, lsOK);
        this.wCancel.addListener(13, lsCancel);
        BaseStepDialog.setSize((Shell)this.shell, (int)450, (int)300);
        this.shell.setMinimumSize(this.shell.getSize());
        this.wName.setSelection(0, this.wName.getText().length());
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                RunConfigurationDialog.this.cancel();
            }
        });
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.savedRunConfiguration;
    }

    private Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"images/run_tree.svg", (int)32, (int)32);
    }

    private void setValues() {
        if (this.runConfiguration == null) {
            this.runConfiguration = this.executionConfigurationManager.getRunConfigurationByType(DefaultRunConfiguration.TYPE);
            this.runConfigurationMap.put(DefaultRunConfiguration.TYPE, this.runConfiguration);
        }
        this.clearOptions();
        this.runConfiguration.getUI().attach((org.pentaho.di.engine.configuration.api.RunConfigurationDialog)this);
        this.gOptions.layout();
        this.shell.pack();
        this.wEngine.setText(StringUtils.capitalize((String)this.runConfiguration.getType()));
        this.wName.setText(Const.NVL((String)this.runConfiguration.getName(), (String)""));
        this.wDescription.setText(Const.NVL((String)this.runConfiguration.getDescription(), (String)""));
    }

    private void clearOptions() {
        for (Control control : this.gOptions.getChildren()) {
            control.dispose();
        }
    }

    private void updateOptions(String type) {
        RunConfiguration newRunConfiguration = this.runConfigurationMap.get(type);
        if (newRunConfiguration == null) {
            newRunConfiguration = this.executionConfigurationManager.getRunConfigurationByType(type);
            newRunConfiguration.setName(this.runConfiguration.getName());
            newRunConfiguration.setDescription(this.runConfiguration.getDescription());
            this.runConfigurationMap.put(type, newRunConfiguration);
        }
        this.runConfiguration = newRunConfiguration;
        this.setValues();
    }

    private void cancel() {
        this.shell.dispose();
    }

    private void ok() {
        if (this.validated()) {
            this.save();
            this.shell.dispose();
        }
    }

    private void save() {
        this.savedRunConfiguration = this.runConfiguration;
    }

    private boolean validated() {
        if (StringUtils.containsAny((String)this.wName.getText(), (String)"%\"\\/:[]*|\t\r\n")) {
            MessageBox messageBox = new MessageBox(this.shell, 1);
            messageBox.setMessage(BaseMessages.getString(PKG, (String)"RunConfiguration.InvalidChars.Message", (String[])new String[0]));
            messageBox.setText(BaseMessages.getString(PKG, (String)"RunConfiguration.InvalidChars.Title", (String[])new String[0]));
            messageBox.open();
            return false;
        }
        return true;
    }

    public Text getName() {
        return this.wName;
    }

    public Button getOKButton() {
        return this.wOK;
    }

    public Group getGroup() {
        return this.gOptions;
    }
}

