/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput.reader;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.SingleRowRowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.jsoninput.JsonInputField;
import org.pentaho.di.trans.steps.jsoninput.JsonInputMeta;
import org.pentaho.di.trans.steps.jsoninput.exception.JsonInputException;
import org.pentaho.di.trans.steps.jsoninput.reader.IJsonReader;

public class FastJsonReader
implements IJsonReader {
    private static Class<?> PKG = JsonInputMeta.class;
    private static final String JSON_CHARSET = "UTF-8";
    private ReadContext jsonReadContext;
    private Configuration jsonConfiguration = Configuration.defaultConfiguration().addOptions(DEFAULT_OPTIONS);
    private boolean ignoreMissingPath = false;
    private JsonInputField[] fields;
    private JsonPath[] paths = null;
    private LogChannelInterface log;
    private static final Option[] DEFAULT_OPTIONS = new Option[]{Option.SUPPRESS_EXCEPTIONS, Option.ALWAYS_RETURN_LIST, Option.DEFAULT_PATH_LEAF_TO_NULL};

    protected FastJsonReader(LogChannelInterface log) throws KettleException {
        this.log = log;
    }

    public FastJsonReader(JsonInputField[] fields, LogChannelInterface log) throws KettleException {
        this(log);
        this.setFields(fields);
    }

    @Override
    public void setIgnoreMissingPath(boolean value) {
        this.ignoreMissingPath = value;
    }

    private ParseContext getParseContext() {
        return JsonPath.using((Configuration)this.jsonConfiguration);
    }

    private ReadContext getReadContext() {
        return this.jsonReadContext;
    }

    private static JsonPath[] compilePaths(JsonInputField[] fields) {
        JsonPath[] paths = new JsonPath[fields.length];
        int i = 0;
        for (JsonInputField field : fields) {
            paths[i++] = JsonPath.compile((String)field.getPath(), (Predicate[])new Predicate[0]);
        }
        return paths;
    }

    protected void readInput(InputStream is) throws KettleException {
        this.jsonReadContext = this.getParseContext().parse(is, JSON_CHARSET);
        if (this.jsonReadContext == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.ReadUrl.Null", (String[])new String[0]));
        }
    }

    @Override
    public boolean isIgnoreMissingPath() {
        return this.ignoreMissingPath;
    }

    @Override
    public void setFields(JsonInputField[] fields) throws KettleException {
        this.fields = fields;
        this.paths = FastJsonReader.compilePaths(fields);
    }

    @Override
    public RowSet parse(InputStream in) throws KettleException {
        int len;
        this.readInput(in);
        List<List<?>> results = this.evalCombinedResult();
        int n = len = results.isEmpty() ? 0 : results.get(0).size();
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"JsonInput.Log.NrRecords", (Object[])new Object[]{len}));
        }
        if (len == 0) {
            return this.getEmptyResponse();
        }
        return new TransposedRowSet(results);
    }

    private RowSet getEmptyResponse() {
        SingleRowRowSet nullInputResponse = new SingleRowRowSet();
        nullInputResponse.putRow(null, new Object[this.fields.length]);
        nullInputResponse.setDone();
        return nullInputResponse;
    }

    private List<List<?>> evalCombinedResult() throws JsonInputException {
        int lastSize = -1;
        String prevPath = null;
        ArrayList results = new ArrayList(this.paths.length);
        int i = 0;
        for (JsonPath path : this.paths) {
            List result = (List)this.getReadContext().read(path);
            if (result.size() != lastSize && lastSize > 0 & result.size() != 0) {
                throw new JsonInputException(BaseMessages.getString(PKG, (String)"JsonInput.Error.BadStructure", (Object[])new Object[]{result.size(), this.fields[i].getPath(), prevPath, lastSize}));
            }
            if (!this.isIgnoreMissingPath() && (FastJsonReader.isAllNull(result) || result.size() == 0)) {
                throw new JsonInputException(BaseMessages.getString(PKG, (String)"JsonReader.Error.CanNotFindPath", (String[])new String[]{this.fields[i].getPath()}));
            }
            results.add(result);
            lastSize = result.size();
            prevPath = this.fields[i].getPath();
            ++i;
        }
        return results;
    }

    public static boolean isAllNull(Iterable<?> list) {
        for (Object obj : list) {
            if (obj == null) continue;
            return false;
        }
        return true;
    }

    private static class TransposedRowSet
    extends SingleRowRowSet {
        private List<List<?>> results;
        private final int rowCount;
        private int rowNbr;
        private boolean cullNulls = true;

        public TransposedRowSet(List<List<?>> results) {
            this.results = results;
            this.rowCount = results.isEmpty() ? 0 : results.get(0).size();
        }

        public Object[] getRow() {
            boolean allNulls = this.cullNulls && this.rowCount > 1;
            Object[] rowData = null;
            do {
                if (this.rowNbr >= this.rowCount) {
                    this.results.clear();
                    return null;
                }
                rowData = new Object[this.results.size()];
                for (int col = 0; col < this.results.size(); ++col) {
                    if (this.results.get(col).size() == 0) {
                        rowData[col] = null;
                        continue;
                    }
                    Object val = this.results.get(col).get(this.rowNbr);
                    rowData[col] = val;
                    allNulls &= val == null;
                }
                ++this.rowNbr;
            } while (allNulls);
            return rowData;
        }

        public int size() {
            return this.rowCount - this.rowNbr;
        }

        public boolean isDone() {
            return true;
        }

        public void clear() {
            this.results.clear();
        }
    }
}

