/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.http;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.Shell;
import org.apache.hive.http.AdminAuthorizedServlet;
import org.apache.hive.http.ConfServlet;
import org.apache.hive.http.JMXJsonServlet;
import org.apache.hive.http.StackServlet;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;

public class HttpServer {
    public static final String CONF_CONTEXT_ATTRIBUTE = "hive.conf";
    public static final String ADMINS_ACL = "admins.acl";
    private final String appDir;
    private final int port;
    private final WebAppContext webAppContext;
    private final Server webServer;

    private HttpServer(Builder b) throws IOException {
        this.port = b.port;
        this.webServer = new Server();
        this.appDir = this.getWebAppsPath(b.name);
        this.webAppContext = this.createWebAppContext(b);
        if (b.useSPNEGO) {
            this.setupSpnegoFilter(b);
        }
        this.initializeWebServer(b);
    }

    public void start() throws Exception {
        this.webServer.start();
    }

    public void stop() throws Exception {
        this.webServer.stop();
    }

    public int getPort() {
        return this.port;
    }

    static boolean isInstrumentationAccessAllowed(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        boolean access = true;
        boolean adminAccess = conf.getBoolean("hadoop.security.instrumentation.requires.admin", false);
        if (adminAccess) {
            access = HttpServer.hasAdministratorAccess(servletContext, request, response);
        }
        return access;
    }

    static boolean hasAdministratorAccess(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)servletContext.getAttribute(CONF_CONTEXT_ATTRIBUTE);
        if (!conf.getBoolean("hadoop.security.authorization", false)) {
            return true;
        }
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            response.sendError(401, "Unauthenticated users are not authorized to access this page.");
            return false;
        }
        if (servletContext.getAttribute(ADMINS_ACL) != null && !HttpServer.userHasAdministratorAccess(servletContext, remoteUser)) {
            response.sendError(401, "User " + remoteUser + " is unauthorized to access this page.");
            return false;
        }
        return true;
    }

    static boolean userHasAdministratorAccess(ServletContext servletContext, String remoteUser) {
        AccessControlList adminsAcl = (AccessControlList)servletContext.getAttribute(ADMINS_ACL);
        UserGroupInformation remoteUserUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        return adminsAcl != null && adminsAcl.isUserAllowed(remoteUserUGI);
    }

    WebAppContext createWebAppContext(Builder b) {
        WebAppContext ctx = new WebAppContext();
        this.setContextAttributes(ctx.getServletContext(), b.contextAttrs);
        ctx.setDisplayName(b.name);
        ctx.setContextPath("/");
        ctx.setWar(this.appDir + "/" + b.name);
        return ctx;
    }

    void setupSpnegoFilter(Builder b) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("kerberos.principal", SecurityUtil.getServerPrincipal((String)b.spnegoPrincipal, (String)b.host));
        params.put("kerberos.keytab", b.spnegoKeytab);
        params.put("type", "kerberos");
        FilterHolder holder = new FilterHolder();
        holder.setClassName(AuthenticationFilter.class.getName());
        holder.setInitParameters(params);
        ServletHandler handler = this.webAppContext.getServletHandler();
        handler.addFilterWithMapping(holder, "/*", 31);
    }

    Connector createChannelConnector(int queueSize, Builder b) {
        SelectChannelConnector connector;
        if (!b.useSSL) {
            connector = new SelectChannelConnector();
        } else {
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(b.keyStorePath);
            HashSet excludedSSLProtocols = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)Strings.nullToEmpty((String)b.conf.getVar(HiveConf.ConfVars.HIVE_SSL_PROTOCOL_BLACKLIST))));
            sslContextFactory.addExcludeProtocols(excludedSSLProtocols.toArray(new String[excludedSSLProtocols.size()]));
            sslContextFactory.setKeyStorePassword(b.keyStorePassword);
            connector = new SslSelectChannelConnector(sslContextFactory);
        }
        connector.setLowResourcesMaxIdleTime(10000);
        connector.setAcceptQueueSize(queueSize);
        connector.setResolveNames(false);
        connector.setUseDirectBuffers(false);
        connector.setRequestHeaderSize(65536);
        connector.setReuseAddress(!Shell.WINDOWS);
        return connector;
    }

    void setContextAttributes(ContextHandler.Context ctx, Map<String, Object> contextAttrs) {
        for (Map.Entry<String, Object> e : contextAttrs.entrySet()) {
            ctx.setAttribute(e.getKey(), e.getValue());
        }
    }

    void initializeWebServer(Builder b) {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        if (b.maxThreads > 0) {
            threadPool.setMaxThreads(b.maxThreads);
        }
        threadPool.setDaemon(true);
        threadPool.setName(b.name + "-web");
        this.webServer.setThreadPool((ThreadPool)threadPool);
        Connector connector = this.createChannelConnector(threadPool.getMaxThreads(), b);
        connector.setHost(b.host);
        connector.setPort(this.port);
        this.webServer.addConnector(connector);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.addHandler((Handler)this.webAppContext);
        this.webServer.setHandler((Handler)contexts);
        this.addServlet("jmx", "/jmx", JMXJsonServlet.class);
        this.addServlet("conf", "/conf", ConfServlet.class);
        this.addServlet("stacks", "/stacks", StackServlet.class);
        ServletContextHandler staticCtx = new ServletContextHandler((HandlerContainer)contexts, "/static");
        staticCtx.setResourceBase(this.appDir + "/static");
        staticCtx.addServlet(DefaultServlet.class, "/*");
        staticCtx.setDisplayName("static");
        String logDir = this.getLogDir(b.conf);
        if (logDir != null) {
            ServletContextHandler logCtx = new ServletContextHandler((HandlerContainer)contexts, "/logs");
            this.setContextAttributes(logCtx.getServletContext(), b.contextAttrs);
            logCtx.addServlet(AdminAuthorizedServlet.class, "/*");
            logCtx.setResourceBase(logDir);
            logCtx.setDisplayName("logs");
        }
    }

    String getLogDir(Configuration conf) {
        String logDir = conf.get("hive.log.dir");
        if (logDir == null) {
            logDir = System.getProperty("hive.log.dir");
        }
        if (logDir != null) {
            return logDir;
        }
        Enumeration e = Logger.getRootLogger().getAllAppenders();
        while (e.hasMoreElements()) {
            Appender app = (Appender)e.nextElement();
            if (!(app instanceof FileAppender)) continue;
            return ((FileAppender)app).getFile();
        }
        return null;
    }

    String getWebAppsPath(String appName) throws FileNotFoundException {
        String relativePath = "hive-webapps/" + appName;
        URL url = this.getClass().getClassLoader().getResource(relativePath);
        if (url == null) {
            throw new FileNotFoundException(relativePath + " not found in CLASSPATH");
        }
        String urlString = url.toString();
        return urlString.substring(0, urlString.lastIndexOf(47));
    }

    public void addServlet(String name, String pathSpec, Class<? extends HttpServlet> clazz) {
        ServletHolder holder = new ServletHolder(clazz);
        if (name != null) {
            holder.setName(name);
        }
        this.webAppContext.addServlet(holder, pathSpec);
    }

    public static class Builder {
        private String name;
        private String host;
        private int port;
        private int maxThreads;
        private HiveConf conf;
        private Map<String, Object> contextAttrs = new HashMap<String, Object>();
        private String keyStorePassword;
        private String keyStorePath;
        private String spnegoPrincipal;
        private String spnegoKeytab;
        private boolean useSPNEGO;
        private boolean useSSL;

        public HttpServer build() throws IOException {
            return new HttpServer(this);
        }

        public Builder setConf(HiveConf origConf) {
            this.conf = new HiveConf(origConf);
            origConf.stripHiddenConfigurations(this.conf);
            this.setContextAttribute(HttpServer.CONF_CONTEXT_ATTRIBUTE, (Object)this.conf);
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setMaxThreads(int maxThreads) {
            this.maxThreads = maxThreads;
            return this;
        }

        public Builder setAdmins(String admins) {
            if (admins != null) {
                this.setContextAttribute(HttpServer.ADMINS_ACL, new AccessControlList(admins));
            }
            return this;
        }

        public Builder setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder setKeyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public Builder setUseSSL(boolean useSSL) {
            this.useSSL = useSSL;
            return this;
        }

        public Builder setUseSPNEGO(boolean useSPNEGO) {
            this.useSPNEGO = useSPNEGO;
            return this;
        }

        public Builder setSPNEGOPrincipal(String principal) {
            this.spnegoPrincipal = principal;
            return this;
        }

        public Builder setSPNEGOKeytab(String keytab) {
            this.spnegoKeytab = keytab;
            return this;
        }

        public Builder setContextAttribute(String name, Object value) {
            this.contextAttrs.put(name, value);
            return this;
        }
    }
}

