/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.impl.model.kettle.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metaverse.api.model.ExternalResourceInfoFactory;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.pentaho.metaverse.impl.model.kettle.LineageRepository;
import org.pentaho.metaverse.impl.model.kettle.json.GenericStepOrJobEntryJsonSerializer;

public abstract class AbstractJobEntryJsonSerializer<T extends JobEntryBase>
extends GenericStepOrJobEntryJsonSerializer<T> {
    public AbstractJobEntryJsonSerializer(Class<T> aClass) {
        super(aClass);
    }

    public AbstractJobEntryJsonSerializer(JavaType javaType) {
        super(javaType);
    }

    public AbstractJobEntryJsonSerializer(Class<?> aClass, boolean b) {
        super(aClass, b);
    }

    @Override
    protected void writeBasicInfo(T meta, JsonGenerator json) throws IOException {
        json.writeStringField("@class", meta.getClass().getName());
        json.writeStringField("name", meta.getName());
        json.writeStringField("type", this.getStepType(meta));
    }

    protected String getStepType(T entry) {
        String stepType = null;
        try {
            stepType = PluginRegistry.getInstance().findPluginWithId(JobEntryPluginType.class, entry.getPluginId()).getName();
        }
        catch (Throwable t) {
            stepType = entry.getClass().getSimpleName();
        }
        return stepType;
    }

    @Override
    protected void writeRepoAttributes(T meta, JsonGenerator json) throws IOException {
        StringObjectId jobId = meta.getObjectId() == null ? new StringObjectId(meta.getName()) : meta.getObjectId();
        LineageRepository repo = this.getLineageRepository();
        if (repo != null) {
            Map<String, Object> attrs = repo.getJobEntryAttributesCache((ObjectId)jobId);
            json.writeObjectField("attributes", attrs);
            List<Map<String, Object>> fields = repo.getJobEntryFieldsCache((ObjectId)jobId);
            json.writeObjectField("fields", fields);
        }
    }

    @Override
    protected void writeExternalResources(T meta, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        json.writeArrayFieldStart("externalResources");
        JobMeta jobMeta = new JobMeta();
        if (meta.getParentJob() != null && meta.getParentJob().getJobMeta() != null) {
            jobMeta = meta.getParentJob().getJobMeta();
        }
        List dependencies = meta.getResourceDependencies(jobMeta);
        for (ResourceReference dependency : dependencies) {
            for (ResourceEntry resourceEntry : dependency.getEntries()) {
                IExternalResourceInfo resourceInfo = ExternalResourceInfoFactory.createResource((ResourceEntry)resourceEntry);
                json.writeObject((Object)resourceInfo);
            }
        }
        json.writeEndArray();
    }
}

