/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.locator;

import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.dictionary.DictionaryHelper;
import org.pentaho.metaverse.api.IDocumentEvent;
import org.pentaho.metaverse.api.IDocumentListener;
import org.pentaho.metaverse.api.IDocumentLocator;
import org.pentaho.metaverse.api.IMetaverseBuilder;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.MetaverseLocatorException;
import org.pentaho.metaverse.api.Namespace;
import org.pentaho.metaverse.impl.MetaverseCompletionService;
import org.pentaho.metaverse.locator.LocatorRunner;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLocator<T>
implements IDocumentLocator {
    private static final long serialVersionUID = 693428630030858039L;
    private static final Logger LOG = LoggerFactory.getLogger(BaseLocator.class);
    protected IMetaverseNode locatorNode;
    protected IPentahoSession session;
    protected IMetaverseBuilder metaverseBuilder;
    protected String id = "";
    protected String locatorType;
    protected LocatorRunner<T> runner;
    protected MetaverseCompletionService completionService = MetaverseCompletionService.getInstance();
    protected Future<String> futureTask;
    protected List<IDocumentListener> listeners = new ArrayList<IDocumentListener>();

    public BaseLocator() {
        DictionaryHelper.registerEntityType((String)"Locator");
    }

    public BaseLocator(List<IDocumentListener> documentListeners) {
        this.listeners = documentListeners;
    }

    protected abstract Object getContents(T var1) throws Exception;

    public void addDocumentListener(IDocumentListener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners(IDocumentEvent event) {
        for (IDocumentListener listener : this.listeners) {
            listener.onEvent(event);
        }
    }

    public void removeDocumentListener(IDocumentListener listener) {
        this.listeners.remove(listener);
    }

    public String getRepositoryId() {
        return this.id;
    }

    public void setRepositoryId(String id) {
        this.id = id;
    }

    public String getLocatorType() {
        return this.locatorType;
    }

    public void setLocatorType(String locatorType) {
        this.locatorType = locatorType;
    }

    public IMetaverseBuilder getMetaverseBuilder() {
        return this.metaverseBuilder;
    }

    public void setMetaverseBuilder(IMetaverseBuilder metaverseBuilder) {
        this.metaverseBuilder = metaverseBuilder;
    }

    public IMetaverseNode getLocatorNode() {
        if (this.locatorNode == null) {
            final URI uri = this.getRootUri();
            HashMap<String, Object> props = new HashMap<String, Object>(){
                {
                    this.put("name", BaseLocator.this.getRepositoryId());
                    this.put("type", "Locator");
                    if (uri != null) {
                        this.put("url", uri.normalize().toString());
                    }
                    this.put("description", "This is a locator of documents to be analyzed");
                }
            };
            this.locatorNode = this.metaverseBuilder.getMetaverseObjectFactory().createNodeObject(this.getNamespace(), DictionaryConst.LOGICAL_ID_GENERATOR_LOCATOR, (Map)props);
        }
        return this.locatorNode;
    }

    public void setLocatorNode(IMetaverseNode locatorNode) {
        this.locatorNode = locatorNode;
    }

    protected INamespace getNamespace() {
        IMetaverseNode locatorNode = this.metaverseBuilder.getMetaverseObjectFactory().createNodeObject(UUID.randomUUID().toString(), this.getRepositoryId(), "Locator");
        locatorNode.setLogicalIdGenerator(DictionaryConst.LOGICAL_ID_GENERATOR_LOCATOR);
        return new Namespace(locatorNode.getLogicalId());
    }

    public void stopScan() {
        if (this.futureTask == null || this.futureTask.isDone() || this.futureTask.isCancelled()) {
            return;
        }
        LOG.debug(Messages.getString("DEBUG.Locator.StopScan", this.getLocatorType()));
        this.runner.stop();
        this.futureTask.cancel(false);
        this.futureTask = null;
        this.runner = null;
    }

    protected void startScan(LocatorRunner<T> locatorRunner) throws MetaverseLocatorException {
        if (this.futureTask != null && !this.futureTask.isDone()) {
            throw new MetaverseLocatorException(Messages.getString("ERROR.BaseLocator.ScanAlreadyExecuting"));
        }
        IMetaverseNode node = this.getLocatorNode();
        Date lastRun = new Date();
        node.setProperty("lastScan", (Object)Long.toString(lastRun.getTime()));
        this.metaverseBuilder.addNode(node);
        this.runner = locatorRunner;
        this.runner.setLocator(this);
        LOG.debug(Messages.getString("DEBUG.Locator.StartScan", this.getLocatorType()));
        this.futureTask = this.completionService.submit((Runnable)this.runner, node.getStringID());
    }
}

