/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format;

import java.net.URI;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.log4j.Logger;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.hadoop.shim.api.format.IPentahoInputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoParquetInputFormat;
import org.pentaho.hadoop.shim.api.format.SchemaDescription;
import org.pentaho.hadoop.shim.common.ConfigurationProxy;
import org.pentaho.hadoop.shim.common.format.HadoopFormatBase;
import org.pentaho.hadoop.shim.common.format.ReadFileFilter;
import org.pentaho.hadoop.shim.common.format.parquet.ParquetConverter;
import org.pentaho.hadoop.shim.common.format.parquet.PentahoInputSplitImpl;
import org.pentaho.hadoop.shim.common.format.parquet.PentahoParquetReadSupport;
import org.pentaho.hadoop.shim.common.format.parquet.PentahoParquetRecordReader;

public class PentahoParquetInputFormat
extends HadoopFormatBase
implements IPentahoParquetInputFormat {
    private static final Logger logger = Logger.getLogger(PentahoParquetInputFormat.class);
    private ParquetInputFormat<RowMetaAndData> nativeParquetInputFormat;
    private Job job;

    public PentahoParquetInputFormat() throws Exception {
        logger.info((Object)"We are initializing parquet input format");
        this.inClassloader(() -> {
            ConfigurationProxy conf = new ConfigurationProxy();
            this.job = Job.getInstance((Configuration)conf);
            this.nativeParquetInputFormat = new ParquetInputFormat();
            ParquetInputFormat.setReadSupportClass((Job)this.job, PentahoParquetReadSupport.class);
            ParquetInputFormat.setTaskSideMetaData((Job)this.job, (boolean)false);
        });
    }

    public void setSchema(SchemaDescription schema) throws Exception {
        this.inClassloader(() -> this.job.getConfiguration().set("PentahoParquetSchema", schema.marshall()));
    }

    public void setInputFile(String file) throws Exception {
        this.inClassloader(() -> {
            Path filePath = new Path(file);
            FileSystem fs = FileSystem.get((URI)filePath.toUri(), (Configuration)this.job.getConfiguration());
            if (!fs.exists(filePath)) {
                throw new NoSuchFileException(file);
            }
            if (fs.getFileStatus(filePath).isDirectory()) {
                ParquetInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{filePath});
                ParquetInputFormat.setInputDirRecursive((Job)this.job, (boolean)true);
            } else {
                ParquetInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{filePath.getParent()});
                ParquetInputFormat.setInputDirRecursive((Job)this.job, (boolean)false);
                ParquetInputFormat.setInputPathFilter((Job)this.job, ReadFileFilter.class);
                this.job.getConfiguration().set("PentahoParquetFilterDir", filePath.getParent().toString());
                this.job.getConfiguration().set("PentahoParquetFilterFile", filePath.toString());
            }
        });
    }

    public void setSplitSize(long blockSize) throws Exception {
        this.inClassloader(() -> this.job.getConfiguration().setBoolean("parquet.split.files", false));
    }

    public List<IPentahoInputFormat.IPentahoInputSplit> getSplits() throws Exception {
        return this.inClassloader(() -> {
            List splits = this.nativeParquetInputFormat.getSplits((JobContext)this.job);
            return splits.stream().map(PentahoInputSplitImpl::new).collect(Collectors.toList());
        });
    }

    public IPentahoInputFormat.IPentahoRecordReader createRecordReader(IPentahoInputFormat.IPentahoInputSplit split) throws Exception {
        return this.inClassloader(() -> {
            PentahoInputSplitImpl pentahoInputSplit = (PentahoInputSplitImpl)split;
            InputSplit inputSplit = pentahoInputSplit.getInputSplit();
            PentahoParquetReadSupport readSupport = new PentahoParquetReadSupport();
            ParquetRecordReader nativeRecordReader = new ParquetRecordReader((ReadSupport)readSupport, ParquetInputFormat.getFilter((Configuration)this.job.getConfiguration()));
            TaskAttemptContextImpl task = new TaskAttemptContextImpl(this.job.getConfiguration(), new TaskAttemptID());
            nativeRecordReader.initialize(inputSplit, (TaskAttemptContext)task);
            return new PentahoParquetRecordReader((ParquetRecordReader<RowMetaAndData>)nativeRecordReader);
        });
    }

    public SchemaDescription readSchema(String file) throws Exception {
        return this.inClassloader(() -> {
            ConfigurationProxy conf = new ConfigurationProxy();
            FileSystem fs = FileSystem.get((URI)new URI(file), (Configuration)conf);
            FileStatus fileStatus = fs.getFileStatus(new Path(file));
            List footers = ParquetFileReader.readFooters((Configuration)conf, (FileStatus)fileStatus, (boolean)true);
            if (footers.isEmpty()) {
                return new SchemaDescription();
            }
            ParquetMetadata meta = ((Footer)footers.get(0)).getParquetMetadata();
            MessageType schema = meta.getFileMetaData().getSchema();
            return ParquetConverter.createSchemaDescription(schema);
        });
    }
}

