/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.avro;

import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.hadoop.shim.api.format.IPentahoAvroOutputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoOutputFormat;
import org.pentaho.hadoop.shim.api.format.SchemaDescription;
import org.pentaho.hadoop.shim.common.format.avro.AvroSchemaConverter;
import org.pentaho.hadoop.shim.common.format.avro.PentahoAvroRecordWriter;

public class PentahoAvroOutputFormat
implements IPentahoAvroOutputFormat {
    private Schema schema;
    private String outputFilename;
    private SchemaDescription schemaDescription;
    private CodecFactory codecFactory;
    private String nameSpace;
    private String recordName;
    private String docValue;
    private String schemaFilename;

    public IPentahoOutputFormat.IPentahoRecordWriter createRecordWriter() throws Exception {
        if (this.schemaDescription == null || StringUtils.isEmpty((String)this.nameSpace) || StringUtils.isEmpty((String)this.recordName) || StringUtils.isEmpty((String)this.outputFilename)) {
            throw new Exception("Invalid state.  One of the following required fields is null:  'nameSpace', 'recordNum', or 'outputFileName");
        }
        AvroSchemaConverter converter = new AvroSchemaConverter(this.schemaDescription, this.nameSpace, this.recordName, this.docValue);
        this.schema = converter.getAvroSchema();
        converter.writeAvroSchemaToFile(this.schemaFilename);
        GenericDatumWriter datumWriter = new GenericDatumWriter(this.schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        dataFileWriter.setCodec(this.codecFactory);
        dataFileWriter.create(this.schema, KettleVFS.getOutputStream((String)this.outputFilename, (boolean)false));
        return new PentahoAvroRecordWriter((DataFileWriter<GenericRecord>)dataFileWriter, this.schema, this.schemaDescription);
    }

    public void setSchemaDescription(SchemaDescription schemaDescription) throws Exception {
        this.schemaDescription = schemaDescription;
    }

    public void setOutputFile(String file) throws Exception {
        this.outputFilename = file;
    }

    public void setCompression(IPentahoAvroOutputFormat.COMPRESSION compression) {
        switch (compression) {
            case SNAPPY: {
                this.codecFactory = CodecFactory.snappyCodec();
                break;
            }
            case DEFLATE: {
                this.codecFactory = CodecFactory.deflateCodec((int)-1);
                break;
            }
            default: {
                this.codecFactory = CodecFactory.nullCodec();
            }
        }
    }

    public void setNameSpace(String namespace) {
        this.nameSpace = namespace;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    public void setDocValue(String docValue) {
        this.docValue = docValue;
    }

    public void setSchemaFilename(String schemaFilename) {
        this.schemaFilename = schemaFilename;
    }
}

