/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.parquet;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaBinary;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaSerializable;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.row.value.ValueMetaTimestamp;
import org.pentaho.hadoop.shim.api.format.SchemaDescription;

public class ParquetConverter {
    public static final int PARQUET_JOB_ID = Integer.MAX_VALUE;
    public static final String PARQUET_SCHEMA_CONF_KEY = "PentahoParquetSchema";
    private final SchemaDescription schema;

    public ParquetConverter(SchemaDescription schema) {
        this.schema = schema;
    }

    public MessageType createParquetSchema() {
        ArrayList types = new ArrayList();
        this.schema.forEach(f -> types.add(this.convertField((SchemaDescription.Field)f)));
        if (types.isEmpty()) {
            throw new IllegalArgumentException("Schema should contain at least one field");
        }
        return new MessageType("parquet-schema", types);
    }

    public static SchemaDescription createSchemaDescription(MessageType schema) {
        SchemaDescription r = new SchemaDescription();
        schema.getFields().forEach(t -> r.addField(ParquetConverter.convertField(r, t)));
        return r;
    }

    private static SchemaDescription.Field convertField(SchemaDescription schema, Type t) {
        boolean allowNull = t.getRepetition() != Type.Repetition.REQUIRED;
        switch (t.asPrimitiveType().getPrimitiveTypeName()) {
            case BINARY: {
                SchemaDescription schemaDescription = schema;
                schemaDescription.getClass();
                return new SchemaDescription.Field(schemaDescription, t.getName(), t.getName(), 2, allowNull);
            }
            case BOOLEAN: {
                SchemaDescription schemaDescription = schema;
                schemaDescription.getClass();
                return new SchemaDescription.Field(schemaDescription, t.getName(), t.getName(), 4, allowNull);
            }
            case DOUBLE: 
            case FLOAT: {
                SchemaDescription schemaDescription = schema;
                schemaDescription.getClass();
                return new SchemaDescription.Field(schemaDescription, t.getName(), t.getName(), 1, allowNull);
            }
            case INT32: 
            case INT64: {
                if (t.getOriginalType() == OriginalType.DATE || t.getOriginalType() == OriginalType.TIME_MILLIS || t.getOriginalType() == OriginalType.TIMESTAMP_MILLIS) {
                    SchemaDescription schemaDescription = schema;
                    schemaDescription.getClass();
                    return new SchemaDescription.Field(schemaDescription, t.getName(), t.getName(), 3, allowNull);
                }
                SchemaDescription schemaDescription = schema;
                schemaDescription.getClass();
                return new SchemaDescription.Field(schemaDescription, t.getName(), t.getName(), 5, allowNull);
            }
            case INT96: {
                SchemaDescription schemaDescription = schema;
                schemaDescription.getClass();
                return new SchemaDescription.Field(schemaDescription, t.getName(), t.getName(), 3, allowNull);
            }
        }
        throw new RuntimeException("Undefined type: " + t);
    }

    private PrimitiveType convertField(SchemaDescription.Field f) {
        Type.Repetition rep = f.allowNull ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED;
        switch (f.pentahoValueMetaType) {
            case 1: {
                return new PrimitiveType(rep, PrimitiveType.PrimitiveTypeName.DOUBLE, f.formatFieldName);
            }
            case 2: {
                return new PrimitiveType(rep, PrimitiveType.PrimitiveTypeName.BINARY, f.formatFieldName, OriginalType.UTF8);
            }
            case 4: {
                return new PrimitiveType(rep, PrimitiveType.PrimitiveTypeName.BOOLEAN, f.formatFieldName);
            }
            case 5: {
                return new PrimitiveType(rep, PrimitiveType.PrimitiveTypeName.INT64, f.formatFieldName, OriginalType.INT_64);
            }
            case 6: {
                return new PrimitiveType(rep, PrimitiveType.PrimitiveTypeName.DOUBLE, f.formatFieldName);
            }
            case 7: 
            case 8: {
                return new PrimitiveType(rep, PrimitiveType.PrimitiveTypeName.BINARY, f.formatFieldName);
            }
            case 3: 
            case 9: {
                return new PrimitiveType(rep, PrimitiveType.PrimitiveTypeName.INT64, f.formatFieldName, OriginalType.TIMESTAMP_MILLIS);
            }
        }
        throw new RuntimeException("Undefined type: " + f.pentahoValueMetaType);
    }

    private void writeField(SchemaDescription.Field field, int index, RowMetaAndData row, RecordConsumer consumer) throws KettleValueException {
        int fieldIndex = row.getRowMeta().indexOfValue(field.pentahoFieldName);
        if (fieldIndex < 0) {
            if (field.allowNull) {
                return;
            }
            throw new KettleValueException("Required field '" + field.pentahoFieldName + "' not found in rowset");
        }
        if (row.isEmptyValue(field.pentahoFieldName)) {
            if (field.allowNull) {
                return;
            }
            if (field.defaultValue == null) {
                throw new KettleValueException("Required field '" + field.pentahoFieldName + "' contains no data and default values not defined");
            }
            consumer.startField(field.formatFieldName, index);
            switch (field.pentahoValueMetaType) {
                case 1: {
                    consumer.addDouble(Double.parseDouble(field.defaultValue));
                    break;
                }
                case 2: {
                    consumer.addBinary(Binary.fromString((String)field.defaultValue));
                    break;
                }
                case 4: {
                    consumer.addBoolean(Boolean.parseBoolean(field.defaultValue));
                    break;
                }
                case 5: {
                    consumer.addLong(Long.parseLong(field.defaultValue));
                    break;
                }
                case 6: {
                    consumer.addDouble(Double.parseDouble(field.defaultValue));
                    break;
                }
                case 7: {
                    consumer.addBinary(Binary.fromReusedByteArray((byte[])new byte[0]));
                    break;
                }
                case 8: {
                    consumer.addBinary(Binary.fromReusedByteArray((byte[])new byte[0]));
                    break;
                }
                case 3: 
                case 9: {
                    consumer.addLong(Long.parseLong(field.defaultValue));
                    break;
                }
                default: {
                    throw new RuntimeException("Undefined type: " + field.pentahoValueMetaType);
                }
            }
            consumer.endField(field.formatFieldName, index);
            return;
        }
        consumer.startField(field.formatFieldName, index);
        switch (field.pentahoValueMetaType) {
            case 1: {
                consumer.addDouble(row.getNumber(fieldIndex, 0.0));
                break;
            }
            case 2: {
                consumer.addBinary(Binary.fromString((String)row.getString(fieldIndex, null)));
                break;
            }
            case 4: {
                consumer.addBoolean(row.getBoolean(fieldIndex, false));
                break;
            }
            case 5: {
                consumer.addLong(row.getInteger(fieldIndex, 0L));
                break;
            }
            case 6: {
                consumer.addDouble(row.getNumber(fieldIndex, 0.0));
                break;
            }
            case 7: {
                consumer.addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(fieldIndex, new byte[0])));
                break;
            }
            case 8: {
                consumer.addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(fieldIndex, new byte[0])));
                break;
            }
            case 3: 
            case 9: {
                consumer.addLong(row.getDate(fieldIndex, new Date(0L)).getTime());
                break;
            }
            default: {
                throw new RuntimeException("Undefined type: " + field.pentahoValueMetaType);
            }
        }
        consumer.endField(field.formatFieldName, index);
    }

    public void writeRow(RowMetaAndData row, RecordConsumer consumer) {
        consumer.startMessage();
        int index = 0;
        for (SchemaDescription.Field f : this.schema) {
            if (f.formatFieldName == null) continue;
            try {
                this.writeField(f, index, row, consumer);
                ++index;
            }
            catch (KettleValueException ex) {
                throw new RuntimeException(ex);
            }
        }
        consumer.endMessage();
    }

    public static class MyGroupConverter
    extends GroupConverter {
        private RowMeta fields = new RowMeta();
        protected RowMetaAndData current;
        private Converter[] converters;
        private int count = 0;
        private static final int JULIAN_DAY_OF_EPOCH = 2440588;

        public MyGroupConverter(ParquetConverter converter) {
            for (SchemaDescription.Field f : converter.schema) {
                if (f.formatFieldName == null) continue;
                ++this.count;
            }
            this.converters = new Converter[this.count];
            int i = 0;
            for (SchemaDescription.Field f : converter.schema) {
                if (f.formatFieldName == null) continue;
                final int index = i;
                switch (f.pentahoValueMetaType) {
                    case 1: {
                        this.fields.addValueMeta((ValueMetaInterface)new ValueMetaNumber(f.pentahoFieldName));
                        this.converters[i] = new PrimitiveConverter(){

                            public void addDouble(double value) {
                                current.getData()[index] = value;
                            }

                            public void addFloat(float value) {
                                current.getData()[index] = (double)value;
                            }

                            public void addInt(int value) {
                                current.getData()[index] = (double)value;
                            }

                            public void addLong(long value) {
                                current.getData()[index] = (double)value;
                            }

                            public void addBoolean(boolean value) {
                                current.getData()[index] = value ? 1.0 : 0.0;
                            }
                        };
                        break;
                    }
                    case 5: {
                        this.fields.addValueMeta((ValueMetaInterface)new ValueMetaInteger(f.pentahoFieldName));
                        this.converters[i] = new PrimitiveConverter(){

                            public void addDouble(double value) {
                                current.getData()[index] = Math.round(value);
                            }

                            public void addFloat(float value) {
                                current.getData()[index] = (long)Math.round(value);
                            }

                            public void addInt(int value) {
                                current.getData()[index] = (long)value;
                            }

                            public void addLong(long value) {
                                current.getData()[index] = value;
                            }

                            public void addBoolean(boolean value) {
                                current.getData()[index] = value ? 1L : 0L;
                            }
                        };
                        break;
                    }
                    case 6: {
                        this.fields.addValueMeta((ValueMetaInterface)new ValueMetaBigNumber(f.pentahoFieldName));
                        this.converters[i] = new PrimitiveConverter(){

                            public void addDouble(double value) {
                                current.getData()[index] = new BigDecimal(value);
                            }

                            public void addFloat(float value) {
                                current.getData()[index] = new BigDecimal(value);
                            }

                            public void addInt(int value) {
                                current.getData()[index] = new BigDecimal(value);
                            }

                            public void addLong(long value) {
                                current.getData()[index] = new BigDecimal(value);
                            }
                        };
                        break;
                    }
                    case 2: {
                        this.fields.addValueMeta((ValueMetaInterface)new ValueMetaString(f.pentahoFieldName));
                        this.converters[i] = new PrimitiveConverter(){

                            public void addBinary(Binary value) {
                                current.getData()[index] = value.toStringUsingUTF8();
                            }

                            public void addBoolean(boolean value) {
                                current.getData()[index] = Boolean.toString(value);
                            }

                            public void addDouble(double value) {
                                current.getData()[index] = Double.toString(value);
                            }

                            public void addFloat(float value) {
                                current.getData()[index] = Float.toString(value);
                            }

                            public void addInt(int value) {
                                current.getData()[index] = Integer.toString(value);
                            }

                            public void addLong(long value) {
                                current.getData()[index] = Long.toString(value);
                            }
                        };
                        break;
                    }
                    case 4: {
                        this.fields.addValueMeta((ValueMetaInterface)new ValueMetaBoolean(f.pentahoFieldName));
                        this.converters[i] = new PrimitiveConverter(){

                            public void addDouble(double value) {
                                current.getData()[index] = Math.round(value) != 0L;
                            }

                            public void addFloat(float value) {
                                current.getData()[index] = Math.round(value) != 0;
                            }

                            public void addInt(int value) {
                                current.getData()[index] = value != 0;
                            }

                            public void addBoolean(boolean value) {
                                current.getData()[index] = value;
                            }
                        };
                        break;
                    }
                    case 7: {
                        this.fields.addValueMeta((ValueMetaInterface)new ValueMetaSerializable(f.pentahoFieldName));
                        this.converters[i] = new PrimitiveConverter(){

                            public void addBinary(Binary value) {
                                current.getData()[index] = value.getBytes();
                            }
                        };
                        break;
                    }
                    case 8: {
                        this.fields.addValueMeta((ValueMetaInterface)new ValueMetaBinary(f.pentahoFieldName));
                        this.converters[i] = new PrimitiveConverter(){

                            public void addBinary(Binary value) {
                                current.getData()[index] = value.getBytes();
                            }
                        };
                        break;
                    }
                    case 3: {
                        this.fields.addValueMeta((ValueMetaInterface)new ValueMetaDate(f.pentahoFieldName));
                        this.converters[i] = new PrimitiveConverter(){

                            public void addLong(long value) {
                                current.getData()[index] = new Date(value);
                            }

                            public void addInt(int value) {
                                current.getData()[index] = new Date((long)value * 24L * 60L * 60L * 1000L);
                            }

                            public void addBinary(Binary value) {
                                current.getData()[index] = new Date(MyGroupConverter.dateFromInt96(value));
                            }
                        };
                        break;
                    }
                    case 9: {
                        this.fields.addValueMeta((ValueMetaInterface)new ValueMetaTimestamp(f.pentahoFieldName));
                        this.converters[i] = new PrimitiveConverter(){

                            public void addLong(long value) {
                                current.getData()[index] = new Timestamp(value);
                            }

                            public void addInt(int value) {
                                current.getData()[index] = new Timestamp((long)value * 24L * 60L * 60L * 1000L);
                            }

                            public void addBinary(Binary value) {
                                current.getData()[index] = new Timestamp(MyGroupConverter.dateFromInt96(value));
                            }
                        };
                        break;
                    }
                    default: {
                        throw new RuntimeException("Undefined type: " + f.pentahoValueMetaType);
                    }
                }
                ++i;
            }
        }

        private static long dateFromInt96(Binary value) {
            byte[] readBuffer = value.getBytes();
            if (readBuffer.length != 12) {
                throw new RuntimeException("Invalid byte array length for INT96");
            }
            long timeOfDayNanos = ((long)readBuffer[7] << 56) + ((long)(readBuffer[6] & 0xFF) << 48) + ((long)(readBuffer[5] & 0xFF) << 40) + ((long)(readBuffer[4] & 0xFF) << 32) + ((long)(readBuffer[3] & 0xFF) << 24) + (long)((readBuffer[2] & 0xFF) << 16) + (long)((readBuffer[1] & 0xFF) << 8) + (long)((readBuffer[0] & 0xFF) << 0);
            int julianDay = ((readBuffer[11] & 0xFF) << 24) + ((readBuffer[10] & 0xFF) << 16) + ((readBuffer[9] & 0xFF) << 8) + ((readBuffer[8] & 0xFF) << 0);
            return (long)(julianDay - 2440588) * 24L * 60L * 60L * 1000L + timeOfDayNanos / 1000000L;
        }

        public void start() {
            this.current = new RowMetaAndData((RowMetaInterface)this.fields, new Object[0]);
            this.current.setData(new Object[this.count]);
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters[fieldIndex];
        }

        public void end() {
        }

        public RowMetaAndData getCurrentRecord() {
            return this.current;
        }
    }

    public static class MyRecordMaterializer
    extends RecordMaterializer<RowMetaAndData> {
        private MyGroupConverter root;

        public MyRecordMaterializer(ParquetConverter converter) {
            this.root = new MyGroupConverter(converter);
        }

        public RowMetaAndData getCurrentRecord() {
            return this.root.getCurrentRecord();
        }

        public GroupConverter getRootConverter() {
            return this.root;
        }
    }
}

