/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common;

import java.io.IOException;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.mapreduce.YarnQueueAclsException;
import org.pentaho.hadoop.mapreduce.YarnQueueAclsVerifier;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.api.fs.Path;
import org.pentaho.hadoop.shim.api.mapred.RunningJob;
import org.pentaho.hadoop.shim.common.ShimUtils;
import org.pentaho.hadoop.shim.common.mapred.RunningJobProxy;

public class ConfigurationProxy
extends JobConf
implements Configuration {
    public ConfigurationProxy() {
        this.addResource("hdfs-site.xml");
    }

    public void setMapperClass(Class c) {
        super.setMapperClass(c);
    }

    public void setCombinerClass(Class c) {
        super.setCombinerClass(c);
    }

    public void setReducerClass(Class c) {
        super.setReducerClass(c);
    }

    public void setMapRunnerClass(Class c) {
        super.setMapRunnerClass(c);
    }

    public void setInputFormat(Class c) {
        super.setInputFormat(c);
    }

    public void setOutputFormat(Class c) {
        super.setOutputFormat(c);
    }

    public String getDefaultFileSystemURL() {
        return this.get("fs.default.name", "");
    }

    public <T> T getAsDelegateConf(Class<T> delegate) {
        if (delegate.isAssignableFrom(((Object)((Object)this)).getClass())) {
            return (T)((Object)this);
        }
        return null;
    }

    public RunningJob submit() throws IOException, ClassNotFoundException, InterruptedException {
        JobClient jobClient = this.createJobClient();
        if (YarnQueueAclsVerifier.verify((QueueAclsInfo[])jobClient.getQueueAclsForCurrentUser())) {
            return new RunningJobProxy(jobClient.submitJob((JobConf)this));
        }
        throw new YarnQueueAclsException(BaseMessages.getString(ConfigurationProxy.class, (String)"ConfigurationProxy.UserHasNoPermissions", (String[])new String[]{UserGroupInformation.getCurrentUser().getUserName()}));
    }

    JobClient createJobClient() throws IOException {
        return new JobClient((JobConf)this);
    }

    public void setInputPaths(Path ... paths) {
        if (paths == null) {
            return;
        }
        org.apache.hadoop.fs.Path[] actualPaths = new org.apache.hadoop.fs.Path[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            actualPaths[i] = ShimUtils.asPath(paths[i]);
        }
        FileInputFormat.setInputPaths((JobConf)this, (org.apache.hadoop.fs.Path[])actualPaths);
    }

    public void setOutputPath(Path path) {
        FileOutputFormat.setOutputPath((JobConf)this, (org.apache.hadoop.fs.Path)ShimUtils.asPath(path));
    }
}

