/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.avro;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericRecord;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.hadoop.shim.api.format.IPentahoOutputFormat;
import org.pentaho.hadoop.shim.api.format.SchemaDescription;
import org.pentaho.hadoop.shim.common.format.avro.AvroConverter;

public class PentahoAvroRecordWriter
implements IPentahoOutputFormat.IPentahoRecordWriter {
    private final DataFileWriter<GenericRecord> nativeAvroRecordWriter;
    private final Schema schema;
    private final SchemaDescription schemaDescription;

    public PentahoAvroRecordWriter(DataFileWriter<GenericRecord> recordWriter, Schema schema, SchemaDescription schemaDescription) {
        this.nativeAvroRecordWriter = recordWriter;
        this.schema = schema;
        this.schemaDescription = schemaDescription;
    }

    public void write(RowMetaAndData row) {
        try {
            this.nativeAvroRecordWriter.append((Object)AvroConverter.convertToAvro(row, this.schema, this.schemaDescription));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        this.nativeAvroRecordWriter.close();
    }
}

