/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.parquet;

import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.hadoop.shim.api.format.SchemaDescription;
import org.pentaho.hadoop.shim.common.format.parquet.ParquetConverter;
import parquet.hadoop.api.WriteSupport;
import parquet.io.api.RecordConsumer;

public class PentahoParquetWriteSupport
extends WriteSupport<RowMetaAndData> {
    ParquetConverter converter;
    RecordConsumer consumer;

    public PentahoParquetWriteSupport(SchemaDescription schema) {
        this.converter = new ParquetConverter(schema);
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        try {
            return new WriteSupport.WriteContext(this.converter.createParquetSchema(), new TreeMap());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.consumer = recordConsumer;
    }

    public void write(RowMetaAndData record) {
        this.converter.writeRow(record, this.consumer);
    }
}

