/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.ExecutionConfiguration;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobExecutionConfiguration
implements ExecutionConfiguration {
    public static final String XML_TAG = "job_execution_configuration";
    private final LogChannelInterface log = LogChannel.GENERAL;
    private boolean executingLocally = true;
    private boolean executingRemotely = false;
    private SlaveServer remoteServer;
    private Map<String, String> arguments = new HashMap<String, String>();
    private Map<String, String> params = new HashMap<String, String>();
    private Map<String, String> variables = new HashMap<String, String>();
    private Date replayDate;
    private boolean safeModeEnabled;
    private LogLevel logLevel;
    private boolean clearingLog = true;
    private Result previousResult;
    private Repository repository;
    private boolean passingExport = false;
    private String startCopyName;
    private int startCopyNr;
    private boolean gatheringMetrics;
    private boolean expandingRemoteJob;
    private Map<String, String> extensionOptions = new HashMap<String, String>();
    private Long passedBatchId;
    private String runConfiguration;

    public JobExecutionConfiguration() {
        this.logLevel = LogLevel.BASIC;
    }

    @Override
    public Object clone() {
        try {
            JobExecutionConfiguration configuration = (JobExecutionConfiguration)super.clone();
            configuration.params = new HashMap<String, String>();
            configuration.params.putAll(this.params);
            configuration.arguments = new HashMap<String, String>();
            configuration.arguments.putAll(this.arguments);
            configuration.variables = new HashMap<String, String>();
            configuration.variables.putAll(this.variables);
            if (this.previousResult != null) {
                configuration.previousResult = this.previousResult.clone();
            }
            return configuration;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public Map<String, String> getArguments() {
        return this.arguments;
    }

    @Override
    public void setArguments(Map<String, String> arguments) {
        this.arguments = arguments;
    }

    @Override
    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public void setArgumentStrings(String[] arguments) {
        this.arguments = new HashMap<String, String>();
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                this.arguments.put("arg " + (i + 1), arguments[i]);
            }
        }
    }

    @Override
    public Map<String, String> getVariables() {
        return this.variables;
    }

    @Override
    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    @Override
    public void setVariables(VariableSpace space) {
        this.variables = new HashMap<String, String>();
        for (String name : space.listVariables()) {
            String value = space.getVariable(name);
            this.variables.put(name, value);
        }
    }

    @Override
    public boolean isExecutingRemotely() {
        return this.executingRemotely;
    }

    @Override
    public void setExecutingRemotely(boolean remoteExecution) {
        this.executingRemotely = remoteExecution;
    }

    @Override
    public boolean isExecutingLocally() {
        return this.executingLocally;
    }

    @Override
    public void setExecutingLocally(boolean localExecution) {
        this.executingLocally = localExecution;
    }

    @Override
    public SlaveServer getRemoteServer() {
        return this.remoteServer;
    }

    @Override
    public void setRemoteServer(SlaveServer remoteServer) {
        this.remoteServer = remoteServer;
    }

    public void getUsedVariables(JobMeta jobMeta) {
        Properties sp = new Properties();
        VariableSpace space = Variables.getADefaultVariableSpace();
        String[] keys = space.listVariables();
        for (int i = 0; i < keys.length; ++i) {
            sp.put(keys[i], space.getVariable(keys[i]));
        }
        List<String> vars = jobMeta.getUsedVariables();
        if (vars != null && vars.size() > 0) {
            HashMap<String, String> newVariables = new HashMap<String, String>();
            for (int i = 0; i < vars.size(); ++i) {
                String varname = vars.get(i);
                if (varname.startsWith("Internal")) continue;
                newVariables.put(varname, Const.NVL((String)this.variables.get(varname), (String)sp.getProperty(varname, "")));
            }
            this.variables.putAll(newVariables);
        }
    }

    @Override
    public Date getReplayDate() {
        return this.replayDate;
    }

    @Override
    public void setReplayDate(Date replayDate) {
        this.replayDate = replayDate;
    }

    @Override
    public boolean isSafeModeEnabled() {
        return this.safeModeEnabled;
    }

    @Override
    public void setSafeModeEnabled(boolean usingSafeMode) {
        this.safeModeEnabled = usingSafeMode;
    }

    @Override
    public String getRunConfiguration() {
        return this.runConfiguration;
    }

    @Override
    public void setRunConfiguration(String runConfiguration) {
        this.runConfiguration = runConfiguration;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public String getXML() throws IOException {
        StringBuilder xml = new StringBuilder(160);
        xml.append("  <job_execution_configuration>").append(Const.CR);
        xml.append("    ").append(XMLHandler.addTagValue((String)"exec_local", (boolean)this.executingLocally));
        xml.append("    ").append(XMLHandler.addTagValue((String)"exec_remote", (boolean)this.executingRemotely));
        if (this.remoteServer != null) {
            xml.append("    ").append(this.remoteServer.getXML()).append(Const.CR);
        }
        xml.append("    ").append(XMLHandler.addTagValue((String)"pass_export", (boolean)this.passingExport));
        xml.append("    <parameters>").append(Const.CR);
        ArrayList<String> paramNames = new ArrayList<String>(this.params.keySet());
        Collections.sort(paramNames);
        for (String string : paramNames) {
            String value = this.params.get(string);
            xml.append("    <parameter>");
            xml.append(XMLHandler.addTagValue((String)"name", (String)string, (boolean)false, (String[])new String[0]));
            xml.append(XMLHandler.addTagValue((String)"value", (String)value, (boolean)false, (String[])new String[0]));
            xml.append("</parameter>").append(Const.CR);
        }
        xml.append("    </parameters>").append(Const.CR);
        xml.append("    <variables>").append(Const.CR);
        ArrayList<String> variableNames = new ArrayList<String>(this.variables.keySet());
        Collections.sort(variableNames);
        for (String name : variableNames) {
            String value = this.variables.get(name);
            xml.append("    <variable>");
            xml.append(XMLHandler.addTagValue((String)"name", (String)name, (boolean)false, (String[])new String[0]));
            xml.append(XMLHandler.addTagValue((String)"value", (String)value, (boolean)false, (String[])new String[0]));
            xml.append("</variable>").append(Const.CR);
        }
        xml.append("    </variables>").append(Const.CR);
        xml.append("    <arguments>").append(Const.CR);
        ArrayList<String> arrayList = new ArrayList<String>(this.arguments.keySet());
        Collections.sort(arrayList);
        for (String name : arrayList) {
            String value = this.arguments.get(name);
            xml.append("    <argument>");
            xml.append(XMLHandler.addTagValue((String)"name", (String)name, (boolean)false, (String[])new String[0]));
            xml.append(XMLHandler.addTagValue((String)"value", (String)value, (boolean)false, (String[])new String[0]));
            xml.append("</argument>").append(Const.CR);
        }
        xml.append("    </arguments>").append(Const.CR);
        xml.append("    ").append(XMLHandler.addTagValue((String)"replay_date", (Date)this.replayDate));
        xml.append("    ").append(XMLHandler.addTagValue((String)"safe_mode", (boolean)this.safeModeEnabled));
        xml.append("    ").append(XMLHandler.addTagValue((String)"log_level", (String)this.logLevel.getCode()));
        xml.append("    ").append(XMLHandler.addTagValue((String)"clear_log", (boolean)this.clearingLog));
        xml.append("    ").append(XMLHandler.addTagValue((String)"start_copy_name", (String)this.startCopyName));
        xml.append("    ").append(XMLHandler.addTagValue((String)"start_copy_nr", (int)this.startCopyNr));
        xml.append("    ").append(XMLHandler.addTagValue((String)"gather_metrics", (boolean)this.gatheringMetrics));
        xml.append("    ").append(XMLHandler.addTagValue((String)"expand_remote_job", (boolean)this.expandingRemoteJob));
        if (this.passedBatchId != null) {
            xml.append("    ").append(XMLHandler.addTagValue((String)"passedBatchId", (long)this.passedBatchId));
        }
        if (this.previousResult != null) {
            xml.append(this.previousResult.getXML());
        }
        if (this.repository != null) {
            xml.append(XMLHandler.openTag((String)"repository"));
            xml.append(XMLHandler.addTagValue((String)"name", (String)this.repository.getName()));
            if (this.repository.getUserInfo() != null) {
                xml.append(XMLHandler.addTagValue((String)"login", (String)this.repository.getUserInfo().getLogin()));
                xml.append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPassword((String)this.repository.getUserInfo().getPassword())));
            }
            xml.append(XMLHandler.closeTag((String)"repository"));
        }
        xml.append("</job_execution_configuration>").append(Const.CR);
        return xml.toString();
    }

    public JobExecutionConfiguration(Node trecNode) throws KettleException {
        this();
        Node repNode;
        Node resultNode;
        this.executingLocally = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"exec_local"));
        this.executingRemotely = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"exec_remote"));
        Node remoteHostNode = XMLHandler.getSubNode((Node)trecNode, (String)"slaveserver");
        if (remoteHostNode != null) {
            this.remoteServer = new SlaveServer(remoteHostNode);
        }
        this.passingExport = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"pass_export"));
        this.expandingRemoteJob = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"expand_remote_job"));
        Node varsNode = XMLHandler.getSubNode((Node)trecNode, (String)"variables");
        int nrVariables = XMLHandler.countNodes((Node)varsNode, (String)"variable");
        for (int i = 0; i < nrVariables; ++i) {
            Node argNode = XMLHandler.getSubNodeByNr((Node)varsNode, (String)"variable", (int)i);
            String name = XMLHandler.getTagValue((Node)argNode, (String)"name");
            String value = XMLHandler.getTagValue((Node)argNode, (String)"value");
            if (Utils.isEmpty((CharSequence)name) || Utils.isEmpty((CharSequence)value)) continue;
            this.variables.put(name, value);
        }
        Node argsNode = XMLHandler.getSubNode((Node)trecNode, (String)"arguments");
        int nrArguments = XMLHandler.countNodes((Node)argsNode, (String)"argument");
        for (int i = 0; i < nrArguments; ++i) {
            Node argNode = XMLHandler.getSubNodeByNr((Node)argsNode, (String)"argument", (int)i);
            String name = XMLHandler.getTagValue((Node)argNode, (String)"name");
            String value = XMLHandler.getTagValue((Node)argNode, (String)"value");
            if (Utils.isEmpty((CharSequence)name) || Utils.isEmpty((CharSequence)value)) continue;
            this.arguments.put(name, value);
        }
        Node parmsNode = XMLHandler.getSubNode((Node)trecNode, (String)"parameters");
        int nrParams = XMLHandler.countNodes((Node)parmsNode, (String)"parameter");
        for (int i = 0; i < nrParams; ++i) {
            Node parmNode = XMLHandler.getSubNodeByNr((Node)parmsNode, (String)"parameter", (int)i);
            String name = XMLHandler.getTagValue((Node)parmNode, (String)"name");
            String value = XMLHandler.getTagValue((Node)parmNode, (String)"value");
            if (Utils.isEmpty((CharSequence)name)) continue;
            this.params.put(name, value);
        }
        this.replayDate = XMLHandler.stringToDate((String)XMLHandler.getTagValue((Node)trecNode, (String)"replay_date"));
        this.safeModeEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"safe_mode"));
        this.logLevel = LogLevel.getLogLevelForCode((String)XMLHandler.getTagValue((Node)trecNode, (String)"log_level"));
        this.clearingLog = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"clear_log"));
        this.startCopyName = XMLHandler.getTagValue((Node)trecNode, (String)"start_copy_name");
        this.startCopyNr = Const.toInt((String)XMLHandler.getTagValue((Node)trecNode, (String)"start_copy_nr"), (int)0);
        this.gatheringMetrics = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)trecNode, (String)"gather_metrics"));
        String sPassedBatchId = XMLHandler.getTagValue((Node)trecNode, (String)"passedBatchId");
        if (!StringUtils.isEmpty((String)sPassedBatchId)) {
            this.passedBatchId = Long.parseLong(sPassedBatchId);
        }
        if ((resultNode = XMLHandler.getSubNode((Node)trecNode, (String)"result")) != null) {
            try {
                this.previousResult = new Result(resultNode);
            }
            catch (KettleException e) {
                throw new KettleException("Unable to hydrate previous result", (Throwable)e);
            }
        }
        if ((repNode = XMLHandler.getSubNode((Node)trecNode, (String)"repository")) != null) {
            String repositoryName = XMLHandler.getTagValue((Node)repNode, (String)"name");
            String username = XMLHandler.getTagValue((Node)repNode, (String)"login");
            String password = Encr.decryptPassword((String)XMLHandler.getTagValue((Node)repNode, (String)"password"));
            this.connectRepository(repositoryName, username, password);
        }
    }

    public Repository connectRepository(String repositoryName, String username, String password) throws KettleException {
        RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
        repositoriesMeta.getLog().setLogLevel(this.log.getLogLevel());
        try {
            repositoriesMeta.readData();
        }
        catch (Exception e) {
            throw new KettleException("Unable to get a list of repositories to locate repository '" + repositoryName + "'");
        }
        return this.connectRepository(repositoriesMeta, repositoryName, username, password);
    }

    @Override
    public Repository connectRepository(RepositoriesMeta repositoriesMeta, String repositoryName, String username, String password) throws KettleException {
        RepositoryMeta repositoryMeta = repositoriesMeta.findRepository(repositoryName);
        if (repositoryMeta == null) {
            this.log.logBasic("I couldn't find the repository with name '" + repositoryName + "'");
            return null;
        }
        Repository rep = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
        rep.init(repositoryMeta);
        try {
            rep.connect(username, password);
            this.log.logBasic("Connected to " + repositoryName + " as " + username);
            this.setRepository(rep);
            return rep;
        }
        catch (Exception e) {
            this.log.logBasic("Unable to connect to the repository with name '" + repositoryName + "'");
            return null;
        }
    }

    @Override
    public String[] getArgumentStrings() {
        if (this.arguments == null || this.arguments.size() == 0) {
            return null;
        }
        Object[] argNames = this.arguments.keySet().toArray(new String[this.arguments.size()]);
        Arrays.sort(argNames);
        String[] values = new String[argNames.length];
        for (int i = 0; i < argNames.length; ++i) {
            values[i] = this.arguments.get(argNames[i]);
        }
        return values;
    }

    @Override
    public Result getPreviousResult() {
        return this.previousResult;
    }

    @Override
    public void setPreviousResult(Result previousResult) {
        this.previousResult = previousResult;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public boolean isClearingLog() {
        return this.clearingLog;
    }

    @Override
    public void setClearingLog(boolean clearingLog) {
        this.clearingLog = clearingLog;
    }

    @Override
    public boolean isPassingExport() {
        return this.passingExport;
    }

    @Override
    public void setPassingExport(boolean passingExport) {
        this.passingExport = passingExport;
    }

    public String getStartCopyName() {
        return this.startCopyName;
    }

    public void setStartCopyName(String startCopyName) {
        this.startCopyName = startCopyName;
    }

    public int getStartCopyNr() {
        return this.startCopyNr;
    }

    public void setStartCopyNr(int startCopyNr) {
        this.startCopyNr = startCopyNr;
    }

    @Override
    public boolean isGatheringMetrics() {
        return this.gatheringMetrics;
    }

    @Override
    public void setGatheringMetrics(boolean gatheringMetrics) {
        this.gatheringMetrics = gatheringMetrics;
    }

    public void setExpandingRemoteJob(boolean expandingRemoteJob) {
        this.expandingRemoteJob = expandingRemoteJob;
    }

    public boolean isExpandingRemoteJob() {
        return this.expandingRemoteJob;
    }

    public Map<String, String> getExtensionOptions() {
        return this.extensionOptions;
    }

    public void setExtensionOptions(Map<String, String> extensionOptions) {
        this.extensionOptions = extensionOptions;
    }

    @Override
    public Long getPassedBatchId() {
        return this.passedBatchId;
    }

    @Override
    public void setPassedBatchId(Long passedBatchId) {
        this.passedBatchId = passedBatchId;
    }

    public void getUsedArguments(JobMeta jobMeta, String[] commandLineArguments, IMetaStore metaStore) {
        for (JobEntryCopy jobEntryCopy : jobMeta.jobcopies) {
            if (!jobEntryCopy.isTransformation()) continue;
            JobEntryTrans jobEntryTrans = (JobEntryTrans)jobEntryCopy.getEntry();
            try {
                TransMeta transMeta = jobEntryTrans.getTransMeta(this.repository, metaStore, jobMeta);
                Map<String, String> map = transMeta.getUsedArguments(commandLineArguments);
                for (String key : map.keySet()) {
                    String value = map.get(key);
                    if (this.arguments.containsKey(key)) continue;
                    this.arguments.put(key, value);
                }
            }
            catch (KettleException ke) {
                this.log.logBasic(ke.getMessage(), new Object[]{ke});
            }
        }
    }
}

