/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.addresultfilenames;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryAddResultFilenames
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryAddResultFilenames.class;
    public boolean argFromPrevious = false;
    public boolean deleteallbefore = false;
    public boolean includeSubfolders = false;
    public String[] arguments = null;
    public String[] filemasks;

    public JobEntryAddResultFilenames(String n) {
        super(n, "");
    }

    public JobEntryAddResultFilenames() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryAddResultFilenames je = (JobEntryAddResultFilenames)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.includeSubfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"delete_all_before", (boolean)this.deleteallbefore));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"filemask", (String)this.filemasks[i]));
                retval.append("        </field>").append(Const.CR);
                if (this.parentJobMeta == null) continue;
                this.parentJobMeta.getNamedClusterEmbedManager().registerUrl(this.arguments[i]);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.includeSubfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.deleteallbefore = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"delete_all_before"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.arguments = new String[nrFields];
            this.filemasks = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.filemasks[i] = XMLHandler.getTagValue((Node)fnode, (String)"filemask");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryAddResultFilenames.UnableToLoadFromXml", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.includeSubfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            this.deleteallbefore = rep.getJobEntryAttributeBoolean(id_jobentry, "delete_all_before");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "name");
            this.arguments = new String[argnr];
            this.filemasks = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "name");
                this.filemasks[a] = rep.getJobEntryAttributeString(id_jobentry, a, "filemask");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryAddResultFilenames.UnableToLoadFromRepo", (String[])new String[]{String.valueOf(id_jobentry)}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "arg_from_previous", this.argFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_subfolders", this.includeSubfolders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "delete_all_before", this.deleteallbefore);
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "name", this.arguments[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "filemask", this.filemasks[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryAddResultFilenames.UnableToSaveToRepo", (String[])new String[]{String.valueOf(id_job)}), (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result result, int nr) throws KettleException {
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        int nrErrFiles = 0;
        result.setResult(true);
        if (this.deleteallbefore) {
            int size = result.getResultFiles().size();
            if (this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryAddResultFilenames.log.FilesFound", (String[])new String[]{"" + size}));
            }
            result.getResultFiles().clear();
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryAddResultFilenames.log.DeletedFiles", (String[])new String[]{"" + size}));
            }
        }
        if (this.argFromPrevious && this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryAddResultFilenames.FoundPreviousRows", (String[])new String[]{String.valueOf(rows != null ? rows.size() : 0)}));
        }
        if (this.argFromPrevious && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                resultRow = (RowMetaAndData)rows.get(iteration);
                String filefolder_previous = resultRow.getString(0, null);
                String fmasks_previous = resultRow.getString(1, null);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryAddResultFilenames.ProcessingRow", (String[])new String[]{filefolder_previous, fmasks_previous}));
                }
                if (this.processFile(filefolder_previous, fmasks_previous, this.parentJob, result)) continue;
                ++nrErrFiles;
            }
        } else if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length && !this.parentJob.isStopped(); ++i) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryAddResultFilenames.ProcessingArg", (String[])new String[]{this.arguments[i], this.filemasks[i]}));
                }
                if (this.processFile(this.arguments[i], this.filemasks[i], this.parentJob, result)) continue;
                ++nrErrFiles;
            }
        }
        if (nrErrFiles > 0) {
            result.setResult(false);
            result.setNrErrors((long)nrErrFiles);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFile(String filename, String wildcard, Job parentJob, Result result) {
        boolean rcode = true;
        FileObject filefolder = null;
        String realFilefoldername = this.environmentSubstitute(filename);
        String realwildcard = this.environmentSubstitute(wildcard);
        try {
            if (this.parentJobMeta.getNamedClusterEmbedManager() != null) {
                this.parentJobMeta.getNamedClusterEmbedManager().passEmbeddedMetastoreKey(this, this.parentJobMeta.getEmbeddedMetastoreProviderKey());
            }
            if ((filefolder = KettleVFS.getFileObject((String)realFilefoldername, (VariableSpace)this)).exists()) {
                if (filefolder.getType() == FileType.FILE) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryAddResultFilenames.AddingFileToResult", (String[])new String[]{filefolder.toString()}));
                    }
                    ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)filefolder.toString(), (VariableSpace)this), parentJob.getJobname(), this.toString());
                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                } else {
                    FileObject[] list = filefolder.findFiles((FileSelector)new TextFileSelector(filefolder.toString(), realwildcard));
                    for (int i = 0; i < list.length && !parentJob.isStopped(); ++i) {
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryAddResultFilenames.AddingFileToResult", (String[])new String[]{list[i].toString()}));
                        }
                        ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)list[i].toString(), (VariableSpace)this), parentJob.getJobname(), this.toString());
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                    }
                }
            } else {
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryAddResultFilenames.FileCanNotbeFound", (String[])new String[]{realFilefoldername}));
                }
                rcode = false;
            }
        }
        catch (Exception e) {
            rcode = false;
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryAddResultFilenames.CouldNotProcess", (String[])new String[]{realFilefoldername, e.getMessage()}), e);
        }
        finally {
            if (filefolder != null) {
                try {
                    filefolder.close();
                    filefolder = null;
                }
                catch (IOException iOException) {}
            }
        }
        return rcode;
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Utils.isEmpty((CharSequence)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setIncludeSubfolders(boolean includeSubfolders) {
        this.includeSubfolders = includeSubfolders;
    }

    public void setArgumentsPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    public void setDeleteAllBefore(boolean deleteallbefore) {
        this.deleteallbefore = deleteallbefore;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public boolean deleteAllBefore() {
        return this.deleteallbefore;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String[] getFilemasks() {
        return this.filemasks;
    }

    public boolean isIncludeSubfolders() {
        return this.includeSubfolders;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.arguments.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    private class TextFileSelector
    implements FileSelector {
        String fileWildcard = null;
        String sourceFolder = null;

        public TextFileSelector(String sourcefolderin, String filewildcard) {
            if (!Utils.isEmpty((CharSequence)sourcefolderin)) {
                this.sourceFolder = sourcefolderin;
            }
            if (!Utils.isEmpty((CharSequence)filewildcard)) {
                this.fileWildcard = filewildcard;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean returncode = false;
            try {
                if (!info.getFile().toString().equals(this.sourceFolder)) {
                    String short_filename = info.getFile().getName().getBaseName();
                    if ((info.getFile().getParent().equals(info.getBaseFolder()) || !info.getFile().getParent().equals(info.getBaseFolder()) && JobEntryAddResultFilenames.this.includeSubfolders) && (info.getFile().getType() == FileType.FILE && this.fileWildcard == null || info.getFile().getType() == FileType.FILE && this.fileWildcard != null && JobEntryAddResultFilenames.this.GetFileWildcard(short_filename, this.fileWildcard))) {
                        returncode = true;
                    }
                }
            }
            catch (Exception e) {
                JobEntryAddResultFilenames.this.logError("Error while finding files ... in [" + info.getFile().toString() + "]. Exception :" + e.getMessage());
                returncode = false;
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

