/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.job;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.listeners.CurrentDirectoryChangedListener;
import org.pentaho.di.core.listeners.impl.EntryCurrentDirectoryChangedListener;
import org.pentaho.di.core.logging.LogChannelFileWriter;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.util.CurrentDirectoryResolver;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.DelegationListener;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJobRunner;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryImportLocation;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryJob
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryJob.class;
    private String filename;
    private String jobname;
    private String directory;
    private ObjectId jobObjectId;
    private ObjectLocationSpecificationMethod specificationMethod;
    public String[] arguments;
    public boolean argFromPrevious;
    public boolean paramsFromPrevious;
    public boolean execPerRow;
    public String[] parameters;
    public String[] parameterFieldNames;
    public String[] parameterValues;
    public boolean setLogfile;
    public String logfile;
    public String logext;
    public boolean addDate;
    public boolean addTime;
    public LogLevel logFileLevel;
    public boolean parallel;
    private String directoryPath;
    public boolean setAppendLogfile;
    public boolean createParentFolder;
    public boolean waitingToFinish = true;
    public boolean followingAbortRemotely;
    public boolean expandingRemoteJob;
    private String remoteSlaveServerName;
    public boolean passingAllParameters = true;
    private boolean passingExport;
    private String runConfiguration;
    public static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.NOTHING;
    private Job job;
    private CurrentDirectoryChangedListener dirListener = new EntryCurrentDirectoryChangedListener(this::getSpecificationMethod, this::getDirectory, this::setDirectory);

    public JobEntryJob(String name) {
        super(name, "");
    }

    public JobEntryJob() {
        this("");
        this.clear();
    }

    private void allocateArgs(int nrArgs) {
        this.arguments = new String[nrArgs];
    }

    private void allocateParams(int nrParameters) {
        this.parameters = new String[nrParameters];
        this.parameterFieldNames = new String[nrParameters];
        this.parameterValues = new String[nrParameters];
    }

    @Override
    public Object clone() {
        JobEntryJob je = (JobEntryJob)super.clone();
        if (this.arguments != null) {
            int nrArgs = this.arguments.length;
            je.allocateArgs(nrArgs);
            System.arraycopy(this.arguments, 0, je.arguments, 0, nrArgs);
        }
        if (this.parameters != null) {
            int nrParameters = this.parameters.length;
            je.allocateParams(nrParameters);
            System.arraycopy(this.parameters, 0, je.parameters, 0, nrParameters);
            System.arraycopy(this.parameterFieldNames, 0, je.parameterFieldNames, 0, nrParameters);
            System.arraycopy(this.parameterValues, 0, je.parameterValues, 0, nrParameters);
        }
        return je;
    }

    public void setFileName(String n) {
        this.filename = n;
    }

    @Deprecated
    public String getFileName() {
        return this.filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getRealFilename() {
        return this.environmentSubstitute(this.getFilename());
    }

    public void setJobName(String jobname) {
        this.jobname = jobname;
    }

    public String getJobName() {
        return this.jobname;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public boolean isPassingExport() {
        return this.passingExport;
    }

    public void setPassingExport(boolean passingExport) {
        this.passingExport = passingExport;
    }

    public String getRunConfiguration() {
        return this.runConfiguration;
    }

    public void setRunConfiguration(String runConfiguration) {
        this.runConfiguration = runConfiguration;
    }

    public String getLogFilename() {
        String retval = "";
        if (this.setLogfile) {
            SimpleDateFormat sdf;
            retval = retval + (this.logfile == null ? "" : this.logfile);
            Calendar cal = Calendar.getInstance();
            if (this.addDate) {
                sdf = new SimpleDateFormat("yyyyMMdd");
                retval = retval + "_" + sdf.format(cal.getTime());
            }
            if (this.addTime) {
                sdf = new SimpleDateFormat("HHmmss");
                retval = retval + "_" + sdf.format(cal.getTime());
            }
            if (this.logext != null && this.logext.length() > 0) {
                retval = retval + "." + this.logext;
            }
        }
        return retval;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(400);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"specification_method", this.specificationMethod == null ? null : this.specificationMethod.getCode()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"job_object_id", this.jobObjectId == null ? null : this.jobObjectId.toString()));
        if (this.rep != null && this.jobObjectId != null) {
            try {
                RepositoryObject objectInformation = this.rep.getObjectInformation(this.jobObjectId, RepositoryObjectType.JOB);
                if (objectInformation != null) {
                    this.jobname = objectInformation.getName();
                    this.directory = objectInformation.getRepositoryDirectory().getPath();
                }
            }
            catch (KettleException objectInformation) {
                // empty catch block
            }
        }
        if (this.parentJobMeta != null) {
            this.parentJobMeta.getNamedClusterEmbedManager().registerUrl(this.filename);
        }
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"jobname", (String)this.jobname));
        if (this.directory != null) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"directory", (String)this.directory));
        } else if (this.directoryPath != null) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"directory", (String)this.directoryPath));
        }
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"params_from_previous", (boolean)this.paramsFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"exec_per_row", (boolean)this.execPerRow));
        retval.append("      ").append(XMLHandler.addTagValue((String)"set_logfile", (boolean)this.setLogfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logfile", (String)this.logfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logext", (String)this.logext));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.addDate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.addTime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"loglevel", (String)(this.logFileLevel != null ? this.logFileLevel.getCode() : DEFAULT_LOG_LEVEL.getCode())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"slave_server_name", (String)this.remoteSlaveServerName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wait_until_finished", (boolean)this.waitingToFinish));
        retval.append("      ").append(XMLHandler.addTagValue((String)"follow_abort_remote", (boolean)this.followingAbortRemotely));
        retval.append("      ").append(XMLHandler.addTagValue((String)"expand_remote_job", (boolean)this.expandingRemoteJob));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_parent_folder", (boolean)this.createParentFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"pass_export", (boolean)this.passingExport));
        retval.append("      ").append(XMLHandler.addTagValue((String)"run_configuration", (String)this.runConfiguration));
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("      ").append(XMLHandler.addTagValue((String)("argument" + i), (String)this.arguments[i]));
            }
        }
        if (this.parameters != null) {
            retval.append("      ").append(XMLHandler.openTag((String)"parameters"));
            retval.append("        ").append(XMLHandler.addTagValue((String)"pass_all_parameters", (boolean)this.passingAllParameters));
            for (int i = 0; i < this.parameters.length; ++i) {
                retval.append("            ").append(XMLHandler.openTag((String)"parameter"));
                retval.append("            ").append(XMLHandler.addTagValue((String)"name", (String)this.parameters[i]));
                retval.append("            ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.parameterFieldNames[i]));
                retval.append("            ").append(XMLHandler.addTagValue((String)"value", (String)this.parameterValues[i]));
                retval.append("            ").append(XMLHandler.closeTag((String)"parameter"));
            }
            retval.append("      ").append(XMLHandler.closeTag((String)"parameters"));
        }
        retval.append("      ").append(XMLHandler.addTagValue((String)"set_append_logfile", (boolean)this.setAppendLogfile));
        return retval.toString();
    }

    private void checkObjectLocationSpecificationMethod() {
        if (this.specificationMethod == null) {
            this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
            if (!Utils.isEmpty((CharSequence)this.filename)) {
                this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
            } else if (this.jobObjectId != null) {
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
            } else if (!Utils.isEmpty((CharSequence)this.jobname)) {
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
            }
        }
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            String method = XMLHandler.getTagValue((Node)entrynode, (String)"specification_method");
            this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
            String jobId = XMLHandler.getTagValue((Node)entrynode, (String)"job_object_id");
            this.jobObjectId = Utils.isEmpty((CharSequence)jobId) ? null : new StringObjectId(jobId);
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.jobname = XMLHandler.getTagValue((Node)entrynode, (String)"jobname");
            if (rep != null && rep.isConnected() && !Utils.isEmpty((CharSequence)this.jobname)) {
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
            }
            this.checkObjectLocationSpecificationMethod();
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.paramsFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"params_from_previous"));
            this.execPerRow = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"exec_per_row"));
            this.setLogfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"set_logfile"));
            this.addDate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.addTime = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.logfile = XMLHandler.getTagValue((Node)entrynode, (String)"logfile");
            this.logext = XMLHandler.getTagValue((Node)entrynode, (String)"logext");
            this.logFileLevel = LogLevel.getLogLevelForCode((String)XMLHandler.getTagValue((Node)entrynode, (String)"loglevel"));
            this.setAppendLogfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"set_append_logfile"));
            this.remoteSlaveServerName = XMLHandler.getTagValue((Node)entrynode, (String)"slave_server_name");
            this.passingExport = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"pass_export"));
            this.directory = XMLHandler.getTagValue((Node)entrynode, (String)"directory");
            this.createParentFolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"create_parent_folder"));
            this.runConfiguration = XMLHandler.getTagValue((Node)entrynode, (String)"run_configuration");
            String wait = XMLHandler.getTagValue((Node)entrynode, (String)"wait_until_finished");
            this.waitingToFinish = Utils.isEmpty((CharSequence)wait) ? true : "Y".equalsIgnoreCase(wait);
            this.followingAbortRemotely = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"follow_abort_remote"));
            this.expandingRemoteJob = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"expand_remote_job"));
            int argnr = 0;
            while (XMLHandler.getTagValue((Node)entrynode, (String)("argument" + argnr)) != null) {
                ++argnr;
            }
            this.allocateArgs(argnr);
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = XMLHandler.getTagValue((Node)entrynode, (String)("argument" + a));
            }
            Node parametersNode = XMLHandler.getSubNode((Node)entrynode, (String)"parameters");
            String passAll = XMLHandler.getTagValue((Node)parametersNode, (String)"pass_all_parameters");
            this.passingAllParameters = Utils.isEmpty((CharSequence)passAll) || "Y".equalsIgnoreCase(passAll);
            int nrParameters = XMLHandler.countNodes((Node)parametersNode, (String)"parameter");
            this.allocateParams(nrParameters);
            for (int i = 0; i < nrParameters; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)parametersNode, (String)"parameter", (int)i);
                this.parameters[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.parameterFieldNames[i] = XMLHandler.getTagValue((Node)knode, (String)"stream_name");
                this.parameterValues[i] = XMLHandler.getTagValue((Node)knode, (String)"value");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load 'job' job entry from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            String method = rep.getJobEntryAttributeString(id_jobentry, "specification_method");
            this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
            String jobId = rep.getJobEntryAttributeString(id_jobentry, "job_object_id");
            this.jobObjectId = Utils.isEmpty((CharSequence)jobId) ? null : new StringObjectId(jobId);
            this.jobname = rep.getJobEntryAttributeString(id_jobentry, "name");
            this.directory = rep.getJobEntryAttributeString(id_jobentry, "dir_path");
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "file_name");
            this.checkObjectLocationSpecificationMethod();
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.paramsFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "params_from_previous");
            this.execPerRow = rep.getJobEntryAttributeBoolean(id_jobentry, "exec_per_row");
            this.setLogfile = rep.getJobEntryAttributeBoolean(id_jobentry, "set_logfile");
            this.addDate = rep.getJobEntryAttributeBoolean(id_jobentry, "add_date");
            this.addTime = rep.getJobEntryAttributeBoolean(id_jobentry, "add_time");
            this.logfile = rep.getJobEntryAttributeString(id_jobentry, "logfile");
            this.logext = rep.getJobEntryAttributeString(id_jobentry, "logext");
            this.logFileLevel = LogLevel.getLogLevelForCode((String)rep.getJobEntryAttributeString(id_jobentry, "loglevel"));
            this.setAppendLogfile = rep.getJobEntryAttributeBoolean(id_jobentry, "set_append_logfile");
            this.remoteSlaveServerName = rep.getJobEntryAttributeString(id_jobentry, "slave_server_name");
            this.passingExport = rep.getJobEntryAttributeBoolean(id_jobentry, "pass_export");
            this.waitingToFinish = rep.getJobEntryAttributeBoolean(id_jobentry, "wait_until_finished", true);
            this.followingAbortRemotely = rep.getJobEntryAttributeBoolean(id_jobentry, "follow_abort_remote");
            this.expandingRemoteJob = rep.getJobEntryAttributeBoolean(id_jobentry, "expand_remote_job");
            this.createParentFolder = rep.getJobEntryAttributeBoolean(id_jobentry, "create_parent_folder");
            this.runConfiguration = rep.getJobEntryAttributeString(id_jobentry, "run_configuration");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "argument");
            this.allocateArgs(argnr);
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "argument");
            }
            int parameternr = rep.countNrJobEntryAttributes(id_jobentry, "parameter_name");
            this.allocateParams(parameternr);
            for (int a = 0; a < parameternr; ++a) {
                this.parameters[a] = rep.getJobEntryAttributeString(id_jobentry, a, "parameter_name");
                this.parameterFieldNames[a] = rep.getJobEntryAttributeString(id_jobentry, a, "parameter_stream_name");
                this.parameterValues[a] = rep.getJobEntryAttributeString(id_jobentry, a, "parameter_value");
            }
            this.passingAllParameters = rep.getJobEntryAttributeBoolean(id_jobentry, "pass_all_parameters", true);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'job' from the repository with id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            int i;
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "specification_method", this.specificationMethod == null ? null : this.specificationMethod.getCode());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "job_object_id", this.jobObjectId == null ? null : this.jobObjectId.toString());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "name", this.getJobName());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "dir_path", this.getDirectory() != null ? this.getDirectory() : "");
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "file_name", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "arg_from_previous", this.argFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "params_from_previous", this.paramsFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "exec_per_row", this.execPerRow);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "set_logfile", this.setLogfile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_date", this.addDate);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_time", this.addTime);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logfile", this.logfile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logext", this.logext);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "set_append_logfile", this.setAppendLogfile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "loglevel", this.logFileLevel != null ? this.logFileLevel.getCode() : DEFAULT_LOG_LEVEL.getCode());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "slave_server_name", this.remoteSlaveServerName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "pass_export", this.passingExport);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wait_until_finished", this.waitingToFinish);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "follow_abort_remote", this.followingAbortRemotely);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "expand_remote_job", this.expandingRemoteJob);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "create_parent_folder", this.createParentFolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "run_configuration", this.runConfiguration);
            if (this.arguments != null) {
                for (i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "argument", this.arguments[i]);
                }
            }
            if (this.parameters != null) {
                for (i = 0; i < this.parameters.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "parameter_name", this.parameters[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "parameter_stream_name", Const.NVL((String)this.parameterFieldNames[i], (String)""));
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "parameter_value", Const.NVL((String)this.parameterValues[i], (String)""));
                }
            }
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "pass_all_parameters", this.passingAllParameters);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type job to the repository with id_job=" + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result result, int nr) throws KettleException {
        result.setEntryNr((long)nr);
        LogChannelFileWriter logChannelFileWriter = null;
        LogLevel jobLogLevel = this.parentJob.getLogLevel();
        if (this.parentJobMeta.getNamedClusterEmbedManager() != null) {
            this.parentJobMeta.getNamedClusterEmbedManager().passEmbeddedMetastoreKey(this, this.parentJobMeta.getEmbeddedMetastoreProviderKey());
        }
        if (this.setLogfile) {
            String realLogFilename = this.environmentSubstitute(this.getLogFilename());
            if (Utils.isEmpty((CharSequence)realLogFilename)) {
                this.logError(BaseMessages.getString(PKG, (String)"JobJob.Exception.LogFilenameMissing", (String[])new String[0]));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            if (!this.createParentFolder(realLogFilename)) {
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            try {
                logChannelFileWriter = new LogChannelFileWriter(this.getLogChannelId(), KettleVFS.getFileObject((String)realLogFilename), this.setAppendLogfile);
                logChannelFileWriter.startLogging();
            }
            catch (KettleException e) {
                this.logError("Unable to open file appender for file [" + this.getLogFilename() + "] : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            jobLogLevel = this.logFileLevel;
        }
        try {
            if (this.parentJob.getJobMeta() != null) {
                this.parentJob.getJobMeta().setInternalKettleVariables();
            }
            switch (this.specificationMethod) {
                case REPOSITORY_BY_NAME: {
                    if (!this.log.isDetailed()) break;
                    this.logDetailed("Loading job from repository : [" + this.directory + " : " + this.environmentSubstitute(this.jobname) + "]");
                    break;
                }
                case FILENAME: {
                    if (!this.log.isDetailed()) break;
                    this.logDetailed("Loading job from XML file : [" + this.environmentSubstitute(this.filename) + "]");
                    break;
                }
                case REPOSITORY_BY_REFERENCE: {
                    if (!this.log.isDetailed()) break;
                    this.logDetailed("Loading job from repository by reference : [" + this.jobObjectId + "]");
                    break;
                }
            }
            JobMeta jobMeta = this.getJobMeta(this.rep, this);
            if (jobMeta == null) {
                throw new KettleException("Unable to load the job: please specify the name and repository directory OR a filename");
            }
            this.verifyRecursiveExecution(this.parentJob, jobMeta);
            int iteration = 0;
            String[] args1 = this.arguments;
            if (args1 == null || args1.length == 0) {
                args1 = this.parentJob.getArguments();
            }
            this.copyVariablesFrom(this.parentJob);
            this.setParentVariableSpace(this.parentJob);
            String[] args = null;
            if (args1 != null) {
                args = new String[args1.length];
                for (int idx = 0; idx < args1.length; ++idx) {
                    args[idx] = this.environmentSubstitute(args1[idx]);
                }
            }
            RowMetaAndData resultRow = null;
            boolean first = true;
            ArrayList rows = new ArrayList(result.getRows());
            while (first && !this.execPerRow || this.execPerRow && rows != null && iteration < rows.size() && result.getNrErrors() == 0L) {
                Result oneResult;
                block98: {
                    String fieldValue;
                    first = false;
                    if (this.execPerRow) {
                        result.getRows().clear();
                    }
                    resultRow = rows != null && this.execPerRow ? (RowMetaAndData)rows.get(iteration) : null;
                    NamedParamsDefault namedParam = new NamedParamsDefault();
                    if (this.paramsFromPrevious) {
                        String[] parentParameters = this.parentJob.listParameters();
                        for (int idx = 0; idx < parentParameters.length; ++idx) {
                            String par = parentParameters[idx];
                            String def = this.parentJob.getParameterDefault(par);
                            String val = this.parentJob.getParameterValue(par);
                            String des = this.parentJob.getParameterDescription(par);
                            namedParam.addParameterDefinition(par, def, des);
                            namedParam.setParameterValue(par, val);
                        }
                    }
                    if (this.parameters != null) {
                        for (int idx = 0; idx < this.parameters.length; ++idx) {
                            if (Utils.isEmpty((CharSequence)this.parameters[idx])) continue;
                            if (Const.indexOfString((String)this.parameters[idx], (String[])namedParam.listParameters()) < 0) {
                                try {
                                    namedParam.addParameterDefinition(this.parameters[idx], "", "Job entry runtime");
                                }
                                catch (DuplicateParamException e) {
                                    this.logError("Duplicate parameter definition for " + this.parameters[idx]);
                                }
                            }
                            if (Utils.isEmpty((CharSequence)Const.trim((String)this.parameterFieldNames[idx]))) {
                                namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.environmentSubstitute(this.parameterValues[idx]), (String)""));
                                continue;
                            }
                            String value = "";
                            if (resultRow != null) {
                                value = resultRow.getString(this.parameterFieldNames[idx], "");
                            }
                            namedParam.setParameterValue(this.parameters[idx], value);
                        }
                    }
                    oneResult = new Result();
                    ArrayList<RowMetaAndData> sourceRows = null;
                    if (this.execPerRow) {
                        if (this.argFromPrevious) {
                            args = null;
                            if (resultRow != null) {
                                args = new String[resultRow.size()];
                                for (int i = 0; i < resultRow.size(); ++i) {
                                    args[i] = resultRow.getString(i, null);
                                }
                            }
                        } else {
                            ArrayList<RowMetaAndData> newList = new ArrayList<RowMetaAndData>();
                            newList.add(resultRow);
                            sourceRows = newList;
                        }
                        if (this.paramsFromPrevious && this.parameters != null) {
                            for (int idx = 0; idx < this.parameters.length; ++idx) {
                                if (Utils.isEmpty((CharSequence)this.parameters[idx])) continue;
                                if (Utils.isEmpty((CharSequence)Const.trim((String)this.parameterFieldNames[idx]))) {
                                    namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.environmentSubstitute(this.parameterValues[idx]), (String)""));
                                    continue;
                                }
                                fieldValue = "";
                                if (resultRow != null) {
                                    fieldValue = resultRow.getString(this.parameterFieldNames[idx], "");
                                }
                                namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)fieldValue, (String)""));
                            }
                        }
                    } else {
                        if (this.argFromPrevious) {
                            args = null;
                            if (resultRow != null) {
                                args = new String[resultRow.size()];
                                for (int i = 0; i < resultRow.size(); ++i) {
                                    args[i] = resultRow.getString(i, null);
                                }
                            }
                        } else {
                            sourceRows = result.getRows();
                        }
                        if (this.paramsFromPrevious && this.parameters != null) {
                            for (int idx = 0; idx < this.parameters.length; ++idx) {
                                if (Utils.isEmpty((CharSequence)this.parameters[idx])) continue;
                                if (Utils.isEmpty((CharSequence)Const.trim((String)this.parameterFieldNames[idx]))) {
                                    namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)this.environmentSubstitute(this.parameterValues[idx]), (String)""));
                                    continue;
                                }
                                fieldValue = "";
                                if (resultRow != null) {
                                    fieldValue = resultRow.getString(this.parameterFieldNames[idx], "");
                                }
                                namedParam.setParameterValue(this.parameters[idx], Const.NVL((String)fieldValue, (String)""));
                            }
                        }
                    }
                    boolean doFallback = true;
                    SlaveServer remoteSlaveServer = null;
                    JobExecutionConfiguration executionConfiguration = new JobExecutionConfiguration();
                    if (!Utils.isEmpty((CharSequence)this.runConfiguration)) {
                        this.log.logBasic(BaseMessages.getString(PKG, (String)"JobJob.RunConfig.Message", (String[])new String[0]), new Object[]{this.runConfiguration});
                        this.runConfiguration = this.environmentSubstitute(this.runConfiguration);
                        executionConfiguration.setRunConfiguration(this.runConfiguration);
                        try {
                            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.SpoonTransBeforeStart.id, (Object)new Object[]{executionConfiguration, this.parentJob.getJobMeta(), jobMeta, this.rep});
                            remoteSlaveServer = executionConfiguration.getRemoteServer();
                            doFallback = false;
                        }
                        catch (KettleException e) {
                            this.log.logError(e.getMessage(), new Object[]{this.getName()});
                            result.setNrErrors(1L);
                            result.setResult(false);
                            return result;
                        }
                    }
                    if (doFallback && !Utils.isEmpty((CharSequence)this.remoteSlaveServerName)) {
                        String realRemoteSlaveServerName = this.environmentSubstitute(this.remoteSlaveServerName);
                        remoteSlaveServer = this.parentJob.getJobMeta().findSlaveServer(realRemoteSlaveServerName);
                        if (remoteSlaveServer == null) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"JobTrans.Exception.UnableToFindRemoteSlaveServer", (String[])new String[]{realRemoteSlaveServerName}));
                        }
                    }
                    if (remoteSlaveServer == null) {
                        this.job = new Job(this.rep, jobMeta, this);
                        this.job.setParentJob(this.parentJob);
                        this.job.setLogLevel(jobLogLevel);
                        this.job.shareVariablesWith(this);
                        this.job.setInternalKettleVariables(this);
                        this.job.copyParametersFrom(jobMeta);
                        this.job.setInteractive(this.parentJob.isInteractive());
                        if (this.job.isInteractive()) {
                            this.job.getJobEntryListeners().addAll(this.parentJob.getJobEntryListeners());
                        }
                        this.job.setSocketRepository(this.parentJob.getSocketRepository());
                        this.job.clearParameters();
                        String[] parameterNames = this.job.listParameters();
                        for (int idx = 0; idx < parameterNames.length; ++idx) {
                            String parentValue;
                            String thisValue = namedParam.getParameterValue(parameterNames[idx]);
                            if (!Utils.isEmpty((CharSequence)thisValue)) {
                                this.job.setParameterValue(parameterNames[idx], thisValue);
                                continue;
                            }
                            if (!this.isPassingAllParameters() || Utils.isEmpty((CharSequence)(parentValue = this.parentJob.getParameterValue(parameterNames[idx])))) continue;
                            this.job.setParameterValue(parameterNames[idx], parentValue);
                        }
                        this.job.activateParameters();
                        this.job.setSourceRows(sourceRows);
                        this.job.beginProcessing();
                        this.parentJob.getJobTracker().addJobTracker(this.job.getJobTracker());
                        this.job.getJobTracker().setParentJobTracker(this.parentJob.getJobTracker());
                        if (this.parentJob.getJobMeta().isBatchIdPassed()) {
                            this.job.setPassedBatchId(this.parentJob.getBatchId());
                        }
                        this.job.setArguments(args);
                        for (DelegationListener delegationListener : this.parentJob.getDelegationListeners()) {
                            delegationListener.jobDelegationStarted(this.job, new JobExecutionConfiguration());
                        }
                        JobEntryJobRunner runner = new JobEntryJobRunner(this.job, result, nr, this.log);
                        Thread jobRunnerThread = new Thread(runner);
                        jobRunnerThread.setName(Const.NVL((String)this.job.getJobMeta().getName(), (String)this.job.getJobMeta().getFilename()) + " UUID: " + UUID.randomUUID().toString());
                        jobRunnerThread.start();
                        while (!runner.isFinished() && !this.parentJob.isStopped()) {
                            try {
                                Thread.sleep(0L, 1);
                            }
                            catch (InterruptedException parentValue) {}
                        }
                        if (this.parentJob.isStopped()) {
                            this.job.stopAll();
                            runner.waitUntilFinished();
                        }
                        oneResult = runner.getResult();
                    } else {
                        String logFromCarte;
                        remoteSlaveServer.shareVariablesWith(this);
                        JobExecutionConfiguration jobExecutionConfiguration = new JobExecutionConfiguration();
                        jobExecutionConfiguration.setPreviousResult(result.lightClone());
                        jobExecutionConfiguration.getPreviousResult().setRows(sourceRows);
                        jobExecutionConfiguration.setArgumentStrings(args);
                        jobExecutionConfiguration.setVariables(this);
                        jobExecutionConfiguration.setRemoteServer(remoteSlaveServer);
                        jobExecutionConfiguration.setRepository(this.rep);
                        jobExecutionConfiguration.setLogLevel(jobLogLevel);
                        jobExecutionConfiguration.setPassingExport(this.passingExport);
                        jobExecutionConfiguration.setExpandingRemoteJob(this.expandingRemoteJob);
                        for (String param : namedParam.listParameters()) {
                            String defValue = namedParam.getParameterDefault(param);
                            String value = namedParam.getParameterValue(param);
                            jobExecutionConfiguration.getParams().put(param, Const.NVL((String)value, (String)defValue));
                        }
                        if (this.parentJob.getJobMeta().isBatchIdPassed()) {
                            jobExecutionConfiguration.setPassedBatchId(this.parentJob.getBatchId());
                        }
                        String carteObjectId = null;
                        try {
                            carteObjectId = Job.sendToSlaveServer(jobMeta, jobExecutionConfiguration, this.rep, this.metaStore);
                        }
                        catch (KettleException e) {
                            this.parentJob.stopAll();
                            throw e;
                        }
                        SlaveServerJobStatus jobStatus = null;
                        while (!this.parentJob.isStopped() && this.waitingToFinish) {
                            block96: {
                                try {
                                    jobStatus = remoteSlaveServer.getJobStatus(jobMeta.getName(), carteObjectId, 0);
                                    if (jobStatus.getResult() != null) {
                                        oneResult = jobStatus.getResult();
                                    }
                                    break block96;
                                }
                                catch (Exception e1) {
                                    this.logError("Unable to contact slave server [" + remoteSlaveServer + "] to verify the status of job [" + jobMeta.getName() + "]", e1);
                                    oneResult.setNrErrors(1L);
                                }
                                break;
                            }
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e1) {}
                        }
                        if (this.setLogfile && jobStatus != null && !Utils.isEmpty((CharSequence)(logFromCarte = jobStatus.getLoggingString()))) {
                            FileObject logfile = logChannelFileWriter.getLogFile();
                            OutputStream logFileOutputStream = null;
                            try {
                                logFileOutputStream = KettleVFS.getOutputStream((FileObject)logfile, (boolean)this.setAppendLogfile);
                                logFileOutputStream.write(logFromCarte.getBytes());
                                logFileOutputStream.flush();
                            }
                            catch (Exception e) {
                                this.logError("There was an error logging to file '" + logfile + "'", e);
                            }
                            finally {
                                try {
                                    if (logFileOutputStream != null) {
                                        logFileOutputStream.close();
                                        logFileOutputStream = null;
                                    }
                                }
                                catch (Exception e) {
                                    this.logError("There was an error closing log file file '" + logfile + "'", e);
                                }
                            }
                        }
                        if (!this.waitingToFinish) {
                            oneResult = new Result();
                            oneResult.setResult(true);
                        }
                        if (this.parentJob.isStopped()) {
                            try {
                                if (jobStatus != null && !jobStatus.isRunning()) break block98;
                                remoteSlaveServer.stopJob(jobMeta.getName(), carteObjectId);
                            }
                            catch (Exception e1) {
                                this.logError("Unable to contact slave server [" + remoteSlaveServer + "] to stop job [" + jobMeta.getName() + "]", e1);
                                oneResult.setNrErrors(1L);
                                break;
                            }
                        }
                    }
                }
                result.clear();
                result.add(oneResult);
                if (!Utils.isEmpty((List)oneResult.getRows())) {
                    result.setRows(new ArrayList(oneResult.getRows()));
                }
                if (!oneResult.getResult()) {
                    result.setNrErrors(result.getNrErrors() + 1L);
                }
                ++iteration;
            }
        }
        catch (KettleException ke) {
            this.logError("Error running job entry 'job' : ", ke);
            result.setResult(false);
            result.setNrErrors(1L);
        }
        if (this.setLogfile && logChannelFileWriter != null) {
            logChannelFileWriter.stopLogging();
            ResultFile resultFile = new ResultFile(1, logChannelFileWriter.getLogFile(), this.parentJob.getJobname(), this.getName());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (logChannelFileWriter.getException() != null) {
                this.logError("Unable to open log file [" + this.getLogFilename() + "] : ");
                this.logError(Const.getStackTracker((Throwable)logChannelFileWriter.getException()));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
        }
        if (result.getNrErrors() > 0L) {
            result.setResult(false);
        } else {
            result.setResult(true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createParentFolder(String filename) {
        FileObject parentfolder = null;
        boolean resultat = true;
        try {
            parentfolder = KettleVFS.getFileObject((String)filename, (VariableSpace)this).getParent();
            if (!parentfolder.exists()) {
                if (this.createParentFolder) {
                    if (this.log.isDebug()) {
                        this.log.logDebug(BaseMessages.getString(PKG, (String)"JobJob.Log.ParentLogFolderNotExist", (String[])new String[]{parentfolder.getName().toString()}));
                    }
                    parentfolder.createFolder();
                    if (this.log.isDebug()) {
                        this.log.logDebug(BaseMessages.getString(PKG, (String)"JobJob.Log.ParentLogFolderCreated", (String[])new String[]{parentfolder.getName().toString()}));
                    }
                } else {
                    this.log.logError(BaseMessages.getString(PKG, (String)"JobJob.Log.ParentLogFolderNotExist", (String[])new String[]{parentfolder.getName().toString()}));
                    resultat = false;
                }
            } else if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"JobJob.Log.ParentLogFolderExists", (String[])new String[]{parentfolder.getName().toString()}));
            }
        }
        catch (Exception e) {
            resultat = false;
            this.log.logError(BaseMessages.getString(PKG, (String)"JobJob.Error.ChekingParentLogFolderTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JobJob.Error.ChekingParentLogFolder", (String[])new String[]{parentfolder.getName().toString()}), e});
        }
        finally {
            if (parentfolder != null) {
                try {
                    parentfolder.close();
                    parentfolder = null;
                }
                catch (Exception exception) {}
            }
        }
        return resultat;
    }

    private void verifyRecursiveExecution(Job parentJob, JobMeta jobMeta) throws KettleException {
        if (parentJob == null) {
            return;
        }
        JobMeta parentJobMeta = parentJob.getJobMeta();
        if (parentJobMeta.getName() == null && jobMeta.getName() != null) {
            return;
        }
        if (parentJobMeta.getName() != null && jobMeta.getName() == null) {
            return;
        }
        if (jobMeta.getFilename() != null && jobMeta.getFilename().equals(parentJobMeta.getFilename())) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobJobError.Recursive", (String[])new String[]{jobMeta.getFilename()}));
        }
        if (parentJobMeta.getRepositoryDirectory() == null && jobMeta.getRepositoryDirectory() != null) {
            return;
        }
        if (parentJobMeta.getRepositoryDirectory() != null && jobMeta.getRepositoryDirectory() == null) {
            return;
        }
        if (jobMeta.getRepositoryDirectory().getObjectId() != parentJobMeta.getRepositoryDirectory().getObjectId()) {
            return;
        }
        if (parentJobMeta.getName().equals(jobMeta.getName())) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobJobError.Recursive", (String[])new String[]{jobMeta.getFilename()}));
        }
        this.verifyRecursiveExecution(parentJob.getParentJob(), jobMeta);
    }

    @Override
    public void clear() {
        super.clear();
        this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
        this.jobname = null;
        this.filename = null;
        this.directory = null;
        this.arguments = null;
        this.argFromPrevious = false;
        this.addDate = false;
        this.addTime = false;
        this.logfile = null;
        this.logext = null;
        this.setLogfile = false;
        this.setAppendLogfile = false;
        this.runConfiguration = null;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    @Override
    public List<SQLStatement> getSQLStatements(Repository repository, IMetaStore metaStore, VariableSpace space) throws KettleException {
        this.copyVariablesFrom(space);
        JobMeta jobMeta = this.getJobMeta(repository, metaStore, space);
        return jobMeta.getSQLStatements(repository, null);
    }

    @Deprecated
    public JobMeta getJobMeta(Repository rep, VariableSpace space) throws KettleException {
        if (rep != null) {
            return this.getJobMeta(rep, rep.getMetaStore(), space);
        }
        return this.getJobMeta(rep, this.getMetaStore(), space);
    }

    /*
     * Unable to fully structure code
     */
    public JobMeta getJobMeta(Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        jobMeta = null;
        try {
            r = new CurrentDirectoryResolver();
            tmpSpace = r.resolveCurrentDirectory(this.specificationMethod, space, rep, this.parentJob, this.getFilename());
            switch (1.$SwitchMap$org$pentaho$di$core$ObjectLocationSpecificationMethod[this.specificationMethod.ordinal()]) {
                case 2: {
                    realFilename = tmpSpace.environmentSubstitute(this.getFilename());
                    if (rep == null) ** GOTO lbl26
                    realFilename = r.normalizeSlashes(realFilename);
                    try {
                        dirStr = realFilename.substring(0, realFilename.lastIndexOf("/"));
                        tmpFilename = realFilename.substring(realFilename.lastIndexOf("/") + 1);
                        dir = rep.findDirectory(dirStr);
                        jobMeta = rep.loadJob(tmpFilename, dir, null, null);
                    }
                    catch (KettleException ke) {
                        if (!realFilename.endsWith("kjb")) ** GOTO lbl26
                        try {
                            tmpFilename = realFilename.substring(realFilename.lastIndexOf("/") + 1, realFilename.indexOf(".kjb"));
                            dirStr = realFilename.substring(0, realFilename.lastIndexOf("/"));
                            dir = rep.findDirectory(dirStr);
                            jobMeta = rep.loadJob(tmpFilename, dir, null, null);
                        }
                        catch (KettleException tmpFilename) {
                            // empty catch block
                        }
                    }
lbl26:
                    // 5 sources

                    if (jobMeta != null) break;
                    jobMeta = new JobMeta(tmpSpace, realFilename, rep, metaStore, null);
                    break;
                }
                case 1: {
                    realDirectory = tmpSpace.environmentSubstitute(this.getDirectory());
                    realJobName = tmpSpace.environmentSubstitute(this.getJobName());
                    if (rep != null) {
                        realDirectory = r.normalizeSlashes(realDirectory);
                        repositoryDirectory = rep.loadRepositoryDirectoryTree().findDirectory(realDirectory);
                        if (repositoryDirectory == null) {
                            throw new KettleException("Unable to find repository directory [" + Const.NVL((String)realDirectory, (String)"") + "]");
                        }
                        jobMeta = rep.loadJob(realJobName, repositoryDirectory, null, null);
                        break;
                    }
                    try {
                        jobMeta = new JobMeta(tmpSpace, realDirectory + "/" + realJobName, rep, metaStore, null);
                        break;
                    }
                    catch (KettleException ke) {
                        try {
                            jobMeta = new JobMeta(tmpSpace, realDirectory + "/" + realJobName + "." + "kjb", rep, metaStore, null);
                            break;
                        }
                        catch (KettleException ke2) {
                            ke2.printStackTrace();
                            throw new KettleException("Could not execute job specified in a repository since we're not connected to one");
                        }
                    }
                }
                case 3: {
                    if (rep != null) {
                        jobMeta = rep.loadJob(this.jobObjectId, null);
                        break;
                    }
                    throw new KettleException("Could not execute job specified in a repository since we're not connected to one");
                }
                default: {
                    throw new KettleException("The specified object location specification method '" + this.specificationMethod + "' is not yet supported in this job entry.");
                }
            }
            if (jobMeta != null) {
                jobMeta.setRepository(rep);
                jobMeta.setMetaStore(metaStore);
            }
            return jobMeta;
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error during job metadata load", (Throwable)e);
        }
    }

    public boolean isExecPerRow() {
        return this.execPerRow;
    }

    public void setExecPerRow(boolean runEveryResultRow) {
        this.execPerRow = runEveryResultRow;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            String realFileName = jobMeta.environmentSubstitute(this.filename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.ACTIONFILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface namingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        this.copyVariablesFrom(space);
        JobMeta jobMeta = this.getJobMeta(repository, metaStore, space);
        String proposedNewFilename = jobMeta.exportResources(jobMeta, definitions, namingInterface, repository, metaStore);
        String newFilename = "${Internal.Job.Filename.Directory}/" + proposedNewFilename;
        jobMeta.setFilename(newFilename);
        jobMeta.setRepositoryDirectory((RepositoryDirectoryInterface)new RepositoryDirectory());
        this.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
        this.filename = newFilename;
        return proposedNewFilename;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (this.setLogfile) {
            JobEntryValidatorUtils.andValidator().validate(this, "logfile", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        }
        if (null != this.directory) {
            JobEntryValidatorUtils.andValidator().validate(this, "directory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
            JobEntryValidatorUtils.andValidator().validate(this, "jobName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        } else {
            JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        }
    }

    public static void main(String[] args) {
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        new JobEntryJob().check(remarks, null, (VariableSpace)new Variables(), null, null);
        System.out.printf("Remarks: %s\n", remarks);
    }

    protected String getLogfile() {
        return this.logfile;
    }

    public String getRemoteSlaveServerName() {
        return this.remoteSlaveServerName;
    }

    public void setRemoteSlaveServerName(String remoteSlaveServerName) {
        this.remoteSlaveServerName = remoteSlaveServerName;
    }

    public boolean isWaitingToFinish() {
        return this.waitingToFinish;
    }

    public void setWaitingToFinish(boolean waitingToFinish) {
        this.waitingToFinish = waitingToFinish;
    }

    public boolean isFollowingAbortRemotely() {
        return this.followingAbortRemotely;
    }

    public void setFollowingAbortRemotely(boolean followingAbortRemotely) {
        this.followingAbortRemotely = followingAbortRemotely;
    }

    public boolean isPassingAllParameters() {
        return this.passingAllParameters;
    }

    public void setPassingAllParameters(boolean passingAllParameters) {
        this.passingAllParameters = passingAllParameters;
    }

    public Job getJob() {
        return this.job;
    }

    public ObjectId getJobObjectId() {
        return this.jobObjectId;
    }

    public void setJobObjectId(ObjectId jobObjectId) {
        this.jobObjectId = jobObjectId;
    }

    public ObjectLocationSpecificationMethod getSpecificationMethod() {
        return this.specificationMethod;
    }

    public void setSpecificationMethod(ObjectLocationSpecificationMethod specificationMethod) {
        this.specificationMethod = specificationMethod;
    }

    @Override
    public boolean hasRepositoryReferences() {
        return this.specificationMethod == ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
    }

    @Override
    public void lookupRepositoryReferences(Repository repository) throws KettleException {
        RepositoryDirectoryInterface repositoryDirectoryInterface = RepositoryImportLocation.getRepositoryImportLocation().findDirectory(this.directory);
        this.jobObjectId = repository.getJobId(this.jobname, repositoryDirectoryInterface);
    }

    private boolean isJobDefined() {
        return !Utils.isEmpty((CharSequence)this.filename) || this.jobObjectId != null || !Utils.isEmpty((CharSequence)this.directory) && !Utils.isEmpty((CharSequence)this.jobname);
    }

    @Override
    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isJobDefined()};
    }

    @Override
    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"JobEntryJob.ReferencedObject.Description", (String[])new String[0])};
    }

    @Override
    public Object loadReferencedObject(int index, Repository rep, IMetaStore metaStore, VariableSpace space) throws KettleException {
        return this.getJobMeta(rep, metaStore, space);
    }

    public boolean isExpandingRemoteJob() {
        return this.expandingRemoteJob;
    }

    public void setExpandingRemoteJob(boolean expandingRemoteJob) {
        this.expandingRemoteJob = expandingRemoteJob;
    }

    @Override
    public void setParentJobMeta(JobMeta parentJobMeta) {
        JobMeta previous = this.getParentJobMeta();
        super.setParentJobMeta(parentJobMeta);
        if (previous != null) {
            previous.removeCurrentDirectoryChangedListener(this.dirListener);
        }
        if (parentJobMeta != null) {
            parentJobMeta.addCurrentDirectoryChangedListener(this.dirListener);
        }
    }
}

