/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.List;
import java.util.Optional;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.TransStepUtil;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorData;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorParameters;

public class SubtransExecutor {
    private static final Class<?> PKG = SubtransExecutor.class;
    private Trans parentTrans;
    private TransMeta subtransMeta;
    private boolean shareVariables;
    private TransExecutorData transExecutorData;
    private TransExecutorParameters parameters;

    public SubtransExecutor(Trans parentTrans, TransMeta subtransMeta, boolean shareVariables, TransExecutorData transExecutorData, TransExecutorParameters parameters) {
        this.parentTrans = parentTrans;
        this.subtransMeta = subtransMeta;
        this.shareVariables = shareVariables;
        this.transExecutorData = transExecutorData;
        this.parameters = parameters;
    }

    public Optional<Result> execute(List<RowMetaAndData> rows) throws KettleException {
        if (rows.isEmpty()) {
            return Optional.empty();
        }
        this.transExecutorData.groupTimeStart = System.currentTimeMillis();
        Trans subtrans = this.createSubtrans();
        this.transExecutorData.setExecutorTrans(subtrans);
        this.passParametersToTrans(subtrans, rows.get(0));
        Result result = new Result();
        result.setRows(rows);
        subtrans.setPreviousResult(result);
        subtrans.prepareExecution(this.parentTrans.getArguments());
        subtrans.startThreads();
        subtrans.waitUntilFinished();
        return Optional.of(subtrans.getResult());
    }

    private Trans createSubtrans() {
        Trans subTrans = new Trans(this.subtransMeta, this.parentTrans);
        subTrans.setParentTrans(this.parentTrans);
        subTrans.setRepository(this.parentTrans.getRepository());
        subTrans.setLogLevel(this.parentTrans.getLogLevel());
        subTrans.setArguments(this.parentTrans.getArguments());
        if (this.shareVariables) {
            subTrans.shareVariablesWith(this.parentTrans);
        }
        subTrans.setInternalKettleVariables(this.parentTrans);
        subTrans.copyParametersFrom(this.subtransMeta);
        subTrans.setPreview(this.parentTrans.isPreview());
        TransStepUtil.initServletConfig(this.parentTrans, subTrans);
        return subTrans;
    }

    private void passParametersToTrans(Trans internalTrans, RowMetaAndData rowMetaAndData) throws KettleException {
        internalTrans.clearParameters();
        String[] parameterNames = internalTrans.listParameters();
        for (int i = 0; i < this.parameters.getVariable().length; ++i) {
            String value;
            String variable = this.parameters.getVariable()[i];
            String fieldName = this.parameters.getField()[i];
            String inputValue = this.parameters.getInput()[i];
            if (!Utils.isEmpty((CharSequence)fieldName)) {
                int idx = rowMetaAndData.getRowMeta().indexOfValue(fieldName);
                if (idx < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"TransExecutor.Exception.UnableToFindField", (String[])new String[]{fieldName}));
                }
                value = rowMetaAndData.getString(idx, "");
            } else {
                value = this.parentTrans.environmentSubstitute(inputValue);
            }
            if (Const.indexOfString((String)variable, (String[])parameterNames) < 0) {
                internalTrans.setVariable(variable, Const.NVL((String)value, (String)""));
                continue;
            }
            internalTrans.setParameterValue(variable, Const.NVL((String)value, (String)""));
        }
        internalTrans.activateParameters();
    }
}

