/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.EnginePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.engine.api.Engine;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.ael.adapters.TransEngineAdapter;
import org.pentaho.di.trans.ael.websocket.TransWebSocketEngineAdapter;

public class TransSupplier
implements Supplier<Trans> {
    private final TransMeta transMeta;
    private final LogChannelInterface log;
    private final Supplier<Trans> fallbackSupplier;

    public TransSupplier(TransMeta transMeta, LogChannelInterface log, Supplier<Trans> fallbackSupplier) {
        this.transMeta = transMeta;
        this.log = log;
        this.fallbackSupplier = fallbackSupplier;
    }

    @Override
    public Trans get() {
        if (Utils.isEmpty((CharSequence)this.transMeta.getVariable("engine"))) {
            this.log.logBasic("Using legacy execution engine");
            return this.fallbackSupplier.get();
        }
        Variables variables = new Variables();
        variables.initializeVariablesFrom(null);
        String version = variables.getVariable("KETTLE_AEL_PDI_DAEMON_VERSION", "2.0");
        if (Const.toDouble((String)version, (double)1.0) >= 2.0) {
            String protocol = this.transMeta.getVariable("engine.protocol");
            String host = this.transMeta.getVariable("engine.host");
            String port = this.transMeta.getVariable("engine.port");
            boolean ssl = "https".equalsIgnoreCase(protocol) || "wss".equalsIgnoreCase(protocol);
            return new TransWebSocketEngineAdapter(this.transMeta, host, port, ssl);
        }
        try {
            return PluginRegistry.getInstance().getPlugins(EnginePluginType.class).stream().filter(this.useThisEngine()).findFirst().map(plugin -> (Engine)this.loadPlugin((PluginInterface)plugin)).map(engine -> {
                this.log.logBasic("Using execution engine " + engine.getClass().getCanonicalName());
                return new TransEngineAdapter((Engine)engine, this.transMeta);
            }).orElseThrow(() -> new KettleException("Unable to find engine [" + this.transMeta.getVariable("engine") + "]"));
        }
        catch (KettleException e) {
            this.log.logError("Failed to load engine", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Predicate<PluginInterface> useThisEngine() {
        return plugin -> Arrays.stream(plugin.getIds()).filter(id -> id.equals(this.transMeta.getVariable("engine"))).findAny().isPresent();
    }

    private Object loadPlugin(PluginInterface plugin) {
        try {
            return PluginRegistry.getInstance().loadClass(plugin);
        }
        catch (KettlePluginException e) {
            throw new RuntimeException(e);
        }
    }
}

