/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;

public class BaseFileInputFiles
implements Cloneable {
    private static Class<?> PKG = BaseFileInputFiles.class;
    public static final String NO = "N";
    public static final String YES = "Y";
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    @Injection(name="FILENAME", group="FILENAME_LINES")
    public String[] fileName = new String[0];
    @Injection(name="FILEMASK", group="FILENAME_LINES")
    public String[] fileMask = new String[0];
    @Injection(name="EXCLUDE_FILEMASK", group="FILENAME_LINES")
    public String[] excludeFileMask = new String[0];
    @Injection(name="FILE_REQUIRED", group="FILENAME_LINES")
    public String[] fileRequired = new String[0];
    @Injection(name="INCLUDE_SUBFOLDERS", group="FILENAME_LINES")
    public String[] includeSubFolders = new String[0];
    @Injection(name="ACCEPT_FILE_NAMES")
    public boolean acceptingFilenames;
    @Injection(name="ACCEPT_FILE_STEP")
    public String acceptingStepName;
    @Injection(name="PASS_THROUGH_FIELDS")
    public boolean passingThruFields;
    @Injection(name="ACCEPT_FILE_FIELD")
    public String acceptingField;
    @Injection(name="ADD_FILES_TO_RESULT")
    public boolean isaddresult;

    public Object clone() {
        try {
            BaseFileInputFiles cloned = (BaseFileInputFiles)super.clone();
            cloned.fileName = Arrays.copyOf(this.fileName, this.fileName.length);
            cloned.fileMask = Arrays.copyOf(this.fileMask, this.fileMask.length);
            cloned.excludeFileMask = Arrays.copyOf(this.excludeFileMask, this.excludeFileMask.length);
            cloned.fileRequired = Arrays.copyOf(this.fileRequired, this.fileRequired.length);
            cloned.includeSubFolders = Arrays.copyOf(this.includeSubFolders, this.includeSubFolders.length);
            return cloned;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("Clone not supported for " + this.getClass().getName());
        }
    }

    public void setFileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.fileRequired[i] = BaseFileInputFiles.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = BaseFileInputFiles.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public static String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public void normalizeAllocation(int length) {
        this.fileMask = BaseFileInputFiles.normalizeAllocation(this.fileMask, length);
        this.excludeFileMask = BaseFileInputFiles.normalizeAllocation(this.excludeFileMask, length);
        this.fileRequired = BaseFileInputFiles.normalizeAllocation(this.fileRequired, length);
        this.includeSubFolders = BaseFileInputFiles.normalizeAllocation(this.includeSubFolders, length);
    }

    private static String[] normalizeAllocation(String[] oldAllocation, int length) {
        String[] newAllocation = null;
        if (oldAllocation.length < length) {
            newAllocation = new String[length];
            for (int i = 0; i < oldAllocation.length; ++i) {
                newAllocation[i] = oldAllocation[i];
            }
        } else {
            newAllocation = oldAllocation;
        }
        return newAllocation;
    }

    public boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        String[] textFiles = FileInputList.createFilePathList((VariableSpace)transMeta, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
        if (textFiles != null) {
            for (int i = 0; i < textFiles.length; ++i) {
                reference.getEntries().add(new ResourceEntry(textFiles[i], ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }
}

