/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.file;

import java.util.List;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.file.BaseFileErrorHandling;
import org.pentaho.di.trans.steps.file.BaseFileField;
import org.pentaho.di.trans.steps.file.BaseFileInputAdditionalField;
import org.pentaho.di.trans.steps.file.BaseFileInputFiles;

public abstract class BaseFileInputMeta<A extends BaseFileInputAdditionalField, I extends BaseFileInputFiles, F extends BaseFileField>
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = BaseFileInputMeta.class;
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    public static final String NO = "N";
    public static final String YES = "Y";
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    @InjectionDeep
    public I inputFiles;
    @InjectionDeep
    public F[] inputFields;
    @InjectionDeep
    public BaseFileErrorHandling errorHandling = new BaseFileErrorHandling();
    @InjectionDeep
    public A additionalOutputFields;

    @Override
    public Object clone() {
        BaseFileInputMeta retval = (BaseFileInputMeta)super.clone();
        retval.inputFiles = (BaseFileInputFiles)((BaseFileInputFiles)this.inputFiles).clone();
        retval.errorHandling = (BaseFileErrorHandling)this.errorHandling.clone();
        retval.additionalOutputFields = (BaseFileInputAdditionalField)((BaseFileInputAdditionalField)this.additionalOutputFields).clone();
        return retval;
    }

    public void inputFiles_fileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            ((BaseFileInputFiles)this.inputFiles).fileRequired[i] = BaseFileInputMeta.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String[] inputFiles_includeSubFolders() {
        return ((BaseFileInputFiles)this.inputFiles).includeSubFolders;
    }

    public void inputFiles_includeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            ((BaseFileInputFiles)this.inputFiles).includeSubFolders[i] = BaseFileInputMeta.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public static String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public FileInputList getFileInputList(VariableSpace space) {
        ((BaseFileInputFiles)this.inputFiles).normalizeAllocation(((BaseFileInputFiles)this.inputFiles).fileName.length);
        return FileInputList.createFileList((VariableSpace)space, (String[])((BaseFileInputFiles)this.inputFiles).fileName, (String[])((BaseFileInputFiles)this.inputFiles).fileMask, (String[])((BaseFileInputFiles)this.inputFiles).excludeFileMask, (String[])((BaseFileInputFiles)this.inputFiles).fileRequired, (boolean[])((BaseFileInputFiles)this.inputFiles).includeSubFolderBoolean());
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        return ((BaseFileInputFiles)this.inputFiles).getResourceDependencies(transMeta, stepInfo);
    }

    public abstract String getEncoding();
}

