/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.insertupdate;

import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProvidesModelerMeta;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.AfterInjection;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.utils.RowMetaUtils;
import org.pentaho.di.trans.steps.insertupdate.InsertUpdate;
import org.pentaho.di.trans.steps.insertupdate.InsertUpdateData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="InsertUpdateMeta.Injection.", groups={"KEYS", "UPDATES"})
public class InsertUpdateMeta
extends BaseStepMeta
implements StepMetaInterface,
ProvidesModelerMeta {
    private static Class<?> PKG = InsertUpdateMeta.class;
    private List<? extends SharedObjectInterface> databases;
    @Injection(name="SCHEMA_NAME")
    private String schemaName;
    @Injection(name="TABLE_NAME")
    private String tableName;
    private DatabaseMeta databaseMeta;
    @Injection(name="KEY_STREAM", group="KEYS")
    private String[] keyStream;
    @Injection(name="KEY_LOOKUP", group="KEYS")
    private String[] keyLookup;
    @Injection(name="KEY_CONDITION", group="KEYS")
    private String[] keyCondition;
    @Injection(name="KEY_STREAM2", group="KEYS")
    private String[] keyStream2;
    @Injection(name="UPDATE_LOOKUP", group="UPDATES")
    private String[] updateLookup;
    @Injection(name="UPDATE_STREAM", group="UPDATES")
    private String[] updateStream;
    @Injection(name="UPDATE_FLAG", group="UPDATES")
    private Boolean[] update;
    @Injection(name="COMMIT_SIZE")
    private String commitSize;
    @Injection(name="DO_NOT")
    private boolean updateBypassed;

    @Injection(name="CONNECTIONNAME")
    public void setConnection(String connectionName) {
        this.databaseMeta = DatabaseMeta.findDatabase(this.databases, (String)connectionName);
    }

    @Deprecated
    public int getCommitSize() {
        return Integer.parseInt(this.commitSize);
    }

    public String getCommitSizeVar() {
        return this.commitSize;
    }

    public int getCommitSize(VariableSpace vs) {
        this.commitSize = this.commitSize == null ? "0" : this.commitSize;
        return Integer.parseInt(vs.environmentSubstitute(this.commitSize));
    }

    @Deprecated
    public void setCommitSize(int commitSize) {
        this.commitSize = Integer.toString(commitSize);
    }

    public void setCommitSize(String commitSize) {
        this.commitSize = commitSize;
    }

    @Override
    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String[] getKeyCondition() {
        return this.keyCondition;
    }

    public void setKeyCondition(String[] keyCondition) {
        this.keyCondition = keyCondition;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] keyLookup) {
        this.keyLookup = keyLookup;
    }

    public String[] getKeyStream() {
        return this.keyStream;
    }

    public void setKeyStream(String[] keyStream) {
        this.keyStream = keyStream;
    }

    public String[] getKeyStream2() {
        return this.keyStream2;
    }

    public void setKeyStream2(String[] keyStream2) {
        this.keyStream2 = keyStream2;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getUpdateLookup() {
        return this.updateLookup;
    }

    public void setUpdateLookup(String[] updateLookup) {
        this.updateLookup = updateLookup;
    }

    public String[] getUpdateStream() {
        return this.updateStream;
    }

    public void setUpdateStream(String[] updateStream) {
        this.updateStream = updateStream;
    }

    public Boolean[] getUpdate() {
        return this.update;
    }

    public void setUpdate(Boolean[] update) {
        this.update = update;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.keyStream = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
        this.keyCondition = new String[nrkeys];
        this.keyStream2 = new String[nrkeys];
        this.updateLookup = new String[nrvalues];
        this.updateStream = new String[nrvalues];
        this.update = new Boolean[nrvalues];
    }

    @Override
    public Object clone() {
        InsertUpdateMeta retval = (InsertUpdateMeta)super.clone();
        int nrkeys = this.keyStream.length;
        int nrvalues = this.updateLookup.length;
        retval.allocate(nrkeys, nrvalues);
        System.arraycopy(this.keyStream, 0, retval.keyStream, 0, nrkeys);
        System.arraycopy(this.keyLookup, 0, retval.keyLookup, 0, nrkeys);
        System.arraycopy(this.keyCondition, 0, retval.keyCondition, 0, nrkeys);
        System.arraycopy(this.keyStream2, 0, retval.keyStream2, 0, nrkeys);
        System.arraycopy(this.updateLookup, 0, retval.updateLookup, 0, nrvalues);
        System.arraycopy(this.updateStream, 0, retval.updateStream, 0, nrvalues);
        System.arraycopy(this.update, 0, retval.update, 0, nrvalues);
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        this.databases = databases;
        try {
            int i;
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            String csize = XMLHandler.getTagValue((Node)stepnode, (String)"commit");
            this.commitSize = csize != null ? csize : "0";
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"lookup", (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"lookup", (String)"table");
            this.updateBypassed = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"update_bypassed"));
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrkeys = XMLHandler.countNodes((Node)lookup, (String)"key");
            int nrvalues = XMLHandler.countNodes((Node)lookup, (String)"value");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"key", (int)i);
                this.keyStream[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.keyLookup[i] = XMLHandler.getTagValue((Node)knode, (String)"field");
                this.keyCondition[i] = XMLHandler.getTagValue((Node)knode, (String)"condition");
                if (this.keyCondition[i] == null) {
                    this.keyCondition[i] = "=";
                }
                this.keyStream2[i] = XMLHandler.getTagValue((Node)knode, (String)"name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                String updateValue;
                Node vnode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"value", (int)i);
                this.updateLookup[i] = XMLHandler.getTagValue((Node)vnode, (String)"name");
                this.updateStream[i] = XMLHandler.getTagValue((Node)vnode, (String)"rename");
                if (this.updateStream[i] == null) {
                    this.updateStream[i] = this.updateLookup[i];
                }
                this.update[i] = (updateValue = XMLHandler.getTagValue((Node)vnode, (String)"update")) == null ? Boolean.TRUE : (updateValue.equalsIgnoreCase("Y") ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int i;
        this.keyStream = null;
        this.updateLookup = null;
        this.databaseMeta = null;
        this.commitSize = "100";
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.DefaultTableName", (String[])new String[0]);
        int nrkeys = 0;
        int nrvalues = 0;
        this.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            this.keyLookup[i] = "age";
            this.keyCondition[i] = "BETWEEN";
            this.keyStream[i] = "age_from";
            this.keyStream2[i] = "age_to";
        }
        for (i = 0; i < nrvalues; ++i) {
            this.updateLookup[i] = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ColumnName.ReturnField", (String[])new String[0]) + i;
            this.updateStream[i] = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ColumnName.NewName", (String[])new String[0]) + i;
            this.update[i] = Boolean.TRUE;
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder(400);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"commit", (String)this.commitSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"update_bypassed", (boolean)this.updateBypassed));
        retval.append("    <lookup>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        for (i = 0; i < this.keyStream.length; ++i) {
            retval.append("      <key>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.keyStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field", (String)this.keyLookup[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"condition", (String)this.keyCondition[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name2", (String)this.keyStream2[i]));
            retval.append("      </key>").append(Const.CR);
        }
        for (i = 0; i < this.updateLookup.length; ++i) {
            retval.append("      <value>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.updateLookup[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"rename", (String)this.updateStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"update", (boolean)this.update[i]));
            retval.append("      </value>").append(Const.CR);
        }
        retval.append("    </lookup>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        this.databases = databases;
        try {
            int i;
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.commitSize = rep.getStepAttributeString(id_step, "commit");
            if (this.commitSize == null) {
                long comSz = -1L;
                try {
                    comSz = rep.getStepAttributeInteger(id_step, "commit");
                }
                catch (Exception ex) {
                    this.commitSize = "100";
                }
                if (comSz >= 0L) {
                    this.commitSize = Long.toString(comSz);
                }
            }
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.updateBypassed = rep.getStepAttributeBoolean(id_step, "update_bypassed");
            int nrkeys = rep.countNrStepAttributes(id_step, "key_field");
            int nrvalues = rep.countNrStepAttributes(id_step, "value_name");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                this.keyStream[i] = rep.getStepAttributeString(id_step, i, "key_name");
                this.keyLookup[i] = rep.getStepAttributeString(id_step, i, "key_field");
                this.keyCondition[i] = rep.getStepAttributeString(id_step, i, "key_condition");
                this.keyStream2[i] = rep.getStepAttributeString(id_step, i, "key_name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.updateLookup[i] = rep.getStepAttributeString(id_step, i, "value_name");
                this.updateStream[i] = rep.getStepAttributeString(id_step, i, "value_rename");
                this.update[i] = rep.getStepAttributeBoolean(id_step, i, "value_update", true);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "commit", this.commitSize);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "update_bypassed", this.updateBypassed);
            for (i = 0; i < this.keyStream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "key_name", this.keyStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_field", this.keyLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_condition", this.keyCondition[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "key_name2", this.keyStream2[i]);
            }
            for (i = 0; i < this.updateLookup.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "value_name", this.updateLookup[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "value_rename", this.updateStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "value_update", this.update[i]);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            try {
                boolean error_found;
                boolean first;
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.TableNameOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_found = false;
                    error_message = "";
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tableName);
                    RowMetaInterface r = db.getTableFields(schemaTable);
                    if (r != null) {
                        ValueMetaInterface v;
                        String lufield;
                        int i;
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.TableExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        for (i = 0; i < this.keyLookup.length; ++i) {
                            lufield = this.keyLookup[i];
                            v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingCompareFieldsInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + lufield + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.AllLookupFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        first = true;
                        error_found = false;
                        error_message = "";
                        for (i = 0; i < this.updateLookup.length; ++i) {
                            lufield = this.updateLookup[i];
                            v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingFieldsToUpdateInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + lufield + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.AllFieldsToUpdateFoundInTargetTable", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        error_message = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    ValueMetaInterface v;
                    int i;
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.StepReceivingDatas", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_message = "";
                    error_found = false;
                    for (i = 0; i < this.keyStream.length; ++i) {
                        v = prev.searchValueMeta(this.keyStream[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.keyStream[i] + Const.CR;
                    }
                    for (i = 0; i < this.keyStream2.length; ++i) {
                        if (this.keyStream2[i] == null || this.keyStream2[i].length() <= 0 || (v = prev.searchValueMeta(this.keyStream2[i])) != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.keyStream[i] + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_found = false;
                    error_message = "";
                    for (i = 0; i < this.updateStream.length; ++i) {
                        String lufield = this.updateStream[i];
                        ValueMetaInterface v2 = prev.searchValueMeta(lufield);
                        if (v2 != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingInputStreamFields", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + lufield + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.AllFieldsFoundInInput2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                error_message = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                error_message = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) throws KettleStepException {
        SQLStatement retval;
        block13: {
            retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    RowMetaInterface tableFields = RowMetaUtils.getRowMetaForUpdate(prev, this.keyLookup, this.keyStream, this.updateLookup, this.updateStream);
                    if (!Utils.isEmpty((CharSequence)this.tableName)) {
                        Database db = new Database(loggingObject, this.databaseMeta);
                        db.shareVariablesWith((VariableSpace)transMeta);
                        try {
                            String sql;
                            db.connect();
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.schemaName, this.tableName);
                            String cr_table = db.getDDL(schemaTable, tableFields, null, false, null, true);
                            String cr_index = "";
                            String[] idx_fields = null;
                            if (this.keyLookup != null && this.keyLookup.length > 0) {
                                idx_fields = new String[this.keyLookup.length];
                                for (int i = 0; i < this.keyLookup.length; ++i) {
                                    idx_fields[i] = this.keyLookup[i];
                                }
                            } else {
                                retval.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.CheckResult.MissingKeyFields", (String[])new String[0]));
                            }
                            if (idx_fields != null && idx_fields.length > 0 && !db.checkIndexExists(this.schemaName, this.tableName, idx_fields)) {
                                String indexname = "idx_" + this.tableName + "_lookup";
                                cr_index = db.getCreateIndexStatement(schemaTable, indexname, idx_fields, false, false, false, true);
                            }
                            if ((sql = cr_table + cr_index).length() == 0) {
                                retval.setSQL(null);
                                break block13;
                            }
                            retval.setSQL(sql);
                        }
                        catch (KettleException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ReturnValue.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ReturnValue.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ReturnValue.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.ReturnValue.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (prev != null) {
            DatabaseImpact ii;
            ValueMetaInterface v;
            int i;
            for (i = 0; i < this.keyLookup.length; ++i) {
                v = prev.searchValueMeta(this.keyStream[i]);
                ii = new DatabaseImpact(1, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.keyLookup[i], this.keyStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
            for (i = 0; i < this.updateLookup.length; ++i) {
                v = prev.searchValueMeta(this.updateStream[i]);
                ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.updateLookup[i], this.updateStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new InsertUpdate(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new InsertUpdateData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean isUpdateBypassed() {
        return this.updateBypassed;
    }

    public void setUpdateBypassed(boolean updateBypassed) {
        this.updateBypassed = updateBypassed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        String realSchemaName = space.environmentSubstitute(this.schemaName);
        String realTableName = space.environmentSubstitute(this.tableName);
        if (this.databaseMeta == null) throw new KettleException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, this.databaseMeta);
        try {
            db.connect();
            if (Utils.isEmpty((CharSequence)realTableName)) throw new KettleException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (db.checkTableExists(schemaTable)) {
                RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
                return rowMetaInterface;
            }
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"InsertUpdateMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public RowMeta getRowMeta(StepDataInterface stepData) {
        return (RowMeta)((InsertUpdateData)stepData).insertRowMeta;
    }

    @Override
    public List<String> getDatabaseFields() {
        return Arrays.asList(this.updateLookup);
    }

    @Override
    public List<String> getStreamFields() {
        return Arrays.asList(this.updateStream);
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        if (this.keyStream == null || this.keyStream.length == 0) {
            return;
        }
        int nrFields = this.keyStream.length;
        if (this.keyStream2.length < nrFields) {
            String[] newKeyStream2 = new String[nrFields];
            System.arraycopy(this.keyStream2, 0, newKeyStream2, 0, this.keyStream2.length);
            this.keyStream2 = newKeyStream2;
        }
    }
}

