/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldifinput;

import java.util.Date;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFContent;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ldifinput.LDIFInputData;
import org.pentaho.di.trans.steps.ldifinput.LDIFInputField;
import org.pentaho.di.trans.steps.ldifinput.LDIFInputMeta;

public class LDIFInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = LDIFInputMeta.class;
    private LDIFInputMeta meta;
    private LDIFInputData data;

    public LDIFInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] getOneRow() throws KettleException {
        try {
            if (this.meta.isFileField()) {
                while (this.data.readrow == null || (this.data.recordLDIF = this.data.InputLDIF.nextRecord()) == null) {
                    if (this.openNextFile()) continue;
                    return null;
                }
            } else {
                while (this.data.file == null || (this.data.recordLDIF = this.data.InputLDIF.nextRecord()) == null) {
                    if (this.openNextFile()) continue;
                    return null;
                }
            }
        }
        catch (Exception IO) {
            return null;
        }
        LDIFContent contentLDIF = this.data.recordLDIF.getContent();
        String contentTYPE = "ATTRIBUTE_CONTENT";
        switch (contentLDIF.getType()) {
            case 2: {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"LDIFInput.Log.ContentType", (String[])new String[]{"DELETE_CONTENT"}));
                }
                contentTYPE = "DELETE_CONTENT";
                break;
            }
            case 1: {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"LDIFInput.Log.ContentType", (String[])new String[]{"ADD_CONTENT"}));
                }
                contentTYPE = "ADD_CONTENT";
                break;
            }
            case 4: {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"LDIFInput.Log.ContentType", (String[])new String[]{"MODDN_CONTENT"}));
                }
                contentTYPE = "MODDN_CONTENT";
                break;
            }
            case 3: {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"LDIFInput.Log.ContentType", (String[])new String[]{"MODIFICATION_CONTENT"}));
                }
                contentTYPE = "MODIFICATION_CONTENT";
                break;
            }
            default: {
                if (!this.isDetailed()) break;
                this.logDetailed(BaseMessages.getString(PKG, (String)"LDIFInput.Log.ContentType", (String[])new String[]{"ATTRIBUTE_CONTENT"}));
            }
        }
        LDIFAttributeContent attrContentLDIF = (LDIFAttributeContent)contentLDIF;
        this.data.attributes_LDIF = attrContentLDIF.getAttributes();
        Object[] outputRowData = this.buildEmptyRow();
        if (this.meta.isFileField()) {
            System.arraycopy(this.data.readrow, 0, outputRowData, 0, this.data.readrow.length);
        }
        try {
            RowMetaInterface irow;
            for (int i = 0; i < this.meta.getInputFields().length; ++i) {
                LDIFInputField ldifInputField = this.meta.getInputFields()[i];
                String AttributValue = this.environmentSubstitute(ldifInputField.getAttribut());
                String Value = this.GetValue(this.data.attributes_LDIF, AttributValue);
                switch (ldifInputField.getTrimType()) {
                    case 1: {
                        Value = Const.ltrim((String)Value);
                        break;
                    }
                    case 2: {
                        Value = Const.rtrim((String)Value);
                        break;
                    }
                    case 3: {
                        Value = Const.trim((String)Value);
                        break;
                    }
                }
                ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(this.data.totalpreviousfields + i);
                ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(this.data.totalpreviousfields + i);
                outputRowData[this.data.totalpreviousfields + i] = targetValueMeta.convertData(sourceValueMeta, (Object)Value);
                if (!this.meta.getInputFields()[i].isRepeated() || this.data.previousRow == null || !Utils.isEmpty((CharSequence)Value)) continue;
                outputRowData[this.data.totalpreviousfields + i] = this.data.previousRow[this.data.totalpreviousfields + i];
            }
            int rowIndex = this.data.totalpreviousfields + this.meta.getInputFields().length;
            if (this.meta.includeFilename() && !Utils.isEmpty((CharSequence)this.meta.getFilenameField())) {
                outputRowData[rowIndex++] = this.data.filename;
            }
            if (this.meta.includeRowNumber() && !Utils.isEmpty((CharSequence)this.meta.getRowNumberField())) {
                outputRowData[this.data.totalpreviousfields + rowIndex++] = new Long(this.data.rownr);
            }
            if (this.meta.includeContentType() && !Utils.isEmpty((CharSequence)this.meta.getContentTypeField())) {
                outputRowData[this.data.totalpreviousfields + rowIndex++] = contentTYPE;
            }
            if (this.meta.IncludeDN() && !Utils.isEmpty((CharSequence)this.meta.getDNField())) {
                outputRowData[this.data.totalpreviousfields + rowIndex++] = this.data.recordLDIF.getDN();
            }
            if (this.meta.getShortFileNameField() != null && this.meta.getShortFileNameField().length() > 0) {
                outputRowData[rowIndex++] = this.data.shortFilename;
            }
            if (this.meta.getExtensionField() != null && this.meta.getExtensionField().length() > 0) {
                outputRowData[rowIndex++] = this.data.extension;
            }
            if (this.meta.getPathField() != null && this.meta.getPathField().length() > 0) {
                outputRowData[rowIndex++] = this.data.path;
            }
            if (this.meta.getSizeField() != null && this.meta.getSizeField().length() > 0) {
                outputRowData[rowIndex++] = new Long(this.data.size);
            }
            if (this.meta.isHiddenField() != null && this.meta.isHiddenField().length() > 0) {
                outputRowData[rowIndex++] = new Boolean(this.data.hidden);
            }
            if (this.meta.getLastModificationDateField() != null && this.meta.getLastModificationDateField().length() > 0) {
                outputRowData[rowIndex++] = this.data.lastModificationDateTime;
            }
            if (this.meta.getUriField() != null && this.meta.getUriField().length() > 0) {
                outputRowData[rowIndex++] = this.data.uriName;
            }
            if (this.meta.getRootUriField() != null && this.meta.getRootUriField().length() > 0) {
                outputRowData[rowIndex++] = this.data.rootUriName;
            }
            this.data.previousRow = (irow = this.getInputRowMeta()) == null ? outputRowData : irow.cloneRow(outputRowData);
            this.incrementLinesInput();
            ++this.data.rownr;
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LDIFInput.Exception.UnableToReadFile", (String[])new String[]{this.data.file.toString()}), (Throwable)e);
        }
        return outputRowData;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block5: {
            Object[] r = null;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                Object[] outputRowData = this.getOneRow();
                if (outputRowData == null) {
                    this.setOutputDone();
                    return false;
                }
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.meta.getRowLimit() > 0L && this.data.rownr > this.meta.getRowLimit()) {
                    this.setOutputDone();
                    return false;
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"LDIFInput.ErrorInStepRunning", (String[])new String[]{e.getMessage()}));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block5;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "LDIFInput001");
            }
        }
        return true;
    }

    private boolean openNextFile() {
        try {
            if (!this.meta.isFileField()) {
                if (this.data.filenr >= this.data.files.nrOfFiles()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"LDIFInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
                this.data.last_file = this.data.filenr == this.data.files.nrOfFiles() - 1;
                this.data.file = this.data.files.getFile(this.data.filenr);
                ++this.data.filenr;
            } else {
                this.data.readrow = this.getRow();
                if (this.data.readrow == null) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"LDIFInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
                if (this.first) {
                    this.first = false;
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    this.data.convertRowMeta = this.data.outputRowMeta.cloneToType(2);
                    if (Utils.isEmpty((CharSequence)this.meta.getDynamicFilenameField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"LDIFInput.Log.NoField", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"LDIFInput.Log.NoField", (String[])new String[0]));
                    }
                    if (this.data.indexOfFilenameField < 0) {
                        this.data.indexOfFilenameField = this.getInputRowMeta().indexOfValue(this.meta.getDynamicFilenameField());
                        if (this.data.indexOfFilenameField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"LDIFInput.Log.ErrorFindingField", (String[])new String[0]) + "[" + this.meta.getDynamicFilenameField() + "]");
                            throw new KettleException(BaseMessages.getString(PKG, (String)"LDIFInput.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicFilenameField()}));
                        }
                    }
                }
                String filename = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfFilenameField);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"LDIFInput.Log.FilenameInStream", (String[])new String[]{this.meta.getDynamicFilenameField(), filename}));
                }
                this.data.file = KettleVFS.getFileObject((String)filename, (VariableSpace)this.getTransMeta());
            }
            this.data.filename = KettleVFS.getFilename((FileObject)this.data.file);
            if (this.meta.getShortFileNameField() != null && this.meta.getShortFileNameField().length() > 0) {
                this.data.shortFilename = this.data.file.getName().getBaseName();
            }
            try {
                if (this.meta.getPathField() != null && this.meta.getPathField().length() > 0) {
                    this.data.path = KettleVFS.getFilename((FileObject)this.data.file.getParent());
                }
                if (this.meta.isHiddenField() != null && this.meta.isHiddenField().length() > 0) {
                    this.data.hidden = this.data.file.isHidden();
                }
                if (this.meta.getExtensionField() != null && this.meta.getExtensionField().length() > 0) {
                    this.data.extension = this.data.file.getName().getExtension();
                }
                if (this.meta.getLastModificationDateField() != null && this.meta.getLastModificationDateField().length() > 0) {
                    this.data.lastModificationDateTime = new Date(this.data.file.getContent().getLastModifiedTime());
                }
                if (this.meta.getUriField() != null && this.meta.getUriField().length() > 0) {
                    this.data.uriName = this.data.file.getName().getURI();
                }
                if (this.meta.getRootUriField() != null && this.meta.getRootUriField().length() > 0) {
                    this.data.rootUriName = this.data.file.getName().getRootURI();
                }
                if (this.meta.getSizeField() != null && this.meta.getSizeField().length() > 0) {
                    this.data.size = new Long(this.data.file.getContent().getSize());
                }
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"LDIFInput.Log.OpeningFile", (String[])new String[]{this.data.file.toString()}));
            }
            if (this.meta.AddToResultFilename()) {
                ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"LDIFInput.Log.FileAddedResult", (String[])new String[0]));
                this.addResultFile(resultFile);
            }
            this.data.InputLDIF = new LDIF(KettleVFS.getFilename((FileObject)this.data.file));
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"LDIFInput.Log.FileOpened", (String[])new String[]{this.data.file.toString()}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"LDIFInput.Log.UnableToOpenFile", (String[])new String[]{"" + this.data.filenr, this.data.file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    private String GetValue(LDAPAttribute[] attributes_LDIF, String AttributValue) {
        String Stringvalue = null;
        int i = 0;
        for (int j = 0; j < attributes_LDIF.length; ++j) {
            LDAPAttribute attribute_DIF = attributes_LDIF[j];
            if (!attribute_DIF.getName().equalsIgnoreCase(AttributValue)) continue;
            Enumeration valuesLDIF = attribute_DIF.getStringValues();
            while (valuesLDIF.hasMoreElements()) {
                String valueLDIF = (String)valuesLDIF.nextElement();
                Stringvalue = i == 0 ? valueLDIF : Stringvalue + this.data.multiValueSeparator + valueLDIF;
                ++i;
            }
        }
        return Stringvalue;
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LDIFInputMeta)smi;
        this.data = (LDIFInputData)sdi;
        if (super.init(smi, sdi)) {
            if (!this.meta.isFileField()) {
                this.data.files = this.meta.getFiles(this);
                if (this.data.files.nrOfFiles() == 0 && this.data.files.nrOfMissingFiles() == 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"LDIFInput.Log.NoFiles", (String[])new String[0]));
                    return false;
                }
                try {
                    this.data.outputRowMeta = new RowMeta();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                    this.data.convertRowMeta = this.data.outputRowMeta.cloneToType(2);
                    this.data.nrInputFields = this.meta.getInputFields().length;
                    this.data.multiValueSeparator = this.environmentSubstitute(this.meta.getMultiValuedSeparator());
                }
                catch (Exception e) {
                    this.logError("Error initializing step: " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
            }
            this.data.rownr = 1L;
            this.data.totalpreviousfields = 0;
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LDIFInputMeta)smi;
        this.data = (LDIFInputData)sdi;
        if (this.data.file != null) {
            try {
                this.data.file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.data.InputLDIF != null) {
            this.data.InputLDIF = null;
        }
        if (this.data.attributes_LDIF != null) {
            this.data.attributes_LDIF = null;
        }
        if (this.data.recordLDIF != null) {
            this.data.recordLDIF = null;
        }
        super.dispose(smi, sdi);
    }
}

