/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mapping;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.logging.TransLogTable;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.SingleThreadedTransExecutor;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RemoteStep;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.TransStepUtil;
import org.pentaho.di.trans.steps.mapping.MappingData;
import org.pentaho.di.trans.steps.mapping.MappingIODefinition;
import org.pentaho.di.trans.steps.mapping.MappingMeta;
import org.pentaho.di.trans.steps.mapping.MappingParameters;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInput;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutput;

public class Mapping
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MappingMeta.class;
    private MappingMeta meta;
    private MappingData data;

    public Mapping(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            this.meta = (MappingMeta)smi;
            this.setData((MappingData)sdi);
            MappingInput[] mappingInputs = this.getData().getMappingTrans().findMappingInput();
            MappingOutput[] mappingOutputs = this.getData().getMappingTrans().findMappingOutput();
            this.getData().wasStarted = true;
            switch (this.getData().mappingTransMeta.getTransformationType()) {
                case Normal: 
                case SerialSingleThreaded: {
                    if (!this.getInputRowSets().isEmpty()) {
                        for (RowSet rowSet : new ArrayList<RowSet>(this.getInputRowSets())) {
                            if (mappingInputs.length == 1) {
                                mappingInputs[0].getInputRowSets().add(rowSet);
                                continue;
                            }
                            throw new KettleException("Unsupported situation detected where more than one Mapping Input step needs to be handled.  To solve it, insert a dummy step before the mapping step.");
                        }
                        this.getInputRowSets().clear();
                    }
                    if (!this.getRemoteInputSteps().isEmpty()) {
                        for (RemoteStep remoteStep : this.getRemoteInputSteps()) {
                            if (mappingInputs.length == 1) {
                                mappingInputs[0].getRemoteInputSteps().add(remoteStep);
                                continue;
                            }
                            throw new KettleException("Unsupported situation detected where a remote input step is expecting data to end up in a particular Mapping Input step of a sub-transformation.  To solve it, insert a dummy step before the mapping.");
                        }
                        this.getRemoteInputSteps().clear();
                    }
                    if (!this.getOutputRowSets().isEmpty()) {
                        for (RowSet rowSet : new ArrayList<RowSet>(this.getOutputRowSets())) {
                            if (mappingOutputs.length == 1) {
                                mappingOutputs[0].getOutputRowSets().add(rowSet);
                                continue;
                            }
                            throw new KettleException("Unsupported situation detected where more than one Mapping Output step needs to be handled.  To solve it, insert a dummy step after the mapping step.");
                        }
                        this.getOutputRowSets().clear();
                    }
                    if (!this.getRemoteOutputSteps().isEmpty()) {
                        for (RemoteStep remoteStep : this.getRemoteOutputSteps()) {
                            if (mappingOutputs.length == 1) {
                                mappingOutputs[0].getRemoteOutputSteps().add(remoteStep);
                                continue;
                            }
                            throw new KettleException("Unsupported situation detected where a remote output step is expecting data to end up in a particular Mapping Output step of a sub-transformation.  To solve it, insert a dummy step after the mapping.");
                        }
                        this.getRemoteOutputSteps().clear();
                    }
                    this.getData().getMappingTrans().startThreads();
                    if (this.getTransMeta().getTransformationType() == TransMeta.TransformationType.Normal) {
                        this.getData().getMappingTrans().waitUntilFinished();
                        Result result = this.getData().getMappingTrans().getResult();
                        this.setErrors(result.getNrErrors());
                        this.setLinesRead(result.getNrLinesRead());
                        this.setLinesWritten(result.getNrLinesWritten());
                        this.setLinesInput(result.getNrLinesInput());
                        this.setLinesOutput(result.getNrLinesOutput());
                        this.setLinesUpdated(result.getNrLinesUpdated());
                        this.setLinesRejected(result.getNrLinesRejected());
                    }
                    return false;
                }
                case SingleThreaded: {
                    boolean result;
                    if (mappingInputs.length > 1 || mappingOutputs.length > 1) {
                        throw new KettleException("Multiple input or output steps are not supported for a single threaded mapping.");
                    }
                    if (this.log != null && this.log.isDebug()) {
                        this.log.logDebug("# of input buffers: " + mappingInputs[0].getInputRowSets().size());
                        if (mappingInputs[0].getInputRowSets().size() > 0) {
                            this.log.logDebug("Input buffer 0 size: " + mappingInputs[0].getInputRowSets().get(0).size());
                        }
                    }
                    if (!(result = this.getData().singleThreadedTransExcecutor.oneIteration())) {
                        this.getData().singleThreadedTransExcecutor.dispose();
                        this.setOutputDone();
                        return false;
                    }
                    return true;
                }
            }
            throw new KettleException("Transformation type '" + this.getData().mappingTransMeta.getTransformationType().getDescription() + "' is an unsupported transformation type for a mapping");
        }
        catch (Throwable t) {
            if (this.getData().getMappingTrans() != null) {
                this.getData().getMappingTrans().stopAll();
            }
            throw new KettleException(t);
        }
    }

    public void setMappingParameters(Trans trans, TransMeta transMeta, MappingParameters mappingParameters) throws KettleException {
        if (mappingParameters == null) {
            return;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        HashSet<String> subTransParameters = new HashSet<String>(Arrays.asList(transMeta.listParameters()));
        if (mappingParameters.isInheritingAllVariables()) {
            for (String variableName : this.listVariables()) {
                parameters.put(variableName, this.getVariable(variableName));
            }
        }
        String[] mappingVariables = mappingParameters.getVariable();
        String[] inputFields = mappingParameters.getInputField();
        for (int i = 0; i < mappingVariables.length; ++i) {
            parameters.put(mappingVariables[i], this.environmentSubstitute(inputFields[i]));
        }
        for (Map.Entry entry : parameters.entrySet()) {
            String key = (String)entry.getKey();
            String value = Const.NVL((String)((String)entry.getValue()), (String)"");
            if (subTransParameters.contains(key)) {
                trans.setParameterValue(key, Const.NVL((String)((String)entry.getValue()), (String)""));
                continue;
            }
            trans.setVariable(key, value);
        }
        trans.activateParameters();
    }

    public void prepareMappingExecution() throws KettleException {
        this.initTransFromMeta();
        MappingData mappingData = this.getData();
        try {
            mappingData.getMappingTrans().prepareExecution(this.getTrans().getArguments());
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Mapping.Exception.UnableToPrepareExecutionOfMapping", (String[])new String[0]), (Throwable)e);
        }
        switch (mappingData.mappingTransMeta.getTransformationType()) {
            case Normal: 
            case SerialSingleThreaded: {
                break;
            }
            case SingleThreaded: {
                mappingData.singleThreadedTransExcecutor = new SingleThreadedTransExecutor(mappingData.getMappingTrans());
                if (mappingData.singleThreadedTransExcecutor.init()) break;
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mapping.Exception.UnableToInitSingleThreadedTransformation", (String[])new String[0]));
            }
        }
        MappingInput[] mappingInputs = mappingData.getMappingTrans().findMappingInput();
        LogTableField readField = mappingData.mappingTransMeta.getTransLogTable().findField(TransLogTable.ID.LINES_READ);
        if (readField.getSubject() == null && mappingInputs != null && mappingInputs.length >= 1) {
            readField.setSubject((Object)mappingInputs[0].getStepMeta());
        }
        MappingOutput[] mappingOutputs = mappingData.getMappingTrans().findMappingOutput();
        LogTableField writeField = mappingData.mappingTransMeta.getTransLogTable().findField(TransLogTable.ID.LINES_WRITTEN);
        if (writeField.getSubject() == null && mappingOutputs != null && mappingOutputs.length >= 1) {
            writeField.setSubject((Object)mappingOutputs[0].getStepMeta());
        }
        for (MappingIODefinition inputDefinition : this.meta.getInputMappings()) {
            StepInterface[] sourceSteps;
            if (!Utils.isEmpty((CharSequence)inputDefinition.getInputStepname())) {
                StepInterface sourceStep = this.getTrans().findRunThread(inputDefinition.getInputStepname());
                if (sourceStep == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.StepNameNotFound", (String[])new String[]{inputDefinition.getInputStepname()}));
                }
                sourceSteps = new StepInterface[]{sourceStep};
            } else {
                List<StepMeta> prevSteps = this.getTransMeta().findPreviousSteps(this.getStepMeta());
                sourceSteps = new StepInterface[prevSteps.size()];
                for (int s = 0; s < sourceSteps.length; ++s) {
                    sourceSteps[s] = this.getTrans().findRunThread(prevSteps.get(s).getName());
                }
            }
            MappingInput mappingInputTarget = null;
            MappingInput[] mappingInputSteps = mappingData.getMappingTrans().findMappingInput();
            if (Utils.isEmpty((CharSequence)inputDefinition.getOutputStepname())) {
                if (mappingInputSteps.length == 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.OneMappingInputStepRequired", (String[])new String[0]));
                }
                if (mappingInputSteps.length > 1) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.OnlyOneMappingInputStepAllowed", (String[])new String[]{"" + mappingInputSteps.length}));
                }
                mappingInputTarget = mappingInputSteps[0];
            } else {
                for (int s = 0; s < mappingInputSteps.length && mappingInputTarget == null; ++s) {
                    if (!mappingInputSteps[s].getStepname().equals(inputDefinition.getOutputStepname())) continue;
                    mappingInputTarget = mappingInputSteps[s];
                }
                if (mappingInputTarget == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.StepNameNotFound", (String[])new String[]{inputDefinition.getOutputStepname()}));
                }
            }
            if (inputDefinition.isRenamingOnOutput()) {
                Mapping.addInputRenames(this.getData().inputRenameList, inputDefinition.getValueRenames());
            }
            mappingInputTarget.setConnectorSteps(sourceSteps, inputDefinition.getValueRenames(), this.getStepname());
        }
        for (MappingIODefinition outputDefinition : this.meta.getOutputMappings()) {
            MappingOutput mappingOutputSource = (MappingOutput)mappingData.getMappingTrans().findRunThread(outputDefinition.getInputStepname());
            if (mappingOutputSource == null) {
                MappingOutput[] mappingOutputSteps = mappingData.getMappingTrans().findMappingOutput();
                if (mappingOutputSteps.length == 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.OneMappingOutputStepRequired", (String[])new String[0]));
                }
                if (mappingOutputSteps.length > 1) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.OnlyOneMappingOutputStepAllowed", (String[])new String[]{"" + mappingOutputSteps.length}));
                }
                mappingOutputSource = mappingOutputSteps[0];
            }
            StepInterface[] targetSteps = this.pickupTargetStepsFor(outputDefinition);
            mappingOutputSource.setConnectorSteps(targetSteps, this.getData().inputRenameList, outputDefinition.getValueRenames());
            mappingOutputSource.setDistributed(this.isDistributed());
        }
        this.getTrans().addActiveSubTransformation(this.getStepname(), this.getData().getMappingTrans());
    }

    @VisibleForTesting
    StepInterface[] pickupTargetStepsFor(MappingIODefinition outputDefinition) throws KettleException {
        List<StepInterface> result;
        if (!Utils.isEmpty((CharSequence)outputDefinition.getOutputStepname())) {
            result = this.getTrans().findStepInterfaces(outputDefinition.getOutputStepname());
            if (Utils.isEmpty(result)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.StepNameNotFound", (String[])new String[]{outputDefinition.getOutputStepname()}));
            }
        } else {
            List<StepMeta> nextSteps = this.getTransMeta().findNextSteps(this.getStepMeta());
            result = new ArrayList<StepInterface>();
            for (StepMeta nextStep : nextSteps) {
                List<StepInterface> copies = this.getTrans().findStepInterfaces(nextStep.getName());
                if (copies == null) continue;
                result.addAll(copies);
            }
        }
        return result.toArray(new StepInterface[result.size()]);
    }

    void initTransFromMeta() throws KettleException {
        this.getData().setMappingTrans(new Trans(this.getData().mappingTransMeta, this));
        if (this.getData().mappingTransMeta.getTransformationType() != TransMeta.TransformationType.Normal) {
            this.getData().getMappingTrans().getTransMeta().setUsingThreadPriorityManagment(false);
        }
        this.getData().getMappingTrans().setParentTrans(this.getTrans());
        this.getData().getMappingTrans().setSafeModeEnabled(this.getTrans().isSafeModeEnabled());
        this.getData().getMappingTrans().setGatheringMetrics(this.getTrans().isGatheringMetrics());
        this.getData().getMappingTrans().setMappingStepName(this.getStepname());
        this.initServletConfig();
        this.setMappingParameters(this.data.mappingTrans, this.data.mappingTransMeta, this.meta.getMappingParameters());
    }

    void initServletConfig() {
        TransStepUtil.initServletConfig(this.getTrans(), this.getData().getMappingTrans());
    }

    public static void addInputRenames(List<MappingValueRename> renameList, List<MappingValueRename> addRenameList) {
        for (MappingValueRename rename : addRenameList) {
            if (renameList.indexOf(rename) >= 0) continue;
            renameList.add(rename);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MappingMeta)smi;
        this.setData((MappingData)sdi);
        MappingData mappingData = this.getData();
        if (!super.init(smi, sdi)) {
            return false;
        }
        try {
            this.meta.setRepository(this.getTransMeta().getRepository());
            mappingData.mappingTransMeta = MappingMeta.loadMappingMeta(this.meta, this.meta.getRepository(), this.meta.getMetaStore(), this, this.meta.getMappingParameters().isInheritingAllVariables());
            if (this.data.mappingTransMeta == null) {
                this.logError("No valid mapping was specified!");
                return false;
            }
            this.prepareMappingExecution();
            this.lookupStatusStepNumbers();
            return true;
        }
        catch (Exception e) {
            this.logError("Unable to load the mapping transformation because of an error : " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            return false;
        }
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.getData().wasStarted) {
            if (!this.getData().mappingTrans.isFinished()) {
                this.getData().getMappingTrans().waitUntilFinished();
            }
            this.getTrans().removeActiveSubTransformation(this.getStepname());
            if (this.getData().getMappingTrans().getErrors() > 0) {
                this.logError(BaseMessages.getString(PKG, (String)"Mapping.Log.ErrorOccurredInSubTransformation", (String[])new String[0]));
                this.setErrors(1L);
            }
        }
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        if (this.getData().getMappingTrans() != null) {
            this.getData().getMappingTrans().stopAll();
        }
    }

    @Override
    public void stopAll() {
        if (this.getData().getMappingTrans() != null) {
            this.getData().getMappingTrans().stopAll();
        }
        super.stopAll();
    }

    private void lookupStatusStepNumbers() {
        MappingData mappingData = this.getData();
        if (mappingData.getMappingTrans() != null) {
            List<StepMetaDataCombi> steps = mappingData.getMappingTrans().getSteps();
            for (int i = 0; i < steps.size(); ++i) {
                StepMetaDataCombi sid = steps.get(i);
                BaseStep rt = (BaseStep)sid.step;
                if (rt.getStepname().equals(this.getData().mappingTransMeta.getTransLogTable().getStepnameRead())) {
                    mappingData.linesReadStepNr = i;
                }
                if (rt.getStepname().equals(this.getData().mappingTransMeta.getTransLogTable().getStepnameInput())) {
                    mappingData.linesInputStepNr = i;
                }
                if (rt.getStepname().equals(this.getData().mappingTransMeta.getTransLogTable().getStepnameWritten())) {
                    mappingData.linesWrittenStepNr = i;
                }
                if (rt.getStepname().equals(this.getData().mappingTransMeta.getTransLogTable().getStepnameOutput())) {
                    mappingData.linesOutputStepNr = i;
                }
                if (rt.getStepname().equals(this.getData().mappingTransMeta.getTransLogTable().getStepnameUpdated())) {
                    mappingData.linesUpdatedStepNr = i;
                }
                if (!rt.getStepname().equals(this.getData().mappingTransMeta.getTransLogTable().getStepnameRejected())) continue;
                mappingData.linesRejectedStepNr = i;
            }
        }
    }

    @Override
    public long getLinesInput() {
        if (this.getData() != null && this.getData().linesInputStepNr != -1) {
            return this.getData().getMappingTrans().getSteps().get((int)this.getData().linesInputStepNr).step.getLinesInput();
        }
        return 0L;
    }

    @Override
    public long getLinesOutput() {
        if (this.getData() != null && this.getData().linesOutputStepNr != -1) {
            return this.getData().getMappingTrans().getSteps().get((int)this.getData().linesOutputStepNr).step.getLinesOutput();
        }
        return 0L;
    }

    @Override
    public long getLinesRead() {
        if (this.getData() != null && this.getData().linesReadStepNr != -1) {
            return this.getData().getMappingTrans().getSteps().get((int)this.getData().linesReadStepNr).step.getLinesRead();
        }
        return 0L;
    }

    @Override
    public long getLinesRejected() {
        if (this.getData() != null && this.getData().linesRejectedStepNr != -1) {
            return this.getData().getMappingTrans().getSteps().get((int)this.getData().linesRejectedStepNr).step.getLinesRejected();
        }
        return 0L;
    }

    @Override
    public long getLinesUpdated() {
        if (this.getData() != null && this.getData().linesUpdatedStepNr != -1) {
            return this.getData().getMappingTrans().getSteps().get((int)this.getData().linesUpdatedStepNr).step.getLinesUpdated();
        }
        return 0L;
    }

    @Override
    public long getLinesWritten() {
        if (this.getData() != null && this.getData().linesWrittenStepNr != -1) {
            return this.getData().getMappingTrans().getSteps().get((int)this.getData().linesWrittenStepNr).step.getLinesWritten();
        }
        return 0L;
    }

    @Override
    public int rowsetInputSize() {
        int size = 0;
        for (MappingInput input : this.getData().getMappingTrans().findMappingInput()) {
            for (RowSet rowSet : input.getInputRowSets()) {
                size += rowSet.size();
            }
        }
        return size;
    }

    @Override
    public int rowsetOutputSize() {
        int size = 0;
        for (MappingOutput output : this.getData().getMappingTrans().findMappingOutput()) {
            for (RowSet rowSet : output.getOutputRowSets()) {
                size += rowSet.size();
            }
        }
        return size;
    }

    public Trans getMappingTrans() {
        return this.getData().getMappingTrans();
    }

    @Override
    public void addRowListener(RowListener rowListener) {
        MappingOutput[] mappingOutputs = this.getData().getMappingTrans().findMappingOutput();
        if (mappingOutputs == null || mappingOutputs.length == 0) {
            return;
        }
        for (MappingOutput mappingOutput : mappingOutputs) {
            mappingOutput.addRowListener(rowListener);
        }
    }

    MappingData getData() {
        return this.data;
    }

    void setData(MappingData data) {
        this.data = data;
    }
}

