/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.webservices;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.HttpClientManager;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLParserFactoryProducer;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.webservices.WebServiceData;
import org.pentaho.di.trans.steps.webservices.WebServiceField;
import org.pentaho.di.trans.steps.webservices.WebServiceMeta;
import org.pentaho.di.trans.steps.webservices.wsdl.Wsdl;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlOpParameter;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlOpParameterList;
import org.pentaho.di.trans.steps.webservices.wsdl.WsdlOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WebService
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = WebServiceMeta.class;
    public static final String NS_PREFIX = "ns";
    private WebServiceData data;
    private WebServiceMeta meta;
    private int nbRowProcess;
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private DecimalFormat decFormat = new DecimalFormat("00");
    private Date dateRef;
    private Wsdl cachedWsdl;
    private HttpClientContext cachedHostConfiguration;
    private HttpClient cachedHttpClient;
    private String cachedURLService;
    private WsdlOperation cachedOperation;
    private WebServiceMeta cachedMeta;
    private List<Integer> indexList;

    public WebService(StepMeta aStepMeta, StepDataInterface aStepData, int value, TransMeta aTransMeta, Trans aTrans) {
        super(aStepMeta, aStepData, value, aTransMeta, aTrans);
        try {
            this.dateRef = this.timeFormat.parse("00:00:00");
        }
        catch (ParseException e) {
            this.logError("Unexpected error in WebService constructor: ", e);
            this.setErrors(1L);
            this.stopAll();
        }
    }

    @Override
    public boolean processRow(StepMetaInterface metaInterface, StepDataInterface dataInterface) throws KettleException {
        this.meta = (WebServiceMeta)metaInterface;
        if (Utils.isEmpty((CharSequence)this.meta.getUrl())) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0014.urlNotSpecified", (String[])new String[]{this.getStepname()}));
        }
        if (Utils.isEmpty((CharSequence)this.meta.getOperationName())) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0015.OperationNotSelected", (String[])new String[]{this.getStepname()}));
        }
        this.data = (WebServiceData)dataInterface;
        Object[] vCurrentRow = this.getRow();
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta() != null ? this.getInputRowMeta().clone() : new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.defineIndexList(this.getInputRowMeta(), vCurrentRow);
        } else if (vCurrentRow == null) {
            this.setOutputDone();
            return false;
        }
        if (vCurrentRow != null) {
            ++this.nbRowProcess;
            this.data.argumentRows.add(vCurrentRow);
        }
        if (vCurrentRow == null && this.nbRowProcess % this.meta.getCallStep() != 0 || vCurrentRow != null && this.nbRowProcess > 0 && this.nbRowProcess % this.meta.getCallStep() == 0 || vCurrentRow == null && !this.meta.hasFieldsIn()) {
            this.requestSOAP(vCurrentRow, this.getInputRowMeta());
        }
        if (vCurrentRow == null) {
            this.setOutputDone();
        }
        return vCurrentRow != null;
    }

    private void defineIndexList(RowMetaInterface rowMeta, Object[] vCurrentRow) throws KettleException {
        int index;
        this.indexList = new ArrayList<Integer>();
        if (rowMeta != null) {
            for (WebServiceField curField : this.meta.getFieldsIn()) {
                index = rowMeta.indexOfValue(curField.getName());
                if (index >= 0) {
                    this.indexList.add(index);
                    continue;
                }
                throw new KettleException("Required input field [" + curField.getName() + "] couldn't be found in the step input");
            }
        }
        for (WebServiceField curField : this.meta.getFieldsOut()) {
            index = this.data.outputRowMeta.indexOfValue(curField.getName());
            if (index < 0) continue;
            this.data.indexMap.put(curField.getWsName(), index);
        }
    }

    private String getRequestXML(WsdlOperation operation, boolean qualifyWSField) throws KettleException {
        WsdlOpParameterList parameters = operation.getParameters();
        String requestOperation = Const.NVL((String)this.meta.getOperationRequestName(), (String)this.meta.getOperationName());
        Iterator iterator = parameters.iterator();
        ArrayList<String> bodyNames = new ArrayList<String>();
        while (iterator.hasNext()) {
            WsdlOpParameter wsdlOpParameter = (WsdlOpParameter)iterator.next();
            bodyNames.add(wsdlOpParameter.getName().getLocalPart());
        }
        ArrayList<String> headerNames = new ArrayList<String>(parameters.getHeaderNames());
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xml.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ns=\"");
        xml.append(this.meta.getOperationNamespace());
        xml.append("\">\n");
        xml.append("  <soapenv:Header>\n");
        this.addParametersToXML(xml, headerNames, qualifyWSField);
        xml.append("  </soapenv:Header>\n");
        xml.append("  <soapenv:Body>\n");
        xml.append("    <ns:").append(requestOperation).append(">\n");
        if (this.meta.getInFieldContainerName() != null) {
            xml.append("      <ns:" + this.meta.getInFieldContainerName() + ">\n");
        }
        this.addParametersToXML(xml, bodyNames, qualifyWSField);
        if (this.meta.getInFieldContainerName() != null) {
            xml.append("      </ns:" + this.meta.getInFieldContainerName() + ">\n");
        }
        xml.append("    </ns:").append(requestOperation).append(">\n");
        xml.append("  </soapenv:Body>\n");
        xml.append("</soapenv:Envelope>\n");
        return xml.toString();
    }

    private void addParametersToXML(StringBuilder xml, List<String> names, boolean qualifyWSField) throws KettleException {
        for (Object[] vCurrentRow : this.data.argumentRows) {
            if (this.meta.getInFieldArgumentName() != null) {
                xml.append("        <ns:").append(this.meta.getInFieldArgumentName()).append(">\n");
            }
            for (Integer index : this.indexList) {
                ValueMetaInterface vCurrentValue = this.getInputRowMeta().getValueMeta(index.intValue());
                Object data = vCurrentRow[index];
                WebServiceField field = this.meta.getFieldInFromName(vCurrentValue.getName());
                if (field == null || !names.contains(field.getWsName())) continue;
                if (!vCurrentValue.isNull(data)) {
                    xml.append("          <");
                    if (qualifyWSField) {
                        xml.append(NS_PREFIX).append(":");
                    }
                    xml.append(field.getWsName()).append(">");
                    if ("time".equals(field.getXsdType())) {
                        long millis = vCurrentValue.getDate(data).getTime() - this.dateRef.getTime();
                        xml.append(this.decFormat.format(millis / 3600000L) + ":" + this.decFormat.format(millis % 3600000L / 60000L) + ":" + this.decFormat.format(millis % 60000L / 1000L));
                    } else if ("date".equals(field.getXsdType())) {
                        xml.append(this.dateFormat.format(vCurrentValue.getDate(data)));
                    } else if ("boolean".equals(field.getXsdType())) {
                        xml.append(vCurrentValue.getBoolean(data) != false ? "true" : "false");
                    } else if ("datetime".equals(field.getXsdType())) {
                        xml.append(this.dateTimeFormat.format(vCurrentValue.getDate(data)));
                    } else if (vCurrentValue.isNumber()) {
                        xml.append(vCurrentValue.getString(data).trim().replace(',', '.'));
                    } else {
                        xml.append(Const.trim((String)vCurrentValue.getString(data)));
                    }
                    xml.append("</");
                    if (qualifyWSField) {
                        xml.append(NS_PREFIX).append(":");
                    }
                    xml.append(field.getWsName()).append(">\n");
                    continue;
                }
                xml.append("          <").append(NS_PREFIX).append(":").append(field.getWsName()).append(" xsi:nil=\"true\"/>\n");
            }
            if (this.meta.getInFieldArgumentName() == null) continue;
            xml.append("        </ns:").append(this.meta.getInFieldArgumentName()).append(">\n");
        }
    }

    private synchronized void requestSOAP(Object[] rowData, RowMetaInterface rowMeta) throws KettleException {
        block13: {
            this.initWsdlEnv();
            HttpPost vHttpMethod = null;
            HttpEntity httpEntity = null;
            Charset charSet = Charset.defaultCharset();
            try {
                String xml = this.getRequestXML(this.cachedOperation, this.cachedWsdl.getWsdlTypes().isElementFormQualified(this.cachedWsdl.getTargetNamespace()));
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"WebServices.Log.SOAPEnvelope", (String[])new String[0]));
                    this.logDetailed(xml);
                }
                vHttpMethod = this.getHttpMethod(this.cachedURLService);
                ByteArrayEntity requestEntity = new ByteArrayEntity(xml.toString().getBytes("UTF-8"));
                vHttpMethod.setEntity((HttpEntity)requestEntity);
                HttpResponse httpResponse = this.cachedHttpClient.execute((HttpUriRequest)vHttpMethod);
                int responseCode = httpResponse.getStatusLine().getStatusCode();
                if (responseCode == 301) {
                    String newLocation = WebService.getLocationFrom(vHttpMethod);
                    vHttpMethod = this.getHttpMethod(newLocation);
                    vHttpMethod.setEntity((HttpEntity)requestEntity);
                    httpResponse = this.cachedHttpClient.execute((HttpUriRequest)vHttpMethod);
                    responseCode = httpResponse.getStatusLine().getStatusCode();
                }
                if (responseCode == 200) {
                    httpEntity = httpResponse.getEntity();
                    ContentType contentType = ContentType.getOrDefault((HttpEntity)httpEntity);
                    charSet = contentType.getCharset();
                    this.processRows(httpEntity.getContent(), rowData, rowMeta, this.cachedWsdl.getWsdlTypes().isElementFormQualified(this.cachedWsdl.getTargetNamespace()), charSet.toString());
                    break block13;
                }
                if (responseCode == 401) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0011.Authentication", (String[])new String[]{this.cachedURLService}));
                }
                if (responseCode == 404) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0012.NotFound", (String[])new String[]{this.cachedURLService}));
                }
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0001.ServerError", (String[])new String[]{Integer.toString(responseCode), Const.NVL((String)new String(EntityUtils.toString((HttpEntity)httpEntity, (String)charSet.toString())), (String)""), this.cachedURLService}));
            }
            catch (UnknownHostException e) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0013.UnknownHost", (String[])new String[]{this.cachedURLService}), (Throwable)e);
            }
            catch (IOException e) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0005.IOException", (String[])new String[]{this.cachedURLService}), (Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0002.InvalidURI", (String[])new String[]{this.cachedURLService}), (Throwable)e);
            }
            finally {
                this.data.argumentRows.clear();
                if (vHttpMethod != null) {
                    vHttpMethod.releaseConnection();
                }
            }
        }
    }

    private void initWsdlEnv() throws KettleException {
        if (this.meta.equals(this.cachedMeta)) {
            return;
        }
        this.cachedMeta = this.meta;
        try {
            this.cachedWsdl = new Wsdl(new URI(this.data.realUrl), null, null, this.meta.getHttpLogin(), this.meta.getHttpPassword());
        }
        catch (Exception e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0013.ExceptionLoadingWSDL", (String[])new String[0]), (Throwable)e);
        }
        this.cachedURLService = this.cachedWsdl.getServiceEndpoint();
        this.cachedHostConfiguration = HttpClientContext.create();
        this.cachedHttpClient = this.getHttpClient(this.cachedHostConfiguration);
        this.cachedOperation = this.cachedWsdl.getOperation(this.meta.getOperationName());
        if (this.cachedOperation == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"WebServices.Exception.OperarationNotSupported", (String[])new String[]{this.meta.getOperationName(), this.meta.getUrl()}));
        }
    }

    static String getLocationFrom(HttpPost method) {
        Header locationHeader = method.getFirstHeader("Location");
        return locationHeader.getValue();
    }

    HttpPost getHttpMethod(String vURLService) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(vURLService);
        HttpPost vHttpMethod = new HttpPost(uriBuilder.build());
        vHttpMethod.setHeader("Content-Type", "text/xml;charset=UTF-8");
        String soapAction = "\"" + this.meta.getOperationNamespace();
        if (!this.meta.getOperationNamespace().endsWith("/")) {
            soapAction = soapAction + "/";
        }
        soapAction = soapAction + this.meta.getOperationName() + "\"";
        this.logDetailed(BaseMessages.getString(PKG, (String)"WebServices.Log.UsingRequestHeaderSOAPAction", (String[])new String[]{soapAction}));
        vHttpMethod.setHeader("SOAPAction", soapAction);
        return vHttpMethod;
    }

    private HttpClient getHttpClient(HttpClientContext context) {
        HttpClientManager.HttpClientBuilderFacade clientBuilder = HttpClientManager.getInstance().createBuilder();
        String login = this.environmentSubstitute(this.meta.getHttpLogin());
        if (StringUtils.isNotBlank((String)login)) {
            clientBuilder.setCredentials(login, this.environmentSubstitute(this.meta.getHttpPassword()));
        }
        int proxyPort = 0;
        if (StringUtils.isNotBlank((String)this.meta.getProxyHost())) {
            proxyPort = Const.toInt((String)this.environmentSubstitute(this.meta.getProxyPort()), (int)8080);
            clientBuilder.setProxy(this.meta.getProxyHost(), proxyPort);
        }
        CloseableHttpClient httpClient = clientBuilder.build();
        if (proxyPort != 0) {
            HttpHost target = new HttpHost(this.meta.getProxyHost(), proxyPort, "http");
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(target, (AuthScheme)basicAuth);
            context.setAuthCache((AuthCache)authCache);
        }
        return httpClient;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (WebServiceMeta)smi;
        this.data = (WebServiceData)sdi;
        this.data.indexMap = new Hashtable<String, Integer>();
        this.data.realUrl = this.environmentSubstitute(this.meta.getUrl());
        return super.init(smi, sdi);
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (WebServiceMeta)smi;
        this.data = (WebServiceData)sdi;
        super.dispose(smi, sdi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStringFromInputStream(InputStream is, String encoding) throws KettleStepException {
        try {
            StringBuilder sb = new StringBuilder(Math.max(16, is.available()));
            char[] tmp = new char[4096];
            try {
                int cnt;
                InputStreamReader reader = new InputStreamReader(is, encoding != null ? encoding : "UTF-8");
                while ((cnt = reader.read(tmp)) > 0) {
                    sb.append(tmp, 0, cnt);
                }
            }
            finally {
                is.close();
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new KettleStepException("Unable to read web service response data from input stream", (Throwable)e);
        }
    }

    private void processRows(InputStream anXml, Object[] rowData, RowMetaInterface rowMeta, boolean ignoreNamespacePrefix, String encoding) throws KettleException {
        if (this.meta.isCompatible()) {
            this.compatibleProcessRows(anXml, rowData, rowMeta, ignoreNamespacePrefix, encoding);
            return;
        }
        String response = this.readStringFromInputStream(anXml, encoding);
        try {
            DocumentBuilderFactory documentBuilderFactory = XMLParserFactoryProducer.createSecureDocBuilderFactory();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document doc = documentBuilder.parse(new InputSource(new StringReader(response)));
            Node envelopeNode = doc.getFirstChild();
            String nsPrefix = envelopeNode.getPrefix();
            Node bodyNode = XMLHandler.getSubNode((Node)envelopeNode, (String)(nsPrefix + ":Body"));
            if (bodyNode == null) {
                XMLHandler.getSubNode((Node)envelopeNode, (String)(nsPrefix + ":body"));
            }
            Transformer transformer = null;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            if (this.log.isDetailed()) {
                StringWriter bodyXML = new StringWriter();
                transformer.transform(new DOMSource(bodyNode), new StreamResult(bodyXML));
                this.logDetailed(bodyXML.toString());
            }
            Node responseNode = null;
            NodeList nodeList = null;
            if (!Utils.isEmpty((CharSequence)this.meta.getRepeatingElementName())) {
                nodeList = ((Element)bodyNode).getElementsByTagName(this.meta.getRepeatingElementName());
            } else if (this.meta.isReturningReplyAsString()) {
                StringWriter nodeXML = new StringWriter();
                transformer.transform(new DOMSource(bodyNode), new StreamResult(nodeXML));
                String xml = response;
                Object[] outputRowData = this.createNewRow(rowData);
                int index = rowData == null ? 0 : this.getInputRowMeta().size();
                outputRowData[index++] = xml;
                this.putRow(this.data.outputRowMeta, outputRowData);
            } else {
                NodeList responseChildren = bodyNode.getChildNodes();
                for (int i = 0; i < responseChildren.getLength(); ++i) {
                    Node responseChild = responseChildren.item(i);
                    if (responseChild.getNodeType() != 1) continue;
                    responseNode = responseChild;
                    break;
                }
                if (this.meta.getFieldsOut().size() == 1) {
                    WebServiceField field = this.meta.getFieldsOut().get(0);
                    if (field.getWsName().equals(responseNode.getNodeName())) {
                        StringWriter nodeXML = new StringWriter();
                        transformer.transform(new DOMSource(responseNode), new StreamResult(nodeXML));
                        String xml = nodeXML.toString();
                        Object[] outputRowData = this.createNewRow(rowData);
                        int index = rowData == null ? 0 : this.getInputRowMeta().size();
                        outputRowData[index++] = xml;
                        this.putRow(this.data.outputRowMeta, outputRowData);
                    } else if (responseNode != null) {
                        nodeList = responseNode.getChildNodes();
                    }
                } else if (responseNode != null) {
                    nodeList = responseNode.getChildNodes();
                }
            }
            if (nodeList == null || this.meta.isReturningReplyAsString()) {
                return;
            }
            Object[] outputRowData = this.createNewRow(rowData);
            boolean singleRow = false;
            int fieldsFound = 0;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (this.meta.isReturningReplyAsString()) {
                    StringWriter nodeXML = new StringWriter();
                    transformer.transform(new DOMSource(bodyNode), new StreamResult(nodeXML));
                    String xml = nodeXML.toString();
                    outputRowData = this.createNewRow(rowData);
                    int index = rowData == null ? 0 : this.getInputRowMeta().size();
                    outputRowData[index++] = xml;
                    this.putRow(this.data.outputRowMeta, outputRowData);
                    continue;
                }
                WebServiceField field = this.meta.getFieldOutFromWsName(node.getNodeName(), ignoreNamespacePrefix);
                if (field != null) {
                    if (!this.getNodeValue(outputRowData, node, field, transformer, true)) continue;
                    singleRow = true;
                    ++fieldsFound;
                    continue;
                }
                if (singleRow) continue;
                if (this.log.isDetailed()) {
                    StringWriter nodeXML = new StringWriter();
                    transformer.transform(new DOMSource(node), new StreamResult(nodeXML));
                    this.logDetailed(BaseMessages.getString(PKG, (String)"WebServices.Log.ResultRowDataFound", (String[])new String[]{nodeXML.toString()}));
                }
                outputRowData = this.createNewRow(rowData);
                NodeList childNodes = node.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node childNode = childNodes.item(j);
                    field = this.meta.getFieldOutFromWsName(childNode.getNodeName(), ignoreNamespacePrefix);
                    if (field == null || !this.getNodeValue(outputRowData, childNode, field, transformer, false)) continue;
                    ++fieldsFound;
                }
                if (fieldsFound <= 0) continue;
                this.putRow(this.data.outputRowMeta, outputRowData);
            }
            if (singleRow && fieldsFound > 0) {
                this.putRow(this.data.outputRowMeta, outputRowData);
            }
        }
        catch (Exception e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0010.OutputParsingError", (String[])new String[]{response.toString()}), (Throwable)e);
        }
    }

    private Object[] createNewRow(Object[] inputRowData) {
        return inputRowData == null ? RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size()) : RowDataUtil.createResizedCopy((Object[])inputRowData, (int)this.data.outputRowMeta.size());
    }

    private void compatibleProcessRows(InputStream anXml, Object[] rowData, RowMetaInterface rowMeta, boolean ignoreNamespacePrefix, String encoding) throws KettleException {
        String response = this.readStringFromInputStream(anXml, encoding);
        StringReader stringReader = new StringReader(response.toString());
        try {
            XMLInputFactory vFactory = XMLInputFactory.newInstance();
            XMLStreamReader vReader = vFactory.createXMLStreamReader(stringReader);
            Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            int outputIndex = 0;
            boolean processing = false;
            boolean oneValueRowProcessing = false;
            int event = vReader.next();
            while (vReader.hasNext()) {
                switch (event) {
                    case 1: {
                        WebServiceField field;
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("START_ELEMENT / " + vReader.getAttributeCount() + " / " + vReader.getNamespaceCount());
                        }
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("vReader.getLocalName = " + vReader.getLocalName());
                        }
                        if (Utils.isEmpty((CharSequence)this.meta.getOutFieldArgumentName())) {
                            if (!oneValueRowProcessing) break;
                            field = this.meta.getFieldOutFromWsName(vReader.getLocalName(), ignoreNamespacePrefix);
                            if (field != null) {
                                outputRowData[outputIndex++] = this.getValue(vReader.getElementText(), field);
                                this.putRow(this.data.outputRowMeta, outputRowData);
                                oneValueRowProcessing = false;
                                break;
                            }
                            if (!this.meta.getOutFieldContainerName().equals(vReader.getLocalName())) break;
                            if (this.log.isRowLevel()) {
                                this.logRowlevel("OutFieldContainerName = " + this.meta.getOutFieldContainerName());
                            }
                            oneValueRowProcessing = true;
                            break;
                        }
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("OutFieldArgumentName = " + this.meta.getOutFieldArgumentName());
                        }
                        if (this.meta.getOutFieldArgumentName().equals(vReader.getLocalName())) {
                            if (this.log.isRowLevel()) {
                                this.logRowlevel("vReader.getLocalName = " + vReader.getLocalName());
                            }
                            if (this.log.isRowLevel()) {
                                this.logRowlevel("OutFieldArgumentName = ");
                            }
                            if (processing) {
                                int index;
                                field = this.meta.getFieldOutFromWsName(vReader.getLocalName(), ignoreNamespacePrefix);
                                if (field != null && (index = this.data.outputRowMeta.indexOfValue(field.getName())) >= 0) {
                                    outputRowData[index] = this.getValue(vReader.getElementText(), field);
                                }
                                processing = false;
                                break;
                            }
                            field = this.meta.getFieldOutFromWsName(vReader.getLocalName(), ignoreNamespacePrefix);
                            if (this.meta.getFieldsOut().size() == 1 && field != null) {
                                try {
                                    if (this.meta.isPassingInputData()) {
                                        for (int i = 0; i < rowMeta.getValueMetaList().size(); ++i) {
                                            ValueMetaInterface valueMeta = this.getInputRowMeta().getValueMeta(i);
                                            outputRowData[outputIndex++] = valueMeta.cloneValueData(rowData[i]);
                                        }
                                    }
                                    outputRowData[outputIndex++] = this.getValue(vReader.getElementText(), field);
                                    this.putRow(this.data.outputRowMeta, outputRowData);
                                    break;
                                }
                                catch (XMLStreamException e) {
                                    throw new KettleStepException("Unable to get value for field [" + field.getName() + "].  Verify that this is not a complex data type by looking at the response XML.", (Throwable)e);
                                }
                            }
                            for (WebServiceField curField : this.meta.getFieldsOut()) {
                                if (Utils.isEmpty((CharSequence)curField.getName())) continue;
                                outputRowData[outputIndex++] = this.getValue(vReader.getElementText(), curField);
                            }
                            processing = true;
                            break;
                        }
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("vReader.getLocalName = " + vReader.getLocalName());
                        }
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("OutFieldArgumentName = " + this.meta.getOutFieldArgumentName());
                        break;
                    }
                    case 2: {
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("END_ELEMENT");
                        }
                        if (this.meta.getOutFieldArgumentName() == null && this.meta.getOperationName().equals(vReader.getLocalName())) {
                            oneValueRowProcessing = false;
                            break;
                        }
                        if (this.meta.getOutFieldArgumentName() == null || !this.meta.getOutFieldArgumentName().equals(vReader.getLocalName())) break;
                        this.putRow(this.data.outputRowMeta, outputRowData);
                        processing = false;
                        break;
                    }
                    case 3: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("PROCESSING_INSTRUCTION");
                        break;
                    }
                    case 4: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("CHARACTERS");
                        break;
                    }
                    case 5: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("COMMENT");
                        break;
                    }
                    case 6: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("PROCESSING_INSTRUCTION");
                        break;
                    }
                    case 7: {
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("START_DOCUMENT");
                        }
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel(vReader.getText());
                        break;
                    }
                    case 8: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("END_DOCUMENT");
                        break;
                    }
                    case 9: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("ENTITY_REFERENCE");
                        break;
                    }
                    case 10: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("ATTRIBUTE");
                        break;
                    }
                    case 11: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("DTD");
                        break;
                    }
                    case 12: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("CDATA");
                        break;
                    }
                    case 13: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("NAMESPACE");
                        break;
                    }
                    case 14: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("NOTATION_DECLARATION");
                        break;
                    }
                    case 15: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("ENTITY_DECLARATION");
                        break;
                    }
                }
                event = vReader.next();
            }
        }
        catch (Exception e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0010.OutputParsingError", (String[])new String[]{response}), (Throwable)e);
        }
    }

    private boolean getNodeValue(Object[] outputRowData, Node node, WebServiceField field, Transformer transformer, boolean singleRowScenario) throws KettleException {
        Integer outputIndex = this.data.indexMap.get(field.getWsName());
        if (outputIndex == null) {
            return false;
        }
        if (node.getNodeType() == 3 || !field.isComplex()) {
            Object rowValue = null;
            String textContent = node.getTextContent();
            try {
                outputRowData[outputIndex.intValue()] = rowValue = this.getValue(textContent, field);
                return true;
            }
            catch (Exception e) {
                throw new KettleException("Unable to convert value [" + textContent + "] for field [" + field.getWsName() + "], type [" + field.getXsdType() + "]", (Throwable)e);
            }
        }
        if (node.getNodeType() == 1) {
            try {
                StringWriter childNodeXML = new StringWriter();
                transformer.transform(new DOMSource(node), new StreamResult(childNodeXML));
                outputRowData[outputIndex.intValue()] = childNodeXML.toString();
                return true;
            }
            catch (Exception e) {
                throw new KettleException("Unable to transform DOM node with name [" + node.getNodeName() + "] to XML", (Throwable)e);
            }
        }
        return false;
    }

    private Object getValue(String vNodeValue, WebServiceField field) throws XMLStreamException, ParseException {
        if (vNodeValue == null) {
            return null;
        }
        if ("boolean".equals(field.getXsdType())) {
            return Boolean.valueOf(vNodeValue);
        }
        if ("date".equals(field.getXsdType())) {
            try {
                return this.dateFormat.parse(vNodeValue);
            }
            catch (ParseException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("time".equals(field.getXsdType())) {
            try {
                return this.timeFormat.parse(vNodeValue);
            }
            catch (ParseException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("datetime".equals(field.getXsdType())) {
            try {
                return this.dateTimeFormat.parse(vNodeValue);
            }
            catch (ParseException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("int".equals(field.getXsdType()) || "short".equals(field.getXsdType()) || "integer".equals(field.getXsdType())) {
            try {
                return Long.parseLong(vNodeValue);
            }
            catch (NumberFormatException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("float".equals(field.getXsdType()) || "double".equals(field.getXsdType())) {
            try {
                return Double.parseDouble(vNodeValue);
            }
            catch (NumberFormatException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("base64Binary".equals(field.getXsdType())) {
            return Base64.decodeBase64((byte[])vNodeValue.getBytes());
        }
        if ("decimal".equals(field.getXsdType())) {
            return new BigDecimal(vNodeValue);
        }
        return vNodeValue;
    }
}

