/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.BaseOperatorPlan;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.PlanDumper;

public class DotPlanDumper
extends PlanDumper {
    protected Set<Operator> mSubgraphs;
    protected Set<Operator> mMultiInputSubgraphs;
    protected Set<Operator> mMultiOutputSubgraphs;
    private boolean isSubGraph = false;

    public DotPlanDumper(BaseOperatorPlan plan, PrintStream ps) {
        this(plan, ps, false, new HashSet<Operator>(), new HashSet<Operator>(), new HashSet<Operator>());
    }

    protected DotPlanDumper(BaseOperatorPlan plan, PrintStream ps, boolean isSubGraph, Set<Operator> mSubgraphs, Set<Operator> mMultiInputSubgraphs, Set<Operator> mMultiOutputSubgraphs) {
        super(plan, ps);
        this.isSubGraph = isSubGraph;
        this.mSubgraphs = mSubgraphs;
        this.mMultiInputSubgraphs = mMultiInputSubgraphs;
        this.mMultiOutputSubgraphs = mMultiOutputSubgraphs;
    }

    @Override
    public void dump() {
        if (!this.isSubGraph) {
            this.ps.println("digraph plan {");
            this.ps.println("compound=true;");
            this.ps.println("node [shape=rect];");
        }
        super.dump();
        if (!this.isSubGraph) {
            this.ps.println("}");
        }
    }

    @Override
    protected void dumpMultiInputNestedOperator(Operator op, MultiMap<Operator, BaseOperatorPlan> plans) {
        this.dumpInvisibleOutput(op);
        this.ps.print("subgraph ");
        this.ps.print(this.getClusterID(op));
        this.ps.println(" {");
        this.join("; ", this.getAttributes(op));
        this.ps.println("labelloc=b;");
        this.mMultiInputSubgraphs.add(op);
        for (Operator o : plans.keySet()) {
            this.ps.print("subgraph ");
            this.ps.print(this.getClusterID(op, o));
            this.ps.println(" {");
            this.ps.println("label=\"\";");
            this.dumpInvisibleInput(op, o);
            for (BaseOperatorPlan plan : plans.get(o)) {
                PlanDumper dumper = this.makeDumper(plan, this.ps);
                dumper.dump();
                this.connectInvisibleInput(op, o, plan);
            }
            this.ps.println("};");
        }
        this.ps.println("};");
        for (Operator o : plans.keySet()) {
            for (BaseOperatorPlan plan : plans.get(o)) {
                this.connectInvisibleOutput(op, plan);
            }
        }
    }

    @Override
    protected void dumpMultiOutputNestedOperator(Operator op, Collection<BaseOperatorPlan> plans) {
        super.dumpMultiOutputNestedOperator(op, plans);
        this.mMultiOutputSubgraphs.add(op);
        this.dumpInvisibleOutput(op);
        for (BaseOperatorPlan plan : plans) {
            this.connectInvisibleOutput(op, plan);
        }
    }

    @Override
    protected void dumpNestedOperator(Operator op, Collection<BaseOperatorPlan> plans) {
        this.dumpInvisibleOperators(op);
        this.ps.print("subgraph ");
        this.ps.print(this.getClusterID(op));
        this.ps.println(" {");
        this.join("; ", this.getAttributes(op));
        this.ps.println("labelloc=b;");
        this.mSubgraphs.add(op);
        for (BaseOperatorPlan plan : plans) {
            PlanDumper dumper = this.makeDumper(plan, this.ps);
            dumper.dump();
            this.connectInvisibleInput(op, plan);
        }
        this.ps.println("};");
        for (BaseOperatorPlan plan : plans) {
            this.connectInvisibleOutput(op, plan);
        }
    }

    @Override
    protected void dumpOperator(Operator op) {
        this.ps.print(this.getID(op));
        this.ps.print(" [");
        this.join(", ", this.getAttributes(op));
        this.ps.println("];");
    }

    @Override
    protected void dumpEdge(Operator op, Operator suc) {
        String in = this.getID(op);
        String out = this.getID(suc);
        String attributes = "";
        if (this.mMultiInputSubgraphs.contains(op) || this.mSubgraphs.contains(op) || this.mMultiOutputSubgraphs.contains(op)) {
            in = this.getSubgraphID(op, false);
        }
        if (this.mMultiInputSubgraphs.contains(suc)) {
            out = this.getSubgraphID(suc, op, true);
            attributes = " [lhead=" + this.getClusterID(suc, op) + "]";
        }
        if (this.mSubgraphs.contains(suc)) {
            out = this.getSubgraphID(suc, true);
            attributes = " [lhead=" + this.getClusterID(suc) + "]";
        }
        if (this.reverse(this.plan)) {
            this.ps.print(out);
            this.ps.print(" -> ");
            this.ps.print(in);
        } else {
            this.ps.print(in);
            this.ps.print(" -> ");
            this.ps.print(out);
        }
        this.ps.println(attributes);
    }

    @Override
    protected PlanDumper makeDumper(BaseOperatorPlan plan, PrintStream ps) {
        return new DotPlanDumper(plan, ps, true, this.mSubgraphs, this.mMultiInputSubgraphs, this.mMultiOutputSubgraphs);
    }

    protected String getName(Operator op) {
        return op.getName();
    }

    protected String[] getAttributes(Operator op) {
        String[] attributes = new String[]{"label=\"" + this.getName(op) + "\""};
        return attributes;
    }

    private void connectInvisibleInput(Operator op1, Operator op2, BaseOperatorPlan plan) {
        String in = this.getSubgraphID(op1, op2, true);
        List<Operator> sources = this.reverse(plan) ? plan.getSinks() : plan.getSources();
        for (Operator l : sources) {
            this.dumpInvisibleEdge(in, this.getID(l));
        }
    }

    private void connectInvisibleInput(Operator op, BaseOperatorPlan plan) {
        String in = this.getSubgraphID(op, true);
        List<Operator> sources = this.reverse(plan) ? plan.getSinks() : plan.getSources();
        for (Operator l : sources) {
            String out = this.mSubgraphs.contains(l) || this.mMultiInputSubgraphs.contains(l) ? this.getSubgraphID(l, true) : this.getID(l);
            this.dumpInvisibleEdge(in, out);
        }
    }

    private void connectInvisibleOutput(Operator op, BaseOperatorPlan plan) {
        String out = this.getSubgraphID(op, false);
        List<Operator> sinks = this.reverse(plan) ? plan.getSources() : plan.getSinks();
        for (Operator l : sinks) {
            String in = this.mSubgraphs.contains(l) || this.mMultiInputSubgraphs.contains(l) || this.mMultiOutputSubgraphs.contains(l) ? this.getSubgraphID(l, false) : this.getID(l);
            this.dumpInvisibleEdge(in, out);
        }
    }

    private void connectInvisible(Operator op, BaseOperatorPlan plan) {
        this.connectInvisibleInput(op, plan);
        this.connectInvisibleOutput(op, plan);
    }

    private void dumpInvisibleInput(Operator op1, Operator op2) {
        this.ps.print(this.getSubgraphID(op1, op2, true));
        this.ps.print(" ");
        this.ps.print(this.getInvisibleAttributes(op1));
        this.ps.println(";");
    }

    private void dumpInvisibleInput(Operator op) {
        this.ps.print(this.getSubgraphID(op, true));
        this.ps.print(" ");
        this.ps.print(this.getInvisibleAttributes(op));
        this.ps.println(";");
    }

    private void dumpInvisibleOutput(Operator op) {
        this.ps.print(this.getSubgraphID(op, false));
        this.ps.print(" ");
        this.ps.print(this.getInvisibleAttributes(op));
        this.ps.println(";");
    }

    protected void dumpInvisibleOperators(Operator op) {
        this.dumpInvisibleInput(op);
        this.dumpInvisibleOutput(op);
    }

    private String getClusterID(Operator op1, Operator op2) {
        return this.getClusterID(op1) + "_" + this.getID(op2);
    }

    private String getClusterID(Operator op) {
        return "cluster_" + this.getID(op);
    }

    private String getSubgraphID(Operator op1, Operator op2, boolean in) {
        String id = "s" + this.getID(op1) + "_" + this.getID(op2);
        id = in ? id + "_in" : id + "_out";
        return id;
    }

    private String getSubgraphID(Operator op, boolean in) {
        String id = "s" + this.getID(op);
        id = in ? id + "_in" : id + "_out";
        return id;
    }

    private String getID(Operator op) {
        return "" + Math.abs(op.hashCode());
    }

    private String getInvisibleAttributes(Operator op) {
        return "[label=\"\", style=invis, height=0, width=0]";
    }

    private void dumpInvisibleEdge(String op, String suc) {
        this.ps.print(op);
        this.ps.print(" -> ");
        this.ps.print(suc);
        this.ps.println(" [style=invis];");
    }

    protected boolean reverse(BaseOperatorPlan plan) {
        return false;
    }
}

