/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.shell.workflow;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.hadoop.gateway.shell.AbstractRequest;
import org.apache.hadoop.gateway.shell.BasicResponse;
import org.apache.hadoop.gateway.shell.Hadoop;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;

class Submit {
    Submit() {
    }

    public static class Response
    extends BasicResponse {
        Response(HttpResponse response) {
            super(response);
        }

        public String getJobId() throws IOException {
            return (String)JsonPath.read((String)this.getString(), (String)"$.id", (Filter[])new Filter[0]);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private String text;
        private String file;
        private String action = "start";

        Request(Hadoop session) {
            super(session);
        }

        public Request text(String text) {
            this.text = text;
            return this;
        }

        public Request file(String file) {
            this.file = file;
            return this;
        }

        public Request action(String action) {
            this.action = action;
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    URIBuilder uri = Request.this.uri(new String[]{"/oozie/v1", "/jobs"});
                    Request.this.addQueryParam(uri, "action", Request.this.action);
                    HttpPost request = new HttpPost(uri.build());
                    StringEntity entity = null;
                    if (Request.this.text != null) {
                        entity = new StringEntity(Request.this.text, ContentType.create((String)"application/xml", (String)"UTF-8"));
                    } else if (Request.this.file != null) {
                        entity = new FileEntity(new File(Request.this.file), ContentType.create((String)"application/xml"));
                    }
                    request.setEntity(entity);
                    return new Response((HttpResponse)Request.this.execute((HttpRequest)request));
                }
            };
        }
    }
}

