/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.shell.yarn;

import java.io.File;
import java.util.concurrent.Callable;
import org.apache.hadoop.gateway.shell.AbstractRequest;
import org.apache.hadoop.gateway.shell.BasicResponse;
import org.apache.hadoop.gateway.shell.Hadoop;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;

public class SubmitApp {

    public static class Response
    extends BasicResponse {
        Response(HttpResponse response) {
            super(response);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private String text;
        private String file;

        Request(Hadoop session) {
            super(session);
        }

        public Request text(String text) {
            this.text = text;
            return this;
        }

        public Request file(String file) {
            this.file = file;
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    URIBuilder uri = Request.this.uri(new String[]{"/resourcemanager", "/v1/cluster/apps"});
                    HttpPost request = new HttpPost(uri.build());
                    StringEntity entity = null;
                    if (Request.this.text != null) {
                        entity = new StringEntity(Request.this.text, ContentType.APPLICATION_JSON);
                    } else if (Request.this.file != null) {
                        entity = new FileEntity(new File(Request.this.file), ContentType.APPLICATION_JSON);
                    }
                    request.setEntity(entity);
                    return new Response((HttpResponse)Request.this.execute((HttpRequest)request));
                }
            };
        }
    }
}

