/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.spark.launcher.CommandBuilderUtils;
import org.apache.spark.launcher.LauncherConnection;
import org.apache.spark.launcher.LauncherProtocol;
import org.apache.spark.launcher.LauncherServer;
import org.apache.spark.launcher.OutputRedirector;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;

class ChildProcAppHandle
implements SparkAppHandle {
    private static final Logger LOG = Logger.getLogger(ChildProcAppHandle.class.getName());
    private final String secret;
    private final LauncherServer server;
    private Process childProc;
    private boolean disposed;
    private LauncherConnection connection;
    private List<SparkAppHandle.Listener> listeners;
    private SparkAppHandle.State state;
    private String appId;
    private OutputRedirector redirector;

    ChildProcAppHandle(String secret, LauncherServer server) {
        this.secret = secret;
        this.server = server;
        this.state = SparkAppHandle.State.UNKNOWN;
    }

    @Override
    public synchronized void addListener(SparkAppHandle.Listener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<SparkAppHandle.Listener>();
        }
        this.listeners.add(l);
    }

    @Override
    public SparkAppHandle.State getState() {
        return this.state;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public void stop() {
        CommandBuilderUtils.checkState(this.connection != null, "Application is still not connected.", new Object[0]);
        try {
            this.connection.send(new LauncherProtocol.Stop());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public synchronized void disconnect() {
        if (!this.disposed) {
            this.disposed = true;
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.server.unregister(this);
            if (this.redirector != null) {
                this.redirector.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void kill() {
        if (!this.disposed) {
            this.disconnect();
        }
        if (this.childProc != null) {
            try {
                this.childProc.exitValue();
            }
            catch (IllegalThreadStateException e) {
                try {
                    Method destroy = this.childProc.getClass().getMethod("destroyForcibly", new Class[0]);
                    destroy.invoke((Object)this.childProc, new Object[0]);
                }
                catch (Exception inner) {
                    this.childProc.destroy();
                }
            }
            finally {
                this.childProc = null;
            }
        }
    }

    String getSecret() {
        return this.secret;
    }

    void setChildProc(Process childProc, String loggerName) {
        this.childProc = childProc;
        this.redirector = new OutputRedirector(childProc.getInputStream(), loggerName, SparkLauncher.REDIRECTOR_FACTORY);
    }

    void setConnection(LauncherConnection connection) {
        this.connection = connection;
    }

    LauncherServer getServer() {
        return this.server;
    }

    LauncherConnection getConnection() {
        return this.connection;
    }

    void setState(SparkAppHandle.State s) {
        if (!this.state.isFinal()) {
            this.state = s;
            this.fireEvent(false);
        } else {
            LOG.log(Level.WARNING, "Backend requested transition from final state {0} to {1}.", new Object[]{this.state, s});
        }
    }

    void setAppId(String appId) {
        this.appId = appId;
        this.fireEvent(true);
    }

    private synchronized void fireEvent(boolean isInfoChanged) {
        if (this.listeners != null) {
            for (SparkAppHandle.Listener l : this.listeners) {
                if (isInfoChanged) {
                    l.infoChanged(this);
                    continue;
                }
                l.stateChanged(this);
            }
        }
    }
}

