/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSOpsCountStatistics;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolTranslatorPB;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.util.concurrent.AsyncGet;
import org.apache.hadoop.util.concurrent.AsyncGetFuture;

@InterfaceStability.Unstable
public class AsyncDistributedFileSystem {
    private final DistributedFileSystem dfs;

    AsyncDistributedFileSystem(DistributedFileSystem dfs) {
        this.dfs = dfs;
    }

    static <T> Future<T> getReturnValue() {
        AsyncGet asyncGet = ClientNamenodeProtocolTranslatorPB.getAsyncReturnValue();
        return new AsyncGetFuture(asyncGet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        this.dfs.getFsStatistics().incrementWriteOps(1);
        this.dfs.getDFSOpsCountStatistics().incrementOpCounter(DFSOpsCountStatistics.OpType.RENAME);
        Path absSrc = this.dfs.fixRelativePart(src);
        Path absDst = this.dfs.fixRelativePart(dst);
        boolean isAsync = Client.isAsynchronousMode();
        Client.setAsynchronousMode((boolean)true);
        try {
            this.dfs.getClient().rename(this.dfs.getPathName(absSrc), this.dfs.getPathName(absDst), options);
            Future<Void> future = AsyncDistributedFileSystem.getReturnValue();
            return future;
        }
        finally {
            Client.setAsynchronousMode((boolean)isAsync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> setPermission(Path p, FsPermission permission) throws IOException {
        this.dfs.getFsStatistics().incrementWriteOps(1);
        this.dfs.getDFSOpsCountStatistics().incrementOpCounter(DFSOpsCountStatistics.OpType.SET_PERMISSION);
        Path absPath = this.dfs.fixRelativePart(p);
        boolean isAsync = Client.isAsynchronousMode();
        Client.setAsynchronousMode((boolean)true);
        try {
            this.dfs.getClient().setPermission(this.dfs.getPathName(absPath), permission);
            Future<Void> future = AsyncDistributedFileSystem.getReturnValue();
            return future;
        }
        finally {
            Client.setAsynchronousMode((boolean)isAsync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> setOwner(Path p, String username, String groupname) throws IOException {
        if (username == null && groupname == null) {
            throw new IOException("username == null && groupname == null");
        }
        this.dfs.getFsStatistics().incrementWriteOps(1);
        this.dfs.getDFSOpsCountStatistics().incrementOpCounter(DFSOpsCountStatistics.OpType.SET_OWNER);
        Path absPath = this.dfs.fixRelativePart(p);
        boolean isAsync = Client.isAsynchronousMode();
        Client.setAsynchronousMode((boolean)true);
        try {
            this.dfs.getClient().setOwner(this.dfs.getPathName(absPath), username, groupname);
            Future<Void> future = AsyncDistributedFileSystem.getReturnValue();
            return future;
        }
        finally {
            Client.setAsynchronousMode((boolean)isAsync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> setAcl(Path p, List<AclEntry> aclSpec) throws IOException {
        this.dfs.getFsStatistics().incrementWriteOps(1);
        this.dfs.getDFSOpsCountStatistics().incrementOpCounter(DFSOpsCountStatistics.OpType.SET_ACL);
        Path absPath = this.dfs.fixRelativePart(p);
        boolean isAsync = Client.isAsynchronousMode();
        Client.setAsynchronousMode((boolean)true);
        try {
            this.dfs.getClient().setAcl(this.dfs.getPathName(absPath), aclSpec);
            Future<Void> future = AsyncDistributedFileSystem.getReturnValue();
            return future;
        }
        finally {
            Client.setAsynchronousMode((boolean)isAsync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<AclStatus> getAclStatus(Path p) throws IOException {
        Path absPath = this.dfs.fixRelativePart(p);
        boolean isAsync = Client.isAsynchronousMode();
        Client.setAsynchronousMode((boolean)true);
        try {
            this.dfs.getClient().getAclStatus(this.dfs.getPathName(absPath));
            Future<AclStatus> future = AsyncDistributedFileSystem.getReturnValue();
            return future;
        }
        finally {
            Client.setAsynchronousMode((boolean)isAsync);
        }
    }
}

