/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.build;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.util.TableModelerSource;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.refinery.model.AnalysisModeler;
import org.pentaho.di.core.refinery.model.DswModeler;
import org.pentaho.di.core.refinery.model.ModelServerFetcher;
import org.pentaho.di.core.refinery.model.RefineryValueMetaStrategy;
import org.pentaho.di.core.refinery.publish.agilebi.BiServerConnection;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.client.DataServiceConnectionInformation;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.util.TransUtil;
import org.pentaho.di.ui.job.entries.build.JobEntryBuildModelDialog;
import org.pentaho.di.ui.job.entries.common.ConnectionValidator;
import org.pentaho.metadata.automodel.PhysicalTableImporter;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.platform.util.StringUtil;
import org.w3c.dom.Node;

@JobEntry(id="DataRefineryBuildModel", categoryDescription="JobCategory.Category.Modeling", i18nPackageName="org.pentaho.di.job.entries.build", documentationUrl="Data/Streamlined_Data_Refinery/0B0/020/0A0", image="model_entry.svg", name="BuildModelJob.Name", description="BuildModelJob.Description")
public class JobEntryBuildModel
extends JobEntryBase
implements JobEntryInterface,
Cloneable {
    public static final String PLUGIN_ID = "DataRefineryBuildModel";
    public static final String KEY_MODEL_ANNOTATIONS = "KEY_MODEL_ANNOTATIONS";
    public static final String KEY_OUTPUT_STEP_PREFIX = "JobEntryBuildModel.OutputStep.";
    private static Class<?> PKG = JobEntryBuildModel.class;
    private DswModeler modeler;
    private String outputStep;
    private String modelName;
    private boolean useExistingModel;
    private String existingModel;
    private boolean createOnPublish;
    private String selectedModel;
    private BiServerConnection biServerConnection;
    private DataServiceContext dataServiceContext;

    public boolean useExistingModel() {
        return this.useExistingModel;
    }

    public String getExistingModel() {
        return this.existingModel;
    }

    public void setUseExistingModel(boolean useExistingModel) {
        this.useExistingModel = useExistingModel;
    }

    public void setExistingModel(String existingModel) {
        this.existingModel = existingModel;
    }

    public void setDataServiceContext(DataServiceContext dataServiceContext) {
        this.dataServiceContext = dataServiceContext;
    }

    public JobEntryBuildModel() {
    }

    public JobEntryBuildModel(String name, String description) {
        super(name, description);
    }

    public void setParentJob(Job parentJob) {
        super.setParentJob(parentJob);
        if (this.log == null) {
            this.log = new LogChannel((Object)this);
        }
        this.modeler.setLog(this.log);
    }

    public DswModeler getModeler() {
        return this.modeler;
    }

    public void setModeler(DswModeler modeler) {
        this.modeler = modeler;
        this.modeler.setLog(this.log);
    }

    public String[] getOutputStepList(JobMeta jobMeta) {
        ArrayList<String> stepNames = new ArrayList<String>();
        try {
            for (JobEntryCopy copy : jobMeta.getJobCopies()) {
                if (!(copy.getEntry() instanceof JobEntryTrans) || !jobMeta.isPathExist(copy.getEntry(), (JobEntryInterface)this)) continue;
                JobEntryTrans trans = (JobEntryTrans)copy.getEntry();
                TransMeta transMeta = trans.getTransMeta(jobMeta.getRepository(), jobMeta.getMetaStore(), (VariableSpace)jobMeta);
                stepNames.addAll(TransUtil.collectOutputStepInTrans(transMeta, this.getRepository(), this.getMetaStore()).keySet());
                stepNames.addAll(this.dataServiceContext.getMetaStoreUtil().getDataServiceNames(transMeta));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stepNames.toArray(new String[stepNames.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String buildXmi(JobMeta jobMeta, String outputStep, String modelName) throws KettleException {
        if (StringUtils.isEmpty((String)outputStep)) {
            throw new KettleException(this.getMsg("BuildModelJob.Missing.OutputStep", new String[0]));
        }
        if (StringUtils.isEmpty((String)modelName)) {
            throw new KettleException(this.getMsg("BuildModelJob.Missing.ModelName", new String[0]));
        }
        DatabaseMeta dbMeta = this.getConnectionInfo().getDatabaseMeta();
        String schemaName = StringUtils.defaultIfBlank((String)this.environmentSubstitute(this.getConnectionInfo().getSchemaName()), (String)"");
        String tableName = this.environmentSubstitute(this.getConnectionInfo().getTableName());
        TableModelerSource source = new TableModelerSource(dbMeta, tableName, schemaName);
        source.setSchemaName(StringUtils.defaultIfBlank((String)source.getSchemaName(), (String)""));
        try {
            Domain modeledDomain;
            block15: {
                PhysicalTableImporter.ImportStrategy importStrategy = this.getImportStrategy();
                ModelAnnotationGroup modelAnnotations = this.getModelAnnotations();
                if (this.useExistingModel()) {
                    ModelServerFetcher fetcher;
                    String existingModelId = this.environmentSubstitute(this.getSelectedModel());
                    if (!this.modelExists(existingModelId, fetcher = this.getModelServerFetcher())) {
                        if (this.isCreateOnPublish()) {
                            this.logBasic(this.getMsg("BuildModelJob.Info.ModelNotFound", existingModelId));
                            modeledDomain = this.getDswModeler().createModel(modelName, source, dbMeta, importStrategy, modelAnnotations, this.getMetaStore());
                            break block15;
                        } else {
                            if (Const.isEmpty((String)existingModelId)) {
                                throw new KettleException(this.getMsg("BuildModelJob.Error.ModelNullNotFound", this.getName()));
                            }
                            throw new KettleException(this.getMsg("BuildModelJob.Error.ModelNotFound", existingModelId));
                        }
                    }
                    Domain templateModel = fetcher.downloadDswFile(existingModelId);
                    modeledDomain = this.getDswModeler().updateModel(modelName, templateModel, dbMeta, schemaName, tableName);
                } else {
                    modeledDomain = this.getDswModeler().createModel(modelName, source, dbMeta, importStrategy, modelAnnotations, this.getMetaStore());
                }
            }
            XmiParser parser = new XmiParser();
            return parser.generateXmi(modeledDomain);
        }
        catch (ModelServerFetcher.AuthorizationException e) {
            throw new KettleException(this.getMsg("BuildModelJob.Error.Authorization", new String[0]));
        }
        catch (ModelServerFetcher.ServerException e) {
            throw new KettleException(this.getMsg("BuildModelJob.Error.ErrorFetchingModel", new String[0]));
        }
        catch (DswModeler.ColumnMismatchException e) {
            throw new KettleException(this.getMsg("BuildModelJob.Error.CannotUpdateModel", this.getMsg("BuildModelJob.Error.UnmatchedColumn", e.getColumnName(), e.getDataType())));
        }
        catch (DswModeler.UnsupportedModelException e) {
            throw new KettleException(this.getMsg("BuildModelJob.Error.CannotUpdateModel", this.getMsg("BuildModelJob.Error.UnsupportedModel", new String[0])));
        }
        catch (ModelerException e) {
            if (!this.isOutputStepADataService()) throw new KettleException((Throwable)e);
            throw new KettleException(this.getMsg("BuildModelJob.Error.DataServiceProblem", new String[0]));
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    private ModelAnnotationGroup getModelAnnotations() {
        Object modelAnnotationGroup = this.getParentJob().getExtensionDataMap().get(KEY_MODEL_ANNOTATIONS);
        if (modelAnnotationGroup != null && modelAnnotationGroup instanceof ModelAnnotationGroup) {
            return (ModelAnnotationGroup)modelAnnotationGroup;
        }
        return new ModelAnnotationGroup();
    }

    PhysicalTableImporter.ImportStrategy getImportStrategy() throws KettleException, ModelerException {
        StepMetaDataCombi stepMetaDataCombi = this.getStepMetaDataCombi();
        if (stepMetaDataCombi != null) {
            return new RefineryValueMetaStrategy(stepMetaDataCombi);
        }
        return PhysicalTableImporter.defaultImportStrategy;
    }

    StepMetaDataCombi getStepMetaDataCombi() {
        return (StepMetaDataCombi)this.getParentJob().getExtensionDataMap().get(KEY_OUTPUT_STEP_PREFIX + this.getName());
    }

    private List<TransMeta> findAllTransInJob() throws KettleException {
        List<JobEntryCopy> jobCopies = this.getParentJobCopies();
        ArrayList<TransMeta> transMetas = new ArrayList<TransMeta>();
        for (JobEntryCopy jobCopy : jobCopies) {
            if (!jobCopy.isTransformation()) continue;
            JobEntryTrans entry = (JobEntryTrans)jobCopy.getEntry();
            try {
                transMetas.add(entry.getTransMeta(this.getRepository(), this.getMetaStore(), this.getVariables()));
            }
            catch (Exception e) {
                this.log.logDebug(this.getMsg("BuildModelJob.Debug.BadTrans", jobCopy.getName()), new Object[]{e});
            }
        }
        return transMetas;
    }

    List<JobEntryCopy> getParentJobCopies() {
        return this.getParentJob().getJobMeta().getJobCopies();
    }

    boolean isOutputStepADataService() throws KettleException {
        List<TransMeta> transMetas = this.findAllTransInJob();
        try {
            for (TransMeta transMeta : transMetas) {
                if (!this.dataServiceContext.getMetaStoreUtil().getDataServiceNames(transMeta).contains(this.getOutputStep())) continue;
                return true;
            }
        }
        catch (MetaStoreException e) {
            return false;
        }
        return false;
    }

    public ProvidesDatabaseConnectionInformation getConnectionInfo() throws KettleException {
        StepMetaDataCombi stepMetaDataCombi = this.getStepMetaDataCombi();
        String sourceName = this.environmentSubstitute(this.getOutputStep());
        if (stepMetaDataCombi == null) {
            if (this.isOutputStepADataService()) {
                return new DataServiceConnectionInformation(this.getOutputStep(), this.getRepository(), this.log);
            }
            throw new KettleException(this.getMsg(StringUtil.isEmpty((String)sourceName) ? "BuildModelJob.Error.SourceUndefined" : "BuildModelJob.Error.UnableToFindStep", sourceName));
        }
        if (ProvidesDatabaseConnectionInformation.class.isAssignableFrom(stepMetaDataCombi.meta.getClass())) {
            return (ProvidesDatabaseConnectionInformation)ProvidesDatabaseConnectionInformation.class.cast(stepMetaDataCombi.meta);
        }
        throw new KettleException(this.getMsg("BuildModelJob.Error.NoConnectionInfo", sourceName));
    }

    protected BiServerConnection validBIServerConnection() throws KettleException {
        BiServerConnection connection = this.environmentSubstitute(this.getBiServerConnection());
        ConnectionValidator validator = this.getConnectionValidator(connection);
        validator.validateConnectionInRuntime();
        return connection;
    }

    protected ConnectionValidator getConnectionValidator(BiServerConnection connection) {
        ConnectionValidator validator = new ConnectionValidator();
        validator.setConnection(connection);
        return validator;
    }

    protected boolean modelExists(String modelId, ModelServerFetcher fetcher) throws KettleException, ModelServerFetcher.AuthorizationException, ModelServerFetcher.ServerException {
        HashSet<String> allIds = new HashSet<String>();
        allIds.addAll(fetcher.fetchAnalysisList());
        allIds.addAll(fetcher.fetchDswList());
        return allIds.contains(modelId);
    }

    public BiServerConnection environmentSubstitute(BiServerConnection conn) {
        if (conn == null) {
            return null;
        }
        BiServerConnection substituted = new BiServerConnection();
        String url = this.environmentSubstitute(conn.getUrl());
        if (StringUtils.endsWith((String)url, (String)"//")) {
            url = StringUtils.chop((String)url);
        }
        substituted.setUrl(url);
        substituted.setUserId(this.environmentSubstitute(conn.getUserId()));
        substituted.setPassword(this.environmentSubstitute(conn.getPassword()));
        return substituted;
    }

    public Result execute(Result result, int nr) throws KettleException {
        String outputStep = this.environmentSubstitute(this.getOutputStep());
        String modelName = this.environmentSubstitute(this.getModelName());
        try {
            this.setVarAndLogBasic("JobEntryBuildModel.DatabaseConnection." + modelName, this.getConnectionInfo().getDatabaseMeta().getName());
            if (this.isPublishAnalysis()) {
                this.setVarAndLogDebug("JobEntryBuildModel.Mondrian.Schema." + modelName, this.buildAnalysis(modelName));
                this.setVarAndLogBasic("JobEntryBuildModel.Mondrian.Datasource." + modelName, this.getConnectionInfo().getDatabaseMeta().getName());
            } else {
                this.setVarAndLogDebug("JobEntryBuildModel.XMI." + modelName, this.buildXmi(this.getParentJob().getJobMeta(), outputStep, modelName));
                this.setVarAndLogBasic("JobEntryBuildModel.XMI.DSW." + modelName, "true");
            }
            result.setResult(true);
        }
        catch (Exception e) {
            this.log.logError(e.getMessage(), (Throwable)e);
            result.setResult(false);
            result.setNrErrors(1L);
        }
        return result;
    }

    String buildAnalysis(String modelName) throws KettleException {
        String analysisFile;
        String selectedModelName = this.environmentSubstitute(this.getSelectedModel());
        try {
            if (!this.modelExists(selectedModelName, this.getModelServerFetcher())) {
                if (Const.isEmpty((String)selectedModelName)) {
                    throw new KettleException(this.getMsg("BuildModelJob.Error.ModelNullNotFound", this.getName()));
                }
                throw new KettleException(this.getMsg("BuildModelJob.Error.ModelNotFound", selectedModelName));
            }
            analysisFile = this.getModelServerFetcher().downloadAnalysisFile(selectedModelName);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        AnalysisModeler analysisModeler = this.getAnalysisModeler();
        return analysisModeler.replaceTableAndSchemaNames(analysisFile, modelName);
    }

    AnalysisModeler getAnalysisModeler() throws KettleException {
        return new AnalysisModeler(this, this.getConnectionInfo());
    }

    ModelServerFetcher getModelServerFetcher() throws KettleException {
        return new ModelServerFetcher(this.validBIServerConnection());
    }

    protected void setVarAndLogDebug(String varName, String value) {
        this.parentJob.setVariable(varName, value);
        this.log.logDebug(this.getMsg("BuildModelJob.SetVariable", varName, this.parentJob.getVariable(varName)));
    }

    protected void setVarAndLogBasic(String varName, String value) {
        this.parentJob.setVariable(varName, value);
        this.log.logBasic(this.getMsg("BuildModelJob.SetVariable", varName, this.parentJob.getVariable(varName)));
    }

    protected boolean isPublishAnalysis() {
        return this.useExistingModel() && !StringUtils.isBlank((String)this.getSelectedModel()) && !this.environmentSubstitute(this.getSelectedModel()).endsWith(".xmi");
    }

    public String getDialogClassName() {
        return JobEntryBuildModelDialog.class.getCanonicalName();
    }

    public String getOutputStep() {
        return this.outputStep;
    }

    public void setOutputStep(String outputStep) {
        this.outputStep = outputStep;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(100);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"outputStep", (String)this.getOutputStep()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"modelName", (String)this.getModelName()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"useExistingModel", (boolean)this.useExistingModel()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"existingModel", (String)this.getExistingModel()));
        if (this.biServerConnection != null) {
            String password = Encr.encryptPasswordIfNotUsingVariables((String)this.biServerConnection.getPassword());
            retval.append("      ").append(XMLHandler.addTagValue((String)"ba_server_password", (String)Const.nullToEmpty((String)password)));
            retval.append("      ").append(XMLHandler.addTagValue((String)"ba_server_url", (String)Const.nullToEmpty((String)this.biServerConnection.getUrl())));
            retval.append("      ").append(XMLHandler.addTagValue((String)"ba_server_user_id", (String)Const.nullToEmpty((String)this.biServerConnection.getUserId())));
        }
        retval.append("      ").append(XMLHandler.addTagValue((String)"selected_model", (String)this.getSelectedModel()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_on_publish", (boolean)this.isCreateOnPublish()));
        return retval.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        super.loadXML(entrynode, databases, slaveServers);
        this.setOutputStep(XMLHandler.getTagValue((Node)entrynode, (String)"outputStep"));
        this.setModelName(XMLHandler.getTagValue((Node)entrynode, (String)"modelName"));
        this.setUseExistingModel("Y".equals(XMLHandler.getTagValue((Node)entrynode, (String)"useExistingModel")));
        this.setExistingModel(XMLHandler.getTagValue((Node)entrynode, (String)"existingModel"));
        BiServerConnection biServer = new BiServerConnection();
        biServer.setUrl(Const.nullToEmpty((String)XMLHandler.getTagValue((Node)entrynode, (String)"ba_server_url")));
        biServer.setUserId(Const.nullToEmpty((String)XMLHandler.getTagValue((Node)entrynode, (String)"ba_server_user_id")));
        String password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"ba_server_password"));
        biServer.setPassword(Const.nullToEmpty((String)password));
        this.setBiServerConnection(biServer);
        this.setSelectedModel(XMLHandler.getTagValue((Node)entrynode, (String)"selected_model"));
        this.setCreateOnPublish(BooleanUtils.toBoolean((String)XMLHandler.getTagValue((Node)entrynode, (String)"create_on_publish")));
    }

    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        super.loadRep(rep, metaStore, id_jobentry, databases, slaveServers);
        this.setOutputStep(rep.getJobEntryAttributeString(id_jobentry, "outputStep"));
        this.setModelName(rep.getJobEntryAttributeString(id_jobentry, "modelName"));
        this.setUseExistingModel(rep.getJobEntryAttributeBoolean(id_jobentry, "useExistingModel"));
        this.setExistingModel(rep.getJobEntryAttributeString(id_jobentry, "existingModel"));
        BiServerConnection biServerModel = new BiServerConnection();
        String password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "ba_server_password"));
        biServerModel.setPassword(Const.nullToEmpty((String)password));
        biServerModel.setUrl(Const.nullToEmpty((String)rep.getJobEntryAttributeString(id_jobentry, "ba_server_url")));
        biServerModel.setUserId(Const.nullToEmpty((String)rep.getJobEntryAttributeString(id_jobentry, "ba_server_user_id")));
        this.setBiServerConnection(biServerModel);
        this.setSelectedModel(rep.getJobEntryAttributeString(id_jobentry, "selected_model"));
        this.setCreateOnPublish(BooleanUtils.toBoolean((String)rep.getJobEntryAttributeString(id_jobentry, "create_on_publish")));
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "outputStep", this.getOutputStep());
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "modelName", this.getModelName());
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "useExistingModel", this.useExistingModel());
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "existingModel", this.getExistingModel());
        if (this.biServerConnection != null) {
            String password = Encr.encryptPasswordIfNotUsingVariables((String)this.biServerConnection.getPassword());
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ba_server_password", Const.nullToEmpty((String)password));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ba_server_url", Const.nullToEmpty((String)this.biServerConnection.getUrl()));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ba_server_user_id", Const.nullToEmpty((String)this.biServerConnection.getUserId()));
        }
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "selected_model", this.getSelectedModel());
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "create_on_publish", this.isCreateOnPublish());
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public BiServerConnection getBiServerConnection() {
        return this.biServerConnection;
    }

    public void setBiServerConnection(BiServerConnection biServerConnection) {
        this.biServerConnection = biServerConnection;
    }

    public String getSelectedModel() {
        return this.selectedModel;
    }

    public void setSelectedModel(String selectedModel) {
        this.selectedModel = selectedModel;
    }

    public boolean isCreateOnPublish() {
        return this.createOnPublish;
    }

    public void setCreateOnPublish(boolean createOnPublish) {
        this.createOnPublish = createOnPublish;
    }

    private String getMsg(String key, String ... parameters) {
        return BaseMessages.getString(PKG, (String)key, (String[])parameters);
    }

    public boolean evaluates() {
        return true;
    }

    protected DswModeler getDswModeler() {
        return this.modeler;
    }

    public final class Fields {
        public static final String NAME = "name";
        public static final String OUTPUT_STEP = "outputStep";
        public static final String MODEL_NAME = "modelName";
        public static final String USE_EXISTING_MODEL = "useExistingModel";
        public static final String EXISTING_MODEL = "existingModel";
        public static final String BASERVER_URL = "ba_server_url";
        public static final String BASERVER_USERID = "ba_server_user_id";
        public static final String BASERVER_PASSWORD = "ba_server_password";
        public static final String SELECTED_MODEL = "selected_model";
        public static final String CREATE_ON_PUBLISH = "create_on_publish";
    }
}

