/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.BaseModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelProperty;
import org.pentaho.agilebi.modeler.models.annotations.util.MondrianSchemaHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.w3c.dom.Document;

public class ShowHideAttribute
extends AnnotationType {
    protected static final Class<?> MSG_CLASS = BaseModelerWorkspaceHelper.class;
    public static final String NAME_ID = "name";
    public static final String NAME_NAME = "Level Name";
    public static final int NAME_ORDER = 0;
    public static final String CUBE_ID = "cube";
    public static final String CUBE_NAME = "Cube Name";
    public static final int CUBE_ORDER = 1;
    public static final String DIMENSION_ID = "dimension";
    public static final String DIMENSION_NAME = "Dimension Name";
    public static final int DIMENSION_ORDER = 2;
    public static final String HIERARCHY_ID = "hierarchy";
    public static final String HIERARCHY_NAME = "Hierarchy Name";
    public static final int HIERARCHY_ORDER = 3;
    public static final String VISIBLE_ID = "visible";
    public static final String VISIBLE_NAME = "Visible";
    public static final int VISIBLE_ORDER = 4;
    @MetaStoreAttribute
    @ModelProperty(id="name", name="Level Name", order=0)
    protected String name;
    @MetaStoreAttribute
    @ModelProperty(id="cube", name="Cube Name", order=1, hideUI=true)
    protected String cube;
    @MetaStoreAttribute
    @ModelProperty(id="dimension", name="Dimension Name", order=2)
    protected String dimension;
    @MetaStoreAttribute
    @ModelProperty(id="hierarchy", name="Hierarchy Name", order=3)
    protected String hierarchy;
    @MetaStoreAttribute
    @ModelProperty(id="visible", name="Visible", order=4)
    protected boolean visible = false;

    @Override
    public boolean apply(ModelerWorkspace workspace, IMetaStore metaStore) throws ModelerException {
        return false;
    }

    @Override
    public boolean apply(Document schema) throws ModelerException {
        MondrianSchemaHandler schemaHandler = new MondrianSchemaHandler(schema);
        return schemaHandler.showHideAttribute(this.getCube(), this.getDimension(), this.getHierarchy(), this.getName(), this.isVisible());
    }

    @Override
    public void validate() throws ModelerException {
        if (StringUtils.isBlank((String)this.getCube())) {
            throw new ModelerException(BaseMessages.getString(MSG_CLASS, (String)"ModelAnnotation.ShowHide.validation.CUBE_NAME_REQUIRED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getDimension())) {
            throw new ModelerException(BaseMessages.getString(MSG_CLASS, (String)"ModelAnnotation.ShowHide.validation.DIMENSION_NAME_REQUIRED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getHierarchy())) {
            throw new ModelerException(BaseMessages.getString(MSG_CLASS, (String)"ModelAnnotation.ShowHide.validation.HIERARCHY_NAME_REQUIRED", (String[])new String[0]));
        }
        if (StringUtils.isBlank((String)this.getName())) {
            throw new ModelerException(BaseMessages.getString(MSG_CLASS, (String)"ModelAnnotation.ShowHide.validation.LEVEL_NAME_REQUIRED", (String[])new String[0]));
        }
    }

    @Override
    public ModelAnnotation.Type getType() {
        return ModelAnnotation.Type.SHOW_HIDE_ATTRIBUTE;
    }

    @Override
    public String getSummary() {
        return BaseMessages.getString(MSG_CLASS, (String)(this.isVisible() ? "Modeler.ShowAttribute.Summary" : "Modeler.HideAttribute.Summary"), (String[])new String[]{this.getName(), this.getHierarchy(), this.getDimension(), this.getCube()});
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getField() {
        return null;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public void setHierarchy(String hierarchy) {
        this.hierarchy = hierarchy;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHierarchy() {
        return this.hierarchy;
    }

    public String getDimension() {
        return this.dimension;
    }

    public String getCube() {
        return this.cube;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

