/*
 * Decompiled with CFR 0.152.
 */
package parquet.glob;

import java.util.regex.Pattern;
import parquet.Preconditions;

public class WildcardPath {
    private static final String STAR_REGEX = "(.*)";
    private static final String MORE_NESTED_FIELDS_TEMPLATE = "((%s).*)?";
    private final String parentGlobPath;
    private final String originalPattern;
    private final Pattern pattern;

    public WildcardPath(String parentGlobPath, String wildcardPath, char delim) {
        this.parentGlobPath = Preconditions.checkNotNull(parentGlobPath, "parentGlobPath");
        this.originalPattern = Preconditions.checkNotNull(wildcardPath, "wildcardPath");
        this.pattern = Pattern.compile(WildcardPath.buildRegex(wildcardPath, delim));
    }

    public static String buildRegex(String wildcardPath, char delim) {
        if (wildcardPath.isEmpty()) {
            return wildcardPath;
        }
        String delimStr = Pattern.quote(Character.toString(delim));
        String[] splits = wildcardPath.split("\\*", -1);
        StringBuilder regex = new StringBuilder();
        for (int i = 0; i < splits.length; ++i) {
            if ((i == 0 || i == splits.length - 1) && splits[i].isEmpty()) {
                regex.append(STAR_REGEX);
                continue;
            }
            if (splits[i].isEmpty()) continue;
            regex.append(Pattern.quote(splits[i]));
            if (i >= splits.length - 1) continue;
            regex.append(STAR_REGEX);
        }
        regex.append(String.format(MORE_NESTED_FIELDS_TEMPLATE, delimStr));
        return regex.toString();
    }

    public boolean matches(String path) {
        return this.pattern.matcher(path).matches();
    }

    public String getParentGlobPath() {
        return this.parentGlobPath;
    }

    public String getOriginalPattern() {
        return this.originalPattern;
    }

    public String toString() {
        return String.format("WildcardPath(parentGlobPath: '%s', pattern: '%s')", this.parentGlobPath, this.originalPattern);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildcardPath wildcardPath = (WildcardPath)o;
        return this.originalPattern.equals(wildcardPath.originalPattern);
    }

    public int hashCode() {
        return this.originalPattern.hashCode();
    }
}

