/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.pan;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import org.pentaho.di.base.AbstractBaseCommandExecutor;
import org.pentaho.di.base.CommandExecutorCodes;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.util.FileUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PanCommandExecutor
extends AbstractBaseCommandExecutor {
    public PanCommandExecutor(Class<?> pkgClazz) {
        this(pkgClazz, (LogChannelInterface)new LogChannel((Object)"Pan"));
    }

    public PanCommandExecutor(Class<?> pkgClazz, LogChannelInterface log) {
        this.setPkgClazz(pkgClazz);
        this.setLog(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int execute(String repoName, String noRepo, String username, String trustUser, String password, String dirName, String filename, String jarFile, String transName, String listTrans, String listDirs, String exportRepo, String initialDir, String listRepos, String safemode, String metrics, String listParams, NamedParams params, String[] arguments) throws Throwable {
        this.getLog().logMinimal(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.StartingToRun", (String[])new String[0]));
        Date start = Calendar.getInstance().getTime();
        this.logDebug("Pan.Log.AllocatteNewTrans");
        Trans trans = null;
        Repository repository = null;
        try {
            if (this.getMetaStore() == null) {
                this.setMetaStore(this.createDefaultMetastore());
            }
            this.logDebug("Pan.Log.StartingToLookOptions");
            if (!(Utils.isEmpty((CharSequence)repoName) && Utils.isEmpty((CharSequence)filename) && Utils.isEmpty((CharSequence)jarFile))) {
                this.logDebug("Pan.Log.ParsingCommandline");
                if (!Utils.isEmpty((CharSequence)repoName) && !this.isEnabled(noRepo)) {
                    if (this.isEnabled(trustUser)) {
                        System.setProperty("pentaho.repository.client.attemptTrust", "Y");
                    }
                    RepositoryMeta repositoryMeta = this.loadRepositoryConnection(repoName, "Pan.Log.LoadingAvailableRep", "Pan.Error.NoRepsDefined", "Pan.Log.FindingRep");
                    repository = this.establishRepositoryConnection(repositoryMeta, username, password, RepositoryOperation.EXECUTE_TRANSFORMATION);
                    trans = this.executeRepositoryBasedCommand(repository, repositoryMeta, dirName, transName, listTrans, listDirs, exportRepo);
                }
                if (trans == null) {
                    trans = this.executeFilesystemBasedCommand(initialDir, filename, jarFile);
                }
            }
            if (this.isEnabled(listRepos)) {
                this.printRepositories(this.loadRepositoryInfo("Pan.Log.LoadingAvailableRep", "Pan.Error.NoRepsDefined"));
            }
        }
        catch (Exception e) {
            trans = null;
            System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.ProcessStopError", (String[])new String[]{e.getMessage()}));
            e.printStackTrace();
            if (repository != null) {
                repository.disconnect();
            }
            return CommandExecutorCodes.Pan.ERRORS_DURING_PROCESSING.getCode();
        }
        if (trans == null) {
            if (!this.isEnabled(listTrans) && !this.isEnabled(listDirs) && !this.isEnabled(listRepos) && Utils.isEmpty((CharSequence)exportRepo)) {
                System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.CanNotLoadTrans", (String[])new String[0]));
                return CommandExecutorCodes.Pan.COULD_NOT_LOAD_TRANS.getCode();
            }
            return CommandExecutorCodes.Pan.SUCCESS.getCode();
        }
        try {
            trans.setLogLevel(this.getLog().getLogLevel());
            PanCommandExecutor.configureParameters(trans, params, trans.getTransMeta());
            trans.setSafeModeEnabled(this.isEnabled(safemode));
            trans.setGatheringMetrics(this.isEnabled(metrics));
            if (this.isEnabled(listParams)) {
                this.printTransformationParameters(trans);
                int e = CommandExecutorCodes.Pan.COULD_NOT_LOAD_TRANS.getCode();
                return e;
            }
            try {
                trans.execute(arguments);
            }
            catch (KettleException ke) {
                this.logDebug(ke.getLocalizedMessage());
                System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.UnablePrepareInitTrans", (String[])new String[0]));
                int n = CommandExecutorCodes.Pan.UNABLE_TO_PREP_INIT_TRANS.getCode();
                if (repository != null) {
                    repository.disconnect();
                }
                if (this.isEnabled(trustUser)) {
                    System.clearProperty("pentaho.repository.client.attemptTrust");
                }
                return n;
            }
            this.waitUntilFinished(trans, 100L);
            if (trans.isRunning()) {
                this.getLog().logError(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.NotStopping", (String[])new String[0]));
            }
            this.getLog().logMinimal(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.Finished", (String[])new String[0]));
            Date stop = Calendar.getInstance().getTime();
            int completionTimeSeconds = this.calculateAndPrintElapsedTime(start, stop, "Pan.Log.StartStop", "Pan.Log.ProcessingEndAfter", "Pan.Log.ProcessingEndAfterLong", "Pan.Log.ProcessingEndAfterLonger", "Pan.Log.ProcessingEndAfterLongest");
            if (trans.getResult().getNrErrors() == 0L) {
                trans.printStats(completionTimeSeconds);
                int n = CommandExecutorCodes.Pan.SUCCESS.getCode();
                return n;
            }
            String transJVMExitCode = trans.getVariable("KETTLE_TRANS_PAN_JVM_EXIT_CODE");
            if (!Utils.isEmpty((CharSequence)transJVMExitCode)) {
                try {
                    int n = Integer.parseInt(transJVMExitCode);
                    return n;
                }
                catch (NumberFormatException nfe) {
                    int n;
                    block34: {
                        this.getLog().logError(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.TransJVMExitCodeInvalid", (String[])new String[]{"KETTLE_TRANS_PAN_JVM_EXIT_CODE", transJVMExitCode}));
                        this.getLog().logError(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.JVMExitCode", (String[])new String[]{"1"}));
                        n = CommandExecutorCodes.Pan.ERRORS_DURING_PROCESSING.getCode();
                        if (repository == null) break block34;
                        repository.disconnect();
                    }
                    if (this.isEnabled(trustUser)) {
                        System.clearProperty("pentaho.repository.client.attemptTrust");
                    }
                    return n;
                }
            }
            int n = CommandExecutorCodes.Pan.ERRORS_DURING_PROCESSING.getCode();
            return n;
            {
                catch (KettleException ke) {
                    System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.ErrorOccurred", (String[])new String[]{"" + ke.getMessage()}));
                    this.getLog().logError(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.UnexpectedErrorOccurred", (String[])new String[]{"" + ke.getMessage()}));
                    int n2 = CommandExecutorCodes.Pan.UNEXPECTED_ERROR.getCode();
                    return n2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (repository != null) {
                repository.disconnect();
            }
            if (this.isEnabled(trustUser)) {
                System.clearProperty("pentaho.repository.client.attemptTrust");
            }
        }
    }

    public int printVersion() {
        this.printVersion("Pan.Log.KettleVersion");
        return CommandExecutorCodes.Pan.KETTLE_VERSION_PRINT.getCode();
    }

    public Trans executeRepositoryBasedCommand(Repository repository, RepositoryMeta repositoryMeta, String dirName, String transName, String listTrans, String listDirs, String exportRepo) throws Exception {
        try {
            if (repository != null && repositoryMeta != null) {
                this.logDebug("Pan.Log.Allocate&ConnectRep");
                RepositoryDirectoryInterface directory = repository.loadRepositoryDirectoryTree();
                if (repository.getMetaStore() != null && this.getMetaStore() != null) {
                    this.getMetaStore().addMetaStore(repository.getMetaStore());
                }
                if (!Utils.isEmpty((CharSequence)dirName)) {
                    directory = directory.findDirectory(dirName);
                }
                if (directory != null) {
                    this.logDebug("Pan.Log.CheckSuppliedUserPass");
                    if (!Utils.isEmpty((CharSequence)transName)) {
                        this.logDebug("Pan.Log.LoadTransInfo");
                        TransMeta transMeta = repository.loadTransformation(transName, directory, null, true, null);
                        this.logDebug("Pan.Log.AllocateTrans");
                        Trans trans = new Trans(transMeta);
                        trans.setRepository(repository);
                        trans.setMetaStore((IMetaStore)this.getMetaStore());
                        return trans;
                    }
                    if (this.isEnabled(listTrans)) {
                        this.printRepositoryStoredTransformations(repository, directory);
                    } else if (this.isEnabled(listDirs)) {
                        this.printRepositoryDirectories(repository, directory);
                    } else if (!Utils.isEmpty((CharSequence)exportRepo)) {
                        System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.ExportingObjectsRepToFile", (String[])new String[]{"" + exportRepo}));
                        repository.getExporter().exportAllObjects(null, exportRepo, directory, "all");
                        System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.FinishedExportObjectsRepToFile", (String[])new String[]{"" + exportRepo}));
                    } else {
                        System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.NoTransNameSupplied", (String[])new String[0]));
                    }
                } else {
                    System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.CanNotFindSpecifiedDirectory", (String[])new String[]{"" + dirName}));
                }
            } else {
                System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.NoRepProvided", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            this.getLog().logError(e.getMessage());
        }
        return null;
    }

    public Trans executeFilesystemBasedCommand(String initialDir, String filename, String jarFilename) throws Exception {
        Trans trans = null;
        if (!Utils.isEmpty((CharSequence)filename)) {
            String filepath = filename;
            if (!KettleVFS.startsWithScheme((String)filename) && !FileUtil.isFullyQualified(filename)) {
                filepath = initialDir + filename;
            }
            this.logDebug("Pan.Log.LoadingTransXML", "" + filepath);
            TransMeta transMeta = new TransMeta(filepath);
            trans = new Trans(transMeta);
        }
        if (!Utils.isEmpty((CharSequence)jarFilename)) {
            try {
                int c;
                this.logDebug("Pan.Log.LoadingTransJar", jarFilename);
                InputStream inputStream = PanCommandExecutor.class.getResourceAsStream(jarFilename);
                StringBuilder xml = new StringBuilder();
                while ((c = inputStream.read()) != -1) {
                    xml.append((char)c);
                }
                inputStream.close();
                Document document = XMLHandler.loadXMLString((String)xml.toString());
                TransMeta transMeta = new TransMeta(XMLHandler.getSubNode((Node)document, (String)"transformation"), null);
                trans = new Trans(transMeta);
            }
            catch (Exception e) {
                System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Error.ReadingJar", (String[])new String[]{e.toString()}));
                System.out.println(Const.getStackTracker((Throwable)e));
                throw e;
            }
        }
        return trans;
    }

    protected static void configureParameters(Trans trans, NamedParams optionParams, TransMeta transMeta) throws UnknownParamException {
        String[] transParams;
        trans.initializeVariablesFrom(null);
        trans.getTransMeta().setInternalKettleVariables(trans);
        for (String param : transParams = trans.listParameters()) {
            String value = optionParams.getParameterValue(param);
            if (value == null) continue;
            trans.setParameterValue(param, value);
            transMeta.setParameterValue(param, value);
        }
        trans.activateParameters();
    }

    protected void printTransformationParameters(Trans trans) throws UnknownParamException {
        if (trans != null && trans.listParameters() != null) {
            for (String pName : trans.listParameters()) {
                this.printParameter(pName, trans.getParameterValue(pName), trans.getParameterDefault(pName), trans.getParameterDescription(pName));
            }
        }
    }

    protected void printRepositoryStoredTransformations(Repository repository, RepositoryDirectoryInterface directory) throws KettleException {
        this.logDebug("Pan.Log.GettingListTransDirectory", "" + directory);
        String[] transformations = repository.getTransformationNames(directory.getObjectId(), false);
        if (transformations != null) {
            for (String trans : transformations) {
                System.out.println(trans);
            }
        }
    }

    protected void printRepositories(RepositoriesMeta repositoriesMeta) {
        if (repositoriesMeta != null) {
            this.logDebug("Pan.Log.GettingListReps");
            for (int i = 0; i < repositoriesMeta.nrRepositories(); ++i) {
                RepositoryMeta repInfo = repositoriesMeta.getRepository(i);
                System.out.println(BaseMessages.getString(this.getPkgClazz(), (String)"Pan.Log.RepNameDesc", (String[])new String[]{"" + (i + 1), repInfo.getName(), repInfo.getDescription()}));
            }
        }
    }

    private void waitUntilFinished(Trans trans, long waitMillis) {
        if (trans != null && trans.isRunning()) {
            trans.waitUntilFinished();
            for (int i = 0; i < 100 && trans.isRunning(); ++i) {
                try {
                    Thread.sleep(waitMillis);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
        }
    }
}

