/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.filerep;

import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleSecurityException;
import org.pentaho.di.repository.RepositoryCapabilities;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.repository.RepositorySecurityProvider;
import org.pentaho.di.repository.UserInfo;

public class KettleFileRepositorySecurityProvider
implements RepositorySecurityProvider {
    private RepositoryMeta repositoryMeta;
    private RepositoryCapabilities capabilities;

    public KettleFileRepositorySecurityProvider(RepositoryMeta repositoryMeta) {
        this.repositoryMeta = repositoryMeta;
        this.capabilities = repositoryMeta.getRepositoryCapabilities();
    }

    @Override
    public UserInfo getUserInfo() {
        return null;
    }

    public RepositoryMeta getRepositoryMeta() {
        return this.repositoryMeta;
    }

    @Override
    public void validateAction(RepositoryOperation ... operations) throws KettleException, KettleSecurityException {
        block17: for (RepositoryOperation operation : operations) {
            switch (operation) {
                case READ_TRANSFORMATION: {
                    continue block17;
                }
                case MODIFY_TRANSFORMATION: {
                    if (!this.capabilities.isReadOnly()) continue block17;
                    throw new KettleException((Object)((Object)operation) + " : repository is read-only");
                }
                case DELETE_TRANSFORMATION: {
                    if (!this.capabilities.isReadOnly()) continue block17;
                    throw new KettleException((Object)((Object)operation) + " : repository is read-only");
                }
                case EXECUTE_TRANSFORMATION: {
                    continue block17;
                }
                case LOCK_TRANSFORMATION: {
                    continue block17;
                }
                case READ_JOB: {
                    continue block17;
                }
                case MODIFY_JOB: {
                    if (!this.capabilities.isReadOnly()) continue block17;
                    throw new KettleException((Object)((Object)operation) + " : repository is read-only");
                }
                case DELETE_JOB: {
                    if (!this.capabilities.isReadOnly()) continue block17;
                    throw new KettleException((Object)((Object)operation) + " : repository is read-only");
                }
                case EXECUTE_JOB: {
                    continue block17;
                }
                case LOCK_JOB: {
                    continue block17;
                }
                case MODIFY_DATABASE: {
                    if (!this.capabilities.isReadOnly()) continue block17;
                    throw new KettleException((Object)((Object)operation) + " : repository is read-only");
                }
                case DELETE_DATABASE: {
                    if (!this.capabilities.isReadOnly()) continue block17;
                    throw new KettleException((Object)((Object)operation) + " : repository is read-only");
                }
                case EXPLORE_DATABASE: {
                    continue block17;
                }
                case MODIFY_SLAVE_SERVER: 
                case MODIFY_CLUSTER_SCHEMA: 
                case MODIFY_PARTITION_SCHEMA: {
                    if (!this.capabilities.isReadOnly()) continue block17;
                    throw new KettleException((Object)((Object)operation) + " : repository is read-only");
                }
                case DELETE_SLAVE_SERVER: 
                case DELETE_CLUSTER_SCHEMA: 
                case DELETE_PARTITION_SCHEMA: {
                    if (!this.capabilities.isReadOnly()) continue block17;
                    throw new KettleException((Object)((Object)operation) + " : repository is read-only");
                }
                default: {
                    throw new KettleException("Operation [" + (Object)((Object)operation) + "] is unknown to the security handler.");
                }
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.capabilities.isReadOnly();
    }

    @Override
    public boolean isLockingPossible() {
        return this.capabilities.supportsLocking();
    }

    @Override
    public boolean allowsVersionComments(String fullPath) {
        return false;
    }

    @Override
    public boolean isVersionCommentMandatory() {
        return false;
    }

    @Override
    public List<String> getAllRoles() throws KettleException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getAllUsers() throws KettleException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getUserLogins() throws KettleException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isVersioningEnabled(String fullPath) {
        return false;
    }
}

