/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.Counters;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;

public class KettleDatabaseRepositoryConnectionDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    private static Class<?> PKG = Repository.class;
    public static final LoggingObjectInterface loggingObject = new SimpleLoggingObject("Database repository", LoggingObjectType.REPOSITORY, null);
    public static final int REQUIRED_MAJOR_VERSION = 5;
    public static final int REQUIRED_MINOR_VERSION = 0;
    protected static final int[] KEY_POSITIONS = new int[]{0, 1, 2};
    protected Database database;
    protected DatabaseMeta databaseMeta;
    protected int majorVersion;
    protected int minorVersion;
    protected PreparedStatement psStepAttributesLookup;
    protected PreparedStatement psStepAttributesInsert;
    protected PreparedStatement psTransAttributesLookup;
    protected PreparedStatement psTransAttributesInsert;
    protected PreparedStatement psJobAttributesLookup;
    protected PreparedStatement psJobAttributesInsert;
    protected List<Object[]> stepAttributesBuffer;
    protected RowMetaInterface stepAttributesRowMeta;
    protected PreparedStatement pstmt_entry_attributes;
    protected boolean useBatchProcessing;
    protected ConcurrentHashMap<String, PreparedStatement> sqlMap;

    public KettleDatabaseRepositoryConnectionDelegate(KettleDatabaseRepository repository, DatabaseMeta databaseMeta) {
        super(repository);
        this.databaseMeta = databaseMeta;
        this.database = new Database(loggingObject, databaseMeta);
        this.sqlMap = new ConcurrentHashMap();
        this.useBatchProcessing = true;
        this.psStepAttributesLookup = null;
        this.psStepAttributesInsert = null;
        this.psTransAttributesLookup = null;
        this.pstmt_entry_attributes = null;
        this.majorVersion = 5;
        this.minorVersion = 0;
    }

    public synchronized void connect() throws KettleException {
        this.connect(false, false);
    }

    public synchronized void connect(boolean no_lookup) throws KettleException {
        this.connect(no_lookup, false);
    }

    public synchronized void connect(boolean no_lookup, boolean ignoreVersion) throws KettleException {
        if (this.repository.isConnected()) {
            throw new KettleException("Repository is already connected!");
        }
        try {
            this.database.initializeVariablesFrom(null);
            this.database.connect();
            if (!ignoreVersion) {
                this.verifyVersion();
            }
            this.setAutoCommit(false);
            this.repository.setConnected(true);
        }
        catch (KettleException e) {
            throw new KettleException("Error connecting to the repository!", (Throwable)e);
        }
    }

    public static final String getRequiredVersion() {
        return "5.0";
    }

    protected void verifyVersion() throws KettleException {
        RowMetaAndData lastUpgrade = null;
        String versionTable = this.databaseMeta.getQuotedSchemaTableCombination(null, "R_VERSION");
        try {
            lastUpgrade = this.callRead(() -> this.database.getOneRow("SELECT " + this.quote("MAJOR_VERSION") + ", " + this.quote("MINOR_VERSION") + ", " + this.quote("UPGRADE_DATE") + " FROM " + versionTable + " ORDER BY " + this.quote("UPGRADE_DATE") + " DESC"));
        }
        catch (Exception e) {
            try {
                String userTable = this.databaseMeta.getQuotedSchemaTableCombination(null, "R_USER");
                this.callRead(() -> this.database.getOneRow("SELECT * FROM " + userTable));
                if (this.log.isBasic()) {
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"Repository.Error.GettingInfoVersionTable", (String[])new String[]{versionTable}));
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"Repository.Error.NewTable", (String[])new String[0]));
                    this.log.logBasic("Stack trace: " + Const.getStackTracker((Throwable)e));
                }
                this.majorVersion = 2;
                this.minorVersion = 2;
                lastUpgrade = null;
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Repository.NoRepositoryExists.Messages", (String[])new String[0]));
            }
        }
        if (lastUpgrade != null) {
            this.majorVersion = (int)lastUpgrade.getInteger("MAJOR_VERSION", -1L);
            this.minorVersion = (int)lastUpgrade.getInteger("MINOR_VERSION", -1L);
        }
        if (this.majorVersion < 5 || this.majorVersion == 5 && this.minorVersion < 0) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Repository.UpgradeRequired.Message", (String[])new String[]{this.getVersion(), KettleDatabaseRepositoryConnectionDelegate.getRequiredVersion()}));
        }
        if (this.majorVersion == 3 && this.minorVersion == 0) {
            String tableName = this.databaseMeta.getQuotedSchemaTableCombination(null, "R_TRANS_PARTITION_SCHEMA");
            String errorColumn = "TRANSFORMATION";
            RowMetaInterface tableFields = this.callRead(() -> this.database.getTableFields(tableName));
            if (tableFields.indexOfValue(errorColumn) >= 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Repository.FixFor300Required.Message", (String[])new String[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect() {
        try {
            this.repository.connectionDelegate.closeStepAttributeLookupPreparedStatement();
            this.repository.connectionDelegate.closeTransAttributeLookupPreparedStatement();
            this.repository.connectionDelegate.closeLookupJobEntryAttribute();
            for (String sql : this.sqlMap.keySet()) {
                PreparedStatement ps = this.sqlMap.get(sql);
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    this.log.logError("Error closing prepared statement: " + sql, (Throwable)e);
                }
            }
            if (!this.database.isAutoCommit()) {
                this.commit();
            }
            this.repository.setConnected(false);
        }
        catch (KettleException dbe) {
            this.log.logError("Error disconnecting from database : " + dbe.getMessage());
        }
        finally {
            this.database.disconnect();
            this.sqlMap.clear();
        }
    }

    public synchronized void setAutoCommit(boolean autocommit) {
        if (!autocommit) {
            this.database.setCommit(99999999);
        } else {
            this.database.setCommit(0);
        }
    }

    public synchronized void commit() throws KettleException {
        try {
            this.closeJobAttributeInsertPreparedStatement();
            this.closeStepAttributeInsertPreparedStatement();
            this.closeTransAttributeInsertPreparedStatement();
            if (!this.database.isAutoCommit()) {
                this.database.commit();
            }
            Counters.getInstance().clear();
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to commit repository connection", (Throwable)dbe);
        }
    }

    public synchronized void rollback() {
        try {
            this.database.rollback();
            Counters.getInstance().clear();
        }
        catch (KettleException dbe) {
            this.log.logError("Error rolling back repository.");
        }
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public String getVersion() {
        return this.majorVersion + "." + this.minorVersion;
    }

    public synchronized void fillStepAttributesBuffer(ObjectId id_transformation) throws KettleException {
        String sql = "SELECT " + this.quote("ID_STEP") + ", " + this.quote("CODE") + ", " + this.quote("NR") + ", " + this.quote("VALUE_NUM") + ", " + this.quote("VALUE_STR") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_STEP_ATTRIBUTE") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ORDER BY " + this.quote("ID_STEP") + ", " + this.quote("CODE") + ", " + this.quote("NR");
        PreparedStatement ps = this.getPreparedStatement(sql);
        RowMetaAndData parameter = this.getParameterMetaData(id_transformation);
        this.stepAttributesBuffer = this.callRead(() -> this.database.getRows(this.database.openQuery(ps, parameter.getRowMeta(), parameter.getData()), -1, null));
        this.stepAttributesRowMeta = this.database.getReturnRowMeta();
        Collections.sort(this.stepAttributesBuffer, new StepAttributeComparator());
    }

    public List<Object[]> getStepAttributesBuffer() {
        return this.stepAttributesBuffer;
    }

    public void setStepAttributesBuffer(List<Object[]> stepAttributesBuffer) {
        this.stepAttributesBuffer = stepAttributesBuffer;
    }

    private synchronized RowMetaAndData searchStepAttributeInBuffer(ObjectId id_step, String code, long nr) throws KettleValueException {
        int index = this.searchStepAttributeIndexInBuffer(id_step, code, nr);
        if (index < 0) {
            return null;
        }
        Object[] r = this.stepAttributesBuffer.get(index);
        return new RowMetaAndData(this.stepAttributesRowMeta, r);
    }

    private synchronized int searchStepAttributeIndexInBuffer(ObjectId id_step, String code, long nr) throws KettleValueException {
        Object[] key = new Object[]{new LongObjectId(id_step).longValue(), code, new Long(nr)};
        int index = Collections.binarySearch(this.stepAttributesBuffer, key, new StepAttributeComparator());
        if (index >= this.stepAttributesBuffer.size() || index < 0) {
            return -1;
        }
        Object[] look = this.stepAttributesBuffer.get(index);
        if (this.stepAttributesRowMeta.compare(look, key, KEY_POSITIONS) == 0) {
            return index;
        }
        return -1;
    }

    private synchronized int searchNrStepAttributes(ObjectId id_step, String code) throws KettleValueException {
        int idx = this.searchStepAttributeIndexInBuffer(id_step, code, 0L);
        if (idx < 0) {
            return 0;
        }
        int nr = 1;
        int offset = 1;
        if (idx + offset >= this.stepAttributesBuffer.size()) {
            return 1;
        }
        Object[] look = this.stepAttributesBuffer.get(idx + offset);
        RowMetaInterface rowMeta = this.stepAttributesRowMeta;
        long lookID = rowMeta.getInteger(look, 0);
        String lookCode = rowMeta.getString(look, 1);
        while (lookID == new LongObjectId(id_step).longValue() && code.equalsIgnoreCase(lookCode)) {
            nr = rowMeta.getInteger(look, 2).intValue() + 1;
            if (idx + ++offset < this.stepAttributesBuffer.size()) {
                look = this.stepAttributesBuffer.get(idx + offset);
                lookID = rowMeta.getInteger(look, 0);
                lookCode = rowMeta.getString(look, 1);
                continue;
            }
            return nr;
        }
        return nr;
    }

    public synchronized void setLookupStepAttribute() throws KettleException {
        String sql = "SELECT " + this.quote("VALUE_STR") + ", " + this.quote("VALUE_NUM") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_STEP_ATTRIBUTE") + " WHERE " + this.quote("ID_STEP") + " = ?  AND " + this.quote("CODE") + " = ?  AND " + this.quote("NR") + " = ? ";
        this.psStepAttributesLookup = this.database.prepareSQL(sql);
    }

    public synchronized void setLookupTransAttribute() throws KettleException {
        String sql = "SELECT " + this.quote("VALUE_STR") + ", " + this.quote("VALUE_NUM") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_TRANS_ATTRIBUTE") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ?  AND " + this.quote("CODE") + " = ? AND " + "NR" + " = ? ";
        this.psTransAttributesLookup = this.database.prepareSQL(sql);
    }

    public synchronized void closeTransAttributeLookupPreparedStatement() throws KettleException {
        this.database.closePreparedStatement(this.psTransAttributesLookup);
        this.psTransAttributesLookup = null;
    }

    public synchronized void setLookupJobAttribute() throws KettleException {
        String sql = "SELECT " + this.quote("VALUE_STR") + ", " + this.quote("VALUE_NUM") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_JOB_ATTRIBUTE") + " WHERE " + this.quote("ID_JOB") + " = ?  AND " + this.quote("CODE") + " = ? AND " + "NR" + " = ? ";
        this.psJobAttributesLookup = this.database.prepareSQL(sql);
    }

    public synchronized void closeJobAttributeLookupPreparedStatement() throws KettleException {
        this.database.closePreparedStatement(this.psJobAttributesLookup);
        this.psJobAttributesLookup = null;
    }

    public synchronized void closeStepAttributeLookupPreparedStatement() throws KettleException {
        this.database.closePreparedStatement(this.psStepAttributesLookup);
        this.psStepAttributesLookup = null;
    }

    public synchronized void closeStepAttributeInsertPreparedStatement() throws KettleException {
        if (this.psStepAttributesInsert != null) {
            this.database.emptyAndCommit(this.psStepAttributesInsert, this.useBatchProcessing, 1);
            this.psStepAttributesInsert = null;
        }
    }

    public synchronized void closeTransAttributeInsertPreparedStatement() throws KettleException {
        if (this.psTransAttributesInsert != null) {
            this.database.emptyAndCommit(this.psTransAttributesInsert, this.useBatchProcessing, 1);
            this.psTransAttributesInsert = null;
        }
    }

    public synchronized void closeJobAttributeInsertPreparedStatement() throws KettleException {
        if (this.psJobAttributesInsert != null) {
            this.database.emptyAndCommit(this.psJobAttributesInsert, this.useBatchProcessing, 1);
            this.psJobAttributesInsert = null;
        }
    }

    private RowMetaAndData getStepAttributeRow(ObjectId id_step, int nr, String code) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        par.addValue((ValueMetaInterface)new ValueMetaInteger("ID_STEP"), (Object)id_step);
        par.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code);
        par.addValue((ValueMetaInterface)new ValueMetaInteger("NR"), (Object)new Long(nr));
        if (this.psStepAttributesLookup == null) {
            this.setLookupStepAttribute();
        }
        this.database.setValues(par.getRowMeta(), par.getData(), this.psStepAttributesLookup);
        return this.callRead(new Callable<RowMetaAndData>(){

            @Override
            public RowMetaAndData call() throws Exception {
                Object[] lookup = KettleDatabaseRepositoryConnectionDelegate.this.database.getLookup(KettleDatabaseRepositoryConnectionDelegate.this.psStepAttributesLookup);
                return new RowMetaAndData(KettleDatabaseRepositoryConnectionDelegate.this.database.getReturnRowMeta(), lookup);
            }
        });
    }

    public RowMetaAndData getTransAttributeRow(ObjectId id_transformation, int nr, String code) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        par.addValue((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION"), (Object)id_transformation);
        par.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code);
        par.addValue((ValueMetaInterface)new ValueMetaInteger("NR"), (Object)new Long(nr));
        if (this.psTransAttributesLookup == null) {
            this.setLookupTransAttribute();
        }
        this.database.setValues(par, this.psTransAttributesLookup);
        return this.callRead(new Callable<RowMetaAndData>(){

            @Override
            public RowMetaAndData call() throws Exception {
                Object[] r = KettleDatabaseRepositoryConnectionDelegate.this.database.getLookup(KettleDatabaseRepositoryConnectionDelegate.this.psTransAttributesLookup);
                if (r == null) {
                    return null;
                }
                return new RowMetaAndData(KettleDatabaseRepositoryConnectionDelegate.this.database.getReturnRowMeta(), r);
            }
        });
    }

    public RowMetaAndData getJobAttributeRow(ObjectId id_job, int nr, String code) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        par.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOB"), (Object)id_job);
        par.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code);
        par.addValue((ValueMetaInterface)new ValueMetaInteger("NR"), (Object)new Long(nr));
        if (this.psJobAttributesLookup == null) {
            this.setLookupJobAttribute();
        }
        this.database.setValues(par, this.psJobAttributesLookup);
        return this.callRead(new Callable<RowMetaAndData>(){

            @Override
            public RowMetaAndData call() throws Exception {
                Object[] r = KettleDatabaseRepositoryConnectionDelegate.this.database.getLookup(KettleDatabaseRepositoryConnectionDelegate.this.psJobAttributesLookup);
                if (r == null) {
                    return null;
                }
                return new RowMetaAndData(KettleDatabaseRepositoryConnectionDelegate.this.database.getReturnRowMeta(), r);
            }
        });
    }

    public synchronized long getStepAttributeInteger(ObjectId id_step, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.stepAttributesBuffer != null ? this.searchStepAttributeInBuffer(id_step, code, nr) : this.getStepAttributeRow(id_step, nr, code);
        if (r == null) {
            return -1L;
        }
        long id = r.getInteger("VALUE_NUM", -1L);
        return id;
    }

    public synchronized ObjectId findStepAttributeID(ObjectId id_step, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.stepAttributesBuffer != null ? this.searchStepAttributeInBuffer(id_step, code, nr) : this.getStepAttributeRow(id_step, nr, code);
        if (r == null) {
            return null;
        }
        long id = r.getInteger("ID_STEP", -1L);
        if (id < 0L) {
            return null;
        }
        return new LongObjectId(id);
    }

    public synchronized String getStepAttributeString(ObjectId id_step, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.stepAttributesBuffer != null ? this.searchStepAttributeInBuffer(id_step, code, nr) : this.getStepAttributeRow(id_step, nr, code);
        if (r == null) {
            return null;
        }
        return r.getString("VALUE_STR", null);
    }

    public synchronized boolean getStepAttributeBoolean(ObjectId id_step, int nr, String code, boolean def) throws KettleException {
        RowMetaAndData r = null;
        r = this.stepAttributesBuffer != null ? this.searchStepAttributeInBuffer(id_step, code, nr) : this.getStepAttributeRow(id_step, nr, code);
        if (r == null) {
            return def;
        }
        String v = r.getString("VALUE_STR", null);
        if (v == null || Utils.isEmpty((CharSequence)v)) {
            return def;
        }
        return ValueMetaString.convertStringToBoolean((String)v);
    }

    public ObjectId saveStepAttribute(ObjectId id_transformation, ObjectId id_step, long nr, String code, String value) throws KettleException {
        return this.saveStepAttribute(code, nr, id_transformation, id_step, 0.0, value);
    }

    public ObjectId saveStepAttribute(ObjectId id_transformation, ObjectId id_step, long nr, String code, double value) throws KettleException {
        return this.saveStepAttribute(code, nr, id_transformation, id_step, value, null);
    }

    public ObjectId saveStepAttribute(ObjectId id_transformation, ObjectId id_step, long nr, String code, boolean value) throws KettleException {
        return this.saveStepAttribute(code, nr, id_transformation, id_step, 0.0, value ? "Y" : "N");
    }

    private ObjectId saveStepAttribute(String code, long nr, ObjectId id_transformation, ObjectId id_step, double value_num, String value_str) throws KettleException {
        return this.insertStepAttribute(id_transformation, id_step, nr, code, value_num, value_str);
    }

    public synchronized int countNrStepAttributes(ObjectId id_step, String code) throws KettleException {
        if (this.stepAttributesBuffer != null) {
            int nr = this.searchNrStepAttributes(id_step, code);
            return nr;
        }
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_STEP_ATTRIBUTE") + " WHERE " + this.quote("ID_STEP") + " = ? AND " + this.quote("CODE") + " = ?";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_STEP"), (Object)id_step);
        table.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code);
        RowMetaAndData r = this.callRead(() -> this.database.getOneRow(sql, table.getRowMeta(), table.getData()));
        if (r == null || r.getData() == null) {
            return 0;
        }
        return (int)r.getInteger(0, 0L);
    }

    public synchronized String getTransAttributeString(ObjectId id_transformation, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getTransAttributeRow(id_transformation, nr, code);
        if (r == null) {
            return null;
        }
        return r.getString("VALUE_STR", null);
    }

    public synchronized boolean getTransAttributeBoolean(ObjectId id_transformation, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getTransAttributeRow(id_transformation, nr, code);
        if (r == null) {
            return false;
        }
        return r.getBoolean("VALUE_STR", false);
    }

    public synchronized double getTransAttributeNumber(ObjectId id_transformation, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getTransAttributeRow(id_transformation, nr, code);
        if (r == null) {
            return 0.0;
        }
        return r.getNumber("VALUE_NUM", 0.0);
    }

    public synchronized long getTransAttributeInteger(ObjectId id_transformation, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getTransAttributeRow(id_transformation, nr, code);
        if (r == null) {
            return 0L;
        }
        return r.getInteger("VALUE_NUM", 0L);
    }

    public synchronized int countNrTransAttributes(ObjectId id_transformation, String code) throws KettleException {
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_TRANS_ATTRIBUTE") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? AND " + this.quote("CODE") + " = ?";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION"), (Object)id_transformation);
        table.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code);
        RowMetaAndData r = this.callRead(() -> this.database.getOneRow(sql, table.getRowMeta(), table.getData()));
        if (r == null || r.getData() == null) {
            return 0;
        }
        return (int)r.getInteger(0, 0L);
    }

    public synchronized List<Object[]> getTransAttributes(ObjectId id_transformation, String code, long nr) throws KettleException {
        String sql = "SELECT * FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_TRANS_ATTRIBUTE") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? AND " + this.quote("CODE") + " = ? AND " + this.quote("NR") + " = ? ORDER BY " + this.quote("VALUE_NUM");
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION"), (Object)new LongObjectId(id_transformation));
        table.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("NR"), (Object)new Long(nr));
        return this.callRead(() -> this.database.getRows(sql, table.getRowMeta(), table.getData(), 1000, false, 0, null));
    }

    public synchronized List<Object[]> getTransAttributesWithPrefix(ObjectId id_transformation, String codePrefix) throws KettleException {
        String sql = "SELECT * FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_TRANS_ATTRIBUTE") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? AND " + this.quote("CODE") + " LIKE '" + codePrefix + "%'";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION"), (Object)new LongObjectId(id_transformation));
        return this.callRead(() -> this.database.getRows(sql, table.getRowMeta(), table.getData(), 1000, false, 0, null));
    }

    public synchronized String getJobAttributeString(ObjectId id_job, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getJobAttributeRow(id_job, nr, code);
        if (r == null) {
            return null;
        }
        return r.getString("VALUE_STR", null);
    }

    public synchronized boolean getJobAttributeBoolean(ObjectId id_job, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getJobAttributeRow(id_job, nr, code);
        if (r == null) {
            return false;
        }
        return r.getBoolean("VALUE_STR", false);
    }

    public synchronized double getJobAttributeNumber(ObjectId id_job, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getJobAttributeRow(id_job, nr, code);
        if (r == null) {
            return 0.0;
        }
        return r.getNumber("VALUE_NUM", 0.0);
    }

    public synchronized long getJobAttributeInteger(ObjectId id_job, int nr, String code) throws KettleException {
        RowMetaAndData r = null;
        r = this.getJobAttributeRow(id_job, nr, code);
        if (r == null) {
            return 0L;
        }
        return r.getInteger("VALUE_NUM", 0L);
    }

    public synchronized int countNrJobAttributes(ObjectId id_job, String code) throws KettleException {
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_JOB_ATTRIBUTE") + " WHERE " + this.quote("ID_JOB") + " = ? AND " + this.quote("CODE") + " = ?";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOB"), (Object)id_job);
        table.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code);
        RowMetaAndData r = this.callRead(() -> this.database.getOneRow(sql, table.getRowMeta(), table.getData()));
        if (r == null || r.getData() == null) {
            return 0;
        }
        return (int)r.getInteger(0, 0L);
    }

    public synchronized List<Object[]> getJobAttributes(ObjectId id_job, String code, long nr) throws KettleException {
        String sql = "SELECT * FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_JOB_ATTRIBUTE") + " WHERE " + this.quote("ID_JOB") + " = ? AND " + this.quote("CODE") + " = ? AND " + this.quote("NR") + " = ? ORDER BY " + this.quote("VALUE_NUM");
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOB"), (Object)id_job);
        table.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("NR"), (Object)new Long(nr));
        return this.callRead(() -> this.database.getRows(sql, table.getRowMeta(), table.getData(), 1000, false, 0, null));
    }

    public synchronized List<Object[]> getJobAttributesWithPrefix(ObjectId jobId, String codePrefix) throws KettleException {
        String sql = "SELECT * FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_JOB_ATTRIBUTE") + " WHERE " + this.quote("ID_JOB") + " = ? AND " + this.quote("CODE") + " LIKE '" + codePrefix + "%'";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOB"), (Object)new LongObjectId(jobId));
        return this.callRead(() -> this.database.getRows(sql, table.getRowMeta(), table.getData(), 1000, false, 0, null));
    }

    public ObjectId saveJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, long nr, String code, String value) throws KettleException {
        return this.saveJobEntryAttribute(code, nr, id_job, id_jobentry, 0.0, value);
    }

    public ObjectId saveJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, long nr, String code, double value) throws KettleException {
        return this.saveJobEntryAttribute(code, nr, id_job, id_jobentry, value, null);
    }

    public ObjectId saveJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, long nr, String code, boolean value) throws KettleException {
        return this.saveJobEntryAttribute(code, nr, id_job, id_jobentry, 0.0, value ? "Y" : "N");
    }

    private ObjectId saveJobEntryAttribute(String code, long nr, ObjectId id_job, ObjectId id_jobentry, double value_num, String value_str) throws KettleException {
        return this.insertJobEntryAttribute(id_job, id_jobentry, nr, code, value_num, value_str);
    }

    public synchronized ObjectId insertJobEntryAttribute(ObjectId id_job, ObjectId id_jobentry, long nr, String code, double value_num, String value_str) throws KettleException {
        LongObjectId id = this.getNextJobEntryAttributeID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY_ATTRIBUTE"), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOB"), (Object)id_job);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY"), (Object)id_jobentry);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("NR"), (Object)new Long(nr));
        table.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code);
        table.addValue((ValueMetaInterface)new ValueMetaNumber("VALUE_NUM"), (Object)new Double(value_num));
        table.addValue((ValueMetaInterface)new ValueMetaString("VALUE_STR"), (Object)value_str);
        this.database.prepareInsert(table.getRowMeta(), "R_JOBENTRY_ATTRIBUTE");
        this.database.setValuesInsert(table);
        this.database.insertRow();
        this.database.closeInsert();
        return id;
    }

    public synchronized LongObjectId getNextJobEntryAttributeID() throws KettleException {
        return this.getNextID(this.databaseMeta.getQuotedSchemaTableCombination(null, "R_JOBENTRY_ATTRIBUTE"), this.quote("ID_JOBENTRY_ATTRIBUTE"));
    }

    public synchronized LongObjectId getNextID(String tableName, String fieldName) throws KettleException {
        String counterName = tableName + "." + fieldName;
        Counter counter = Counters.getInstance().getCounter(counterName);
        if (counter == null) {
            LongObjectId id = this.getNextTableID(tableName, fieldName);
            counter = new Counter(id.longValue().longValue());
            Counters.getInstance().setCounter(counterName, counter);
            return new LongObjectId(counter.next());
        }
        return new LongObjectId(counter.next());
    }

    private synchronized LongObjectId getNextTableID(String tablename, String idfield) throws KettleException {
        LongObjectId retval = null;
        RowMetaAndData r = this.callRead(() -> this.database.getOneRow("SELECT MAX(" + idfield + ") FROM " + tablename));
        if (r != null) {
            Long id = r.getInteger(0);
            if (id == null) {
                if (this.log.isDebug()) {
                    this.log.logDebug("no max(" + idfield + ") found in table " + tablename);
                }
                retval = new LongObjectId(1L);
            } else {
                if (this.log.isDebug()) {
                    this.log.logDebug("max(" + idfield + ") found in table " + tablename + " --> " + idfield + " number: " + id);
                }
                retval = new LongObjectId(id + 1L);
            }
        }
        return retval;
    }

    public synchronized void setLookupJobEntryAttribute() throws KettleException {
        String sql = "SELECT " + this.quote("VALUE_STR") + ", " + this.quote("VALUE_NUM") + " FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_JOBENTRY_ATTRIBUTE") + " WHERE " + this.quote("ID_JOBENTRY") + " = ? AND " + this.quote("CODE") + " = ?  AND " + this.quote("NR") + " = ? ";
        this.pstmt_entry_attributes = this.database.prepareSQL(sql);
    }

    public synchronized void closeLookupJobEntryAttribute() throws KettleException {
        this.database.closePreparedStatement(this.pstmt_entry_attributes);
        this.pstmt_entry_attributes = null;
    }

    private RowMetaAndData getJobEntryAttributeRow(ObjectId id_jobentry, int nr, String code) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        par.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY"), (Object)id_jobentry);
        par.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code);
        par.addValue((ValueMetaInterface)new ValueMetaInteger("NR"), (Object)new Long(nr));
        if (this.pstmt_entry_attributes == null) {
            this.setLookupJobEntryAttribute();
        }
        this.database.setValues(par.getRowMeta(), par.getData(), this.pstmt_entry_attributes);
        return this.callRead(new Callable<RowMetaAndData>(){

            @Override
            public RowMetaAndData call() throws Exception {
                Object[] lookup = KettleDatabaseRepositoryConnectionDelegate.this.database.getLookup(KettleDatabaseRepositoryConnectionDelegate.this.pstmt_entry_attributes);
                return new RowMetaAndData(KettleDatabaseRepositoryConnectionDelegate.this.database.getReturnRowMeta(), lookup);
            }
        });
    }

    public synchronized long getJobEntryAttributeInteger(ObjectId id_jobentry, int nr, String code) throws KettleException {
        RowMetaAndData r = this.getJobEntryAttributeRow(id_jobentry, nr, code);
        if (r == null) {
            return 0L;
        }
        return r.getInteger("VALUE_NUM", 0L);
    }

    public synchronized double getJobEntryAttributeNumber(ObjectId id_jobentry, int nr, String code) throws KettleException {
        RowMetaAndData r = this.getJobEntryAttributeRow(id_jobentry, nr, code);
        if (r == null) {
            return 0.0;
        }
        return r.getNumber("VALUE_NUM", 0.0);
    }

    public synchronized String getJobEntryAttributeString(ObjectId id_jobentry, int nr, String code) throws KettleException {
        RowMetaAndData r = this.getJobEntryAttributeRow(id_jobentry, nr, code);
        if (r == null) {
            return null;
        }
        return r.getString("VALUE_STR", null);
    }

    public synchronized boolean getJobEntryAttributeBoolean(ObjectId id_jobentry, int nr, String code, boolean def) throws KettleException {
        RowMetaAndData r = this.getJobEntryAttributeRow(id_jobentry, nr, code);
        if (r == null) {
            return def;
        }
        String v = r.getString("VALUE_STR", null);
        if (v == null || Utils.isEmpty((CharSequence)v)) {
            return def;
        }
        return ValueMetaString.convertStringToBoolean((String)v);
    }

    public synchronized int countNrJobEntryAttributes(ObjectId id_jobentry, String code) throws KettleException {
        String sql = "SELECT COUNT(*) FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_JOBENTRY_ATTRIBUTE") + " WHERE " + this.quote("ID_JOBENTRY") + " = ? AND " + this.quote("CODE") + " = ?";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY"), (Object)id_jobentry);
        table.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code);
        RowMetaAndData r = this.callRead(() -> this.database.getOneRow(sql, table.getRowMeta(), table.getData()));
        if (r == null || r.getData() == null) {
            return 0;
        }
        return (int)r.getInteger(0, 0L);
    }

    public synchronized List<Object[]> getJobEntryAttributesWithPrefix(ObjectId jobId, ObjectId jobEntryId, String codePrefix) throws KettleException {
        String sql = "SELECT * FROM " + this.databaseMeta.getQuotedSchemaTableCombination(null, "R_JOBENTRY_ATTRIBUTE") + " WHERE " + this.quote("ID_JOB") + " = ? AND " + this.quote("ID_JOBENTRY") + " = ? AND " + this.quote("CODE") + " LIKE '" + codePrefix + "%'";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOB"), (Object)new LongObjectId(jobId));
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOBENTRY"), (Object)new LongObjectId(jobEntryId));
        return this.callRead(() -> this.database.getRows(sql, table.getRowMeta(), table.getData(), 1000, false, 0, null));
    }

    public synchronized ObjectId getNextTransformationID() throws KettleException {
        return this.getNextID(this.quoteTable("R_TRANSFORMATION"), this.quote("ID_TRANSFORMATION"));
    }

    public synchronized ObjectId getNextJobID() throws KettleException {
        return this.getNextID(this.quoteTable("R_JOB"), this.quote("ID_JOB"));
    }

    public synchronized ObjectId getNextNoteID() throws KettleException {
        return this.getNextID(this.quoteTable("R_NOTE"), this.quote("ID_NOTE"));
    }

    public synchronized ObjectId getNextLogID() throws KettleException {
        return this.getNextID(this.quoteTable("R_REPOSITORY_LOG"), this.quote("ID_REPOSITORY_LOG"));
    }

    public synchronized ObjectId getNextDatabaseID() throws KettleException {
        return this.getNextID(this.quoteTable("R_DATABASE"), this.quote("ID_DATABASE"));
    }

    public synchronized ObjectId getNextDatabaseTypeID() throws KettleException {
        return this.getNextID(this.quoteTable("R_DATABASE_TYPE"), this.quote("ID_DATABASE_TYPE"));
    }

    public synchronized ObjectId getNextDatabaseConnectionTypeID() throws KettleException {
        return this.getNextID(this.quoteTable("R_DATABASE_CONTYPE"), this.quote("ID_DATABASE_CONTYPE"));
    }

    public synchronized ObjectId getNextLoglevelID() throws KettleException {
        return this.getNextID(this.quoteTable("R_LOGLEVEL"), this.quote("ID_LOGLEVEL"));
    }

    public synchronized ObjectId getNextStepTypeID() throws KettleException {
        return this.getNextID(this.quoteTable("R_STEP_TYPE"), this.quote("ID_STEP_TYPE"));
    }

    public synchronized ObjectId getNextStepID() throws KettleException {
        return this.getNextID(this.quoteTable("R_STEP"), this.quote("ID_STEP"));
    }

    public synchronized ObjectId getNextJobEntryID() throws KettleException {
        return this.getNextID(this.quoteTable("R_JOBENTRY"), this.quote("ID_JOBENTRY"));
    }

    public synchronized ObjectId getNextJobEntryTypeID() throws KettleException {
        return this.getNextID(this.quoteTable("R_JOBENTRY_TYPE"), this.quote("ID_JOBENTRY_TYPE"));
    }

    public synchronized LongObjectId getNextJobEntryCopyID() throws KettleException {
        return this.getNextID(this.quoteTable("R_JOBENTRY_COPY"), this.quote("ID_JOBENTRY_COPY"));
    }

    public synchronized LongObjectId getNextStepAttributeID() throws KettleException {
        return this.getNextID(this.quoteTable("R_STEP_ATTRIBUTE"), this.quote("ID_STEP_ATTRIBUTE"));
    }

    public synchronized LongObjectId getNextTransAttributeID() throws KettleException {
        return this.getNextID(this.quoteTable("R_TRANS_ATTRIBUTE"), this.quote("ID_TRANS_ATTRIBUTE"));
    }

    public synchronized LongObjectId getNextJobAttributeID() throws KettleException {
        return this.getNextID(this.quoteTable("R_JOB_ATTRIBUTE"), this.quote("ID_JOB_ATTRIBUTE"));
    }

    public synchronized LongObjectId getNextDatabaseAttributeID() throws KettleException {
        return this.getNextID(this.quoteTable("R_DATABASE_ATTRIBUTE"), this.quote("ID_DATABASE_ATTRIBUTE"));
    }

    public synchronized ObjectId getNextTransHopID() throws KettleException {
        return this.getNextID(this.quoteTable("R_TRANS_HOP"), this.quote("ID_TRANS_HOP"));
    }

    public synchronized ObjectId getNextJobHopID() throws KettleException {
        return this.getNextID(this.quoteTable("R_JOB_HOP"), this.quote("ID_JOB_HOP"));
    }

    public synchronized ObjectId getNextDepencencyID() throws KettleException {
        return this.getNextID(this.quoteTable("R_DEPENDENCY"), this.quote("ID_DEPENDENCY"));
    }

    public synchronized ObjectId getNextPartitionSchemaID() throws KettleException {
        return this.getNextID(this.quoteTable("R_PARTITION_SCHEMA"), this.quote("ID_PARTITION_SCHEMA"));
    }

    public synchronized ObjectId getNextPartitionID() throws KettleException {
        return this.getNextID(this.quoteTable("R_PARTITION"), this.quote("ID_PARTITION"));
    }

    public synchronized ObjectId getNextTransformationPartitionSchemaID() throws KettleException {
        return this.getNextID(this.quoteTable("R_TRANS_PARTITION_SCHEMA"), this.quote("ID_TRANS_PARTITION_SCHEMA"));
    }

    public synchronized ObjectId getNextClusterID() throws KettleException {
        return this.getNextID(this.quoteTable("R_CLUSTER"), this.quote("ID_CLUSTER"));
    }

    public synchronized ObjectId getNextSlaveServerID() throws KettleException {
        return this.getNextID(this.quoteTable("R_SLAVE"), this.quote("ID_SLAVE"));
    }

    public synchronized ObjectId getNextClusterSlaveID() throws KettleException {
        return this.getNextID(this.quoteTable("R_CLUSTER_SLAVE"), this.quote("ID_CLUSTER_SLAVE"));
    }

    public synchronized ObjectId getNextTransformationSlaveID() throws KettleException {
        return this.getNextID(this.quoteTable("R_TRANS_SLAVE"), this.quote("ID_TRANS_SLAVE"));
    }

    public synchronized ObjectId getNextTransformationClusterID() throws KettleException {
        return this.getNextID(this.quoteTable("R_TRANS_CLUSTER"), this.quote("ID_TRANS_CLUSTER"));
    }

    public synchronized ObjectId getNextConditionID() throws KettleException {
        return this.getNextID(this.quoteTable("R_CONDITION"), this.quote("ID_CONDITION"));
    }

    public synchronized ObjectId getNextValueID() throws KettleException {
        return this.getNextID(this.quoteTable("R_VALUE"), this.quote("ID_VALUE"));
    }

    public synchronized ObjectId getNextUserID() throws KettleException {
        return this.getNextID(this.quoteTable("R_USER"), this.quote("ID_USER"));
    }

    public synchronized void clearNextIDCounters() {
        Counters.getInstance().clear();
    }

    public synchronized ObjectId getNextDirectoryID() throws KettleException {
        return this.getNextID(this.quoteTable("R_DIRECTORY"), this.quote("ID_DIRECTORY"));
    }

    public synchronized ObjectId insertStepAttribute(ObjectId id_transformation, ObjectId id_step, long nr, String code, double value_num, String value_str) throws KettleException {
        LongObjectId id = this.getNextStepAttributeID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_STEP_ATTRIBUTE"), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION"), (Object)id_transformation);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_STEP"), (Object)id_step);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("NR"), (Object)new Long(nr));
        table.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code);
        table.addValue((ValueMetaInterface)new ValueMetaNumber("VALUE_NUM"), (Object)new Double(value_num));
        table.addValue((ValueMetaInterface)new ValueMetaString("VALUE_STR"), (Object)value_str);
        if (this.psStepAttributesInsert == null) {
            String sql = this.database.getInsertStatement("R_STEP_ATTRIBUTE", table.getRowMeta());
            this.psStepAttributesInsert = this.database.prepareSQL(sql);
        }
        this.database.setValues(table, this.psStepAttributesInsert);
        this.database.insertRow(this.psStepAttributesInsert, this.useBatchProcessing);
        if (this.log.isDebug()) {
            this.log.logDebug("saved attribute [" + code + "]");
        }
        return id;
    }

    public synchronized ObjectId insertTransAttribute(ObjectId id_transformation, long nr, String code, long value_num, String value_str) throws KettleException {
        LongObjectId id = this.getNextTransAttributeID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_TRANS_ATTRIBUTE"), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_TRANSFORMATION"), (Object)id_transformation);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("NR"), (Object)new Long(nr));
        table.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("VALUE_NUM"), (Object)new Long(value_num));
        table.addValue((ValueMetaInterface)new ValueMetaString("VALUE_STR"), (Object)value_str);
        if (this.psTransAttributesInsert == null) {
            String sql = this.database.getInsertStatement("R_TRANS_ATTRIBUTE", table.getRowMeta());
            this.psTransAttributesInsert = this.database.prepareSQL(sql);
        }
        this.database.setValues(table, this.psTransAttributesInsert);
        this.database.insertRow(this.psTransAttributesInsert, this.useBatchProcessing);
        if (this.log.isDebug()) {
            this.log.logDebug("saved transformation attribute [" + code + "]");
        }
        return id;
    }

    public synchronized ObjectId insertJobAttribute(ObjectId id_job, long nr, String code, long value_num, String value_str) throws KettleException {
        LongObjectId id = this.getNextJobAttributeID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOB_ATTRIBUTE"), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_JOB"), (Object)id_job);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("NR"), (Object)new Long(nr));
        table.addValue((ValueMetaInterface)new ValueMetaString("CODE"), (Object)code);
        table.addValue((ValueMetaInterface)new ValueMetaInteger("VALUE_NUM"), (Object)new Long(value_num));
        table.addValue((ValueMetaInterface)new ValueMetaString("VALUE_STR"), (Object)value_str);
        if (this.psJobAttributesInsert == null) {
            String sql = this.database.getInsertStatement("R_JOB_ATTRIBUTE", table.getRowMeta());
            this.psJobAttributesInsert = this.database.prepareSQL(sql);
        }
        this.database.setValues(table, this.psJobAttributesInsert);
        this.database.insertRow(this.psJobAttributesInsert, this.useBatchProcessing);
        if (this.log.isDebug()) {
            this.log.logDebug("saved job attribute [" + code + "]");
        }
        return id;
    }

    public synchronized void updateTableRow(String tablename, String idfield, RowMetaAndData values, ObjectId id) throws KettleException {
        String[] sets = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            sets[i] = values.getValueMeta(i).getName();
        }
        String[] codes = new String[]{idfield};
        String[] condition = new String[]{"="};
        this.database.prepareUpdate(tablename, codes, condition, sets);
        values.addValue((ValueMetaInterface)new ValueMetaInteger(idfield), (Object)id);
        this.database.setValuesUpdate(values.getRowMeta(), values.getData());
        this.database.updateRow();
        this.database.closeUpdate();
    }

    public synchronized void updateTableRow(String tablename, String idfield, RowMetaAndData values) throws KettleException {
        long id = values.getInteger(idfield, 0L);
        values.removeValue(idfield);
        String[] sets = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            sets[i] = values.getValueMeta(i).getName();
        }
        String[] codes = new String[]{idfield};
        String[] condition = new String[]{"="};
        this.database.prepareUpdate(tablename, codes, condition, sets);
        values.addValue((ValueMetaInterface)new ValueMetaInteger(idfield), (Object)new Long(id));
        this.database.setValuesUpdate(values.getRowMeta(), values.getData());
        this.database.updateRow();
    }

    public synchronized List<RepositoryElementMetaInterface> getRepositoryObjects(String tableName, final RepositoryObjectType objectType, ObjectId id_directory) throws KettleException {
        try {
            String idField = RepositoryObjectType.TRANSFORMATION.equals((Object)objectType) ? "ID_TRANSFORMATION" : "ID_JOB";
            if (id_directory == null) {
                id_directory = new LongObjectId(0L);
            }
            final RepositoryDirectoryInterface repositoryDirectory = this.repository.directoryDelegate.loadPathToRoot(id_directory);
            final String sql = "SELECT " + this.quote("NAME") + ", " + this.quote("MODIFIED_USER") + ", " + this.quote("MODIFIED_DATE") + ", " + this.quote("DESCRIPTION") + ", " + this.quote(idField) + " FROM " + tableName + " WHERE " + this.quote("ID_DIRECTORY") + " = ? ";
            final RowMetaAndData directoryIdRow = this.getParameterMetaData(id_directory);
            return this.callRead(new Callable<List<RepositoryElementMetaInterface>>(){

                @Override
                public List<RepositoryElementMetaInterface> call() throws Exception {
                    ArrayList<RepositoryElementMetaInterface> repositoryObjects = new ArrayList<RepositoryElementMetaInterface>();
                    ResultSet rs = KettleDatabaseRepositoryConnectionDelegate.this.database.openQuery(sql, directoryIdRow.getRowMeta(), directoryIdRow.getData());
                    if (rs != null) {
                        List rows = KettleDatabaseRepositoryConnectionDelegate.this.database.getRows(rs, -1, null);
                        if (rs != null) {
                            KettleDatabaseRepositoryConnectionDelegate.this.database.closeQuery(rs);
                        }
                        RowMetaInterface rowMeta = KettleDatabaseRepositoryConnectionDelegate.this.database.getReturnRowMeta();
                        for (Object[] r : rows) {
                            LongObjectId id = new LongObjectId(rowMeta.getInteger(r, 4).longValue());
                            repositoryObjects.add(new RepositoryObject((ObjectId)id, rowMeta.getString(r, 0), repositoryDirectory, rowMeta.getString(r, 1), rowMeta.getDate(r, 2), objectType, rowMeta.getString(r, 3), false));
                        }
                    }
                    return repositoryObjects;
                }
            });
        }
        catch (Exception e) {
            throw new KettleException("Unable to get list of repository objects", (Throwable)e);
        }
    }

    public ObjectId[] getIDs(String sql, ObjectId ... objectId) throws KettleException {
        final PreparedStatement ps = this.getPreparedStatement(sql);
        RowMeta parameterMeta = new RowMeta();
        Object[] parameterData = new Object[objectId.length];
        for (int i = 0; i < objectId.length; ++i) {
            parameterMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger("id" + (i + 1)));
            parameterData[i] = ((LongObjectId)objectId[i]).longValue();
        }
        return this.callRead(new Callable<ObjectId[]>((RowMetaInterface)parameterMeta, parameterData){
            final /* synthetic */ RowMetaInterface val$parameterMeta;
            final /* synthetic */ Object[] val$parameterData;
            {
                this.val$parameterMeta = rowMetaInterface;
                this.val$parameterData = objectArray;
            }

            @Override
            public ObjectId[] call() throws Exception {
                ResultSet resultSet = KettleDatabaseRepositoryConnectionDelegate.this.database.openQuery(ps, this.val$parameterMeta, this.val$parameterData);
                List rows = KettleDatabaseRepositoryConnectionDelegate.this.database.getRows(resultSet, 0, null);
                if (Utils.isEmpty((List)rows)) {
                    return new ObjectId[0];
                }
                RowMetaInterface rowMeta = KettleDatabaseRepositoryConnectionDelegate.this.database.getReturnRowMeta();
                ObjectId[] ids = new ObjectId[rows.size()];
                for (int i = 0; i < ids.length; ++i) {
                    Object[] row = (Object[])rows.get(i);
                    ids[i] = new LongObjectId(rowMeta.getInteger(row, 0).longValue());
                }
                return ids;
            }
        });
    }

    public String[] getStrings(String sql, ObjectId ... objectId) throws KettleException {
        final PreparedStatement ps = this.getPreparedStatement(sql);
        RowMeta parameterMeta = new RowMeta();
        Object[] parameterData = new Object[objectId.length];
        for (int i = 0; i < objectId.length; ++i) {
            parameterMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger("id" + (i + 1)));
            parameterData[i] = ((LongObjectId)objectId[i]).longValue();
        }
        return this.callRead(new Callable<String[]>((RowMetaInterface)parameterMeta, parameterData){
            final /* synthetic */ RowMetaInterface val$parameterMeta;
            final /* synthetic */ Object[] val$parameterData;
            {
                this.val$parameterMeta = rowMetaInterface;
                this.val$parameterData = objectArray;
            }

            @Override
            public String[] call() throws Exception {
                ResultSet resultSet = KettleDatabaseRepositoryConnectionDelegate.this.database.openQuery(ps, this.val$parameterMeta, this.val$parameterData);
                List rows = KettleDatabaseRepositoryConnectionDelegate.this.database.getRows(resultSet, 0, null);
                if (Utils.isEmpty((List)rows)) {
                    return new String[0];
                }
                RowMetaInterface rowMeta = KettleDatabaseRepositoryConnectionDelegate.this.database.getReturnRowMeta();
                String[] strings = new String[rows.size()];
                for (int i = 0; i < strings.length; ++i) {
                    Object[] row = (Object[])rows.get(i);
                    strings[i] = rowMeta.getString(row, 0);
                }
                return strings;
            }
        });
    }

    public static final ObjectId[] convertLongList(List<Long> list) {
        ObjectId[] ids = new ObjectId[list.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = new LongObjectId(list.get(i).longValue());
        }
        return ids;
    }

    private String[] getQuotedSchemaTablenames(String[] tables) {
        String[] quoted = new String[tables.length];
        for (int i = 0; i < quoted.length; ++i) {
            quoted[i] = this.database.getDatabaseMeta().getQuotedSchemaTableCombination(null, tables[i]);
        }
        return quoted;
    }

    public synchronized void lockRepository() throws KettleException {
        if (this.database.getDatabaseMeta().needsToLockAllTables()) {
            this.database.lockTables(this.getQuotedSchemaTablenames(KettleDatabaseRepository.repositoryTableNames));
        } else {
            this.database.lockTables(this.getQuotedSchemaTablenames(new String[]{"R_REPOSITORY_LOG"}));
        }
    }

    public synchronized void unlockRepository() throws KettleException {
        if (this.database.getDatabaseMeta().needsToLockAllTables()) {
            this.database.unlockTables(KettleDatabaseRepository.repositoryTableNames);
        } else {
            this.database.unlockTables(new String[]{"R_REPOSITORY_LOG"});
        }
    }

    public RowMetaInterface getStepAttributesRowMeta() {
        return this.stepAttributesRowMeta;
    }

    public boolean isUseBatchProcessing() {
        return this.useBatchProcessing;
    }

    public void setStepAttributesRowMeta(RowMetaInterface stepAttributesRowMeta) {
        this.stepAttributesRowMeta = stepAttributesRowMeta;
    }

    public synchronized LongObjectId getIDWithValue(String tablename, String idfield, String lookupfield, String value) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        par.addValue((ValueMetaInterface)new ValueMetaString("value"), (Object)value);
        RowMetaAndData result = this.getOneRow("SELECT " + idfield + " FROM " + tablename + " WHERE " + lookupfield + " = ?", par.getRowMeta(), par.getData());
        if (result != null && result.getRowMeta() != null && result.getData() != null && result.isNumeric(0)) {
            return new LongObjectId(result.getInteger(0, 0L));
        }
        return null;
    }

    static String createIdsWithValuesQuery(String tablename, String idfield, String lookupfield, int amount) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("SELECT ").append(idfield).append(" FROM ").append(tablename).append(" WHERE ").append(lookupfield).append(" IN (");
        for (int i = 0; i < amount; ++i) {
            sb.append('?').append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }

    public Map<String, LongObjectId> getValueToIdMap(String tablename, String idfield, String lookupfield) throws KettleException {
        String sql = "SELECT " + lookupfield + ", " + idfield + " FROM " + tablename;
        HashMap<String, LongObjectId> result = new HashMap<String, LongObjectId>();
        for (Object[] row : this.callRead(() -> this.database.getRows(sql, (RowMetaInterface)new RowMeta(), new Object[0], 1000, false, -1, null))) {
            result.put(String.valueOf(row[0]), new LongObjectId(((Number)row[1]).longValue()));
        }
        return result;
    }

    public LongObjectId[] getIDsWithValues(String tablename, String idfield, String lookupfield, String[] values) throws KettleException {
        String sql = KettleDatabaseRepositoryConnectionDelegate.createIdsWithValuesQuery(tablename, idfield, lookupfield, values.length);
        RowMeta params = new RowMeta();
        for (int i = 0; i < values.length; ++i) {
            ValueMetaString value = new ValueMetaString(Integer.toString(i));
            params.addValueMeta((ValueMetaInterface)value);
        }
        List rows = this.callRead(() -> this.database.getRows(sql, (RowMetaInterface)params, (Object[])values, 1000, false, -1, null));
        LongObjectId[] result = new LongObjectId[rows.size()];
        int i = 0;
        for (Object[] row : rows) {
            result[i++] = new LongObjectId(((Number)row[0]).longValue());
        }
        return result;
    }

    public synchronized ObjectId getIDWithValue(String tablename, String idfield, String lookupfield, String value, String lookupkey, ObjectId key) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        par.addValue((ValueMetaInterface)new ValueMetaString("value"), (Object)value);
        par.addValue((ValueMetaInterface)new ValueMetaInteger("key"), (Object)new LongObjectId(key));
        RowMetaAndData result = this.getOneRow("SELECT " + idfield + " FROM " + tablename + " WHERE " + lookupfield + " = ? AND " + lookupkey + " = ?", par.getRowMeta(), par.getData());
        if (result != null && result.getRowMeta() != null && result.getData() != null && result.isNumeric(0)) {
            return new LongObjectId(result.getInteger(0, 0L));
        }
        return null;
    }

    public synchronized ObjectId getIDWithValue(String tablename, String idfield, String[] lookupkey, ObjectId[] key) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        String sql = "SELECT " + idfield + " FROM " + tablename + " ";
        for (int i = 0; i < lookupkey.length; ++i) {
            sql = i == 0 ? sql + "WHERE " : sql + "AND   ";
            par.addValue((ValueMetaInterface)new ValueMetaInteger(lookupkey[i]), (Object)new LongObjectId(key[i]));
            sql = sql + lookupkey[i] + " = ? ";
        }
        RowMetaAndData result = this.getOneRow(sql, par.getRowMeta(), par.getData());
        if (result != null && result.getRowMeta() != null && result.getData() != null && result.isNumeric(0)) {
            return new LongObjectId(result.getInteger(0, 0L));
        }
        return null;
    }

    public synchronized LongObjectId getIDWithValue(String tablename, String idfield, String lookupfield, String value, String[] lookupkey, ObjectId[] key) throws KettleException {
        RowMetaAndData par = new RowMetaAndData();
        par.addValue((ValueMetaInterface)new ValueMetaString(lookupfield), (Object)value);
        String sql = "SELECT " + idfield + " FROM " + tablename + " WHERE " + lookupfield + " = ? ";
        for (int i = 0; i < lookupkey.length; ++i) {
            par.addValue((ValueMetaInterface)new ValueMetaInteger(lookupkey[i]), (Object)new LongObjectId(key[i]));
            sql = sql + "AND " + lookupkey[i] + " = ? ";
        }
        RowMetaAndData result = this.getOneRow(sql, par.getRowMeta(), par.getData());
        if (result != null && result.getRowMeta() != null && result.getData() != null && result.isNumeric(0)) {
            return new LongObjectId(result.getInteger(0, 0L));
        }
        return null;
    }

    public RowMetaAndData getOneRow(String schemaAndTable, String keyfield, ObjectId id) throws KettleException {
        String sql = "SELECT * FROM " + schemaAndTable + " WHERE " + keyfield + " = ?";
        final PreparedStatement ps = this.getPreparedStatement(sql);
        RowMeta parameterMeta = new RowMeta();
        parameterMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger("id"));
        Object[] parameterData = new Object[]{id != null ? Long.valueOf(Long.parseLong(id.getId())) : null};
        return this.callRead(new Callable<RowMetaAndData>((RowMetaInterface)parameterMeta, parameterData){
            final /* synthetic */ RowMetaInterface val$parameterMeta;
            final /* synthetic */ Object[] val$parameterData;
            {
                this.val$parameterMeta = rowMetaInterface;
                this.val$parameterData = objectArray;
            }

            @Override
            public RowMetaAndData call() throws Exception {
                ResultSet resultSet = null;
                resultSet = KettleDatabaseRepositoryConnectionDelegate.this.database.openQuery(ps, this.val$parameterMeta, this.val$parameterData);
                Object[] result = KettleDatabaseRepositoryConnectionDelegate.this.database.getRow(resultSet);
                if (resultSet != null) {
                    KettleDatabaseRepositoryConnectionDelegate.this.database.closeQuery(resultSet);
                }
                if (result == null) {
                    return new RowMetaAndData(KettleDatabaseRepositoryConnectionDelegate.this.database.getReturnRowMeta(), RowDataUtil.allocateRowData((int)KettleDatabaseRepositoryConnectionDelegate.this.database.getReturnRowMeta().size()));
                }
                return new RowMetaAndData(KettleDatabaseRepositoryConnectionDelegate.this.database.getReturnRowMeta(), result);
            }
        });
    }

    public RowMetaAndData getOneRow(String sql) throws KettleDatabaseException {
        return this.callRead(() -> this.database.getOneRow(sql));
    }

    public RowMetaAndData getOneRow(String sql, RowMetaInterface rowMeta, Object[] rowData) throws KettleDatabaseException {
        return this.callRead(() -> this.database.getOneRow(sql, rowMeta, rowData));
    }

    public synchronized String getStringWithID(String tablename, String keyfield, ObjectId id, String fieldname) throws KettleException {
        String sql = "SELECT " + fieldname + " FROM " + tablename + " WHERE " + keyfield + " = ?";
        RowMetaAndData par = new RowMetaAndData();
        par.addValue((ValueMetaInterface)new ValueMetaInteger(keyfield), (Object)id);
        RowMetaAndData result = this.getOneRow(sql, par.getRowMeta(), par.getData());
        if (result != null && result.getData() != null) {
            return result.getString(0, null);
        }
        return null;
    }

    public List<Object[]> getRows(String sql, int limit) throws KettleDatabaseException {
        return this.callRead(() -> this.database.getRows(sql, limit));
    }

    public RowMetaInterface getReturnRowMeta() throws KettleDatabaseException {
        return this.database.getReturnRowMeta();
    }

    public synchronized void insertTableRow(String tablename, RowMetaAndData values) throws KettleException {
        this.database.prepareInsert(values.getRowMeta(), tablename);
        this.database.setValuesInsert(values);
        this.database.insertRow();
        this.database.closeInsert();
    }

    public Collection<RowMetaAndData> getDatabaseAttributes(ObjectId id_database) throws KettleDatabaseException, KettleValueException {
        String sql = "SELECT * FROM " + this.quoteTable("R_DATABASE_ATTRIBUTE") + " WHERE " + this.quote("ID_DATABASE") + " = ?";
        final PreparedStatement ps = this.getPreparedStatement(sql);
        RowMeta parameterMeta = new RowMeta();
        parameterMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger("id"));
        Object[] parameterData = new Object[]{((LongObjectId)id_database).longValue()};
        ArrayList attrs = new ArrayList();
        return this.callRead(new Callable<Collection<RowMetaAndData>>((RowMetaInterface)parameterMeta, parameterData, attrs){
            final /* synthetic */ RowMetaInterface val$parameterMeta;
            final /* synthetic */ Object[] val$parameterData;
            final /* synthetic */ List val$attrs;
            {
                this.val$parameterMeta = rowMetaInterface;
                this.val$parameterData = objectArray;
                this.val$attrs = list;
            }

            @Override
            public Collection<RowMetaAndData> call() throws Exception {
                List list;
                ResultSet resultSet = null;
                try {
                    resultSet = KettleDatabaseRepositoryConnectionDelegate.this.database.openQuery(ps, this.val$parameterMeta, this.val$parameterData);
                    List rows = KettleDatabaseRepositoryConnectionDelegate.this.database.getRows(resultSet, 0, null);
                    for (Object[] row : rows) {
                        RowMetaAndData rowWithMeta = new RowMetaAndData(KettleDatabaseRepositoryConnectionDelegate.this.database.getReturnRowMeta(), row);
                        long id = rowWithMeta.getInteger(KettleDatabaseRepositoryConnectionDelegate.this.quote("ID_DATABASE_ATTRIBUTE"), 0L);
                        if (id <= 0L) continue;
                        this.val$attrs.add(rowWithMeta);
                    }
                    list = this.val$attrs;
                }
                catch (KettleDatabaseException e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        KettleDatabaseRepositoryConnectionDelegate.this.database.closeQuery(resultSet);
                        throw throwable;
                    }
                }
                KettleDatabaseRepositoryConnectionDelegate.this.database.closeQuery(resultSet);
                return list;
            }
        });
    }

    private PreparedStatement getPreparedStatement(String sql) throws KettleDatabaseException {
        PreparedStatement ps = this.sqlMap.get(sql);
        if (ps == null) {
            ps = this.database.prepareSQL(sql);
            this.sqlMap.putIfAbsent(sql, ps);
        }
        return ps;
    }

    public RowMetaAndData getParameterMetaData(ObjectId ... ids) throws KettleException {
        RowMeta parameterMeta = new RowMeta();
        Object[] parameterData = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            parameterMeta.addValueMeta((ValueMetaInterface)new ValueMetaInteger("id" + (i + 1)));
            parameterData[i] = Long.valueOf(ids[i].getId());
        }
        return new RowMetaAndData((RowMetaInterface)parameterMeta, parameterData);
    }

    public void performDelete(String sql, ObjectId ... ids) throws KettleException {
        try {
            PreparedStatement ps = this.getPreparedStatement(sql);
            RowMetaAndData param = this.getParameterMetaData(ids);
            this.database.setValues(param, ps);
            ps.execute();
        }
        catch (SQLException e) {
            throw new KettleException("Unable to perform delete with SQL: " + sql + ", ids=" + ids.toString(), (Throwable)e);
        }
    }

    public void closeAttributeLookupPreparedStatements() throws KettleException {
        this.closeStepAttributeLookupPreparedStatement();
        this.closeTransAttributeLookupPreparedStatement();
        this.closeJobAttributeLookupPreparedStatement();
        this.closeLookupJobEntryAttribute();
    }

    public void closeReadTransaction() throws KettleDatabaseException {
        if (this.databaseMeta.isMySQLVariant() && !this.database.isAutoCommit()) {
            this.database.commit();
        }
    }

    public <V> V callRead(Callable<V> callable) throws KettleDatabaseException {
        try {
            V v = callable.call();
            return v;
        }
        catch (Exception e) {
            if (KettleDatabaseException.class.isInstance(e)) {
                throw (KettleDatabaseException)((Object)KettleDatabaseException.class.cast(e));
            }
            throw new RuntimeException(e);
        }
        finally {
            this.closeReadTransaction();
        }
    }

    private class StepAttributeComparator
    implements Comparator<Object[]> {
        private StepAttributeComparator() {
        }

        @Override
        public int compare(Object[] r1, Object[] r2) {
            try {
                return KettleDatabaseRepositoryConnectionDelegate.this.stepAttributesRowMeta.compare(r1, r2, KEY_POSITIONS);
            }
            catch (KettleValueException e) {
                return 0;
            }
        }
    }
}

