/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.attributes.AttributesUtil;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleRowException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.MetricsLogTable;
import org.pentaho.di.core.logging.PerformanceLogTable;
import org.pentaho.di.core.logging.StepLogTable;
import org.pentaho.di.core.logging.TransLogTable;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.reflection.StringSearchResult;
import org.pentaho.di.core.reflection.StringSearcher;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLFormatter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.HasRepositoryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceExportInterface;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.CheckStepsExtension;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.SlaveStepCopyPartitionDistribution;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransDependency;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RemoteStep;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaChangeListenerInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.jobexecutor.JobExecutorMeta;
import org.pentaho.di.trans.steps.mapping.MappingMeta;
import org.pentaho.di.trans.steps.missing.MissingTrans;
import org.pentaho.di.trans.steps.named.cluster.NamedClusterEmbedManager;
import org.pentaho.di.trans.steps.singlethreader.SingleThreaderMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransMeta
extends AbstractMeta
implements XMLInterface,
Comparator<TransMeta>,
Comparable<TransMeta>,
Cloneable,
ResourceExportInterface,
RepositoryElementInterface,
LoggingObjectInterface {
    private static Class<?> PKG = Trans.class;
    public static final String XML_TAG = "transformation";
    public static final String STRING_TRANSMETA = "Transformation metadata";
    public static final RepositoryObjectType REPOSITORY_ELEMENT_TYPE = RepositoryObjectType.TRANSFORMATION;
    public static final int BORDER_INDENT = 20;
    protected List<StepMeta> steps;
    protected List<TransHopMeta> hops;
    protected List<TransDependency> dependencies;
    protected List<ClusterSchema> clusterSchemas;
    private List<PartitionSchema> partitionSchemas;
    protected String trans_version;
    protected int trans_status;
    protected TransLogTable transLogTable;
    protected PerformanceLogTable performanceLogTable;
    protected StepLogTable stepLogTable;
    protected MetricsLogTable metricsLogTable;
    protected int sizeRowset;
    protected DatabaseMeta maxDateConnection;
    protected String maxDateTable;
    protected String maxDateField;
    protected double maxDateOffset;
    protected double maxDateDifference;
    @Deprecated
    protected String[] arguments;
    @Deprecated
    protected Hashtable<String, Counter> counters;
    protected boolean changed_steps;
    protected boolean changed_hops;
    protected DBCache dbCache;
    protected int sleepTimeEmpty;
    protected int sleepTimeFull;
    protected Result previousResult;
    @Deprecated
    protected List<RowMetaAndData> resultRows;
    @Deprecated
    protected List<ResultFile> resultFiles;
    protected boolean usingUniqueConnections;
    protected boolean feedbackShown;
    protected int feedbackSize;
    protected boolean usingThreadPriorityManagment;
    protected SlaveStepCopyPartitionDistribution slaveStepCopyPartitionDistribution;
    protected boolean slaveTransformation;
    protected boolean capturingStepPerformanceSnapShots;
    protected long stepPerformanceCapturingDelay;
    protected String stepPerformanceCapturingSizeLimit;
    protected Map<String, RowMetaInterface> stepsFieldsCache;
    protected Map<String, Boolean> loopCache;
    protected Map<String, List<StepMeta>> previousStepCache;
    protected LogChannelInterface log;
    protected List<StepMetaChangeListenerInterface> stepChangeListeners;
    protected byte[] keyForSessionKey;
    boolean isKeyPrivate;
    private ArrayList<MissingTrans> missingTrans;
    protected TransformationType transformationType;
    public static final String[] desc_type_undo = new String[]{"", BaseMessages.getString(PKG, (String)"TransMeta.UndoTypeDesc.UndoChange", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransMeta.UndoTypeDesc.UndoNew", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransMeta.UndoTypeDesc.UndoDelete", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransMeta.UndoTypeDesc.UndoPosition", (String[])new String[0])};
    protected static final String XML_TAG_INFO = "info";
    public static final String XML_TAG_ORDER = "order";
    public static final String XML_TAG_NOTEPADS = "notepads";
    public static final String XML_TAG_PARAMETERS = "parameters";
    protected static final String XML_TAG_DEPENDENCIES = "dependencies";
    public static final String XML_TAG_PARTITIONSCHEMAS = "partitionschemas";
    public static final String XML_TAG_SLAVESERVERS = "slaveservers";
    public static final String XML_TAG_CLUSTERSCHEMAS = "clusterschemas";
    public static final String XML_TAG_STEP_ERROR_HANDLING = "step_error_handling";
    private long prevCount;

    public TransMeta() {
        this.clear();
        this.initializeVariablesFrom(null);
    }

    public TransMeta(VariableSpace parent) {
        this.clear();
        this.initializeVariablesFrom(parent);
    }

    public TransMeta(String filename, String name) {
        this.clear();
        this.setFilename(filename);
        this.name = name;
        this.initializeVariablesFrom(null);
    }

    @Deprecated
    public TransMeta(String filename, String name, String[] arguments) {
        this.clear();
        this.setFilename(filename);
        this.name = name;
        this.arguments = arguments;
        this.initializeVariablesFrom(null);
    }

    @Override
    public int compare(TransMeta t1, TransMeta t2) {
        return super.compare(t1, t2);
    }

    @Override
    public int compareTo(TransMeta o) {
        return this.compare(this, o);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TransMeta)) {
            return false;
        }
        return this.compare(this, (TransMeta)obj) == 0;
    }

    public Object clone() {
        return this.realClone(true);
    }

    public Object realClone(boolean doClear) {
        try {
            TransMeta transMeta = (TransMeta)super.clone();
            if (doClear) {
                transMeta.clear();
            } else {
                transMeta.databases = new ArrayList();
                transMeta.steps = new ArrayList<StepMeta>();
                transMeta.hops = new ArrayList<TransHopMeta>();
                transMeta.notes = new ArrayList();
                transMeta.dependencies = new ArrayList<TransDependency>();
                transMeta.partitionSchemas = new ArrayList<PartitionSchema>();
                transMeta.slaveServers = new ArrayList();
                transMeta.clusterSchemas = new ArrayList<ClusterSchema>();
                transMeta.namedParams = new NamedParamsDefault();
                transMeta.stepChangeListeners = new ArrayList<StepMetaChangeListenerInterface>();
            }
            for (DatabaseMeta databaseMeta : this.databases) {
                transMeta.addDatabase((DatabaseMeta)databaseMeta.clone());
            }
            for (StepMeta stepMeta : this.steps) {
                transMeta.addStep((StepMeta)stepMeta.clone());
            }
            for (StepMeta stepMeta : transMeta.getSteps()) {
                StepIOMetaInterface stepIOMetaInterface;
                StepMetaInterface stepMetaInterface = stepMeta.getStepMetaInterface();
                if (stepMetaInterface == null || (stepIOMetaInterface = stepMetaInterface.getStepIOMeta()) == null) continue;
                for (StreamInterface stream : stepIOMetaInterface.getInfoStreams()) {
                    String streamStepName = stream.getStepname();
                    if (streamStepName == null) continue;
                    StepMeta streamStepMeta = transMeta.findStep(streamStepName);
                    stream.setStepMeta(streamStepMeta);
                }
            }
            for (TransHopMeta transHopMeta : this.hops) {
                transMeta.addTransHop((TransHopMeta)transHopMeta.clone());
            }
            for (NotePadMeta notePadMeta : this.notes) {
                transMeta.addNote((NotePadMeta)notePadMeta.clone());
            }
            for (TransDependency transDependency : this.dependencies) {
                transMeta.addDependency((TransDependency)transDependency.clone());
            }
            for (SlaveServer slaveServer : this.slaveServers) {
                transMeta.getSlaveServers().add((SlaveServer)slaveServer.clone());
            }
            for (ClusterSchema clusterSchema : this.clusterSchemas) {
                transMeta.getClusterSchemas().add(clusterSchema.clone());
            }
            for (PartitionSchema partitionSchema : this.partitionSchemas) {
                transMeta.getPartitionSchemas().add((PartitionSchema)partitionSchema.clone());
            }
            for (Iterator<Object> iterator : this.listParameters()) {
                transMeta.addParameterDefinition((String)((Object)iterator), this.getParameterDefault((String)((Object)iterator)), this.getParameterDescription((String)((Object)iterator)));
            }
            return transMeta;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void clear() {
        this.setObjectId(null);
        this.steps = new ArrayList<StepMeta>();
        this.hops = new ArrayList<TransHopMeta>();
        this.dependencies = new ArrayList<TransDependency>();
        this.partitionSchemas = new ArrayList<PartitionSchema>();
        this.clusterSchemas = new ArrayList<ClusterSchema>();
        this.namedParams = new NamedParamsDefault();
        this.stepChangeListeners = new ArrayList<StepMetaChangeListenerInterface>();
        this.slaveStepCopyPartitionDistribution = new SlaveStepCopyPartitionDistribution();
        this.trans_status = -1;
        this.trans_version = null;
        this.transLogTable = TransLogTable.getDefault(this, this, this.steps);
        this.performanceLogTable = PerformanceLogTable.getDefault(this, this);
        this.stepLogTable = StepLogTable.getDefault(this, this);
        this.metricsLogTable = MetricsLogTable.getDefault(this, this);
        this.sizeRowset = 10000;
        this.sleepTimeEmpty = 50;
        this.sleepTimeFull = 50;
        this.maxDateConnection = null;
        this.maxDateTable = null;
        this.maxDateField = null;
        this.maxDateOffset = 0.0;
        this.maxDateDifference = 0.0;
        this.undo = new ArrayList();
        this.max_undo = 100;
        this.undo_position = -1;
        this.counters = new Hashtable();
        this.resultRows = null;
        super.clear();
        this.dbCache = DBCache.getInstance();
        this.resultRows = new ArrayList<RowMetaAndData>();
        this.resultFiles = new ArrayList<ResultFile>();
        this.feedbackShown = true;
        this.feedbackSize = 50000;
        this.usingThreadPriorityManagment = true;
        this.capturingStepPerformanceSnapShots = false;
        this.stepPerformanceCapturingDelay = 1000L;
        this.stepPerformanceCapturingSizeLimit = "100";
        this.stepsFieldsCache = new HashMap<String, RowMetaInterface>();
        this.loopCache = new HashMap<String, Boolean>();
        this.previousStepCache = new HashMap<String, List<StepMeta>>();
        this.transformationType = TransformationType.Normal;
        this.log = LogChannel.GENERAL;
    }

    public void addStep(StepMeta stepMeta) {
        this.steps.add(stepMeta);
        stepMeta.setParentTransMeta(this);
        StepMetaInterface iface = stepMeta.getStepMetaInterface();
        if (iface instanceof StepMetaChangeListenerInterface) {
            this.addStepChangeListener((StepMetaChangeListenerInterface)((Object)iface));
        }
        this.changed_steps = true;
        this.clearCaches();
    }

    public void addOrReplaceStep(StepMeta stepMeta) {
        int index = this.steps.indexOf(stepMeta);
        if (index < 0) {
            index = this.steps.add(stepMeta) ? 0 : index;
        } else {
            StepMeta previous = this.getStep(index);
            previous.replaceMeta(stepMeta);
        }
        stepMeta.setParentTransMeta(this);
        StepMetaInterface iface = stepMeta.getStepMetaInterface();
        if (index != -1 && iface instanceof StepMetaChangeListenerInterface) {
            this.addStepChangeListener(index, (StepMetaChangeListenerInterface)((Object)iface));
        }
        this.changed_steps = true;
        this.clearCaches();
    }

    public void addTransHop(TransHopMeta hi) {
        this.hops.add(hi);
        this.changed_hops = true;
        this.clearCaches();
    }

    public void addDependency(TransDependency td) {
        this.dependencies.add(td);
    }

    public void addStep(int p, StepMeta stepMeta) {
        this.steps.add(p, stepMeta);
        stepMeta.setParentTransMeta(this);
        this.changed_steps = true;
        StepMetaInterface iface = stepMeta.getStepMetaInterface();
        if (iface instanceof StepMetaChangeListenerInterface) {
            this.addStepChangeListener(p, (StepMetaChangeListenerInterface)((Object)stepMeta.getStepMetaInterface()));
        }
        this.clearCaches();
    }

    public void addTransHop(int p, TransHopMeta hi) {
        try {
            this.hops.add(p, hi);
        }
        catch (IndexOutOfBoundsException e) {
            this.hops.add(hi);
        }
        this.changed_hops = true;
        this.clearCaches();
    }

    public void addDependency(int p, TransDependency td) {
        this.dependencies.add(p, td);
    }

    public List<StepMeta> getSteps() {
        return this.steps;
    }

    public StepMeta getStep(int i) {
        return this.steps.get(i);
    }

    public List<TransHopMeta> getTransHops() {
        return Collections.unmodifiableList(this.hops);
    }

    public TransHopMeta getTransHop(int i) {
        return this.hops.get(i);
    }

    public TransDependency getDependency(int i) {
        return this.dependencies.get(i);
    }

    public void removeStep(int i) {
        if (i < 0 || i >= this.steps.size()) {
            return;
        }
        StepMeta removeStep = this.steps.get(i);
        StepMetaInterface iface = removeStep.getStepMetaInterface();
        if (iface instanceof StepMetaChangeListenerInterface) {
            this.removeStepChangeListener((StepMetaChangeListenerInterface)((Object)iface));
        }
        this.steps.remove(i);
        if (removeStep.getStepMetaInterface() instanceof MissingTrans) {
            this.removeMissingTrans((MissingTrans)removeStep.getStepMetaInterface());
        }
        this.changed_steps = true;
        this.clearCaches();
    }

    public void removeTransHop(int i) {
        if (i < 0 || i >= this.hops.size()) {
            return;
        }
        this.hops.remove(i);
        this.changed_hops = true;
        this.clearCaches();
    }

    public void removeTransHop(TransHopMeta hop) {
        this.hops.remove(hop);
        this.changed_hops = true;
        this.clearCaches();
    }

    public void removeDependency(int i) {
        if (i < 0 || i >= this.dependencies.size()) {
            return;
        }
        this.dependencies.remove(i);
    }

    public void removeAllDependencies() {
        this.dependencies.clear();
    }

    public int nrSteps() {
        return this.steps.size();
    }

    public int nrTransHops() {
        return this.hops.size();
    }

    public int nrDependencies() {
        return this.dependencies.size();
    }

    public int nrStepChangeListeners() {
        return this.stepChangeListeners.size();
    }

    public void setStep(int i, StepMeta stepMeta) {
        StepMetaInterface iface = stepMeta.getStepMetaInterface();
        if (iface instanceof StepMetaChangeListenerInterface) {
            this.addStepChangeListener(i, (StepMetaChangeListenerInterface)((Object)stepMeta.getStepMetaInterface()));
        }
        this.steps.set(i, stepMeta);
        stepMeta.setParentTransMeta(this);
        this.clearCaches();
    }

    public void setTransHop(int i, TransHopMeta hi) {
        this.hops.set(i, hi);
        this.clearCaches();
    }

    public List<StepMeta> getUsedSteps() {
        List<StepMeta> list = new ArrayList<StepMeta>();
        for (StepMeta stepMeta : this.steps) {
            if (!this.isStepUsedInTransHops(stepMeta)) continue;
            list.add(stepMeta);
        }
        if (list.isEmpty() && this.getSteps().size() == 1) {
            list = this.getSteps();
        }
        return list;
    }

    public StepMeta findStep(String name) {
        return this.findStep(name, null);
    }

    public StepMeta findStep(String name, StepMeta exclude) {
        if (name == null) {
            return null;
        }
        int excl = -1;
        if (exclude != null) {
            excl = this.indexOfStep(exclude);
        }
        for (int i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            if (i == excl || !stepMeta.getName().equalsIgnoreCase(name)) continue;
            return stepMeta;
        }
        return null;
    }

    public TransHopMeta findTransHop(String name) {
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.toString().equalsIgnoreCase(name)) continue;
            return hi;
        }
        return null;
    }

    public TransHopMeta findTransHopFrom(StepMeta fromstep) {
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (hi.getFromStep() == null || !hi.getFromStep().equals(fromstep)) continue;
            return hi;
        }
        return null;
    }

    public List<TransHopMeta> findAllTransHopFrom(StepMeta fromstep) {
        return this.hops.stream().filter(hop -> hop.getFromStep() != null && hop.getFromStep().equals(fromstep)).collect(Collectors.toList());
    }

    public TransHopMeta findTransHop(TransHopMeta hi) {
        return this.findTransHop(hi.getFromStep(), hi.getToStep());
    }

    public TransHopMeta findTransHop(StepMeta from, StepMeta to) {
        return this.findTransHop(from, to, false);
    }

    public TransHopMeta findTransHop(StepMeta from, StepMeta to, boolean disabledToo) {
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.isEnabled() && !disabledToo || hi.getFromStep() == null || hi.getToStep() == null || !hi.getFromStep().equals(from) || !hi.getToStep().equals(to)) continue;
            return hi;
        }
        return null;
    }

    public TransHopMeta findTransHopTo(StepMeta tostep) {
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (hi.getToStep() == null || !hi.getToStep().equals(tostep)) continue;
            return hi;
        }
        return null;
    }

    public boolean isStepInformative(StepMeta this_step, StepMeta prev_step) {
        String[] infoSteps = this_step.getStepMetaInterface().getStepIOMeta().getInfoStepnames();
        if (infoSteps == null) {
            return false;
        }
        for (int i = 0; i < infoSteps.length; ++i) {
            if (!prev_step.getName().equalsIgnoreCase(infoSteps[i])) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public int findNrPrevSteps(String stepname) {
        return this.findNrPrevSteps(this.findStep(stepname), false);
    }

    @Deprecated
    public int findNrPrevSteps(String stepname, boolean info) {
        return this.findNrPrevSteps(this.findStep(stepname), info);
    }

    public int findNrPrevSteps(StepMeta stepMeta) {
        return this.findNrPrevSteps(stepMeta, false);
    }

    @Deprecated
    public StepMeta findPrevStep(String stepname, int nr) {
        return this.findPrevStep(this.findStep(stepname), nr);
    }

    @Deprecated
    public StepMeta findPrevStep(String stepname, int nr, boolean info) {
        return this.findPrevStep(this.findStep(stepname), nr, info);
    }

    public StepMeta findPrevStep(StepMeta stepMeta, int nr) {
        return this.findPrevStep(stepMeta, nr, false);
    }

    @Deprecated
    public int findNrPrevSteps(StepMeta stepMeta, boolean info) {
        int count = 0;
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (hi.getToStep() == null || !hi.isEnabled() || !hi.getToStep().equals(stepMeta) || !info && this.isStepInformative(stepMeta, hi.getFromStep())) continue;
            ++count;
        }
        return count;
    }

    @Deprecated
    public StepMeta findPrevStep(StepMeta stepMeta, int nr, boolean info) {
        int count = 0;
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (hi.getToStep() == null || !hi.isEnabled() || !hi.getToStep().equals(stepMeta) || !info && this.isStepInformative(stepMeta, hi.getFromStep())) continue;
            if (count == nr) {
                return hi.getFromStep();
            }
            ++count;
        }
        return null;
    }

    public List<StepMeta> findPreviousSteps(StepMeta stepMeta) {
        return this.findPreviousSteps(stepMeta, true);
    }

    public List<StepMeta> findPreviousSteps(StepMeta stepMeta, boolean info) {
        String cacheKey = TransMeta.getStepMetaCacheKey(stepMeta, info);
        List<StepMeta> previousSteps = this.previousStepCache.get(cacheKey);
        if (previousSteps == null) {
            previousSteps = new ArrayList<StepMeta>();
            for (TransHopMeta hi : this.hops) {
                if (hi.getToStep() == null || !hi.isEnabled() || !hi.getToStep().equals(stepMeta) || !info && this.isStepInformative(stepMeta, hi.getFromStep())) continue;
                previousSteps.add(hi.getFromStep());
            }
            this.previousStepCache.put(cacheKey, previousSteps);
        }
        return previousSteps;
    }

    public StepMeta[] getInfoStep(StepMeta stepMeta) {
        String[] infoStepName = stepMeta.getStepMetaInterface().getStepIOMeta().getInfoStepnames();
        if (infoStepName == null) {
            return null;
        }
        StepMeta[] infoStep = new StepMeta[infoStepName.length];
        for (int i = 0; i < infoStep.length; ++i) {
            infoStep[i] = this.findStep(infoStepName[i]);
        }
        return infoStep;
    }

    public int findNrInfoSteps(StepMeta stepMeta) {
        if (stepMeta == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (hi == null || hi.getToStep() == null) {
                this.log.logError(BaseMessages.getString(PKG, (String)"TransMeta.Log.DestinationOfHopCannotBeNull", (String[])new String[0]));
            }
            if (hi == null || hi.getToStep() == null || !hi.isEnabled() || !hi.getToStep().equals(stepMeta) || !this.isStepInformative(stepMeta, hi.getFromStep())) continue;
            ++count;
        }
        return count;
    }

    public RowMetaInterface getPrevInfoFields(String stepname) throws KettleStepException {
        return this.getPrevInfoFields(this.findStep(stepname));
    }

    public RowMetaInterface getPrevInfoFields(StepMeta stepMeta) throws KettleStepException {
        for (int i = 0; i < this.nrTransHops(); ++i) {
            StepMeta infoStep;
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.isEnabled() || !hi.getToStep().equals(stepMeta) || !this.isStepInformative(stepMeta, infoStep = hi.getFromStep())) continue;
            RowMetaInterface row = this.getPrevStepFields(infoStep);
            return this.getThisStepFields(infoStep, stepMeta, row);
        }
        return new RowMeta();
    }

    @Deprecated
    public int findNrNextSteps(StepMeta stepMeta) {
        int count = 0;
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.isEnabled() || !hi.getFromStep().equals(stepMeta)) continue;
            ++count;
        }
        return count;
    }

    @Deprecated
    public StepMeta findNextStep(StepMeta stepMeta, int nr) {
        int count = 0;
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.isEnabled() || !hi.getFromStep().equals(stepMeta)) continue;
            if (count == nr) {
                return hi.getToStep();
            }
            ++count;
        }
        return null;
    }

    public StepMeta[] getPrevSteps(StepMeta stepMeta) {
        List<StepMeta> prevSteps = this.previousStepCache.get(TransMeta.getStepMetaCacheKey(stepMeta, true));
        if (prevSteps == null) {
            prevSteps = new ArrayList<StepMeta>();
            for (int i = 0; i < this.nrTransHops(); ++i) {
                TransHopMeta hopMeta = this.getTransHop(i);
                if (!hopMeta.isEnabled() || !hopMeta.getToStep().equals(stepMeta)) continue;
                prevSteps.add(hopMeta.getFromStep());
            }
        }
        return prevSteps.toArray(new StepMeta[prevSteps.size()]);
    }

    public String[] getPrevStepNames(String stepname) {
        return this.getPrevStepNames(this.findStep(stepname));
    }

    public String[] getPrevStepNames(StepMeta stepMeta) {
        StepMeta[] prevStepMetas = this.getPrevSteps(stepMeta);
        String[] retval = new String[prevStepMetas.length];
        for (int x = 0; x < prevStepMetas.length; ++x) {
            retval[x] = prevStepMetas[x].getName();
        }
        return retval;
    }

    @Deprecated
    public StepMeta[] getNextSteps(StepMeta stepMeta) {
        ArrayList<StepMeta> nextSteps = new ArrayList<StepMeta>();
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.isEnabled() || !hi.getFromStep().equals(stepMeta)) continue;
            nextSteps.add(hi.getToStep());
        }
        return nextSteps.toArray(new StepMeta[nextSteps.size()]);
    }

    public List<StepMeta> findNextSteps(StepMeta stepMeta) {
        ArrayList<StepMeta> nextSteps = new ArrayList<StepMeta>();
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.isEnabled() || !hi.getFromStep().equals(stepMeta)) continue;
            nextSteps.add(hi.getToStep());
        }
        return nextSteps;
    }

    public String[] getNextStepNames(StepMeta stepMeta) {
        StepMeta[] nextStepMeta = this.getNextSteps(stepMeta);
        String[] retval = new String[nextStepMeta.length];
        for (int x = 0; x < nextStepMeta.length; ++x) {
            retval[x] = nextStepMeta[x].getName();
        }
        return retval;
    }

    public StepMeta getStep(int x, int y, int iconsize) {
        int s = this.steps.size();
        for (int i = s - 1; i >= 0; --i) {
            Point p;
            StepMeta stepMeta = this.steps.get(i);
            if (!this.partOfTransHop(stepMeta) && !stepMeta.isDrawn() || (p = stepMeta.getLocation()) == null || x < p.x || x > p.x + iconsize || y < p.y || y > p.y + iconsize + 20) continue;
            return stepMeta;
        }
        return null;
    }

    public boolean partOfTransHop(StepMeta stepMeta) {
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (hi.getFromStep() == null || hi.getToStep() == null) {
                return false;
            }
            if (!hi.getFromStep().equals(stepMeta) && !hi.getToStep().equals(stepMeta)) continue;
            return true;
        }
        return false;
    }

    public RowMetaInterface getStepFields(String stepname) throws KettleStepException {
        StepMeta stepMeta = this.findStep(stepname);
        if (stepMeta != null) {
            return this.getStepFields(stepMeta);
        }
        return null;
    }

    public RowMetaInterface getStepFields(StepMeta stepMeta) throws KettleStepException {
        return this.getStepFields(stepMeta, null);
    }

    public RowMetaInterface getStepFields(StepMeta[] stepMeta) throws KettleStepException {
        RowMeta fields = new RowMeta();
        for (int i = 0; i < stepMeta.length; ++i) {
            RowMetaInterface flds = this.getStepFields(stepMeta[i]);
            if (flds == null) continue;
            fields.mergeRowMeta(flds, stepMeta[i].getName());
        }
        return fields;
    }

    public RowMetaInterface getStepFields(StepMeta stepMeta, ProgressMonitorListener monitor) throws KettleStepException {
        this.setRepositoryOnMappingSteps();
        return this.getStepFields(stepMeta, null, monitor);
    }

    public RowMetaInterface getStepFields(StepMeta stepMeta, StepMeta targetStep, ProgressMonitorListener monitor) throws KettleStepException {
        RowMeta row = new RowMeta();
        if (stepMeta == null) {
            return row;
        }
        String fromToCacheEntry = stepMeta.getName() + (targetStep != null ? "-" + targetStep.getName() : "");
        RowMetaInterface rowMeta = this.stepsFieldsCache.get(fromToCacheEntry);
        if (rowMeta != null) {
            return rowMeta;
        }
        if (targetStep != null && stepMeta.isSendingErrorRowsToStep(targetStep)) {
            row = this.getPrevStepFields(stepMeta);
            StepErrorMeta stepErrorMeta = stepMeta.getStepErrorMeta();
            row.addRowMeta(stepErrorMeta.getErrorFields());
            this.stepsFieldsCache.put(fromToCacheEntry, (RowMetaInterface)row);
            return row;
        }
        List<StepMeta> prevSteps = this.findPreviousSteps(stepMeta, false);
        int nrPrevious = prevSteps.size();
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.FromStepALookingAtPreviousStep", (String[])new String[]{stepMeta.getName(), String.valueOf(nrPrevious)}));
        }
        for (int i = 0; i < prevSteps.size(); ++i) {
            RowMetaInterface add;
            StepMeta prevStepMeta = prevSteps.get(i);
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.CheckingStepTask.Title", (String[])new String[]{prevStepMeta.getName()}));
            }
            if ((add = this.getStepFields(prevStepMeta, stepMeta, monitor)) == null) {
                add = new RowMeta();
            }
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.FoundFieldsToAdd", (String[])new String[0]) + add.toString());
            }
            if (i == 0) {
                row.addRowMeta(add);
                continue;
            }
            for (int x = 0; x < add.size(); ++x) {
                ValueMetaInterface v = add.getValueMeta(x);
                ValueMetaInterface s = row.searchValueMeta(v.getName());
                if (s != null) continue;
                row.addValueMeta(v);
            }
        }
        if (nrPrevious == 0 && stepMeta.getRemoteInputSteps().size() > 0) {
            for (RemoteStep remoteStep : stepMeta.getRemoteInputSteps()) {
                RowMetaInterface inputFields = remoteStep.getRowMeta();
                for (ValueMetaInterface inputField : inputFields.getValueMetaList()) {
                    if (row.searchValueMeta(inputField.getName()) != null) continue;
                    row.addValueMeta(inputField);
                }
            }
        }
        rowMeta = this.getThisStepFields(stepMeta, targetStep, (RowMetaInterface)row, monitor);
        this.stepsFieldsCache.put(fromToCacheEntry, rowMeta);
        return rowMeta;
    }

    public RowMetaInterface getPrevStepFields(String stepname) throws KettleStepException {
        return this.getPrevStepFields(this.findStep(stepname));
    }

    public RowMetaInterface getPrevStepFields(StepMeta stepMeta) throws KettleStepException {
        return this.getPrevStepFields(stepMeta, null);
    }

    public RowMetaInterface getPrevStepFields(StepMeta stepMeta, ProgressMonitorListener monitor) throws KettleStepException {
        return this.getPrevStepFields(stepMeta, null, monitor);
    }

    public RowMetaInterface getPrevStepFields(StepMeta stepMeta, String stepName, ProgressMonitorListener monitor) throws KettleStepException {
        this.clearStepFieldsCachce();
        RowMeta row = new RowMeta();
        if (stepMeta == null) {
            return null;
        }
        List<StepMeta> prevSteps = this.findPreviousSteps(stepMeta);
        int nrPrevSteps = prevSteps.size();
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.FromStepALookingAtPreviousStep", (String[])new String[]{stepMeta.getName(), String.valueOf(nrPrevSteps)}));
        }
        StepMeta prevStepMeta = null;
        for (int i = 0; i < nrPrevSteps; ++i) {
            prevStepMeta = prevSteps.get(i);
            if (stepName != null && !stepName.equalsIgnoreCase(prevStepMeta.getName())) continue;
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.CheckingStepTask.Title", (String[])new String[]{prevStepMeta.getName()}));
            }
            RowMetaInterface add = this.getStepFields(prevStepMeta, stepMeta, monitor);
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.FoundFieldsToAdd2", (String[])new String[0]) + add.toString());
            }
            if (i == 0) {
                row.addRowMeta(add);
                continue;
            }
            for (int x = 0; x < add.size(); ++x) {
                ValueMetaInterface v = add.getValueMeta(x);
                ValueMetaInterface s = row.searchValueMeta(v.getName());
                if (s != null) continue;
                row.addValueMeta(v);
            }
        }
        return row;
    }

    public RowMetaInterface getThisStepFields(String stepname, RowMetaInterface row) throws KettleStepException {
        return this.getThisStepFields(this.findStep(stepname), null, row);
    }

    public RowMetaInterface getThisStepFields(StepMeta stepMeta, StepMeta nextStep, RowMetaInterface row) throws KettleStepException {
        return this.getThisStepFields(stepMeta, nextStep, row, null);
    }

    public RowMetaInterface getThisStepFields(StepMeta stepMeta, StepMeta nextStep, RowMetaInterface row, ProgressMonitorListener monitor) throws KettleStepException {
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.GettingFieldsFromStep", (String[])new String[]{stepMeta.getName(), stepMeta.getStepID()}));
        }
        String name = stepMeta.getName();
        if (monitor != null) {
            monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.GettingFieldsFromStepTask.Title", (String[])new String[]{name}));
        }
        StepMetaInterface stepint = stepMeta.getStepMetaInterface();
        RowMetaInterface[] inform = null;
        Object[] lu = this.getInfoStep(stepMeta);
        if (Utils.isEmpty((Object[])lu)) {
            inform = new RowMetaInterface[]{stepint.getTableFields()};
        } else {
            inform = new RowMetaInterface[lu.length];
            for (int i = 0; i < lu.length; ++i) {
                inform[i] = this.getStepFields((StepMeta)lu[i]);
            }
        }
        this.setRepositoryOnMappingSteps();
        RowMetaInterface before = row.clone();
        this.compatibleGetStepFields(stepint, row, name, inform, nextStep, this);
        if (!this.isSomethingDifferentInRow(before, row)) {
            stepint.getFields(before, name, inform, nextStep, this, this.repository, this.metaStore);
            row = before;
        }
        return row;
    }

    private void compatibleGetStepFields(StepMetaInterface stepint, RowMetaInterface row, String name, RowMetaInterface[] inform, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        stepint.getFields(row, name, inform, nextStep, space);
    }

    private boolean isSomethingDifferentInRow(RowMetaInterface before, RowMetaInterface after) {
        if (before.size() != after.size()) {
            return true;
        }
        for (int i = 0; i < before.size(); ++i) {
            ValueMetaInterface beforeValueMeta = before.getValueMeta(i);
            ValueMetaInterface afterValueMeta = after.getValueMeta(i);
            if (this.stringsDifferent(beforeValueMeta.getName(), afterValueMeta.getName())) {
                return true;
            }
            if (beforeValueMeta.getType() != afterValueMeta.getType()) {
                return true;
            }
            if (beforeValueMeta.getLength() != afterValueMeta.getLength()) {
                return true;
            }
            if (beforeValueMeta.getPrecision() != afterValueMeta.getPrecision()) {
                return true;
            }
            if (this.stringsDifferent(beforeValueMeta.getOrigin(), afterValueMeta.getOrigin())) {
                return true;
            }
            if (this.stringsDifferent(beforeValueMeta.getComments(), afterValueMeta.getComments())) {
                return true;
            }
            if (this.stringsDifferent(beforeValueMeta.getConversionMask(), afterValueMeta.getConversionMask())) {
                return true;
            }
            if (this.stringsDifferent(beforeValueMeta.getStringEncoding(), afterValueMeta.getStringEncoding())) {
                return true;
            }
            if (this.stringsDifferent(beforeValueMeta.getDecimalSymbol(), afterValueMeta.getDecimalSymbol())) {
                return true;
            }
            if (!this.stringsDifferent(beforeValueMeta.getGroupingSymbol(), afterValueMeta.getGroupingSymbol())) continue;
            return true;
        }
        return false;
    }

    private boolean stringsDifferent(String one, String two) {
        if (one == null && two == null) {
            return false;
        }
        if (one == null && two != null) {
            return true;
        }
        if (one != null && two == null) {
            return true;
        }
        return !one.equals(two);
    }

    private void setRepositoryOnMappingSteps() {
        for (StepMeta step : this.steps) {
            if (step.getStepMetaInterface() instanceof MappingMeta) {
                ((MappingMeta)step.getStepMetaInterface()).setRepository(this.repository);
                ((MappingMeta)step.getStepMetaInterface()).setMetaStore(this.metaStore);
            }
            if (step.getStepMetaInterface() instanceof SingleThreaderMeta) {
                ((SingleThreaderMeta)step.getStepMetaInterface()).setRepository(this.repository);
                ((SingleThreaderMeta)step.getStepMetaInterface()).setMetaStore(this.metaStore);
            }
            if (step.getStepMetaInterface() instanceof JobExecutorMeta) {
                ((JobExecutorMeta)step.getStepMetaInterface()).setRepository(this.repository);
                ((JobExecutorMeta)step.getStepMetaInterface()).setMetaStore(this.metaStore);
            }
            if (!(step.getStepMetaInterface() instanceof TransExecutorMeta)) continue;
            ((TransExecutorMeta)step.getStepMetaInterface()).setRepository(this.repository);
            ((TransExecutorMeta)step.getStepMetaInterface()).setMetaStore(this.metaStore);
        }
    }

    public boolean isUsingPartitionSchema(PartitionSchema partitionSchema) {
        for (int i = 0; i < this.nrSteps(); ++i) {
            PartitionSchema check;
            StepPartitioningMeta stepPartitioningMeta = this.getStep(i).getStepPartitioningMeta();
            if (stepPartitioningMeta == null || (check = stepPartitioningMeta.getPartitionSchema()) == null || !check.equals(partitionSchema)) continue;
            return true;
        }
        return false;
    }

    public boolean isUsingAClusterSchema() {
        return this.isUsingClusterSchema(null);
    }

    public boolean isUsingClusterSchema(ClusterSchema clusterSchema) {
        for (int i = 0; i < this.nrSteps(); ++i) {
            ClusterSchema check = this.getStep(i).getClusterSchema();
            if (check == null || clusterSchema != null && !check.equals(clusterSchema)) continue;
            return true;
        }
        return false;
    }

    public boolean isUsingSlaveServer(SlaveServer slaveServer) throws KettleException {
        for (int i = 0; i < this.nrSteps(); ++i) {
            ClusterSchema clusterSchema = this.getStep(i).getClusterSchema();
            if (clusterSchema == null) continue;
            for (SlaveServer check : clusterSchema.getSlaveServers()) {
                if (!check.equals(slaveServer)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean isRepReference() {
        return TransMeta.isRepReference(this.getFilename(), this.getName());
    }

    public boolean isFileReference() {
        return !TransMeta.isRepReference(this.getFilename(), this.getName());
    }

    public static boolean isRepReference(String exactFilename, String exactTransname) {
        return Utils.isEmpty((CharSequence)exactFilename) && !Utils.isEmpty((CharSequence)exactTransname);
    }

    public static boolean isFileReference(String exactFilename, String exactTransname) {
        return !TransMeta.isRepReference(exactFilename, exactTransname);
    }

    public int indexOfTransHop(TransHopMeta hi) {
        return this.hops.indexOf(hi);
    }

    public int indexOfStep(StepMeta stepMeta) {
        return this.steps.indexOf(stepMeta);
    }

    @Override
    public String getFileType() {
        return "Trans";
    }

    @Override
    public String[] getFilterNames() {
        return Const.getTransformationFilterNames();
    }

    @Override
    public String[] getFilterExtensions() {
        return Const.STRING_TRANS_FILTER_EXT;
    }

    @Override
    public String getDefaultExtension() {
        return "ktr";
    }

    @Override
    public String getXML() throws KettleException {
        return this.getXML(true, true, true, true, true);
    }

    public String getXML(boolean includeSteps, boolean includeDatabase, boolean includeSlaves, boolean includeClusters, boolean includePartitions) throws KettleException {
        return this.getXML(true, true, true, true, true, true, true, true, true, true);
    }

    public String getXML(boolean includeSteps, boolean includeDatabase, boolean includeSlaves, boolean includeClusters, boolean includePartitions, boolean includeNamedParameters, boolean includeLog, boolean includeDependencies, boolean includeNotePads, boolean includeAttributeGroups) throws KettleException {
        this.getNamedClusterEmbedManager().clear();
        Props props = null;
        if (Props.isInitialized()) {
            props = Props.getInstance();
        }
        StringBuilder retval = new StringBuilder(800);
        retval.append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        retval.append("  ").append(XMLHandler.openTag((String)XML_TAG_INFO)).append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"name", (String)this.name));
        retval.append("    ").append(XMLHandler.addTagValue((String)"description", (String)this.description));
        retval.append("    ").append(XMLHandler.addTagValue((String)"extended_description", (String)this.extendedDescription));
        retval.append("    ").append(XMLHandler.addTagValue((String)"trans_version", (String)this.trans_version));
        retval.append("    ").append(XMLHandler.addTagValue((String)"trans_type", (String)this.transformationType.getCode()));
        if (this.trans_status >= 0) {
            retval.append("    ").append(XMLHandler.addTagValue((String)"trans_status", (int)this.trans_status));
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"directory", (String)(this.directory != null ? this.directory.getPath() : "/")));
        if (includeNamedParameters) {
            retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_PARAMETERS)).append(Const.CR);
            String[] parameters = this.listParameters();
            for (int idx = 0; idx < parameters.length; ++idx) {
                retval.append("      ").append(XMLHandler.openTag((String)"parameter")).append(Const.CR);
                retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)parameters[idx]));
                retval.append("        ").append(XMLHandler.addTagValue((String)"default_value", (String)this.getParameterDefault(parameters[idx])));
                retval.append("        ").append(XMLHandler.addTagValue((String)"description", (String)this.getParameterDescription(parameters[idx])));
                retval.append("      ").append(XMLHandler.closeTag((String)"parameter")).append(Const.CR);
            }
            retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_PARAMETERS)).append(Const.CR);
        }
        if (includeLog) {
            retval.append("    ").append(XMLHandler.openTag((String)"log")).append(Const.CR);
            retval.append(this.transLogTable.getXML());
            retval.append(this.performanceLogTable.getXML());
            retval.append(this.channelLogTable.getXML());
            retval.append(this.stepLogTable.getXML());
            retval.append(this.metricsLogTable.getXML());
            retval.append("    ").append(XMLHandler.closeTag((String)"log")).append(Const.CR);
        }
        retval.append("    ").append(XMLHandler.openTag((String)"maxdate")).append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", (String)(this.maxDateConnection == null ? "" : this.maxDateConnection.getName())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"table", (String)this.maxDateTable));
        retval.append("      ").append(XMLHandler.addTagValue((String)"field", (String)this.maxDateField));
        retval.append("      ").append(XMLHandler.addTagValue((String)"offset", (double)this.maxDateOffset));
        retval.append("      ").append(XMLHandler.addTagValue((String)"maxdiff", (double)this.maxDateDifference));
        retval.append("    ").append(XMLHandler.closeTag((String)"maxdate")).append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"size_rowset", (int)this.sizeRowset));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sleep_time_empty", (int)this.sleepTimeEmpty));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sleep_time_full", (int)this.sleepTimeFull));
        retval.append("    ").append(XMLHandler.addTagValue((String)"unique_connections", (boolean)this.usingUniqueConnections));
        retval.append("    ").append(XMLHandler.addTagValue((String)"feedback_shown", (boolean)this.feedbackShown));
        retval.append("    ").append(XMLHandler.addTagValue((String)"feedback_size", (int)this.feedbackSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"using_thread_priorities", (boolean)this.usingThreadPriorityManagment));
        retval.append("    ").append(XMLHandler.addTagValue((String)"shared_objects_file", (String)this.sharedObjectsFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"capture_step_performance", (boolean)this.capturingStepPerformanceSnapShots));
        retval.append("    ").append(XMLHandler.addTagValue((String)"step_performance_capturing_delay", (long)this.stepPerformanceCapturingDelay));
        retval.append("    ").append(XMLHandler.addTagValue((String)"step_performance_capturing_size_limit", (String)this.stepPerformanceCapturingSizeLimit));
        if (includeDependencies) {
            retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_DEPENDENCIES)).append(Const.CR);
            for (int i = 0; i < this.nrDependencies(); ++i) {
                TransDependency td = this.getDependency(i);
                retval.append(td.getXML());
            }
            retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_DEPENDENCIES)).append(Const.CR);
        }
        if (includePartitions) {
            retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_PARTITIONSCHEMAS)).append(Const.CR);
            for (int i = 0; i < this.partitionSchemas.size(); ++i) {
                PartitionSchema partitionSchema = this.partitionSchemas.get(i);
                retval.append(partitionSchema.getXML());
            }
            retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_PARTITIONSCHEMAS)).append(Const.CR);
        }
        if (includeSlaves) {
            retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_SLAVESERVERS)).append(Const.CR);
            for (int i = 0; i < this.slaveServers.size(); ++i) {
                SlaveServer slaveServer = (SlaveServer)this.slaveServers.get(i);
                retval.append(slaveServer.getXML());
            }
            retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_SLAVESERVERS)).append(Const.CR);
        }
        if (includeClusters) {
            retval.append("    ").append(XMLHandler.openTag((String)XML_TAG_CLUSTERSCHEMAS)).append(Const.CR);
            for (int i = 0; i < this.clusterSchemas.size(); ++i) {
                ClusterSchema clusterSchema = this.clusterSchemas.get(i);
                retval.append(clusterSchema.getXML());
            }
            retval.append("    ").append(XMLHandler.closeTag((String)XML_TAG_CLUSTERSCHEMAS)).append(Const.CR);
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"created_user", (String)this.createdUser));
        retval.append("    ").append(XMLHandler.addTagValue((String)"created_date", (String)XMLHandler.date2string((Date)this.createdDate)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"modified_user", (String)this.modifiedUser));
        retval.append("    ").append(XMLHandler.addTagValue((String)"modified_date", (String)XMLHandler.date2string((Date)this.modifiedDate)));
        try {
            retval.append("    ").append(XMLHandler.addTagValue((String)"key_for_session_key", (byte[])this.keyForSessionKey));
        }
        catch (Exception ex) {
            this.log.logError("Unable to decode key", (Throwable)ex);
        }
        retval.append("    ").append(XMLHandler.addTagValue((String)"is_key_private", (boolean)this.isKeyPrivate));
        retval.append("  ").append(XMLHandler.closeTag((String)XML_TAG_INFO)).append(Const.CR);
        if (includeNotePads) {
            retval.append("  ").append(XMLHandler.openTag((String)XML_TAG_NOTEPADS)).append(Const.CR);
            if (this.notes != null) {
                for (int i = 0; i < this.nrNotes(); ++i) {
                    NotePadMeta ni = this.getNote(i);
                    retval.append(ni.getXML());
                }
            }
            retval.append("  ").append(XMLHandler.closeTag((String)XML_TAG_NOTEPADS)).append(Const.CR);
        }
        if (includeDatabase) {
            for (int i = 0; i < this.nrDatabases(); ++i) {
                DatabaseMeta dbMeta = this.getDatabase(i);
                if (props != null && props.areOnlyUsedConnectionsSavedToXML()) {
                    if (!this.isDatabaseConnectionUsed(dbMeta)) continue;
                    retval.append(dbMeta.getXML());
                    continue;
                }
                retval.append(dbMeta.getXML());
            }
        }
        if (includeSteps) {
            int i;
            retval.append("  ").append(XMLHandler.openTag((String)XML_TAG_ORDER)).append(Const.CR);
            for (i = 0; i < this.nrTransHops(); ++i) {
                TransHopMeta transHopMeta = this.getTransHop(i);
                retval.append(transHopMeta.getXML());
            }
            retval.append("  ").append(XMLHandler.closeTag((String)XML_TAG_ORDER)).append(Const.CR);
            for (i = 0; i < this.nrSteps(); ++i) {
                StepMeta stepMeta = this.getStep(i);
                if (stepMeta.getStepMetaInterface() instanceof HasRepositoryInterface) {
                    ((HasRepositoryInterface)((Object)stepMeta.getStepMetaInterface())).setRepository(this.repository);
                }
                retval.append(stepMeta.getXML());
            }
            retval.append("  ").append(XMLHandler.openTag((String)XML_TAG_STEP_ERROR_HANDLING)).append(Const.CR);
            for (i = 0; i < this.nrSteps(); ++i) {
                StepMeta stepMeta = this.getStep(i);
                if (stepMeta.getStepErrorMeta() == null) continue;
                retval.append(stepMeta.getStepErrorMeta().getXML());
            }
            retval.append("  ").append(XMLHandler.closeTag((String)XML_TAG_STEP_ERROR_HANDLING)).append(Const.CR);
        }
        retval.append(this.slaveStepCopyPartitionDistribution.getXML());
        retval.append("  ").append(XMLHandler.addTagValue((String)"slave_transformation", (boolean)this.slaveTransformation));
        if (includeAttributeGroups) {
            retval.append(AttributesUtil.getAttributesXml(this.attributesMap));
        }
        retval.append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return XMLFormatter.format((String)retval.toString());
    }

    public TransMeta(String fname) throws KettleXMLException, KettleMissingPluginsException {
        this(fname, true);
    }

    public TransMeta(String fname, VariableSpace parentVariableSpace) throws KettleXMLException, KettleMissingPluginsException {
        this(fname, null, true, parentVariableSpace);
    }

    public TransMeta(String fname, boolean setInternalVariables) throws KettleXMLException, KettleMissingPluginsException {
        this(fname, null, setInternalVariables);
    }

    public TransMeta(String fname, Repository rep) throws KettleXMLException, KettleMissingPluginsException {
        this(fname, rep, true);
    }

    public TransMeta(String fname, Repository rep, boolean setInternalVariables) throws KettleXMLException, KettleMissingPluginsException {
        this(fname, rep, setInternalVariables, null);
    }

    public TransMeta(String fname, Repository rep, boolean setInternalVariables, VariableSpace parentVariableSpace) throws KettleXMLException, KettleMissingPluginsException {
        this(fname, rep, setInternalVariables, parentVariableSpace, null);
    }

    public TransMeta(String fname, Repository rep, boolean setInternalVariables, VariableSpace parentVariableSpace, OverwritePrompter prompter) throws KettleXMLException, KettleMissingPluginsException {
        this(fname, null, rep, setInternalVariables, parentVariableSpace, prompter);
    }

    public TransMeta(String fname, IMetaStore metaStore, Repository rep, boolean setInternalVariables, VariableSpace parentVariableSpace, OverwritePrompter prompter) throws KettleXMLException, KettleMissingPluginsException {
        Node transnode;
        if (StringUtils.isBlank((String)fname)) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.MissingXMLFilePath", (String[])new String[0]));
        }
        this.metaStore = metaStore;
        this.repository = rep;
        Document doc = null;
        try {
            FileObject transFile = KettleVFS.getFileObject((String)fname, (VariableSpace)parentVariableSpace);
            if (!transFile.exists()) {
                throw new KettleXMLException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.InvalidXMLPath", (String[])new String[]{fname}));
            }
            doc = XMLHandler.loadXMLFile((FileObject)transFile);
        }
        catch (KettleXMLException ke) {
            throw ke;
        }
        catch (FileSystemException | KettleException e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.ErrorOpeningOrValidatingTheXMLFile", (String[])new String[]{fname}), e);
        }
        if (doc != null) {
            transnode = XMLHandler.getSubNode((Node)doc, (String)XML_TAG);
            if (transnode == null) {
                throw new KettleXMLException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.NotValidTransformationXML", (String[])new String[]{fname}));
            }
        } else {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.ErrorOpeningOrValidatingTheXMLFile", (String[])new String[]{fname}));
        }
        this.loadXML(transnode, fname, metaStore, rep, setInternalVariables, parentVariableSpace, prompter);
    }

    public TransMeta(InputStream xmlStream, Repository rep, boolean setInternalVariables, VariableSpace parentVariableSpace, OverwritePrompter prompter) throws KettleXMLException, KettleMissingPluginsException {
        Document doc = XMLHandler.loadXMLFile((InputStream)xmlStream, null, (boolean)false, (boolean)false);
        Node transnode = XMLHandler.getSubNode((Node)doc, (String)XML_TAG);
        this.loadXML(transnode, rep, setInternalVariables, parentVariableSpace, prompter);
    }

    public TransMeta(Node transnode, Repository rep) throws KettleXMLException, KettleMissingPluginsException {
        this.loadXML(transnode, rep, false);
    }

    public void loadXML(Node transnode, Repository rep, boolean setInternalVariables) throws KettleXMLException, KettleMissingPluginsException {
        this.loadXML(transnode, rep, setInternalVariables, null);
    }

    public void loadXML(Node transnode, Repository rep, boolean setInternalVariables, VariableSpace parentVariableSpace) throws KettleXMLException, KettleMissingPluginsException {
        this.loadXML(transnode, rep, setInternalVariables, parentVariableSpace, null);
    }

    public void loadXML(Node transnode, Repository rep, boolean setInternalVariables, VariableSpace parentVariableSpace, OverwritePrompter prompter) throws KettleXMLException, KettleMissingPluginsException {
        this.loadXML(transnode, null, rep, setInternalVariables, parentVariableSpace, prompter);
    }

    public void loadXML(Node transnode, String fname, Repository rep, boolean setInternalVariables, VariableSpace parentVariableSpace, OverwritePrompter prompter) throws KettleXMLException, KettleMissingPluginsException {
        this.loadXML(transnode, fname, null, rep, setInternalVariables, parentVariableSpace, prompter);
    }

    public void loadXML(Node transnode, String fname, IMetaStore metaStore, Repository rep, boolean setInternalVariables, VariableSpace parentVariableSpace, OverwritePrompter prompter) throws KettleXMLException, KettleMissingPluginsException {
        KettleMissingPluginsException missingPluginsException = new KettleMissingPluginsException(BaseMessages.getString(PKG, (String)"TransMeta.MissingPluginsFoundWhileLoadingTransformation.Exception", (String[])new String[0]));
        this.metaStore = metaStore;
        try {
            Props props = null;
            if (Props.isInitialized()) {
                props = Props.getInstance();
            }
            this.initializeVariablesFrom(parentVariableSpace);
            try {
                Node partitionDistNode;
                int i;
                int i2;
                Node logNode;
                String directoryPath;
                int i3;
                this.clear();
                if (null == rep) {
                    this.setFilename(fname);
                } else {
                    this.setRepository(rep);
                }
                try {
                    this.sharedObjectsFile = XMLHandler.getTagValue((Node)transnode, (String)XML_TAG_INFO, (String)"shared_objects_file");
                    this.sharedObjects = rep != null ? rep.readTransSharedObjects(this) : this.readSharedObjects();
                }
                catch (Exception e) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"TransMeta.ErrorReadingSharedObjects.Message", (String[])new String[]{e.toString()}));
                    this.log.logError(Const.getStackTracker((Throwable)e));
                }
                this.importFromMetaStore();
                int n = XMLHandler.countNodes((Node)transnode, (String)"connection");
                HashSet<String> privateTransformationDatabases = new HashSet<String>(n);
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.WeHaveConnections", (String[])new String[]{String.valueOf(n)}));
                }
                for (int i4 = 0; i4 < n; ++i4) {
                    DatabaseMeta exist;
                    if (this.log.isDebug()) {
                        this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.LookingAtConnection", (String[])new String[0]) + i4);
                    }
                    Node nodecon = XMLHandler.getSubNodeByNr((Node)transnode, (String)"connection", (int)i4);
                    DatabaseMeta dbcon = new DatabaseMeta(nodecon);
                    dbcon.shareVariablesWith((VariableSpace)this);
                    if (!dbcon.isShared()) {
                        privateTransformationDatabases.add(dbcon.getName());
                    }
                    if ((exist = this.findDatabase(dbcon.getName())) == null) {
                        this.addDatabase(dbcon);
                        continue;
                    }
                    if (exist.isShared() || !this.shouldOverwrite(prompter, props, BaseMessages.getString(PKG, (String)"TransMeta.Message.OverwriteConnectionYN", (String[])new String[]{dbcon.getName()}), BaseMessages.getString(PKG, (String)"TransMeta.Message.OverwriteConnection.DontShowAnyMoreMessage", (String[])new String[0]))) continue;
                    int idx = this.indexOfDatabase(exist);
                    this.removeDatabase(idx);
                    this.addDatabase(idx, dbcon);
                }
                this.setPrivateDatabases(privateTransformationDatabases);
                Node notepadsnode = XMLHandler.getSubNode((Node)transnode, (String)XML_TAG_NOTEPADS);
                int nrnotes = XMLHandler.countNodes((Node)notepadsnode, (String)"notepad");
                for (int i5 = 0; i5 < nrnotes; ++i5) {
                    Node notepadnode = XMLHandler.getSubNodeByNr((Node)notepadsnode, (String)"notepad", (int)i5);
                    NotePadMeta ni = new NotePadMeta(notepadnode);
                    this.notes.add(ni);
                }
                int s = XMLHandler.countNodes((Node)transnode, (String)"step");
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.ReadingSteps", (String[])new String[0]) + s + " steps...");
                }
                for (int i6 = 0; i6 < s; ++i6) {
                    StepMeta check;
                    Node stepnode = XMLHandler.getSubNodeByNr((Node)transnode, (String)"step", (int)i6);
                    if (this.log.isDebug()) {
                        this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.LookingAtStep", (String[])new String[0]) + i6);
                    }
                    StepMeta stepMeta = new StepMeta(stepnode, (List<DatabaseMeta>)this.databases, metaStore);
                    stepMeta.setParentTransMeta(this);
                    if (stepMeta.isMissing()) {
                        this.addMissingTrans((MissingTrans)stepMeta.getStepMetaInterface());
                    }
                    if ((check = this.findStep(stepMeta.getName())) != null) {
                        if (!check.isShared()) {
                            this.addOrReplaceStep(stepMeta);
                            continue;
                        }
                        check.setDraw(stepMeta.isDrawn());
                        check.setLocation(stepMeta.getLocation());
                        continue;
                    }
                    this.addStep(stepMeta);
                }
                Node errorHandlingNode = XMLHandler.getSubNode((Node)transnode, (String)XML_TAG_STEP_ERROR_HANDLING);
                int nrErrorHandlers = XMLHandler.countNodes((Node)errorHandlingNode, (String)"error");
                for (i3 = 0; i3 < nrErrorHandlers; ++i3) {
                    Node stepErrorMetaNode = XMLHandler.getSubNodeByNr((Node)errorHandlingNode, (String)"error", (int)i3);
                    StepErrorMeta stepErrorMeta = new StepErrorMeta((VariableSpace)this, stepErrorMetaNode, this.steps);
                    if (stepErrorMeta.getSourceStep() == null) continue;
                    stepErrorMeta.getSourceStep().setStepErrorMeta(stepErrorMeta);
                }
                for (i3 = 0; i3 < this.nrSteps(); ++i3) {
                    StepMeta stepMeta = this.getStep(i3);
                    StepMetaInterface sii = stepMeta.getStepMetaInterface();
                    if (sii == null) continue;
                    sii.searchInfoAndTargetSteps(this.steps);
                }
                Node ordernode = XMLHandler.getSubNode((Node)transnode, (String)XML_TAG_ORDER);
                n = XMLHandler.countNodes((Node)ordernode, (String)"hop");
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.WeHaveHops", (String[])new String[0]) + n + " hops...");
                }
                for (int i7 = 0; i7 < n; ++i7) {
                    if (this.log.isDebug()) {
                        this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.LookingAtHop", (String[])new String[0]) + i7);
                    }
                    Node hopnode = XMLHandler.getSubNodeByNr((Node)ordernode, (String)"hop", (int)i7);
                    TransHopMeta hopinf = new TransHopMeta(hopnode, this.steps);
                    hopinf.setErrorHop(this.isErrorNode(errorHandlingNode, hopnode));
                    this.addTransHop(hopinf);
                }
                Node infonode = XMLHandler.getSubNode((Node)transnode, (String)XML_TAG_INFO);
                this.setName(XMLHandler.getTagValue((Node)infonode, (String)"name"));
                this.description = XMLHandler.getTagValue((Node)infonode, (String)"description");
                this.extendedDescription = XMLHandler.getTagValue((Node)infonode, (String)"extended_description");
                this.trans_version = XMLHandler.getTagValue((Node)infonode, (String)"trans_version");
                this.trans_status = Const.toInt((String)XMLHandler.getTagValue((Node)infonode, (String)"trans_status"), (int)-1);
                String transTypeCode = XMLHandler.getTagValue((Node)infonode, (String)"trans_type");
                this.transformationType = TransformationType.getTransformationTypeByCode(transTypeCode);
                if (rep != null && (directoryPath = XMLHandler.getTagValue((Node)infonode, (String)"directory")) != null) {
                    this.directory = rep.findDirectory(directoryPath);
                    if (this.directory == null) {
                        this.directory = new RepositoryDirectory();
                    }
                }
                if ((logNode = XMLHandler.getSubNode((Node)infonode, (String)"log")) != null) {
                    Node metricsLogNode;
                    Node stepLogNode;
                    Node channelLogNode;
                    Node transLogNode = XMLHandler.getSubNode((Node)logNode, (String)"trans-log-table");
                    if (transLogNode == null) {
                        this.transLogTable.findField(TransLogTable.ID.LINES_READ).setSubject((Object)this.findStep(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"read")));
                        this.transLogTable.findField(TransLogTable.ID.LINES_WRITTEN).setSubject((Object)this.findStep(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"write")));
                        this.transLogTable.findField(TransLogTable.ID.LINES_INPUT).setSubject((Object)this.findStep(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"input")));
                        this.transLogTable.findField(TransLogTable.ID.LINES_OUTPUT).setSubject((Object)this.findStep(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"output")));
                        this.transLogTable.findField(TransLogTable.ID.LINES_UPDATED).setSubject((Object)this.findStep(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"update")));
                        this.transLogTable.findField(TransLogTable.ID.LINES_REJECTED).setSubject((Object)this.findStep(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"rejected")));
                        this.transLogTable.setConnectionName(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"connection"));
                        this.transLogTable.setSchemaName(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"schema"));
                        this.transLogTable.setTableName(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"table"));
                        this.transLogTable.findField(TransLogTable.ID.ID_BATCH).setEnabled("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"use_batchid")));
                        this.transLogTable.findField(TransLogTable.ID.LOG_FIELD).setEnabled("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"USE_LOGFIELD")));
                        this.transLogTable.setLogSizeLimit(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"size_limit_lines"));
                        this.transLogTable.setLogInterval(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"interval"));
                        this.transLogTable.findField(TransLogTable.ID.CHANNEL_ID).setEnabled(false);
                        this.transLogTable.findField(TransLogTable.ID.LINES_REJECTED).setEnabled(false);
                        this.performanceLogTable.setConnectionName(this.transLogTable.getConnectionName());
                        this.performanceLogTable.setTableName(XMLHandler.getTagValue((Node)infonode, (String)"log", (String)"step_performance_table"));
                    } else {
                        this.transLogTable.loadXML(transLogNode, this.databases, this.steps);
                    }
                    Node perfLogNode = XMLHandler.getSubNode((Node)logNode, (String)"perf-log-table");
                    if (perfLogNode != null) {
                        this.performanceLogTable.loadXML(perfLogNode, this.databases, this.steps);
                    }
                    if ((channelLogNode = XMLHandler.getSubNode((Node)logNode, (String)"channel-log-table")) != null) {
                        this.channelLogTable.loadXML(channelLogNode, this.databases, this.steps);
                    }
                    if ((stepLogNode = XMLHandler.getSubNode((Node)logNode, (String)"step-log-table")) != null) {
                        this.stepLogTable.loadXML(stepLogNode, this.databases, this.steps);
                    }
                    if ((metricsLogNode = XMLHandler.getSubNode((Node)logNode, (String)"metrics-log-table")) != null) {
                        this.metricsLogTable.loadXML(metricsLogNode, this.databases, this.steps);
                    }
                }
                String maxdatcon = XMLHandler.getTagValue((Node)infonode, (String)"maxdate", (String)"connection");
                this.maxDateConnection = this.findDatabase(maxdatcon);
                this.maxDateTable = XMLHandler.getTagValue((Node)infonode, (String)"maxdate", (String)"table");
                this.maxDateField = XMLHandler.getTagValue((Node)infonode, (String)"maxdate", (String)"field");
                String offset = XMLHandler.getTagValue((Node)infonode, (String)"maxdate", (String)"offset");
                this.maxDateOffset = Const.toDouble((String)offset, (double)0.0);
                String mdiff = XMLHandler.getTagValue((Node)infonode, (String)"maxdate", (String)"maxdiff");
                this.maxDateDifference = Const.toDouble((String)mdiff, (double)0.0);
                Node depsNode = XMLHandler.getSubNode((Node)infonode, (String)XML_TAG_DEPENDENCIES);
                int nrDeps = XMLHandler.countNodes((Node)depsNode, (String)"dependency");
                for (int i8 = 0; i8 < nrDeps; ++i8) {
                    Node depNode = XMLHandler.getSubNodeByNr((Node)depsNode, (String)"dependency", (int)i8);
                    TransDependency transDependency = new TransDependency(depNode, this.databases);
                    if (transDependency.getDatabase() == null || transDependency.getFieldname() == null) continue;
                    this.addDependency(transDependency);
                }
                Node paramsNode = XMLHandler.getSubNode((Node)infonode, (String)XML_TAG_PARAMETERS);
                int nrParams = XMLHandler.countNodes((Node)paramsNode, (String)"parameter");
                for (int i9 = 0; i9 < nrParams; ++i9) {
                    Node paramNode = XMLHandler.getSubNodeByNr((Node)paramsNode, (String)"parameter", (int)i9);
                    String paramName = XMLHandler.getTagValue((Node)paramNode, (String)"name");
                    String defaultValue = XMLHandler.getTagValue((Node)paramNode, (String)"default_value");
                    String descr = XMLHandler.getTagValue((Node)paramNode, (String)"description");
                    this.addParameterDefinition(paramName, defaultValue, descr);
                }
                Node partSchemasNode = XMLHandler.getSubNode((Node)infonode, (String)XML_TAG_PARTITIONSCHEMAS);
                int nrPartSchemas = XMLHandler.countNodes((Node)partSchemasNode, (String)"partitionschema");
                for (i2 = 0; i2 < nrPartSchemas; ++i2) {
                    Node partSchemaNode = XMLHandler.getSubNodeByNr((Node)partSchemasNode, (String)"partitionschema", (int)i2);
                    PartitionSchema partitionSchema = new PartitionSchema(partSchemaNode);
                    PartitionSchema check = this.findPartitionSchema(partitionSchema.getName());
                    if (check != null) {
                        if (check.isShared() || !this.shouldOverwrite(prompter, props, BaseMessages.getString(PKG, (String)"TransMeta.Message.OverwritePartitionSchemaYN", (String[])new String[]{partitionSchema.getName()}), BaseMessages.getString(PKG, (String)"TransMeta.Message.OverwriteConnection.DontShowAnyMoreMessage", (String[])new String[0]))) continue;
                        this.addOrReplacePartitionSchema(partitionSchema);
                        continue;
                    }
                    this.partitionSchemas.add(partitionSchema);
                }
                for (i2 = 0; i2 < this.nrSteps(); ++i2) {
                    StepPartitioningMeta targetStepPartitioningMeta;
                    StepPartitioningMeta stepPartitioningMeta = this.getStep(i2).getStepPartitioningMeta();
                    if (stepPartitioningMeta != null) {
                        stepPartitioningMeta.setPartitionSchemaAfterLoading(this.partitionSchemas);
                    }
                    if ((targetStepPartitioningMeta = this.getStep(i2).getTargetStepPartitioningMeta()) == null) continue;
                    targetStepPartitioningMeta.setPartitionSchemaAfterLoading(this.partitionSchemas);
                }
                Node slaveServersNode = XMLHandler.getSubNode((Node)infonode, (String)XML_TAG_SLAVESERVERS);
                int nrSlaveServers = XMLHandler.countNodes((Node)slaveServersNode, (String)"slaveserver");
                for (int i10 = 0; i10 < nrSlaveServers; ++i10) {
                    Node slaveServerNode = XMLHandler.getSubNodeByNr((Node)slaveServersNode, (String)"slaveserver", (int)i10);
                    SlaveServer slaveServer = new SlaveServer(slaveServerNode);
                    if (slaveServer.getName() == null) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"TransMeta.Log.WarningWhileCreationSlaveServer", (String[])new String[]{slaveServer.getName()}));
                        continue;
                    }
                    slaveServer.shareVariablesWith(this);
                    SlaveServer check = this.findSlaveServer(slaveServer.getName());
                    if (check != null) {
                        if (check.isShared() || !this.shouldOverwrite(prompter, props, BaseMessages.getString(PKG, (String)"TransMeta.Message.OverwriteSlaveServerYN", (String[])new String[]{slaveServer.getName()}), BaseMessages.getString(PKG, (String)"TransMeta.Message.OverwriteConnection.DontShowAnyMoreMessage", (String[])new String[0]))) continue;
                        this.addOrReplaceSlaveServer(slaveServer);
                        continue;
                    }
                    this.slaveServers.add(slaveServer);
                }
                Node clusterSchemasNode = XMLHandler.getSubNode((Node)infonode, (String)XML_TAG_CLUSTERSCHEMAS);
                int nrClusterSchemas = XMLHandler.countNodes((Node)clusterSchemasNode, (String)"clusterschema");
                for (i = 0; i < nrClusterSchemas; ++i) {
                    Node clusterSchemaNode = XMLHandler.getSubNodeByNr((Node)clusterSchemasNode, (String)"clusterschema", (int)i);
                    ClusterSchema clusterSchema = new ClusterSchema(clusterSchemaNode, (List<SlaveServer>)this.slaveServers);
                    clusterSchema.shareVariablesWith(this);
                    ClusterSchema check = this.findClusterSchema(clusterSchema.getName());
                    if (check != null) {
                        if (check.isShared() || !this.shouldOverwrite(prompter, props, BaseMessages.getString(PKG, (String)"TransMeta.Message.OverwriteClusterSchemaYN", (String[])new String[]{clusterSchema.getName()}), BaseMessages.getString(PKG, (String)"TransMeta.Message.OverwriteConnection.DontShowAnyMoreMessage", (String[])new String[0]))) continue;
                        this.addOrReplaceClusterSchema(clusterSchema);
                        continue;
                    }
                    this.clusterSchemas.add(clusterSchema);
                }
                for (i = 0; i < this.nrSteps(); ++i) {
                    this.getStep(i).setClusterSchemaAfterLoading(this.clusterSchemas);
                }
                String srowset = XMLHandler.getTagValue((Node)infonode, (String)"size_rowset");
                this.sizeRowset = Const.toInt((String)srowset, (int)10000);
                this.sleepTimeEmpty = Const.toInt((String)XMLHandler.getTagValue((Node)infonode, (String)"sleep_time_empty"), (int)50);
                this.sleepTimeFull = Const.toInt((String)XMLHandler.getTagValue((Node)infonode, (String)"sleep_time_full"), (int)50);
                this.usingUniqueConnections = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)infonode, (String)"unique_connections"));
                this.feedbackShown = !"N".equalsIgnoreCase(XMLHandler.getTagValue((Node)infonode, (String)"feedback_shown"));
                this.feedbackSize = Const.toInt((String)XMLHandler.getTagValue((Node)infonode, (String)"feedback_size"), (int)50000);
                this.usingThreadPriorityManagment = !"N".equalsIgnoreCase(XMLHandler.getTagValue((Node)infonode, (String)"using_thread_priorities"));
                this.capturingStepPerformanceSnapShots = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)infonode, (String)"capture_step_performance"));
                this.stepPerformanceCapturingDelay = Const.toLong((String)XMLHandler.getTagValue((Node)infonode, (String)"step_performance_capturing_delay"), (long)1000L);
                this.stepPerformanceCapturingSizeLimit = XMLHandler.getTagValue((Node)infonode, (String)"step_performance_capturing_size_limit");
                this.createdUser = XMLHandler.getTagValue((Node)infonode, (String)"created_user");
                String createDate = XMLHandler.getTagValue((Node)infonode, (String)"created_date");
                if (createDate != null) {
                    this.createdDate = XMLHandler.stringToDate((String)createDate);
                }
                this.modifiedUser = XMLHandler.getTagValue((Node)infonode, (String)"modified_user");
                String modDate = XMLHandler.getTagValue((Node)infonode, (String)"modified_date");
                if (modDate != null) {
                    this.modifiedDate = XMLHandler.stringToDate((String)modDate);
                }
                this.slaveStepCopyPartitionDistribution = (partitionDistNode = XMLHandler.getSubNode((Node)transnode, (String)"slave-step-copy-partition-distribution")) != null ? new SlaveStepCopyPartitionDistribution(partitionDistNode) : new SlaveStepCopyPartitionDistribution();
                this.slaveTransformation = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)transnode, (String)"slave_transformation"));
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.NumberOfStepsReaded", (String[])new String[0]) + this.nrSteps());
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"TransMeta.Log.NumberOfHopsReaded", (String[])new String[0]) + this.nrTransHops());
                }
                this.sortSteps();
                this.attributesMap = AttributesUtil.loadAttributes(XMLHandler.getSubNode((Node)transnode, (String)"attributes"));
                this.keyForSessionKey = XMLHandler.stringToBinary((String)XMLHandler.getTagValue((Node)infonode, (String)"key_for_session_key"));
                this.isKeyPrivate = "Y".equals(XMLHandler.getTagValue((Node)infonode, (String)"is_key_private"));
            }
            catch (KettleXMLException xe) {
                throw new KettleXMLException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.ErrorReadingTransformation", (String[])new String[0]), (Throwable)xe);
            }
            catch (KettleException e) {
                throw new KettleXMLException((Throwable)e);
            }
            finally {
                this.initializeVariablesFrom(null);
                if (setInternalVariables) {
                    this.setInternalKettleVariables();
                }
                ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.TransformationMetaLoaded.id, (Object)this);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.ErrorReadingTransformation", (String[])new String[0]), (Throwable)e);
        }
        finally {
            if (!missingPluginsException.getMissingPluginDetailsList().isEmpty()) {
                throw missingPluginsException;
            }
        }
    }

    public byte[] getKey() {
        return this.keyForSessionKey;
    }

    public void setKey(byte[] key) {
        this.keyForSessionKey = key;
    }

    public boolean isPrivateKey() {
        return this.isKeyPrivate;
    }

    public void setPrivateKey(boolean privateKey) {
        this.isKeyPrivate = privateKey;
    }

    @Override
    public boolean loadSharedObject(SharedObjectInterface object) {
        if (!super.loadSharedObject(object)) {
            if (object instanceof StepMeta) {
                StepMeta stepMeta = (StepMeta)object;
                this.addOrReplaceStep(stepMeta);
            } else if (object instanceof PartitionSchema) {
                PartitionSchema partitionSchema = (PartitionSchema)object;
                this.addOrReplacePartitionSchema(partitionSchema);
            } else if (object instanceof ClusterSchema) {
                ClusterSchema clusterSchema = (ClusterSchema)object;
                clusterSchema.shareVariablesWith(this);
                this.addOrReplaceClusterSchema(clusterSchema);
            } else {
                return false;
            }
        }
        return true;
    }

    public List<StepMeta> getTransHopSteps(boolean all) {
        int x;
        ArrayList<StepMeta> st = new ArrayList<StepMeta>();
        for (x = 0; x < this.nrTransHops(); ++x) {
            TransHopMeta hi = this.getTransHop(x);
            if (!hi.isEnabled() && !all) continue;
            int idx = st.indexOf(hi.getFromStep());
            if (idx < 0) {
                st.add(hi.getFromStep());
            }
            if ((idx = st.indexOf(hi.getToStep())) >= 0) continue;
            st.add(hi.getToStep());
        }
        for (x = 0; x < this.nrSteps(); ++x) {
            StepMeta stepMeta = this.getStep(x);
            if (stepMeta.isDrawn() && !this.isStepUsedInTransHops(stepMeta)) {
                st.add(stepMeta);
            }
            if (stepMeta.getRemoteInputSteps().isEmpty() && stepMeta.getRemoteOutputSteps().isEmpty() || st.contains(stepMeta)) continue;
            st.add(stepMeta);
        }
        return st;
    }

    public boolean isStepUsedInTransHops(StepMeta stepMeta) {
        TransHopMeta fr = this.findTransHopFrom(stepMeta);
        TransHopMeta to = this.findTransHopTo(stepMeta);
        return fr != null || to != null;
    }

    public boolean isAnySelectedStepUsedInTransHops() {
        List<StepMeta> selectedSteps = this.getSelectedSteps();
        for (int i = 0; i < selectedSteps.size(); ++i) {
            StepMeta stepMeta = selectedSteps.get(i);
            if (!this.isStepUsedInTransHops(stepMeta)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearChanged() {
        int i;
        this.changed_steps = false;
        this.changed_hops = false;
        for (i = 0; i < this.nrSteps(); ++i) {
            this.getStep(i).setChanged(false);
            if (this.getStep(i).getStepPartitioningMeta() == null) continue;
            this.getStep(i).getStepPartitioningMeta().hasChanged(false);
        }
        for (i = 0; i < this.nrTransHops(); ++i) {
            this.getTransHop(i).setChanged(false);
        }
        for (i = 0; i < this.partitionSchemas.size(); ++i) {
            this.partitionSchemas.get(i).setChanged(false);
        }
        for (i = 0; i < this.clusterSchemas.size(); ++i) {
            this.clusterSchemas.get(i).setChanged(false);
        }
        super.clearChanged();
    }

    public boolean haveStepsChanged() {
        if (this.changed_steps) {
            return true;
        }
        for (int i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            if (stepMeta.hasChanged()) {
                return true;
            }
            if (stepMeta.getStepPartitioningMeta() == null || !stepMeta.getStepPartitioningMeta().hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveHopsChanged() {
        if (this.changed_hops) {
            return true;
        }
        for (int i = 0; i < this.nrTransHops(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean havePartitionSchemasChanged() {
        for (int i = 0; i < this.partitionSchemas.size(); ++i) {
            PartitionSchema ps = this.partitionSchemas.get(i);
            if (!ps.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveClusterSchemasChanged() {
        for (int i = 0; i < this.clusterSchemas.size(); ++i) {
            ClusterSchema cs = this.clusterSchemas.get(i);
            if (!cs.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChanged() {
        if (super.hasChanged()) {
            return true;
        }
        if (this.haveStepsChanged()) {
            return true;
        }
        if (this.haveHopsChanged()) {
            return true;
        }
        if (this.havePartitionSchemasChanged()) {
            return true;
        }
        return this.haveClusterSchemasChanged();
    }

    private boolean isErrorNode(Node errorHandingNode, Node checkNode) {
        if (errorHandingNode != null) {
            NodeList errors = errorHandingNode.getChildNodes();
            Node nodeHopFrom = XMLHandler.getSubNode((Node)checkNode, (String)"from");
            Node nodeHopTo = XMLHandler.getSubNode((Node)checkNode, (String)"to");
            int i = 0;
            while (i < errors.getLength()) {
                Node errorNode = errors.item(i);
                if (!"error".equals(errorNode.getNodeName())) {
                    ++i;
                    continue;
                }
                Node errorSourceNode = XMLHandler.getSubNode((Node)errorNode, (String)"source_step");
                Node errorTagetNode = XMLHandler.getSubNode((Node)errorNode, (String)"target_step");
                String sourceContent = errorSourceNode.getTextContent().trim();
                String tagetContent = errorTagetNode.getTextContent().trim();
                if (sourceContent.equals(nodeHopFrom.getTextContent().trim()) && tagetContent.equals(nodeHopTo.getTextContent().trim())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean hasLoop(StepMeta stepMeta) {
        this.clearLoopCache();
        return this.hasLoop(stepMeta, null);
    }

    @Deprecated
    public boolean hasLoop(StepMeta stepMeta, StepMeta lookup, boolean info) {
        return this.hasLoop(stepMeta, lookup, new HashSet<StepMeta>());
    }

    public boolean hasLoop(StepMeta stepMeta, StepMeta lookup) {
        return this.hasLoop(stepMeta, lookup, new HashSet<StepMeta>());
    }

    private boolean hasLoop(StepMeta stepMeta, StepMeta lookup, HashSet<StepMeta> checkedEntries) {
        String cacheKey = stepMeta.getName() + " - " + (lookup != null ? lookup.getName() : "");
        Boolean hasLoop = this.loopCache.get(cacheKey);
        if (hasLoop != null) {
            return hasLoop;
        }
        hasLoop = false;
        checkedEntries.add(stepMeta);
        List<StepMeta> prevSteps = this.findPreviousSteps(stepMeta, true);
        int nr = prevSteps.size();
        for (int i = 0; i < nr; ++i) {
            StepMeta prevStepMeta = prevSteps.get(i);
            if (prevStepMeta == null || !prevStepMeta.equals(lookup) && (checkedEntries.contains(prevStepMeta) || !this.hasLoop(prevStepMeta, lookup == null ? stepMeta : lookup, checkedEntries))) continue;
            hasLoop = true;
            break;
        }
        this.loopCache.put(cacheKey, hasLoop);
        return hasLoop;
    }

    public void selectAll() {
        int i;
        for (i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            stepMeta.setSelected(true);
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            ni.setSelected(true);
        }
        this.setChanged();
        this.notifyObservers("refreshGraph");
    }

    public void unselectAll() {
        int i;
        for (i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            stepMeta.setSelected(false);
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta ni = this.getNote(i);
            ni.setSelected(false);
        }
    }

    public Point[] getSelectedStepLocations() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (StepMeta stepMeta : this.getSelectedSteps()) {
            Point p = stepMeta.getLocation();
            points.add(new Point(p.x, p.y));
        }
        return points.toArray(new Point[points.size()]);
    }

    public Point[] getSelectedNoteLocations() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (NotePadMeta ni : this.getSelectedNotes()) {
            Point p = ni.getLocation();
            points.add(new Point(p.x, p.y));
        }
        return points.toArray(new Point[points.size()]);
    }

    public List<StepMeta> getSelectedSteps() {
        ArrayList<StepMeta> selection = new ArrayList<StepMeta>();
        for (StepMeta stepMeta : this.steps) {
            if (!stepMeta.isSelected()) continue;
            selection.add(stepMeta);
        }
        return selection;
    }

    public String[] getSelectedStepNames() {
        List<StepMeta> selection = this.getSelectedSteps();
        String[] retval = new String[selection.size()];
        for (int i = 0; i < retval.length; ++i) {
            StepMeta stepMeta = selection.get(i);
            retval[i] = stepMeta.getName();
        }
        return retval;
    }

    public int[] getStepIndexes(List<StepMeta> steps) {
        int[] retval = new int[steps.size()];
        for (int i = 0; i < steps.size(); ++i) {
            retval[i] = this.indexOfStep(steps.get(i));
        }
        return retval;
    }

    public Point getMaximum() {
        Point loc;
        int i;
        int maxx = 0;
        int maxy = 0;
        for (i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            loc = stepMeta.getLocation();
            if (loc.x > maxx) {
                maxx = loc.x;
            }
            if (loc.y <= maxy) continue;
            maxy = loc.y;
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta notePadMeta = this.getNote(i);
            loc = notePadMeta.getLocation();
            if (loc.x + notePadMeta.width > maxx) {
                maxx = loc.x + notePadMeta.width;
            }
            if (loc.y + notePadMeta.height <= maxy) continue;
            maxy = loc.y + notePadMeta.height;
        }
        return new Point(maxx + 100, maxy + 100);
    }

    public Point getMinimum() {
        Point loc;
        int i;
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        for (i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            loc = stepMeta.getLocation();
            if (loc.x < minx) {
                minx = loc.x;
            }
            if (loc.y >= miny) continue;
            miny = loc.y;
        }
        for (i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta notePadMeta = this.getNote(i);
            loc = notePadMeta.getLocation();
            if (loc.x < minx) {
                minx = loc.x;
            }
            if (loc.y >= miny) continue;
            miny = loc.y;
        }
        minx = minx > 20 && minx != Integer.MAX_VALUE ? (minx -= 20) : 0;
        miny = miny > 20 && miny != Integer.MAX_VALUE ? (miny -= 20) : 0;
        return new Point(minx, miny);
    }

    public String[] getStepNames() {
        String[] retval = new String[this.nrSteps()];
        for (int i = 0; i < this.nrSteps(); ++i) {
            retval[i] = this.getStep(i).getName();
        }
        return retval;
    }

    public StepMeta[] getStepsArray() {
        StepMeta[] retval = new StepMeta[this.nrSteps()];
        for (int i = 0; i < this.nrSteps(); ++i) {
            retval[i] = this.getStep(i);
        }
        return retval;
    }

    public boolean findPrevious(StepMeta startStep, StepMeta stepToFind) {
        String key = startStep.getName() + " - " + stepToFind.getName();
        Boolean result = this.loopCache.get(key);
        if (result != null) {
            return result;
        }
        List<StepMeta> previousSteps = this.findPreviousSteps(startStep, false);
        for (int i = 0; i < previousSteps.size(); ++i) {
            StepMeta stepMeta = previousSteps.get(i);
            if (stepMeta.equals(stepToFind)) {
                this.loopCache.put(key, true);
                return true;
            }
            boolean found = this.findPrevious(stepMeta, stepToFind);
            if (!found) continue;
            this.loopCache.put(key, true);
            return true;
        }
        List<StepMeta> infoSteps = this.findPreviousSteps(startStep, true);
        for (int i = 0; i < infoSteps.size(); ++i) {
            StepMeta stepMeta = infoSteps.get(i);
            if (stepMeta.equals(stepToFind)) {
                this.loopCache.put(key, true);
                return true;
            }
            boolean found = this.findPrevious(stepMeta, stepToFind);
            if (!found) continue;
            this.loopCache.put(key, true);
            return true;
        }
        this.loopCache.put(key, false);
        return false;
    }

    public void sortSteps() {
        try {
            Collections.sort(this.steps);
        }
        catch (Exception e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"TransMeta.Exception.ErrorOfSortingSteps", (String[])new String[0]) + e);
            this.log.logError(Const.getStackTracker((Throwable)e));
        }
    }

    public void sortHops() {
        Collections.sort(this.hops);
    }

    public Map<StepMeta, Map<StepMeta, Boolean>> sortStepsNatural() {
        long startTime = System.currentTimeMillis();
        this.prevCount = 0L;
        final HashMap<StepMeta, Map<StepMeta, Boolean>> stepMap = new HashMap<StepMeta, Map<StepMeta, Boolean>>();
        HashMap<StepMeta, List<StepMeta>> previousCache = new HashMap<StepMeta, List<StepMeta>>();
        HashMap<StepMeta, Map<StepMeta, Boolean>> beforeCache = new HashMap<StepMeta, Map<StepMeta, Boolean>>();
        for (StepMeta stepMeta : this.steps) {
            List<StepMeta> prevSteps = (List<StepMeta>)previousCache.get(stepMeta);
            if (prevSteps == null) {
                prevSteps = this.findPreviousSteps(stepMeta);
                ++this.prevCount;
                previousCache.put(stepMeta, prevSteps);
            }
            for (StepMeta prev : prevSteps) {
                Map<StepMeta, Boolean> beforePrevMap = this.updateFillStepMap(previousCache, beforeCache, stepMeta, prev);
                stepMap.put(stepMeta, beforePrevMap);
                beforeCache.put(prev, beforePrevMap);
            }
        }
        Collections.sort(this.steps, new Comparator<StepMeta>(){

            @Override
            public int compare(StepMeta o1, StepMeta o2) {
                Map beforeMap = (Map)stepMap.get(o1);
                if (beforeMap != null) {
                    if (beforeMap.get(o2) == null) {
                        return -1;
                    }
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        long endTime = System.currentTimeMillis();
        this.log.logBasic(BaseMessages.getString(PKG, (String)"TransMeta.Log.TimeExecutionStepSort", (Object[])new Object[]{endTime - startTime, this.prevCount}));
        return stepMap;
    }

    private Map<StepMeta, Boolean> updateFillStepMap(Map<StepMeta, List<StepMeta>> previousCache, Map<StepMeta, Map<StepMeta, Boolean>> beforeCache, StepMeta originStepMeta, StepMeta previousStepMeta) {
        Map<StepMeta, Boolean> beforeMap = beforeCache.get(previousStepMeta);
        if (beforeMap != null) {
            return beforeMap;
        }
        beforeMap = new HashMap<StepMeta, Boolean>();
        beforeMap.put(previousStepMeta, Boolean.TRUE);
        List<StepMeta> prevSteps = previousCache.get(previousStepMeta);
        if (prevSteps == null) {
            prevSteps = this.findPreviousSteps(previousStepMeta);
            ++this.prevCount;
            previousCache.put(previousStepMeta, prevSteps);
        }
        for (StepMeta prev : prevSteps) {
            Map<StepMeta, Boolean> beforePrevMap = this.updateFillStepMap(previousCache, beforeCache, originStepMeta, prev);
            beforeCache.put(prev, beforePrevMap);
            beforeMap.putAll(beforePrevMap);
        }
        return beforeMap;
    }

    public void sortHopsNatural() {
        for (int j = 0; j < this.nrTransHops(); ++j) {
            for (int i = 0; i < this.nrTransHops() - 1; ++i) {
                StepMeta b;
                TransHopMeta one = this.getTransHop(i);
                TransHopMeta two = this.getTransHop(i + 1);
                StepMeta a = two.getFromStep();
                if (this.findPrevious(a, b = one.getToStep()) || a.equals(b)) continue;
                this.setTransHop(i + 1, one);
                this.setTransHop(i, two);
            }
        }
    }

    public void analyseImpact(List<DatabaseImpact> impact, ProgressMonitorListener monitor) throws KettleStepException {
        if (monitor != null) {
            monitor.beginTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.DeterminingImpactTask.Title", (String[])new String[0]), this.nrSteps());
        }
        boolean stop = false;
        for (int i = 0; i < this.nrSteps() && !stop; ++i) {
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.LookingAtStepTask.Title", (String[])new String[0]) + (i + 1) + "/" + this.nrSteps());
            }
            StepMeta stepMeta = this.getStep(i);
            RowMetaInterface prev = this.getPrevStepFields(stepMeta);
            StepMetaInterface stepint = stepMeta.getStepMetaInterface();
            RowMetaInterface inform = null;
            StepMeta[] lu = this.getInfoStep(stepMeta);
            inform = lu != null ? this.getStepFields(lu) : stepint.getTableFields();
            this.compatibleAnalyseImpactStep(impact, stepint, this, stepMeta, prev, inform);
            stepint.analyseImpact(impact, this, stepMeta, prev, null, null, inform, this.repository, this.metaStore);
            if (monitor == null) continue;
            monitor.worked(1);
            stop = monitor.isCanceled();
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    private void compatibleAnalyseImpactStep(List<DatabaseImpact> impact, StepMetaInterface stepint, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, RowMetaInterface inform) throws KettleStepException {
        stepint.analyseImpact(impact, transMeta, stepMeta, prev, null, null, inform);
    }

    public String getAlternativeStepname(String stepname) {
        String newname = stepname;
        StepMeta stepMeta = this.findStep(newname);
        int nr = 1;
        while (stepMeta != null) {
            newname = stepname + " " + ++nr;
            stepMeta = this.findStep(newname);
        }
        return newname;
    }

    public List<SQLStatement> getSQLStatements() throws KettleStepException {
        return this.getSQLStatements(null);
    }

    public List<SQLStatement> getSQLStatements(ProgressMonitorListener monitor) throws KettleStepException {
        if (monitor != null) {
            monitor.beginTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.GettingTheSQLForTransformationTask.Title", (String[])new String[0]), this.nrSteps() + 1);
        }
        ArrayList<SQLStatement> stats = new ArrayList<SQLStatement>();
        for (int i = 0; i < this.nrSteps(); ++i) {
            SQLStatement sql;
            StepMeta stepMeta = this.getStep(i);
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.GettingTheSQLForStepTask.Title", (String[])new String[]{"" + stepMeta}));
            }
            RowMetaInterface prev = this.getPrevStepFields(stepMeta);
            SQLStatement sqlCompat = this.compatibleStepMetaGetSQLStatements(stepMeta.getStepMetaInterface(), stepMeta, prev);
            if (sqlCompat.getSQL() != null || sqlCompat.hasError()) {
                stats.add(sqlCompat);
            }
            if ((sql = stepMeta.getStepMetaInterface().getSQLStatements(this, stepMeta, prev, this.repository, this.metaStore)).getSQL() != null || sql.hasError()) {
                stats.add(sql);
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.GettingTheSQLForTransformationTask.Title2", (String[])new String[0]));
        }
        if (!(this.transLogTable.getDatabaseMeta() == null || Utils.isEmpty((CharSequence)this.transLogTable.getTableName()) && Utils.isEmpty((CharSequence)this.performanceLogTable.getTableName()))) {
            try {
                for (LogTableInterface logTable : new LogTableInterface[]{this.transLogTable, this.performanceLogTable, this.channelLogTable, this.stepLogTable}) {
                    if (logTable.getDatabaseMeta() == null || Utils.isEmpty((CharSequence)logTable.getTableName())) continue;
                    Database db = null;
                    try {
                        db = new Database((LoggingObjectInterface)this, this.transLogTable.getDatabaseMeta());
                        db.shareVariablesWith((VariableSpace)this);
                        db.connect();
                        RowMetaInterface fields = logTable.getLogRecord(LogStatus.START, null, null).getRowMeta();
                        String schemaTable = logTable.getDatabaseMeta().getQuotedSchemaTableCombination(logTable.getSchemaName(), logTable.getTableName());
                        String sql = db.getDDL(schemaTable, fields);
                        if (Utils.isEmpty((CharSequence)sql)) continue;
                        SQLStatement stat = new SQLStatement("<this transformation>", this.transLogTable.getDatabaseMeta(), sql);
                        stats.add(stat);
                    }
                    catch (Exception e) {
                        throw new KettleDatabaseException("Unable to connect to logging database [" + logTable.getDatabaseMeta() + "]", (Throwable)e);
                    }
                    finally {
                        if (db != null) {
                            db.disconnect();
                        }
                    }
                }
            }
            catch (KettleDatabaseException dbe) {
                SQLStatement stat = new SQLStatement("<this transformation>", this.transLogTable.getDatabaseMeta(), null);
                stat.setError(BaseMessages.getString(PKG, (String)"TransMeta.SQLStatement.ErrorDesc.ErrorObtainingTransformationLogTableInfo", (String[])new String[0]) + dbe.getMessage());
                stats.add(stat);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        return stats;
    }

    private SQLStatement compatibleStepMetaGetSQLStatements(StepMetaInterface stepMetaInterface, StepMeta stepMeta, RowMetaInterface prev) throws KettleStepException {
        return stepMetaInterface.getSQLStatements(this, stepMeta, prev);
    }

    public String getSQLStatementsString() throws KettleStepException {
        String sql = "";
        List<SQLStatement> stats = this.getSQLStatements();
        for (int i = 0; i < stats.size(); ++i) {
            SQLStatement stat = stats.get(i);
            if (stat.hasError() || !stat.hasSQL()) continue;
            sql = sql + stat.getSQL();
        }
        return sql;
    }

    @Deprecated
    public void checkSteps(List<CheckResultInterface> remarks, boolean only_selected, ProgressMonitorListener monitor) {
        this.checkSteps(remarks, only_selected, monitor, this, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSteps(List<CheckResultInterface> remarks, boolean only_selected, ProgressMonitorListener monitor, VariableSpace space, Repository repository, IMetaStore metaStore) {
        try {
            StepMeta[] steps;
            String[] stepnames;
            remarks.clear();
            Hashtable<ValueMetaInterface, String> values = new Hashtable<ValueMetaInterface, String>();
            List<StepMeta> selectedSteps = this.getSelectedSteps();
            if (!only_selected || selectedSteps.isEmpty()) {
                stepnames = this.getStepNames();
                steps = this.getStepsArray();
            } else {
                stepnames = this.getSelectedStepNames();
                steps = selectedSteps.toArray(new StepMeta[selectedSteps.size()]);
            }
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.getLogChannel(), (String)KettleExtensionPoint.BeforeCheckSteps.id, (Object)new CheckStepsExtension(remarks, space, this, steps, repository, metaStore));
            boolean stop_checking = false;
            if (monitor != null) {
                monitor.beginTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.VerifyingThisTransformationTask.Title", (String[])new String[0]), steps.length + 2);
            }
            for (int i = 0; i < steps.length && !stop_checking; ++i) {
                CheckResult cr;
                CheckResult cr2;
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.VerifyingStepTask.Title", (String[])new String[]{stepnames[i]}));
                }
                StepMeta stepMeta = steps[i];
                int nrinfo = this.findNrInfoSteps(stepMeta);
                StepMeta[] infostep = null;
                if (nrinfo > 0) {
                    infostep = this.getInfoStep(stepMeta);
                }
                RowMetaInterface info = null;
                if (infostep != null) {
                    try {
                        info = this.getStepFields(infostep);
                    }
                    catch (KettleStepException kse) {
                        info = null;
                        cr2 = new CheckResult(4, BaseMessages.getString(PKG, (String)"TransMeta.CheckResult.TypeResultError.ErrorOccurredGettingStepInfoFields.Description", (String[])new String[]{"" + stepMeta, Const.CR + kse.getMessage()}), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr2);
                    }
                }
                RowMetaInterface prev = null;
                try {
                    prev = this.getPrevStepFields(stepMeta);
                }
                catch (KettleStepException kse) {
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TransMeta.CheckResult.TypeResultError.ErrorOccurredGettingInputFields.Description", (String[])new String[]{"" + stepMeta, Const.CR + kse.getMessage()}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    stop_checking = true;
                }
                if (this.isStepUsedInTransHops(stepMeta) || this.getSteps().size() == 1) {
                    String[] input = this.getPrevStepNames(stepMeta);
                    String[] output = this.getNextStepNames(stepMeta);
                    ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.getLogChannel(), (String)KettleExtensionPoint.BeforeCheckStep.id, (Object)new CheckStepsExtension(remarks, space, this, new StepMeta[]{stepMeta}, repository, metaStore));
                    stepMeta.check(remarks, this, prev, input, output, info, space, repository, metaStore);
                    ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.getLogChannel(), (String)KettleExtensionPoint.AfterCheckStep.id, (Object)new CheckStepsExtension(remarks, space, this, new StepMeta[]{stepMeta}, repository, metaStore));
                    if (prev != null) {
                        for (int x = 0; x < prev.size(); ++x) {
                            ValueMetaInterface v = prev.getValueMeta(x);
                            String name = v.getName();
                            if (name == null) {
                                values.put(v, BaseMessages.getString(PKG, (String)"TransMeta.Value.CheckingFieldName.FieldNameIsEmpty.Description", (String[])new String[0]));
                                continue;
                            }
                            if (name.indexOf(32) >= 0) {
                                values.put(v, BaseMessages.getString(PKG, (String)"TransMeta.Value.CheckingFieldName.FieldNameContainsSpaces.Description", (String[])new String[0]));
                                continue;
                            }
                            char[] list = new char[]{'.', ',', '-', '/', '+', '*', '\'', '\t', '\"', '|', '@', '(', ')', '{', '}', '!', '^'};
                            for (int c = 0; c < list.length; ++c) {
                                if (name.indexOf(list[c]) < 0) continue;
                                values.put(v, BaseMessages.getString(PKG, (String)"TransMeta.Value.CheckingFieldName.FieldNameContainsUnfriendlyCodes.Description", (String[])new String[]{String.valueOf(list[c])}));
                            }
                        }
                        if (prev.size() > 1) {
                            String[] fieldNames = prev.getFieldNames();
                            String[] sortedNames = Const.sortStrings((String[])fieldNames);
                            String prevName = sortedNames[0];
                            for (int x = 1; x < sortedNames.length; ++x) {
                                if (prevName.equalsIgnoreCase(sortedNames[x])) {
                                    CheckResult cr3 = new CheckResult(4, BaseMessages.getString(PKG, (String)"TransMeta.CheckResult.TypeResultWarning.HaveTheSameNameField.Description", (String[])new String[]{prevName}), (CheckResultSourceInterface)stepMeta);
                                    remarks.add((CheckResultInterface)cr3);
                                    continue;
                                }
                                prevName = sortedNames[x];
                            }
                        }
                    } else {
                        CheckResult cr4 = new CheckResult(4, BaseMessages.getString(PKG, (String)"TransMeta.CheckResult.TypeResultError.CannotFindPreviousFields.Description", (String[])new String[0]) + stepMeta.getName(), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr4);
                    }
                } else {
                    cr2 = new CheckResult(3, BaseMessages.getString(PKG, (String)"TransMeta.CheckResult.TypeResultWarning.StepIsNotUsed.Description", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr2);
                }
                try {
                    this.checkRowMixingStatically(stepMeta, null);
                }
                catch (KettleRowException e) {
                    cr = new CheckResult(4, e.getMessage(), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                if (monitor == null) continue;
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                stop_checking = true;
            }
            if (monitor == null || !monitor.isCanceled()) {
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.CheckingTheLoggingTableTask.Title", (String[])new String[0]));
                }
                if (this.transLogTable.getDatabaseMeta() != null) {
                    Database logdb = new Database((LoggingObjectInterface)this, this.transLogTable.getDatabaseMeta());
                    logdb.shareVariablesWith((VariableSpace)this);
                    try {
                        logdb.connect();
                        CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TransMeta.CheckResult.TypeResultOK.ConnectingWorks.Description", (String[])new String[0]), null);
                        remarks.add((CheckResultInterface)cr);
                        if (this.transLogTable.getTableName() != null) {
                            if (logdb.checkTableExists(this.transLogTable.getTableName())) {
                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TransMeta.CheckResult.TypeResultOK.LoggingTableExists.Description", (String[])new String[]{this.transLogTable.getTableName()}), null);
                                remarks.add((CheckResultInterface)cr);
                                RowMetaInterface fields = this.transLogTable.getLogRecord(LogStatus.START, null, null).getRowMeta();
                                String sql = logdb.getDDL(this.transLogTable.getTableName(), fields);
                                if (sql == null || sql.length() == 0) {
                                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TransMeta.CheckResult.TypeResultOK.CorrectLayout.Description", (String[])new String[0]), null);
                                    remarks.add((CheckResultInterface)cr);
                                } else {
                                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TransMeta.CheckResult.TypeResultError.LoggingTableNeedsAdjustments.Description", (String[])new String[0]) + Const.CR + sql, null);
                                    remarks.add((CheckResultInterface)cr);
                                }
                            } else {
                                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TransMeta.CheckResult.TypeResultError.LoggingTableDoesNotExist.Description", (String[])new String[0]), null);
                                remarks.add((CheckResultInterface)cr);
                            }
                        } else {
                            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TransMeta.CheckResult.TypeResultError.LogTableNotSpecified.Description", (String[])new String[0]), null);
                            remarks.add((CheckResultInterface)cr);
                        }
                    }
                    catch (KettleDatabaseException cr) {
                    }
                    finally {
                        logdb.disconnect();
                    }
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            if (monitor != null) {
                monitor.subTask(BaseMessages.getString(PKG, (String)"TransMeta.Monitor.CheckingForDatabaseUnfriendlyCharactersInFieldNamesTask.Title", (String[])new String[0]));
            }
            if (values.size() > 0) {
                for (ValueMetaInterface v : values.keySet()) {
                    String message = (String)values.get(v);
                    CheckResult cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"TransMeta.CheckResult.TypeResultWarning.Description", (String[])new String[]{v.getName(), message, v.getOrigin()}), (CheckResultSourceInterface)this.findStep(v.getOrigin()));
                    remarks.add((CheckResultInterface)cr);
                }
            } else {
                CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TransMeta.CheckResult.TypeResultOK.Description", (String[])new String[0]), null);
                remarks.add((CheckResultInterface)cr);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.getLogChannel(), (String)KettleExtensionPoint.AfterCheckSteps.id, (Object)new CheckStepsExtension(remarks, space, this, steps, repository, metaStore));
        }
        catch (Exception e) {
            this.log.logError(Const.getStackTracker((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public List<RowMetaAndData> getResultRows() {
        return this.resultRows;
    }

    @Deprecated
    public void setResultRows(List<RowMetaAndData> resultRows) {
        this.resultRows = resultRows;
    }

    public String getPathAndName() {
        if (this.getRepositoryDirectory().isRoot()) {
            return this.getRepositoryDirectory().getPath() + this.getName();
        }
        return this.getRepositoryDirectory().getPath() + "/" + this.getName();
    }

    @Deprecated
    public String[] getArguments() {
        return this.arguments;
    }

    @Deprecated
    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    @Deprecated
    public Hashtable<String, Counter> getCounters() {
        return this.counters;
    }

    @Deprecated
    public void setCounters(Hashtable<String, Counter> counters) {
        this.counters = counters;
    }

    public List<TransDependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<TransDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public DatabaseMeta getMaxDateConnection() {
        return this.maxDateConnection;
    }

    public void setMaxDateConnection(DatabaseMeta maxDateConnection) {
        this.maxDateConnection = maxDateConnection;
    }

    public double getMaxDateDifference() {
        return this.maxDateDifference;
    }

    public void setMaxDateDifference(double maxDateDifference) {
        this.maxDateDifference = maxDateDifference;
    }

    public String getMaxDateField() {
        return this.maxDateField;
    }

    public void setMaxDateField(String maxDateField) {
        this.maxDateField = maxDateField;
    }

    public double getMaxDateOffset() {
        return this.maxDateOffset;
    }

    public void setMaxDateOffset(double maxDateOffset) {
        this.maxDateOffset = maxDateOffset;
    }

    public String getMaxDateTable() {
        return this.maxDateTable;
    }

    public void setMaxDateTable(String maxDateTable) {
        this.maxDateTable = maxDateTable;
    }

    public int getSizeRowset() {
        String rowSetSize = this.getVariable("KETTLE_TRANS_ROWSET_SIZE");
        int altSize = Const.toInt((String)rowSetSize, (int)0);
        if (altSize > 0) {
            return altSize;
        }
        return this.sizeRowset;
    }

    public void setSizeRowset(int sizeRowset) {
        this.sizeRowset = sizeRowset;
    }

    public DBCache getDbCache() {
        return this.dbCache;
    }

    public void setDbCache(DBCache dbCache) {
        this.dbCache = dbCache;
    }

    public String getTransversion() {
        return this.trans_version;
    }

    public void setTransversion(String n) {
        this.trans_version = n;
    }

    public void setTransstatus(int n) {
        this.trans_status = n;
    }

    public int getTransstatus() {
        return this.trans_status;
    }

    public String toString() {
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            if (Utils.isEmpty((CharSequence)this.name)) {
                return this.filename;
            }
            return this.filename + " : " + this.name;
        }
        if (this.name != null) {
            if (this.directory != null) {
                String path = this.directory.getPath();
                if (path.endsWith("/")) {
                    return path + this.name;
                }
                return path + "/" + this.name;
            }
            return this.name;
        }
        return TransMeta.class.getName();
    }

    public void cancelQueries() throws KettleDatabaseException {
        for (int i = 0; i < this.nrSteps(); ++i) {
            this.getStep(i).getStepMetaInterface().cancelQueries();
        }
    }

    public Map<String, String> getUsedArguments(String[] arguments) {
        HashMap<String, String> transArgs = new HashMap<String, String>();
        for (int i = 0; i < this.nrSteps(); ++i) {
            StepMetaInterface smi = this.getStep(i).getStepMetaInterface();
            Map<String, String> stepArgs = smi.getUsedArguments();
            if (stepArgs == null) continue;
            transArgs.putAll(stepArgs);
        }
        String[] saved = Props.isInitialized() ? Props.getInstance().getLastArguments() : null;
        for (String argument : transArgs.keySet()) {
            String value = "";
            int argNr = Const.toInt((String)argument, (int)-1);
            if (arguments != null && argNr > 0 && argNr <= arguments.length) {
                value = Const.NVL((String)arguments[argNr - 1], (String)"");
            }
            if (value.length() == 0 && argNr > 0 && argNr < saved.length && saved[argNr] != null) {
                value = saved[argNr - 1];
            }
            transArgs.put(argument, value);
        }
        return transArgs;
    }

    public int getSleepTimeEmpty() {
        return this.sleepTimeEmpty;
    }

    public int getSleepTimeFull() {
        return this.sleepTimeFull;
    }

    public void setSleepTimeEmpty(int sleepTimeEmpty) {
        this.sleepTimeEmpty = sleepTimeEmpty;
    }

    public void setSleepTimeFull(int sleepTimeFull) {
        this.sleepTimeFull = sleepTimeFull;
    }

    public boolean isDatabaseConnectionUsed(DatabaseMeta databaseMeta) {
        for (int i = 0; i < this.nrSteps(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            DatabaseMeta[] dbs = stepMeta.getStepMetaInterface().getUsedDatabaseConnections();
            for (int d = 0; d < dbs.length; ++d) {
                if (!dbs[d].equals((Object)databaseMeta)) continue;
                return true;
            }
        }
        return this.transLogTable.getDatabaseMeta() != null && this.transLogTable.getDatabaseMeta().equals((Object)databaseMeta);
    }

    public List<StringSearchResult> getStringList(boolean searchSteps, boolean searchDatabases, boolean searchNotes, boolean includePasswords) {
        Object meta;
        int i;
        ArrayList<StringSearchResult> stringList = new ArrayList<StringSearchResult>();
        if (searchSteps) {
            for (i = 0; i < this.nrSteps(); ++i) {
                StepMeta stepMeta = this.getStep(i);
                stringList.add(new StringSearchResult(stepMeta.getName(), stepMeta, this, BaseMessages.getString(PKG, (String)"TransMeta.SearchMetadata.StepName", (String[])new String[0])));
                if (stepMeta.getDescription() != null) {
                    stringList.add(new StringSearchResult(stepMeta.getDescription(), stepMeta, this, BaseMessages.getString(PKG, (String)"TransMeta.SearchMetadata.StepDescription", (String[])new String[0])));
                }
                StepMetaInterface metaInterface = stepMeta.getStepMetaInterface();
                StringSearcher.findMetaData(metaInterface, 1, stringList, stepMeta, this);
            }
        }
        if (searchDatabases) {
            for (i = 0; i < this.nrDatabases(); ++i) {
                meta = this.getDatabase(i);
                stringList.add(new StringSearchResult(meta.getName(), meta, this, BaseMessages.getString(PKG, (String)"TransMeta.SearchMetadata.DatabaseConnectionName", (String[])new String[0])));
                if (meta.getHostname() != null) {
                    stringList.add(new StringSearchResult(meta.getHostname(), meta, this, BaseMessages.getString(PKG, (String)"TransMeta.SearchMetadata.DatabaseHostName", (String[])new String[0])));
                }
                if (meta.getDatabaseName() != null) {
                    stringList.add(new StringSearchResult(meta.getDatabaseName(), meta, this, BaseMessages.getString(PKG, (String)"TransMeta.SearchMetadata.DatabaseName", (String[])new String[0])));
                }
                if (meta.getUsername() != null) {
                    stringList.add(new StringSearchResult(meta.getUsername(), meta, this, BaseMessages.getString(PKG, (String)"TransMeta.SearchMetadata.DatabaseUsername", (String[])new String[0])));
                }
                if (meta.getPluginId() != null) {
                    stringList.add(new StringSearchResult(meta.getPluginId(), meta, this, BaseMessages.getString(PKG, (String)"TransMeta.SearchMetadata.DatabaseTypeDescription", (String[])new String[0])));
                }
                if (meta.getDatabasePortNumberString() != null) {
                    stringList.add(new StringSearchResult(meta.getDatabasePortNumberString(), meta, this, BaseMessages.getString(PKG, (String)"TransMeta.SearchMetadata.DatabasePort", (String[])new String[0])));
                }
                if (meta.getServername() != null) {
                    stringList.add(new StringSearchResult(meta.getServername(), meta, this, BaseMessages.getString(PKG, (String)"TransMeta.SearchMetadata.DatabaseServer", (String[])new String[0])));
                }
                if (!includePasswords || meta.getPassword() == null) continue;
                stringList.add(new StringSearchResult(meta.getPassword(), meta, this, BaseMessages.getString(PKG, (String)"TransMeta.SearchMetadata.DatabasePassword", (String[])new String[0])));
            }
        }
        if (searchNotes) {
            for (i = 0; i < this.nrNotes(); ++i) {
                meta = this.getNote(i);
                if (((NotePadMeta)meta).getNote() == null) continue;
                stringList.add(new StringSearchResult(((NotePadMeta)meta).getNote(), meta, this, BaseMessages.getString(PKG, (String)"TransMeta.SearchMetadata.NotepadText", (String[])new String[0])));
            }
        }
        return stringList;
    }

    public List<StringSearchResult> getStringList(boolean searchSteps, boolean searchDatabases, boolean searchNotes) {
        return this.getStringList(searchSteps, searchDatabases, searchNotes, false);
    }

    public List<String> getUsedVariables() {
        List<StringSearchResult> stringList = this.getStringList(true, true, false, true);
        ArrayList<String> varList = new ArrayList<String>();
        for (int i = 0; i < stringList.size(); ++i) {
            StringSearchResult result = stringList.get(i);
            StringUtil.getUsedVariables((String)result.getString(), varList, (boolean)false);
        }
        return varList;
    }

    @Deprecated
    public Result getPreviousResult() {
        return this.previousResult;
    }

    @Deprecated
    public void setPreviousResult(Result previousResult) {
        this.previousResult = previousResult;
    }

    @Deprecated
    public List<ResultFile> getResultFiles() {
        return this.resultFiles;
    }

    @Deprecated
    public void setResultFiles(List<ResultFile> resultFiles) {
        this.resultFiles = resultFiles;
    }

    public List<PartitionSchema> getPartitionSchemas() {
        return this.partitionSchemas;
    }

    public void setPartitionSchemas(List<PartitionSchema> partitionSchemas) {
        this.partitionSchemas = partitionSchemas;
    }

    public String[] getPartitionSchemasNames() {
        String[] names = new String[this.partitionSchemas.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.partitionSchemas.get(i).getName();
        }
        return names;
    }

    public boolean isFeedbackShown() {
        return this.feedbackShown;
    }

    public void setFeedbackShown(boolean feedbackShown) {
        this.feedbackShown = feedbackShown;
    }

    public int getFeedbackSize() {
        return this.feedbackSize;
    }

    public void setFeedbackSize(int feedbackSize) {
        this.feedbackSize = feedbackSize;
    }

    public boolean isUsingUniqueConnections() {
        return this.usingUniqueConnections;
    }

    public void setUsingUniqueConnections(boolean usingUniqueConnections) {
        this.usingUniqueConnections = usingUniqueConnections;
    }

    public List<ClusterSchema> getClusterSchemas() {
        return this.clusterSchemas;
    }

    public void setClusterSchemas(List<ClusterSchema> clusterSchemas) {
        this.clusterSchemas = clusterSchemas;
    }

    public String[] getClusterSchemaNames() {
        String[] names = new String[this.clusterSchemas.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.clusterSchemas.get(i).getName();
        }
        return names;
    }

    public PartitionSchema findPartitionSchema(String name) {
        for (int i = 0; i < this.partitionSchemas.size(); ++i) {
            PartitionSchema schema = this.partitionSchemas.get(i);
            if (!schema.getName().equalsIgnoreCase(name)) continue;
            return schema;
        }
        return null;
    }

    public ClusterSchema findClusterSchema(String name) {
        for (int i = 0; i < this.clusterSchemas.size(); ++i) {
            ClusterSchema schema = this.clusterSchemas.get(i);
            if (!schema.getName().equalsIgnoreCase(name)) continue;
            return schema;
        }
        return null;
    }

    public void addOrReplacePartitionSchema(PartitionSchema partitionSchema) {
        int index = this.partitionSchemas.indexOf(partitionSchema);
        if (index < 0) {
            this.partitionSchemas.add(partitionSchema);
        } else {
            PartitionSchema previous = this.partitionSchemas.get(index);
            previous.replaceMeta(partitionSchema);
        }
        this.setChanged();
    }

    public void addOrReplaceClusterSchema(ClusterSchema clusterSchema) {
        int index = this.clusterSchemas.indexOf(clusterSchema);
        if (index < 0) {
            this.clusterSchemas.add(clusterSchema);
        } else {
            ClusterSchema previous = this.clusterSchemas.get(index);
            previous.replaceMeta(clusterSchema);
        }
        this.setChanged();
    }

    @Override
    protected List<SharedObjectInterface> getAllSharedObjects() {
        List<SharedObjectInterface> shared = super.getAllSharedObjects();
        shared.addAll(this.steps);
        shared.addAll(this.partitionSchemas);
        shared.addAll(this.clusterSchemas);
        return shared;
    }

    public boolean isUsingThreadPriorityManagment() {
        return this.usingThreadPriorityManagment;
    }

    public void setUsingThreadPriorityManagment(boolean usingThreadPriorityManagment) {
        this.usingThreadPriorityManagment = usingThreadPriorityManagment;
    }

    public void checkRowMixingStatically(StepMeta stepMeta, ProgressMonitorListener monitor) throws KettleRowException {
        List<StepMeta> prevSteps = this.findPreviousSteps(stepMeta);
        int nrPrevious = prevSteps.size();
        if (nrPrevious > 1) {
            RowMetaInterface referenceRow = null;
            for (int i = 0; i < nrPrevious; ++i) {
                StepMeta previousStep = prevSteps.get(i);
                try {
                    RowMetaInterface row = this.getStepFields(previousStep, monitor);
                    if (referenceRow == null) {
                        referenceRow = row;
                        continue;
                    }
                    if (stepMeta.getStepMetaInterface().excludeFromRowLayoutVerification()) continue;
                    BaseStep.safeModeChecking(referenceRow, row);
                    continue;
                }
                catch (KettleStepException kettleStepException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setInternalKettleVariables(VariableSpace var) {
        boolean hasRepoDir;
        this.setInternalFilenameKettleVariables(var);
        this.setInternalNameKettleVariable(var);
        this.variables.setVariable("Internal.Transformation.Repository.Directory", this.directory != null ? this.directory.getPath() : "");
        boolean bl = hasRepoDir = this.getRepositoryDirectory() != null && this.getRepository() != null;
        if (hasRepoDir) {
            this.variables.setVariable("Internal.Transformation.Filename.Directory", this.variables.getVariable("Internal.Transformation.Repository.Directory"));
        } else {
            this.variables.setVariable("Internal.Transformation.Repository.Directory", this.variables.getVariable("Internal.Transformation.Filename.Directory"));
        }
        if (this.variables.getVariable("Internal.Job.Filename.Directory") == null) {
            this.variables.setVariable("Internal.Job.Filename.Directory", "Parent Job File Directory");
        }
        if (this.variables.getVariable("Internal.Job.Filename.Name") == null) {
            this.variables.setVariable("Internal.Job.Filename.Name", "Parent Job Filename");
        }
        if (this.variables.getVariable("Internal.Job.Name") == null) {
            this.variables.setVariable("Internal.Job.Name", "Parent Job Name");
        }
        if (this.variables.getVariable("Internal.Job.Repository.Directory") == null) {
            this.variables.setVariable("Internal.Job.Repository.Directory", "Parent Job Repository Directory");
        }
        this.variables.setVariable("Internal.Entry.Current.Directory", this.variables.getVariable(this.repository != null ? "Internal.Transformation.Repository.Directory" : "Internal.Transformation.Filename.Directory"));
    }

    @Override
    protected void setInternalNameKettleVariable(VariableSpace var) {
        this.variables.setVariable("Internal.Transformation.Name", Const.NVL((String)this.name, (String)""));
    }

    @Override
    protected void setInternalFilenameKettleVariables(VariableSpace var) {
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)this.filename, (VariableSpace)var);
                FileName fileName = fileObject.getName();
                this.variables.setVariable("Internal.Transformation.Filename.Name", fileName.getBaseName());
                FileName fileDir = fileName.getParent();
                this.variables.setVariable("Internal.Transformation.Filename.Directory", fileDir.getURI());
            }
            catch (KettleFileException e) {
                this.log.logError("Unexpected error setting internal filename variables!", (Throwable)e);
                this.variables.setVariable("Internal.Transformation.Filename.Directory", "");
                this.variables.setVariable("Internal.Transformation.Filename.Name", "");
            }
        } else {
            this.variables.setVariable("Internal.Transformation.Filename.Directory", "");
            this.variables.setVariable("Internal.Transformation.Filename.Name", "");
        }
        this.variables.setVariable("Internal.Entry.Current.Directory", this.variables.getVariable(this.repository != null ? "Internal.Transformation.Repository.Directory" : "Internal.Transformation.Filename.Directory"));
    }

    public StepMeta findMappingInputStep(String stepname) throws KettleStepException {
        if (!Utils.isEmpty((CharSequence)stepname)) {
            StepMeta stepMeta = this.findStep(stepname);
            if (stepMeta == null) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.StepNameNotFound", (String[])new String[]{stepname}));
            }
            return stepMeta;
        }
        StepMeta stepMeta = null;
        for (StepMeta mappingStep : this.steps) {
            if (!mappingStep.getStepID().equals("MappingInput")) continue;
            if (stepMeta == null) {
                stepMeta = mappingStep;
                continue;
            }
            if (stepMeta == null) continue;
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.OnlyOneMappingInputStepAllowed", (String[])new String[]{"2"}));
        }
        if (stepMeta == null) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.OneMappingInputStepRequired", (String[])new String[0]));
        }
        return stepMeta;
    }

    public StepMeta findMappingOutputStep(String stepname) throws KettleStepException {
        if (!Utils.isEmpty((CharSequence)stepname)) {
            StepMeta stepMeta = this.findStep(stepname);
            if (stepMeta == null) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.StepNameNotFound", (String[])new String[]{stepname}));
            }
            return stepMeta;
        }
        StepMeta stepMeta = null;
        for (StepMeta mappingStep : this.steps) {
            if (!mappingStep.getStepID().equals("MappingOutput")) continue;
            if (stepMeta == null) {
                stepMeta = mappingStep;
                continue;
            }
            if (stepMeta == null) continue;
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.OnlyOneMappingOutputStepAllowed", (String[])new String[]{"2"}));
        }
        if (stepMeta == null) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.OneMappingOutputStepRequired", (String[])new String[0]));
        }
        return stepMeta;
    }

    public List<ResourceReference> getResourceDependencies() {
        return this.steps.stream().flatMap(stepMeta -> stepMeta.getResourceDependencies(this).stream()).collect(Collectors.toList());
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            String fullname;
            String baseName;
            String originalPath;
            String extension = "ktr";
            if (Utils.isEmpty((CharSequence)this.getFilename())) {
                originalPath = this.directory.getPath();
                baseName = this.getName();
                fullname = this.directory.getPath() + (this.directory.getPath().endsWith("/") ? "" : "/") + this.getName() + "." + extension;
            } else {
                FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.getFilename()), (VariableSpace)space);
                originalPath = fileObject.getParent().getURL().toString();
                baseName = fileObject.getName().getBaseName();
                fullname = fileObject.getURL().toString();
            }
            String exportFileName = resourceNamingInterface.nameResource(baseName, originalPath, extension, ResourceNamingInterface.FileNamingType.TRANSFORMATION);
            ResourceDefinition definition = definitions.get(exportFileName);
            if (definition == null) {
                TransMeta transMeta = (TransMeta)this.realClone(false);
                for (StepMeta stepMeta : transMeta.getSteps()) {
                    stepMeta.exportResources(space, definitions, resourceNamingInterface, repository, metaStore);
                }
                transMeta.setFilename(exportFileName);
                transMeta.setRepositoryDirectory((RepositoryDirectoryInterface)new RepositoryDirectory());
                Map<String, String> directoryMap = resourceNamingInterface.getDirectoryMap();
                if (directoryMap != null) {
                    for (String directory : directoryMap.keySet()) {
                        String parameterName = directoryMap.get(directory);
                        transMeta.addParameterDefinition(parameterName, directory, "Data file path discovered during export");
                    }
                }
                String string = transMeta.getXML();
                definition = new ResourceDefinition(exportFileName, string);
                if (Utils.isEmpty((CharSequence)this.getFilename())) {
                    definition.setOrigin(fullname);
                } else {
                    definition.setOrigin(this.getFilename());
                }
                definitions.put(fullname, definition);
            }
            return exportFileName;
        }
        catch (FileSystemException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.ErrorOpeningOrValidatingTheXMLFile", (String[])new String[]{this.getFilename()}), (Throwable)e);
        }
        catch (KettleFileException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TransMeta.Exception.ErrorOpeningOrValidatingTheXMLFile", (String[])new String[]{this.getFilename()}), (Throwable)e);
        }
    }

    public SlaveStepCopyPartitionDistribution getSlaveStepCopyPartitionDistribution() {
        return this.slaveStepCopyPartitionDistribution;
    }

    public void setSlaveStepCopyPartitionDistribution(SlaveStepCopyPartitionDistribution slaveStepCopyPartitionDistribution) {
        this.slaveStepCopyPartitionDistribution = slaveStepCopyPartitionDistribution;
    }

    public ClusterSchema findFirstUsedClusterSchema() {
        for (StepMeta stepMeta : this.steps) {
            if (stepMeta.getClusterSchema() == null) continue;
            return stepMeta.getClusterSchema();
        }
        return null;
    }

    public boolean isSlaveTransformation() {
        return this.slaveTransformation;
    }

    public void setSlaveTransformation(boolean slaveTransformation) {
        this.slaveTransformation = slaveTransformation;
    }

    public boolean isCapturingStepPerformanceSnapShots() {
        return this.capturingStepPerformanceSnapShots;
    }

    public void setCapturingStepPerformanceSnapShots(boolean capturingStepPerformanceSnapShots) {
        this.capturingStepPerformanceSnapShots = capturingStepPerformanceSnapShots;
    }

    public long getStepPerformanceCapturingDelay() {
        return this.stepPerformanceCapturingDelay;
    }

    public void setStepPerformanceCapturingDelay(long stepPerformanceCapturingDelay) {
        this.stepPerformanceCapturingDelay = stepPerformanceCapturingDelay;
    }

    public String getStepPerformanceCapturingSizeLimit() {
        return this.stepPerformanceCapturingSizeLimit;
    }

    public void setStepPerformanceCapturingSizeLimit(String stepPerformanceCapturingSizeLimit) {
        this.stepPerformanceCapturingSizeLimit = stepPerformanceCapturingSizeLimit;
    }

    public void clearCaches() {
        this.clearStepFieldsCachce();
        this.clearLoopCache();
        this.clearPreviousStepCache();
    }

    private void clearStepFieldsCachce() {
        this.stepsFieldsCache.clear();
    }

    private void clearLoopCache() {
        this.loopCache.clear();
    }

    @VisibleForTesting
    void clearPreviousStepCache() {
        this.previousStepCache.clear();
    }

    public RepositoryObjectType getRepositoryElementType() {
        return REPOSITORY_ELEMENT_TYPE;
    }

    public LogChannelInterface getLogChannel() {
        return this.log;
    }

    public String getLogChannelId() {
        return this.log.getLogChannelId();
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.TRANSMETA;
    }

    public TransLogTable getTransLogTable() {
        return this.transLogTable;
    }

    public void setTransLogTable(TransLogTable transLogTable) {
        this.transLogTable = transLogTable;
    }

    public PerformanceLogTable getPerformanceLogTable() {
        return this.performanceLogTable;
    }

    public void setPerformanceLogTable(PerformanceLogTable performanceLogTable) {
        this.performanceLogTable = performanceLogTable;
    }

    public StepLogTable getStepLogTable() {
        return this.stepLogTable;
    }

    public void setStepLogTable(StepLogTable stepLogTable) {
        this.stepLogTable = stepLogTable;
    }

    public List<LogTableInterface> getLogTables() {
        ArrayList<LogTableInterface> logTables = new ArrayList<LogTableInterface>();
        logTables.add(this.transLogTable);
        logTables.add(this.stepLogTable);
        logTables.add(this.performanceLogTable);
        logTables.add(this.channelLogTable);
        logTables.add(this.metricsLogTable);
        return logTables;
    }

    public TransformationType getTransformationType() {
        return this.transformationType;
    }

    public void setTransformationType(TransformationType transformationType) {
        this.transformationType = transformationType;
    }

    public void writeXML(String filename) throws KettleXMLException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            fos.write(XMLHandler.getXMLHeader().getBytes("UTF-8"));
            fos.write(this.getXML().getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to save to XML file '" + filename + "'", (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new KettleXMLException("Unable to close file '" + filename + "'", (Throwable)e);
                }
            }
        }
    }

    public boolean hasRepositoryReferences() {
        for (StepMeta stepMeta : this.steps) {
            if (!stepMeta.getStepMetaInterface().hasRepositoryReferences()) continue;
            return true;
        }
        return false;
    }

    public void lookupRepositoryReferences(Repository repository) throws KettleException {
        for (StepMeta stepMeta : this.steps) {
            stepMeta.getStepMetaInterface().lookupRepositoryReferences(repository);
        }
    }

    public MetricsLogTable getMetricsLogTable() {
        return this.metricsLogTable;
    }

    public void setMetricsLogTable(MetricsLogTable metricsLogTable) {
        this.metricsLogTable = metricsLogTable;
    }

    public boolean isGatheringMetrics() {
        return this.log.isGatheringMetrics();
    }

    public void setGatheringMetrics(boolean gatheringMetrics) {
        this.log.setGatheringMetrics(gatheringMetrics);
    }

    public boolean isForcingSeparateLogging() {
        return this.log.isForcingSeparateLogging();
    }

    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        this.log.setForcingSeparateLogging(forcingSeparateLogging);
    }

    public void addStepChangeListener(StepMetaChangeListenerInterface listener) {
        this.stepChangeListeners.add(listener);
    }

    public void addStepChangeListener(int p, StepMetaChangeListenerInterface list) {
        int indexListener = -1;
        int indexListenerRemove = -1;
        StepMeta rewriteStep = this.steps.get(p);
        StepMetaInterface iface = rewriteStep.getStepMetaInterface();
        if (iface instanceof StepMetaChangeListenerInterface) {
            for (StepMetaChangeListenerInterface listener : this.stepChangeListeners) {
                ++indexListener;
                if (!listener.equals(iface)) continue;
                indexListenerRemove = indexListener;
            }
            if (indexListenerRemove >= 0) {
                this.stepChangeListeners.add(indexListenerRemove, list);
            } else if (this.stepChangeListeners.size() == 0 && p == 0) {
                this.stepChangeListeners.add(list);
            }
        }
    }

    public void removeStepChangeListener(StepMetaChangeListenerInterface list) {
        int indexListener = -1;
        int indexListenerRemove = -1;
        for (StepMetaChangeListenerInterface listener : this.stepChangeListeners) {
            ++indexListener;
            if (!listener.equals(list)) continue;
            indexListenerRemove = indexListener;
        }
        if (indexListenerRemove >= 0) {
            this.stepChangeListeners.remove(indexListenerRemove);
        }
    }

    public void notifyAllListeners(StepMeta oldMeta, StepMeta newMeta) {
        for (StepMetaChangeListenerInterface listener : this.stepChangeListeners) {
            listener.onStepChange(this, oldMeta, newMeta);
        }
    }

    public boolean containsStepMeta(StepMeta stepMeta) {
        return this.steps.contains(stepMeta);
    }

    public List<MissingTrans> getMissingTrans() {
        return this.missingTrans;
    }

    public void addMissingTrans(MissingTrans trans) {
        if (this.missingTrans == null) {
            this.missingTrans = new ArrayList();
        }
        this.missingTrans.add(trans);
    }

    public void removeMissingTrans(MissingTrans trans) {
        if (this.missingTrans != null && trans != null && this.missingTrans.contains(trans)) {
            this.missingTrans.remove(trans);
        }
    }

    @Override
    public boolean hasMissingPlugins() {
        return this.missingTrans != null && !this.missingTrans.isEmpty();
    }

    @Override
    public NamedClusterEmbedManager getNamedClusterEmbedManager() {
        if (this.namedClusterEmbedManager == null) {
            this.namedClusterEmbedManager = new NamedClusterEmbedManager(this, this.getLogChannel());
        }
        return this.namedClusterEmbedManager;
    }

    public int getCacheVersion() throws KettleException {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(17, 31).append((Object)this.getName()).append((Object)this.getTransformationType()).append(this.getSizeRowset()).append(this.getSleepTimeEmpty()).append(this.getSleepTimeFull()).append(this.isUsingUniqueConnections()).append(this.isFeedbackShown()).append(this.getFeedbackSize()).append(this.isUsingThreadPriorityManagment()).append((Object)this.getSharedObjectsFile()).append(this.isCapturingStepPerformanceSnapShots()).append(this.getStepPerformanceCapturingDelay()).append((Object)this.getStepPerformanceCapturingSizeLimit()).append((Object)this.getMaxDateConnection()).append((Object)this.getMaxDateTable()).append((Object)this.getMaxDateField()).append(this.getMaxDateOffset()).append(this.getMaxDateDifference()).append(this.getDependencies()).append(this.getPartitionSchemas()).append(this.getSlaveServers()).append(this.getClusterSchemas()).append((Object)this.getSlaveStepCopyPartitionDistribution()).append(this.isSlaveTransformation()).append(this.nrTransHops()).append(this.getSteps().size()).append((Object[])this.getStepNames()).append(this.hops);
        List<StepMeta> steps = this.getSteps();
        for (StepMeta step : steps) {
            hashCodeBuilder.append((Object)step.getName()).append((Object)step.getStepMetaInterface().getXML()).append((Object)step.getClusterSchema()).append(step.getRemoteInputSteps()).append(step.getRemoteOutputSteps()).append(step.isDoingErrorHandling());
        }
        return hashCodeBuilder.toHashCode();
    }

    private static String getStepMetaCacheKey(StepMeta stepMeta, boolean info) {
        return String.format("%1$b-%2$s-%3$s", info, stepMeta.getStepID(), stepMeta.toString());
    }

    static /* synthetic */ Class access$000() {
        return PKG;
    }

    public static enum TransformationType {
        Normal("Normal", BaseMessages.getString((Class)TransMeta.access$000(), (String)"TransMeta.TransformationType.Normal", (String[])new String[0])),
        SerialSingleThreaded("SerialSingleThreaded", BaseMessages.getString((Class)TransMeta.access$000(), (String)"TransMeta.TransformationType.SerialSingleThreaded", (String[])new String[0])),
        SingleThreaded("SingleThreaded", BaseMessages.getString((Class)TransMeta.access$000(), (String)"TransMeta.TransformationType.SingleThreaded", (String[])new String[0]));

        private String code;
        private String description;

        private TransformationType(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static TransformationType getTransformationTypeByCode(String transTypeCode) {
            if (transTypeCode != null) {
                for (TransformationType type : TransformationType.values()) {
                    if (!type.code.equalsIgnoreCase(transTypeCode)) continue;
                    return type;
                }
            }
            return Normal;
        }

        public static String[] getTransformationTypesDescriptions() {
            String[] desc = new String[TransformationType.values().length];
            for (int i = 0; i < TransformationType.values().length; ++i) {
                desc[i] = TransformationType.values()[i].getDescription();
            }
            return desc;
        }
    }
}

