/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.ael.websocket;

import java.util.concurrent.atomic.AtomicReference;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.engine.api.events.PDIEvent;
import org.pentaho.di.engine.api.model.Operation;
import org.pentaho.di.engine.api.remote.Message;
import org.pentaho.di.engine.api.reporting.Status;
import org.pentaho.di.trans.ael.websocket.MessageEventService;
import org.pentaho.di.trans.ael.websocket.Util;
import org.pentaho.di.trans.ael.websocket.exception.MessageEventHandlerExecutionException;
import org.pentaho.di.trans.ael.websocket.handler.MessageEventHandler;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;

public class StepDataInterfaceWebSocketEngineAdapter
implements StepDataInterface {
    private static final String OPERATION_STATUS_HANDLER_ID = "OPERATION_STATUS_DATA_INTERFACE_";
    private AtomicReference<BaseStepData.StepExecutionStatus> stepExecutionStatus = new AtomicReference<BaseStepData.StepExecutionStatus>(BaseStepData.StepExecutionStatus.STATUS_INIT);

    StepDataInterfaceWebSocketEngineAdapter(final Operation op, MessageEventService messageEventService) throws KettleException {
        messageEventService.addHandler((Message)Util.getOperationStatusEvent(op.getId()), new MessageEventHandler(){

            @Override
            public void execute(Message message) throws MessageEventHandlerExecutionException {
                PDIEvent data = (PDIEvent)message;
                switch ((Status)data.getData()) {
                    case FINISHED: {
                        StepDataInterfaceWebSocketEngineAdapter.this.stepExecutionStatus.set(BaseStepData.StepExecutionStatus.STATUS_FINISHED);
                        break;
                    }
                    case FAILED: 
                    case STOPPED: {
                        StepDataInterfaceWebSocketEngineAdapter.this.stepExecutionStatus.set(BaseStepData.StepExecutionStatus.STATUS_STOPPED);
                        break;
                    }
                    case PAUSED: {
                        StepDataInterfaceWebSocketEngineAdapter.this.stepExecutionStatus.set(BaseStepData.StepExecutionStatus.STATUS_PAUSED);
                        break;
                    }
                    case RUNNING: {
                        StepDataInterfaceWebSocketEngineAdapter.this.stepExecutionStatus.set(BaseStepData.StepExecutionStatus.STATUS_RUNNING);
                    }
                }
            }

            @Override
            public String getIdentifier() {
                return StepDataInterfaceWebSocketEngineAdapter.OPERATION_STATUS_HANDLER_ID + op.getId();
            }
        });
    }

    @Override
    public void setStatus(BaseStepData.StepExecutionStatus stepExecutionStatus) {
        this.stepExecutionStatus.set(stepExecutionStatus);
    }

    @Override
    public BaseStepData.StepExecutionStatus getStatus() {
        return this.stepExecutionStatus.get();
    }

    @Override
    public boolean isEmpty() {
        return this.stepExecutionStatus.get() == BaseStepData.StepExecutionStatus.STATUS_EMPTY;
    }

    @Override
    public boolean isInitialising() {
        return this.stepExecutionStatus.get() == BaseStepData.StepExecutionStatus.STATUS_INIT;
    }

    @Override
    public boolean isRunning() {
        return this.stepExecutionStatus.get() == BaseStepData.StepExecutionStatus.STATUS_RUNNING;
    }

    @Override
    public boolean isIdle() {
        return this.stepExecutionStatus.get() == BaseStepData.StepExecutionStatus.STATUS_IDLE;
    }

    @Override
    public boolean isFinished() {
        return this.stepExecutionStatus.get() == BaseStepData.StepExecutionStatus.STATUS_FINISHED;
    }

    @Override
    public boolean isDisposed() {
        return this.stepExecutionStatus.get() == BaseStepData.StepExecutionStatus.STATUS_DISPOSED;
    }
}

