/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.filterrows;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.filterrows.FilterRows;
import org.pentaho.di.trans.steps.filterrows.FilterRowsData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="FilterRowsMeta.Injection.")
public class FilterRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = FilterRowsMeta.class;
    private Condition condition = new Condition();

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public void allocate() {
        this.condition = new Condition();
    }

    @Override
    public Object clone() {
        FilterRowsMeta retval = (FilterRowsMeta)super.clone();
        retval.setTrueStepname(this.getTrueStepname());
        retval.setFalseStepname(this.getFalseStepname());
        retval.condition = this.condition != null ? (Condition)this.condition.clone() : null;
        return retval;
    }

    @Override
    public String getXML() throws KettleException {
        StringBuilder retval = new StringBuilder(200);
        retval.append(XMLHandler.addTagValue((String)"send_true_to", (String)this.getTrueStepname()));
        retval.append(XMLHandler.addTagValue((String)"send_false_to", (String)this.getFalseStepname()));
        retval.append("    <compare>").append(Const.CR);
        if (this.condition != null) {
            retval.append(this.condition.getXML());
        }
        retval.append("    </compare>").append(Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.setTrueStepname(XMLHandler.getTagValue((Node)stepnode, (String)"send_true_to"));
            this.setFalseStepname(XMLHandler.getTagValue((Node)stepnode, (String)"send_false_to"));
            Node compare = XMLHandler.getSubNode((Node)stepnode, (String)"compare");
            Node condnode = XMLHandler.getSubNode((Node)compare, (String)"condition");
            if (condnode != null) {
                this.condition = new Condition(condnode);
            } else {
                this.condition = new Condition();
                int nrkeys = XMLHandler.countNodes((Node)compare, (String)"key");
                if (nrkeys == 1) {
                    Node knode = XMLHandler.getSubNodeByNr((Node)compare, (String)"key", (int)0);
                    String key = XMLHandler.getTagValue((Node)knode, (String)"name");
                    String value = XMLHandler.getTagValue((Node)knode, (String)"value");
                    String field = XMLHandler.getTagValue((Node)knode, (String)"field");
                    String comparator = XMLHandler.getTagValue((Node)knode, (String)"condition");
                    this.condition.setOperator(0);
                    this.condition.setLeftValuename(key);
                    this.condition.setFunction(Condition.getFunction((String)comparator));
                    this.condition.setRightValuename(field);
                    this.condition.setRightExact(new ValueMetaAndData("value", (Object)value));
                } else {
                    for (int i = 0; i < nrkeys; ++i) {
                        Node knode = XMLHandler.getSubNodeByNr((Node)compare, (String)"key", (int)i);
                        String key = XMLHandler.getTagValue((Node)knode, (String)"name");
                        String value = XMLHandler.getTagValue((Node)knode, (String)"value");
                        String field = XMLHandler.getTagValue((Node)knode, (String)"field");
                        String comparator = XMLHandler.getTagValue((Node)knode, (String)"condition");
                        Condition subc = new Condition();
                        if (i > 0) {
                            subc.setOperator(1);
                        } else {
                            subc.setOperator(0);
                        }
                        subc.setLeftValuename(key);
                        subc.setFunction(Condition.getFunction((String)comparator));
                        subc.setRightValuename(field);
                        subc.setRightExact(new ValueMetaAndData("value", (Object)value));
                        this.condition.addCondition(subc);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"FilterRowsMeta.Exception..UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.allocate();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.allocate();
            this.setTrueStepname(rep.getStepAttributeString(id_step, "send_true_to"));
            this.setFalseStepname(rep.getStepAttributeString(id_step, "send_false_to"));
            this.condition = rep.loadConditionFromStepAttribute(id_step, "id_condition");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"FilterRowsMeta.Exception.UnexpectedErrorInReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (StreamInterface stream : this.getStepIOMeta().getTargetStreams()) {
            stream.setStepMeta(StepMeta.findStep(steps, (String)stream.getSubject()));
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            if (this.condition != null) {
                rep.saveConditionStepAttribute(id_transformation, id_step, "id_condition", this.condition);
                rep.saveStepAttribute(id_transformation, id_step, "send_true_to", this.getTrueStepname());
                rep.saveStepAttribute(id_transformation, id_step, "send_false_to", this.getFalseStepname());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"FilterRowsMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        String[] conditionField = this.condition.getUsedFields();
        for (int i = 0; i < conditionField.length; ++i) {
            int idx = rowMeta.indexOfValue(conditionField[i]);
            if (idx < 0) continue;
            ValueMetaInterface valueMeta = rowMeta.getValueMeta(idx);
            valueMeta.setSortedDescending(false);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        String error_message = "";
        this.checkTarget(stepMeta, "true", this.getTrueStepname(), output).ifPresent(remarks::add);
        this.checkTarget(stepMeta, "false", this.getFalseStepname(), output).ifPresent(remarks::add);
        CheckResult cr = this.condition.isEmpty() ? new CheckResult(4, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.NoConditionSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.ConditionSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            List<String> orphanFields = this.getOrphanFields(this.condition, prev);
            if (orphanFields.size() > 0) {
                error_message = BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.FieldsNotFoundFromPreviousStep", (String[])new String[0]) + Const.CR;
                for (String field : orphanFields) {
                    error_message = error_message + "\t\t" + field + Const.CR;
                }
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.AllFieldsFoundInInputStream", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            }
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.CouldNotReadFieldsFromPreviousStep", (String[])new String[0]) + Const.CR;
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    private Optional<CheckResult> checkTarget(StepMeta stepMeta, String target, String targetStepName, String[] output) {
        int trueTargetIdx;
        if (targetStepName != null && (trueTargetIdx = Const.indexOfString((String)targetStepName, (String[])output)) < 0) {
            return Optional.of(new CheckResult(4, BaseMessages.getString(PKG, (String)"FilterRowsMeta.CheckResult.TargetStepInvalid", (String[])new String[]{target, targetStepName}), (CheckResultSourceInterface)stepMeta));
        }
        return Optional.empty();
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new FilterRows(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new FilterRowsData();
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        if (this.ioMeta == null) {
            this.ioMeta = new StepIOMeta(true, true, false, false, false, false);
            this.ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"FilterRowsMeta.InfoStream.True.Description", (String[])new String[0]), StreamIcon.TRUE, null));
            this.ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"FilterRowsMeta.InfoStream.False.Description", (String[])new String[0]), StreamIcon.FALSE, null));
        }
        return this.ioMeta;
    }

    @Override
    public void resetStepIoMeta() {
    }

    @Override
    public void handleStreamSelection(StreamInterface stream) {
        StepMeta trueStep;
        StepMeta falseStep;
        List<StreamInterface> targets = this.getStepIOMeta().getTargetStreams();
        int index = targets.indexOf(stream);
        if (index == 0 && (falseStep = targets.get(1).getStepMeta()) != null && falseStep.equals(stream.getStepMeta())) {
            targets.get(1).setStepMeta(null);
        }
        if (index == 1 && (trueStep = targets.get(0).getStepMeta()) != null && trueStep.equals(stream.getStepMeta())) {
            targets.get(0).setStepMeta(null);
        }
    }

    @Override
    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }

    public List<String> getOrphanFields(Condition condition, RowMetaInterface prev) {
        ArrayList<String> orphans = new ArrayList<String>();
        if (condition == null || prev == null) {
            return orphans;
        }
        String[] key = condition.getUsedFields();
        for (int i = 0; i < key.length; ++i) {
            ValueMetaInterface v;
            if (Utils.isEmpty((CharSequence)key[i]) || (v = prev.searchValueMeta(key[i])) != null) continue;
            orphans.add(key[i]);
        }
        return orphans;
    }

    public String getTrueStepname() {
        return this.getTargetStepName(0);
    }

    @Injection(name="SEND_TRUE_STEP")
    public void setTrueStepname(String trueStepname) {
        this.getStepIOMeta().getTargetStreams().get(0).setSubject(trueStepname);
    }

    public String getFalseStepname() {
        return this.getTargetStepName(1);
    }

    @Injection(name="SEND_FALSE_STEP")
    public void setFalseStepname(String falseStepname) {
        this.getStepIOMeta().getTargetStreams().get(1).setSubject(falseStepname);
    }

    private String getTargetStepName(int streamIndex) {
        StreamInterface stream = this.getStepIOMeta().getTargetStreams().get(streamIndex);
        return java.util.stream.Stream.of(stream.getStepname(), stream.getSubject()).filter(Objects::nonNull).findFirst().map(Object::toString).orElse(null);
    }

    public String getConditionXML() {
        String conditionXML = null;
        try {
            conditionXML = this.condition.getXML();
        }
        catch (KettleValueException e) {
            this.log.logError(e.getMessage());
        }
        return conditionXML;
    }

    @Injection(name="CONDITION")
    public void setConditionXML(String conditionXML) {
        try {
            this.condition = new Condition(conditionXML);
        }
        catch (KettleXMLException e) {
            this.log.logError(e.getMessage());
        }
    }
}

