/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.userdefinedjavaclass;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.userdefinedjavaclass.StepDefinition;
import org.pentaho.di.trans.steps.userdefinedjavaclass.TransformClassBase;
import org.pentaho.di.trans.steps.userdefinedjavaclass.UsageParameter;
import org.pentaho.di.trans.steps.userdefinedjavaclass.UserDefinedJavaClass;
import org.pentaho.di.trans.steps.userdefinedjavaclass.UserDefinedJavaClassData;
import org.pentaho.di.trans.steps.userdefinedjavaclass.UserDefinedJavaClassDef;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class UserDefinedJavaClassMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = UserDefinedJavaClassMeta.class;
    private List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private List<UserDefinedJavaClassDef> definitions = new ArrayList<UserDefinedJavaClassDef>();
    public Class<TransformClassBase> cookedTransformClass;
    public List<Exception> cookErrors = new ArrayList<Exception>(0);
    private static final Cache<String, Class<?>> classCache;
    private boolean clearingResultFields;
    private boolean changed = true;
    private List<StepDefinition> infoStepDefinitions = new ArrayList<StepDefinition>();
    private List<StepDefinition> targetStepDefinitions = new ArrayList<StepDefinition>();
    private List<UsageParameter> usageParameters = new ArrayList<UsageParameter>();

    @VisibleForTesting
    Class<?> cookClass(UserDefinedJavaClassDef def) throws CompileException, Parser.ParseException, Scanner.ScanException, IOException, RuntimeException, KettleStepException {
        StringReader sr;
        String checksum = def.getChecksum();
        Class rtn = (Class)classCache.getIfPresent((Object)checksum);
        if (rtn != null) {
            return rtn;
        }
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        ClassBodyEvaluator cbe = new ClassBodyEvaluator();
        cbe.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        cbe.setClassName(def.getClassName());
        if (def.isTransformClass()) {
            cbe.setExtendedType(TransformClassBase.class);
            sr = new StringReader(def.getTransformedSource());
        } else {
            sr = new StringReader(def.getSource());
        }
        cbe.setDefaultImports(new String[]{"org.pentaho.di.trans.steps.userdefinedjavaclass.*", "org.pentaho.di.trans.step.*", "org.pentaho.di.core.row.*", "org.pentaho.di.core.*", "org.pentaho.di.core.exception.*"});
        cbe.cook(new Scanner(null, (Reader)sr));
        rtn = cbe.getClazz();
        classCache.put((Object)checksum, (Object)rtn);
        return rtn;
    }

    public void cookClasses() {
        this.cookErrors.clear();
        for (UserDefinedJavaClassDef def : this.getDefinitions()) {
            if (!def.isActive()) continue;
            try {
                Class<?> cookedClass = this.cookClass(def);
                if (!def.isTransformClass()) continue;
                this.cookedTransformClass = cookedClass;
            }
            catch (Throwable e) {
                CompileException exception = new CompileException(e.getMessage(), null);
                exception.setStackTrace(new StackTraceElement[0]);
                this.cookErrors.add((Exception)exception);
            }
        }
        this.changed = false;
    }

    public TransformClassBase newChildInstance(UserDefinedJavaClass parent, UserDefinedJavaClassMeta meta, UserDefinedJavaClassData data) {
        if (!this.checkClassCookings(this.getLog())) {
            return null;
        }
        try {
            return this.cookedTransformClass.getConstructor(UserDefinedJavaClass.class, UserDefinedJavaClassMeta.class, UserDefinedJavaClassData.class).newInstance(parent, meta, data);
        }
        catch (Exception e) {
            if (this.log.isDebug()) {
                this.log.logError("Full debugging stacktrace of UserDefinedJavaClass instanciation exception:", e.getCause());
            }
            KettleException kettleException = new KettleException(e.getMessage());
            kettleException.setStackTrace(new StackTraceElement[0]);
            this.cookErrors.add((Exception)((Object)kettleException));
            return null;
        }
    }

    public List<FieldInfo> getFieldInfo() {
        return Collections.unmodifiableList(this.fields);
    }

    public void replaceFields(List<FieldInfo> fields) {
        this.fields = fields;
        this.changed = true;
    }

    public List<UserDefinedJavaClassDef> getDefinitions() {
        return Collections.unmodifiableList(this.definitions);
    }

    public void replaceDefinitions(List<UserDefinedJavaClassDef> definitions) {
        this.definitions.clear();
        this.definitions.addAll(definitions);
        this.changed = true;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        try {
            UserDefinedJavaClassMeta retval = (UserDefinedJavaClassMeta)super.clone();
            if (this.fields != null) {
                ArrayList<FieldInfo> newFields = new ArrayList<FieldInfo>(this.fields.size());
                for (FieldInfo field : this.fields) {
                    newFields.add((FieldInfo)field.clone());
                }
                retval.fields = newFields;
            }
            if (this.definitions != null) {
                ArrayList<UserDefinedJavaClassDef> newDefinitions = new ArrayList<UserDefinedJavaClassDef>();
                for (UserDefinedJavaClassDef def : this.definitions) {
                    newDefinitions.add((UserDefinedJavaClassDef)def.clone());
                }
                retval.definitions = newDefinitions;
            }
            retval.cookedTransformClass = null;
            retval.cookErrors = new ArrayList<Exception>(0);
            if (this.infoStepDefinitions != null) {
                ArrayList<StepDefinition> newInfoStepDefinitions = new ArrayList<StepDefinition>();
                for (StepDefinition step : this.infoStepDefinitions) {
                    newInfoStepDefinitions.add((StepDefinition)step.clone());
                }
                retval.infoStepDefinitions = newInfoStepDefinitions;
            }
            if (this.targetStepDefinitions != null) {
                ArrayList<StepDefinition> newTargetStepDefinitions = new ArrayList<StepDefinition>();
                for (StepDefinition step : this.targetStepDefinitions) {
                    newTargetStepDefinitions.add((StepDefinition)step.clone());
                }
                retval.targetStepDefinitions = newTargetStepDefinitions;
            }
            if (this.usageParameters != null) {
                ArrayList<UsageParameter> newUsageParameters = new ArrayList<UsageParameter>();
                for (UsageParameter param : this.usageParameters) {
                    newUsageParameters.add((UsageParameter)param.clone());
                }
                retval.usageParameters = newUsageParameters;
            }
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node definitionsNode = XMLHandler.getSubNode((Node)stepnode, (String)ElementNames.definitions.name());
            int nrDefinitions = XMLHandler.countNodes((Node)definitionsNode, (String)ElementNames.definition.name());
            for (int i = 0; i < nrDefinitions; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)definitionsNode, (String)ElementNames.definition.name(), (int)i);
                this.definitions.add(new UserDefinedJavaClassDef(UserDefinedJavaClassDef.ClassType.valueOf(XMLHandler.getTagValue((Node)fnode, (String)ElementNames.class_type.name())), XMLHandler.getTagValue((Node)fnode, (String)ElementNames.class_name.name()), XMLHandler.getTagValue((Node)fnode, (String)ElementNames.class_source.name())));
            }
            Node fieldsNode = XMLHandler.getSubNode((Node)stepnode, (String)ElementNames.fields.name());
            int nrfields = XMLHandler.countNodes((Node)fieldsNode, (String)ElementNames.field.name());
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fieldsNode, (String)ElementNames.field.name(), (int)i);
                this.fields.add(new FieldInfo(XMLHandler.getTagValue((Node)fnode, (String)ElementNames.field_name.name()), ValueMetaFactory.getIdForValueMeta((String)XMLHandler.getTagValue((Node)fnode, (String)ElementNames.field_type.name())), Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)ElementNames.field_length.name()), (int)-1), Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)ElementNames.field_precision.name()), (int)-1)));
            }
            this.setClearingResultFields(!"N".equals(XMLHandler.getTagValue((Node)stepnode, (String)ElementNames.clear_result_fields.name())));
            this.infoStepDefinitions.clear();
            Node infosNode = XMLHandler.getSubNode((Node)stepnode, (String)ElementNames.info_steps.name());
            int nrInfos = XMLHandler.countNodes((Node)infosNode, (String)ElementNames.info_step.name());
            for (int i = 0; i < nrInfos; ++i) {
                Node infoNode = XMLHandler.getSubNodeByNr((Node)infosNode, (String)ElementNames.info_step.name(), (int)i);
                StepDefinition stepDefinition = new StepDefinition();
                stepDefinition.tag = XMLHandler.getTagValue((Node)infoNode, (String)ElementNames.step_tag.name());
                stepDefinition.stepName = XMLHandler.getTagValue((Node)infoNode, (String)ElementNames.step_name.name());
                stepDefinition.description = XMLHandler.getTagValue((Node)infoNode, (String)ElementNames.step_description.name());
                this.infoStepDefinitions.add(stepDefinition);
            }
            this.targetStepDefinitions.clear();
            Node targetsNode = XMLHandler.getSubNode((Node)stepnode, (String)ElementNames.target_steps.name());
            int nrTargets = XMLHandler.countNodes((Node)targetsNode, (String)ElementNames.target_step.name());
            for (int i = 0; i < nrTargets; ++i) {
                Node targetNode = XMLHandler.getSubNodeByNr((Node)targetsNode, (String)ElementNames.target_step.name(), (int)i);
                StepDefinition stepDefinition = new StepDefinition();
                stepDefinition.tag = XMLHandler.getTagValue((Node)targetNode, (String)ElementNames.step_tag.name());
                stepDefinition.stepName = XMLHandler.getTagValue((Node)targetNode, (String)ElementNames.step_name.name());
                stepDefinition.description = XMLHandler.getTagValue((Node)targetNode, (String)ElementNames.step_description.name());
                this.targetStepDefinitions.add(stepDefinition);
            }
            this.usageParameters.clear();
            Node parametersNode = XMLHandler.getSubNode((Node)stepnode, (String)ElementNames.usage_parameters.name());
            int nrParameters = XMLHandler.countNodes((Node)parametersNode, (String)ElementNames.usage_parameter.name());
            for (int i = 0; i < nrParameters; ++i) {
                Node parameterNode = XMLHandler.getSubNodeByNr((Node)parametersNode, (String)ElementNames.usage_parameter.name(), (int)i);
                UsageParameter usageParameter = new UsageParameter();
                usageParameter.tag = XMLHandler.getTagValue((Node)parameterNode, (String)ElementNames.parameter_tag.name());
                usageParameter.value = XMLHandler.getTagValue((Node)parameterNode, (String)ElementNames.parameter_value.name());
                usageParameter.description = XMLHandler.getTagValue((Node)parameterNode, (String)ElementNames.parameter_description.name());
                this.usageParameters.add(usageParameter);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
    }

    private boolean checkClassCookings(LogChannelInterface logChannel) {
        boolean ok;
        boolean bl = ok = this.cookedTransformClass != null && this.cookErrors.size() == 0;
        if (this.changed) {
            this.cookClasses();
            if (this.cookedTransformClass == null) {
                if (this.cookErrors.size() > 0) {
                    logChannel.logDebug(BaseMessages.getString(PKG, (String)"UserDefinedJavaClass.Exception.CookingError", (Object[])new Object[]{this.cookErrors.get(0)}));
                }
                ok = false;
            } else {
                ok = true;
            }
        }
        return ok;
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        if (!this.checkClassCookings(this.getLog())) {
            return super.getStepIOMeta();
        }
        try {
            Method getStepIOMeta = this.cookedTransformClass.getMethod("getStepIOMeta", UserDefinedJavaClassMeta.class);
            if (getStepIOMeta != null) {
                StepIOMetaInterface stepIoMeta = (StepIOMetaInterface)getStepIOMeta.invoke(null, this);
                if (stepIoMeta == null) {
                    return super.getStepIOMeta();
                }
                return stepIoMeta;
            }
            return super.getStepIOMeta();
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.getStepIOMeta();
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (StepDefinition stepDefinition : this.infoStepDefinitions) {
            stepDefinition.stepMeta = StepMeta.findStep(steps, stepDefinition.stepName);
        }
        for (StepDefinition stepDefinition : this.targetStepDefinitions) {
            stepDefinition.stepMeta = StepMeta.findStep(steps, stepDefinition.stepName);
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String originStepname, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (!this.checkClassCookings(this.getLog())) {
            if (this.cookErrors.size() > 0) {
                throw new KettleStepException("Error initializing UserDefinedJavaClass to get fields: ", (Throwable)this.cookErrors.get(0));
            }
            return;
        }
        try {
            Method getFieldsMethod = this.cookedTransformClass.getMethod("getFields", Boolean.TYPE, RowMetaInterface.class, String.class, RowMetaInterface[].class, StepMeta.class, VariableSpace.class, List.class);
            getFieldsMethod.invoke(null, this.isClearingResultFields(), row, originStepname, info, nextStep, space, this.getFieldInfo());
        }
        catch (Exception e) {
            throw new KettleStepException("Error executing UserDefinedJavaClass.getFields(): ", (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(String.format("\n    <%s>", ElementNames.definitions.name()));
        for (UserDefinedJavaClassDef def : this.definitions) {
            retval.append(String.format("\n        <%s>", ElementNames.definition.name()));
            retval.append("\n        ").append(XMLHandler.addTagValue((String)ElementNames.class_type.name(), (String)def.getClassType().name()));
            retval.append("\n        ").append(XMLHandler.addTagValue((String)ElementNames.class_name.name(), (String)def.getClassName()));
            retval.append("\n        ");
            retval.append(XMLHandler.addTagValue((String)ElementNames.class_source.name(), (String)def.getSource()));
            retval.append(String.format("\n        </%s>", ElementNames.definition.name()));
        }
        retval.append(String.format("\n    </%s>", ElementNames.definitions.name()));
        retval.append(String.format("\n    <%s>", ElementNames.fields.name()));
        for (FieldInfo fi : this.fields) {
            retval.append(String.format("\n        <%s>", ElementNames.field.name()));
            retval.append("\n        ").append(XMLHandler.addTagValue((String)ElementNames.field_name.name(), (String)fi.name));
            retval.append("\n        ").append(XMLHandler.addTagValue((String)ElementNames.field_type.name(), (String)ValueMetaFactory.getValueMetaName((int)fi.type)));
            retval.append("\n        ").append(XMLHandler.addTagValue((String)ElementNames.field_length.name(), (int)fi.length));
            retval.append("\n        ").append(XMLHandler.addTagValue((String)ElementNames.field_precision.name(), (int)fi.precision));
            retval.append(String.format("\n        </%s>", ElementNames.field.name()));
        }
        retval.append(String.format("\n    </%s>", ElementNames.fields.name()));
        retval.append(XMLHandler.addTagValue((String)ElementNames.clear_result_fields.name(), (boolean)this.clearingResultFields));
        retval.append(XMLHandler.openTag((String)ElementNames.info_steps.name()));
        for (StepDefinition stepDefinition : this.infoStepDefinitions) {
            retval.append(XMLHandler.openTag((String)ElementNames.info_step.name()));
            retval.append(XMLHandler.addTagValue((String)ElementNames.step_tag.name(), (String)stepDefinition.tag));
            retval.append(XMLHandler.addTagValue((String)ElementNames.step_name.name(), stepDefinition.stepMeta != null ? stepDefinition.stepMeta.getName() : null));
            retval.append(XMLHandler.addTagValue((String)ElementNames.step_description.name(), (String)stepDefinition.description));
            retval.append(XMLHandler.closeTag((String)ElementNames.info_step.name()));
        }
        retval.append(XMLHandler.closeTag((String)ElementNames.info_steps.name()));
        retval.append(XMLHandler.openTag((String)ElementNames.target_steps.name()));
        for (StepDefinition stepDefinition : this.targetStepDefinitions) {
            retval.append(XMLHandler.openTag((String)ElementNames.target_step.name()));
            retval.append(XMLHandler.addTagValue((String)ElementNames.step_tag.name(), (String)stepDefinition.tag));
            retval.append(XMLHandler.addTagValue((String)ElementNames.step_name.name(), stepDefinition.stepMeta != null ? stepDefinition.stepMeta.getName() : null));
            retval.append(XMLHandler.addTagValue((String)ElementNames.step_description.name(), (String)stepDefinition.description));
            retval.append(XMLHandler.closeTag((String)ElementNames.target_step.name()));
        }
        retval.append(XMLHandler.closeTag((String)ElementNames.target_steps.name()));
        retval.append(XMLHandler.openTag((String)ElementNames.usage_parameters.name()));
        for (UsageParameter usageParameter : this.usageParameters) {
            retval.append(XMLHandler.openTag((String)ElementNames.usage_parameter.name()));
            retval.append(XMLHandler.addTagValue((String)ElementNames.parameter_tag.name(), (String)usageParameter.tag));
            retval.append(XMLHandler.addTagValue((String)ElementNames.parameter_value.name(), (String)usageParameter.value));
            retval.append(XMLHandler.addTagValue((String)ElementNames.parameter_description.name(), (String)usageParameter.description));
            retval.append(XMLHandler.closeTag((String)ElementNames.usage_parameter.name()));
        }
        retval.append(XMLHandler.closeTag((String)ElementNames.usage_parameters.name()));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrScripts = rep.countNrStepAttributes(id_step, ElementNames.class_name.name());
            for (int i = 0; i < nrScripts; ++i) {
                this.definitions.add(new UserDefinedJavaClassDef(UserDefinedJavaClassDef.ClassType.valueOf(rep.getStepAttributeString(id_step, i, ElementNames.class_type.name())), rep.getStepAttributeString(id_step, i, ElementNames.class_name.name()), rep.getStepAttributeString(id_step, i, ElementNames.class_source.name())));
            }
            int nrfields = rep.countNrStepAttributes(id_step, ElementNames.field_name.name());
            for (int i = 0; i < nrfields; ++i) {
                this.fields.add(new FieldInfo(rep.getStepAttributeString(id_step, i, ElementNames.field_name.name()), ValueMetaFactory.getIdForValueMeta((String)rep.getStepAttributeString(id_step, i, ElementNames.field_type.name())), (int)rep.getStepAttributeInteger(id_step, i, ElementNames.field_length.name()), (int)rep.getStepAttributeInteger(id_step, i, ElementNames.field_precision.name())));
            }
            this.clearingResultFields = rep.getStepAttributeBoolean(id_step, ElementNames.clear_result_fields.name());
            int nrInfos = rep.countNrStepAttributes(id_step, ElementNames.info_.name() + ElementNames.step_name.name());
            for (int i = 0; i < nrInfos; ++i) {
                StepDefinition stepDefinition = new StepDefinition();
                stepDefinition.tag = rep.getStepAttributeString(id_step, i, ElementNames.info_.name() + ElementNames.step_tag.name());
                stepDefinition.stepName = rep.getStepAttributeString(id_step, i, ElementNames.info_.name() + ElementNames.step_name.name());
                stepDefinition.description = rep.getStepAttributeString(id_step, i, ElementNames.info_.name() + ElementNames.step_description.name());
                this.infoStepDefinitions.add(stepDefinition);
            }
            int nrTargets = rep.countNrStepAttributes(id_step, ElementNames.target_.name() + ElementNames.step_name.name());
            for (int i = 0; i < nrTargets; ++i) {
                StepDefinition stepDefinition = new StepDefinition();
                stepDefinition.tag = rep.getStepAttributeString(id_step, i, ElementNames.target_.name() + ElementNames.step_tag.name());
                stepDefinition.stepName = rep.getStepAttributeString(id_step, i, ElementNames.target_.name() + ElementNames.step_name.name());
                stepDefinition.description = rep.getStepAttributeString(id_step, i, ElementNames.target_.name() + ElementNames.step_description.name());
                this.targetStepDefinitions.add(stepDefinition);
            }
            int nrParameters = rep.countNrStepAttributes(id_step, ElementNames.parameter_tag.name());
            for (int i = 0; i < nrParameters; ++i) {
                UsageParameter usageParameter = new UsageParameter();
                usageParameter.tag = rep.getStepAttributeString(id_step, i, ElementNames.parameter_tag.name());
                usageParameter.value = rep.getStepAttributeString(id_step, i, ElementNames.parameter_value.name());
                usageParameter.description = rep.getStepAttributeString(id_step, i, ElementNames.parameter_description.name());
                this.usageParameters.add(usageParameter);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            StepDefinition stepDefinition;
            int i;
            for (i = 0; i < this.definitions.size(); ++i) {
                UserDefinedJavaClassDef def = this.definitions.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.class_name.name(), def.getClassName());
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.class_source.name(), def.getSource());
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.class_type.name(), def.getClassType().name());
            }
            for (i = 0; i < this.fields.size(); ++i) {
                FieldInfo fi = this.fields.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.field_name.name(), fi.name);
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.field_type.name(), ValueMetaFactory.getValueMetaName((int)fi.type));
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.field_length.name(), fi.length);
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.field_precision.name(), fi.precision);
            }
            rep.saveStepAttribute(id_transformation, id_step, ElementNames.clear_result_fields.name(), this.clearingResultFields);
            for (i = 0; i < this.infoStepDefinitions.size(); ++i) {
                stepDefinition = this.infoStepDefinitions.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.info_.name() + ElementNames.step_tag.name(), stepDefinition.tag);
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.info_.name() + ElementNames.step_name.name(), stepDefinition.stepMeta != null ? stepDefinition.stepMeta.getName() : null);
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.info_.name() + ElementNames.step_description.name(), stepDefinition.description);
            }
            for (i = 0; i < this.targetStepDefinitions.size(); ++i) {
                stepDefinition = this.targetStepDefinitions.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.target_.name() + ElementNames.step_tag.name(), stepDefinition.tag);
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.target_.name() + ElementNames.step_name.name(), stepDefinition.stepMeta != null ? stepDefinition.stepMeta.getName() : null);
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.target_.name() + ElementNames.step_description.name(), stepDefinition.description);
            }
            for (i = 0; i < this.usageParameters.size(); ++i) {
                UsageParameter usageParameter = this.usageParameters.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.parameter_tag.name(), usageParameter.tag);
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.parameter_value.name(), usageParameter.value);
                rep.saveStepAttribute(id_transformation, id_step, i, ElementNames.parameter_description.name(), usageParameter.description);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UserDefinedJavaClassMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"UserDefinedJavaClassMeta.CheckResult.ConnectedStepOK2", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"UserDefinedJavaClassMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        UserDefinedJavaClass userDefinedJavaClass = new UserDefinedJavaClass(stepMeta, stepDataInterface, cnr, transMeta, trans);
        if (trans.hasHaltedSteps()) {
            return null;
        }
        return userDefinedJavaClass;
    }

    @Override
    public StepDataInterface getStepData() {
        return new UserDefinedJavaClassData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public boolean isClearingResultFields() {
        return this.clearingResultFields;
    }

    public void setClearingResultFields(boolean clearingResultFields) {
        this.clearingResultFields = clearingResultFields;
    }

    public List<StepDefinition> getInfoStepDefinitions() {
        return this.infoStepDefinitions;
    }

    public void setInfoStepDefinitions(List<StepDefinition> infoStepDefinitions) {
        this.infoStepDefinitions = infoStepDefinitions;
    }

    public List<StepDefinition> getTargetStepDefinitions() {
        return this.targetStepDefinitions;
    }

    public void setTargetStepDefinitions(List<StepDefinition> targetStepDefinitions) {
        this.targetStepDefinitions = targetStepDefinitions;
    }

    @Override
    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public List<UsageParameter> getUsageParameters() {
        return this.usageParameters;
    }

    public void setUsageParameters(List<UsageParameter> usageParameters) {
        this.usageParameters = usageParameters;
    }

    static {
        Variables vs = new Variables();
        vs.initializeVariablesFrom(null);
        String maxSizeStr = vs.getVariable("KETTLE_DEFAULT_CLASS_CACHE_SIZE", "100");
        int maxCacheSize = -1;
        try {
            maxCacheSize = Integer.parseInt(maxSizeStr);
        }
        catch (Exception ignored) {
            maxCacheSize = 100;
        }
        classCache = CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).build();
    }

    public static class FieldInfo
    implements Cloneable {
        public final String name;
        public final int type;
        public final int length;
        public final int precision;

        public FieldInfo(String name, int type, int length, int precision) {
            this.name = name;
            this.type = type;
            this.length = length;
            this.precision = precision;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public static enum ElementNames {
        class_type,
        class_name,
        class_source,
        definitions,
        definition,
        fields,
        field,
        field_name,
        field_type,
        field_length,
        field_precision,
        clear_result_fields,
        info_steps,
        info_step,
        info_,
        target_steps,
        target_step,
        target_,
        step_tag,
        step_name,
        step_description,
        usage_parameters,
        usage_parameter,
        parameter_tag,
        parameter_value,
        parameter_description;

    }
}

